/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.noModel;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import mathematics.functions.Discrete;
import mathematics.metrics.Metric;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;

public class KNearestNeighbors
implements Classifier {
    private static final long serialVersionUID = -1270938492407713875L;
    protected Instances LearningSet = null;
    protected Metric metrique = null;
    protected int nbAttributs = -1;
    protected int ClassIndex = -1;
    protected int nbClasses = -1;
    protected Discrete fonction = null;
    private List<Voisin> kNN = null;
    protected int K = -1;
    protected double[] Ratios = null;
    protected double Epsilon = 1.0E-4;

    public KNearestNeighbors(Discrete fonction, Metric metrique) {
        if (metrique == null) {
            throw new Error("Metrique = null");
        }
        this.metrique = metrique;
        if (fonction == null) {
            throw new Error("fonction = nulle.");
        }
        this.fonction = fonction;
    }

    public void buildClassifier(Instances LearningSet) throws Exception {
        if (LearningSet == null) {
            throw new NullPointerException("inst == null.");
        }
        this.getCapabilities().testWithFail(LearningSet);
        this.LearningSet = null;
        this.LearningSet = LearningSet;
        this.nbAttributs = LearningSet.numAttributes();
        if (this.fonction == null) {
            throw new Error("Fonction nulles");
        }
        this.K = this.fonction.Compute(new int[]{this.nbAttributs - 1, LearningSet.numInstances()});
        if (this.K <= 0) {
            throw new Error("Valeur de K incorrecte : " + this.K + " (attendu [1..N]).");
        }
        this.ClassIndex = LearningSet.classIndex();
        this.nbClasses = LearningSet.attribute(LearningSet.classIndex()).numValues();
        this.Ratios = null;
        this.Ratios = new double[this.nbClasses];
        int Somme = LearningSet.attributeStats((int)this.ClassIndex).totalCount;
        for (int i2 = 0; i2 < this.nbClasses; ++i2) {
            this.Ratios[i2] = (double)LearningSet.attributeStats((int)this.ClassIndex).nominalCounts[i2] / (double)Somme;
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int y;
        int x;
        if (this.nbAttributs != instance.numAttributes()) {
            throw new IllegalArgumentException("Format de l'instance different de celui de l'echantillon d'apprentissage.");
        }
        if (this.ClassIndex != instance.classIndex()) {
            throw new IllegalArgumentException("Colonne cible placee differemment entre l'echantillon d'apprentissage et l'instance");
        }
        int Hauteur = this.LearningSet.numInstances();
        if (this.K > Hauteur) {
            throw new IllegalArgumentException("Nombre d'individus de l'echantillon d'apprentissage (" + Hauteur + ") inferieur e K (" + this.K + ").");
        }
        double[] inst = new double[this.nbAttributs - 1];
        double[] insts = new double[this.nbAttributs - 1];
        Instance train = null;
        this.kNN = null;
        this.kNN = new Vector<Voisin>(this.K);
        int i2 = 0;
        for (x = 0; x < this.nbAttributs; ++x) {
            if (x == this.ClassIndex) continue;
            inst[i2++] = instance.value(x);
        }
        for (y = 0; y < this.K; ++y) {
            train = this.LearningSet.instance(y);
            i2 = 0;
            for (x = 0; x < this.nbAttributs; ++x) {
                if (x == this.ClassIndex) continue;
                insts[i2++] = train.value(x);
            }
            this.InsererVoisin(y, this.metrique.Distance(inst, insts));
        }
        double max = this.kNN.get((int)(this.K - 1)).dist;
        for (y = this.K; y < Hauteur; ++y) {
            train = this.LearningSet.instance(y);
            i2 = 0;
            for (x = 0; x < this.nbAttributs; ++x) {
                if (x == this.ClassIndex) continue;
                insts[i2++] = train.value(x);
            }
            double distance = this.metrique.Distance(inst, insts);
            if (!(distance < max)) continue;
            this.InsererVoisin(y, distance);
            max = this.kNN.get((int)(this.K - 1)).dist;
        }
        double[] Voisinage = new double[this.nbClasses];
        Iterator<Voisin> iter = this.kNN.iterator();
        while (iter.hasNext()) {
            int n = (int)this.LearningSet.instance(iter.next().num).classValue();
            Voisinage[n] = Voisinage[n] + 1.0;
        }
        double[] RatiosVoisins = new double[this.nbClasses];
        for (i2 = 0; i2 < this.nbClasses; ++i2) {
            RatiosVoisins[i2] = Voisinage[i2] / (double)this.K;
        }
        double[] Probabilites = new double[this.nbClasses];
        for (i2 = 0; i2 < this.nbClasses; ++i2) {
            Probabilites[i2] = RatiosVoisins[i2] / this.Ratios[i2];
        }
        int max1 = 0;
        int max2 = 1;
        if (Probabilites[0] < Probabilites[1]) {
            max1 = 1;
            max2 = 0;
        }
        for (i2 = 2; i2 < this.nbClasses; ++i2) {
            if (Probabilites[max1] < Probabilites[i2]) {
                max2 = max1;
                max1 = i2;
                continue;
            }
            if (!(Probabilites[max2] < Probabilites[i2])) continue;
            max2 = i2;
        }
        if (Math.abs(Probabilites[max1] - Probabilites[max2]) < this.Epsilon) {
            if (Math.random() < 0.5) {
                int n = max1;
                Probabilites[n] = Probabilites[n] + this.Epsilon;
                int n2 = max2;
                Probabilites[n2] = Probabilites[n2] - this.Epsilon;
            } else {
                int n = max1;
                Probabilites[n] = Probabilites[n] - this.Epsilon;
                int n3 = max2;
                Probabilites[n3] = Probabilites[n3] + this.Epsilon;
            }
        }
        double Somme = 0.0;
        for (i2 = 0; i2 < this.nbClasses; ++i2) {
            Somme += Probabilites[i2];
        }
        i2 = 0;
        while (i2 < this.nbClasses) {
            int n = i2++;
            Probabilites[n] = Probabilites[n] / Somme;
        }
        inst = null;
        insts = null;
        RatiosVoisins = null;
        return Probabilites;
    }

    protected void InsererVoisin(int num, double distance) {
        int i2;
        int taille = this.kNN.size();
        for (i2 = 0; i2 < taille && this.kNN.get((int)i2).dist < distance; ++i2) {
        }
        if (taille == this.K) {
            this.kNN.remove(this.K - 1);
        }
        this.kNN.add(i2, new Voisin(num, distance));
    }

    public void ComputeModel(Instances instances) {
        if (instances == null) {
            throw new Error("instances = null");
        }
        try {
            this.buildClassifier(instances);
            this.nbClasses = instances.attribute(instances.classIndex()).numValues();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Une exception generee dans la construction du modele.");
        }
    }

    public int getTarget() {
        return this.ClassIndex;
    }

    public Classifier getClassifier() {
        return this;
    }

    public int getNbClasses() {
        return this.nbClasses;
    }

    public int getK() {
        return this.K;
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(null);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    public String getRevision() {
        return "Version 1.0";
    }

    public double getEpsilon() {
        return this.Epsilon;
    }

    public void setEpsilon(double Epsilon) {
        if (Epsilon <= 0.0) {
            throw new Error("Valeur negative ou nulle : " + Epsilon);
        }
        this.Epsilon = Epsilon;
    }

    public double classifyInstance(Instance arg0) throws Exception {
        return 0.0;
    }

    protected class Voisin {
        int num;
        double dist;

        public Voisin(int num, double dist) {
            this.num = num;
            this.dist = dist;
        }
    }
}

