/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.optimization.backpropagation.momentums;

import dataMining.classifiers.neuralnet.optimization.backpropagation.GradientBP;

public class AdaptiveDoubleMomentums
implements GradientBP {
    private float Momentum1;
    private float Momentum2;

    public AdaptiveDoubleMomentums(float Momentum1, float Momentum2) {
        this.Momentums(Momentum1, Momentum2);
    }

    @Override
    public float Compute(float roughgradient, int pos, float[] LearningRates, float[] GradientsK1, float[] GradientsK2) {
        float lr = LearningRates[pos];
        float newgrad = lr * roughgradient;
        GradientsK2[pos] = GradientsK1[pos];
        GradientsK1[pos] = newgrad;
        LearningRates[pos] = lr += this.Momentum1 * GradientsK1[pos] * roughgradient + this.Momentum2 * GradientsK1[pos] * GradientsK2[pos];
        return newgrad;
    }

    @Override
    public float[] Momentums() {
        return new float[]{this.Momentum1, this.Momentum2};
    }

    public void Momentums(float Momentum1, float Momentum2) {
        if (Momentum1 < 0.0f || 1.0f < Momentum1) {
            throw new IllegalArgumentException("The Momentum1 must be into the range [0,1].");
        }
        if (Momentum2 < 0.0f || 1.0f < Momentum2) {
            throw new IllegalArgumentException("The Momentum2 must be into the range [0,1].");
        }
        this.Momentum1 = Momentum1;
        this.Momentum2 = Momentum2;
    }

    @Override
    public void Momentums(float[] momentums) {
        this.Momentums(momentums[0], momentums[1]);
    }

    @Override
    public void MultipyMomentums(float multiplier) {
        this.Momentum1 *= multiplier;
        this.Momentum2 *= multiplier;
    }
}

