/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.optimization.backpropagation;

import arrayTiTi.ArrayArithmetic;
import dataMining.classifiers.neuralnet.NeuralNetwork;
import dataMining.classifiers.neuralnet.functions.LossFunction;
import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.InputLayer;
import dataMining.classifiers.neuralnet.layers.Layer;
import dataMining.classifiers.neuralnet.layers.fullyconnected.FullyConnectedLayer;
import dataMining.classifiers.neuralnet.neurons.BasicNeuron;
import dataMining.classifiers.neuralnet.neurons.Neuron;
import dataMining.classifiers.neuralnet.neurons.NeuronBP;
import dataMining.classifiers.neuralnet.neurons.NeuronBackProp;
import dataMining.classifiers.neuralnet.optimization.backpropagation.BackPropagation;
import dataMining.classifiers.neuralnet.optimization.backpropagation.GradientBP;
import mathematics.functions.Differentiable;
import mathematics.functions.Function1D;

public class BackPropDropOut
extends BackPropagation {
    protected float ilp = 0.2f;
    protected float hlp = 0.5f;
    protected boolean[][] dropout = null;

    public BackPropDropOut(LossFunction Loss, GradientBP gradbp, float LearningRate, float safety, float ConvergenceLimit, int MaxEpoch) {
        super(Loss, gradbp, LearningRate, safety, ConvergenceLimit, MaxEpoch, -2);
    }

    public BackPropDropOut(LossFunction Loss, GradientBP gradbp, float LearningRate, float safety, float ConvergenceLimit, int MaxEpoch, float ilp, float hlp) {
        super(Loss, gradbp, LearningRate, safety, ConvergenceLimit, MaxEpoch, -2);
        if (Float.compare(ilp, 0.0f) <= 0 || 0 < Float.compare(ilp, 100.0f)) {
            throw new IllegalArgumentException("The ilp coefficient must be into the range ]0,100[.");
        }
        this.ilp = ilp / 100.0f;
        if (Float.compare(hlp, 0.0f) <= 0 || 0 < Float.compare(hlp, 100.0f)) {
            throw new IllegalArgumentException("The hlp coefficient must be into the range ]0,100[.");
        }
        this.hlp = hlp / 100.0f;
    }

    @Override
    public void EpochOver(boolean verbose) {
        this.EpochOverBasic(verbose);
        if (this.EpochOverActivateSafety()) {
            this.EpochOverSafety();
        }
        ++this.EpochCounter;
        if (Math.abs(this.OutputConvergence) + Math.abs(this.WeightsConvergence) < this.ConvergenceLimit || this.MaxEpoch <= this.EpochCounter) {
            this.isTraining = false;
        }
        if (!this.isTraining) {
            float c = 1.0f - this.hlp;
            BasicNeuron[] neurons = null;
            for (int i2 = 1; i2 < this.Layers.size() - 1; ++i2) {
                if (!(this.Layers.get(i2) instanceof FullyConnectedLayer)) continue;
                neurons = ((BasicLayer)this.Layers.get(i2)).Neurons();
                for (int j = 0; j < neurons.length; ++j) {
                    float[] weights = ((Neuron)neurons[j]).Combination.getCoefficients((float[])null);
                    ArrayArithmetic.Multiply((float[])weights, (float)c, (float[])weights);
                    weights = null;
                }
                neurons = null;
            }
        }
    }

    @Override
    protected void FeedForward() {
        int x;
        int length = this.Layers.size();
        BasicNeuron[] basicneurons = ((BasicLayer)this.Layers.get(0)).Neurons();
        float percentage = this.ilp;
        for (x = 0; x < basicneurons.length; ++x) {
            if (Math.random() < (double)percentage) {
                basicneurons[x].Output = 0.0f;
                this.dropout[0][x] = true;
                continue;
            }
            this.dropout[0][x] = false;
        }
        basicneurons = null;
        percentage = this.hlp;
        for (int i2 = 1; i2 < length; ++i2) {
            Layer layer = (Layer)this.Layers.get(i2);
            layer.Compute();
            if (this.dropout[i2] != null) {
                Neuron[] neurons = (Neuron[])layer.Neurons();
                for (x = 0; x < neurons.length; ++x) {
                    if (Math.random() < (double)percentage) {
                        neurons[x].Output = 0.0f;
                        neurons[x].Combined = 0.0f;
                        this.dropout[i2][x] = true;
                        continue;
                    }
                    this.dropout[i2][x] = false;
                }
                Object var3_7 = null;
            }
            layer = null;
        }
    }

    @Override
    protected void FullConnLERP(int layernum, boolean last) throws Exception {
        Layer layer = (Layer)this.Layers.get(layernum);
        Neuron[] neurons = (Neuron[])layer.Neurons();
        Function1D derivative = ((Differentiable)layer.Activation()).Derivative();
        if (layer.Activation().hasConstant()) {
            throw new Exception("Constant in the activation function not supported (yet).");
        }
        int length = neurons[0].Combination.Dimension();
        if (layer.hasVirtualBias()) {
            --length;
        }
        boolean[] drop = this.dropout[layernum];
        for (int n = 0; n < neurons.length; ++n) {
            if (drop != null && drop[n]) continue;
            NeuronBP neuron = (NeuronBP)neurons[n];
            neuron.Error *= derivative.Compute(neuron.Combined);
            if (!last) {
                float[] weights = neuron.Combination.getCoefficients((float[])null);
                BasicNeuron[] connexions = neuron.Synapses();
                for (int ne = 0; ne < length; ++ne) {
                    ((NeuronBackProp)((Object)connexions[ne])).AddError(neuron.Error * weights[ne]);
                }
                weights = null;
                connexions = null;
            }
            neuron = null;
        }
        layer = null;
        neurons = null;
        derivative = null;
        drop = null;
    }

    @Override
    protected void FullConnLWU(int layernum) {
        Layer layer = (Layer)this.Layers.get(layernum);
        Neuron[] neurons = (Neuron[])layer.Neurons();
        boolean[] drop = this.dropout[layernum];
        for (int n = 0; n < neurons.length; ++n) {
            if (drop != null && drop[n]) continue;
            NeuronBP neuron = (NeuronBP)neurons[n];
            BasicNeuron[] connexions = neuron.Synapses();
            float[] weights = neuron.Combination.getCoefficients((float[])null);
            int ne = 0;
            while (ne < weights.length) {
                float grad = this.gradbp.Compute(neuron.Error * connexions[ne].Output, ne, neuron.LearningRates, neuron.GradientsK1, neuron.GradientsK2);
                int n2 = ne++;
                weights[n2] = weights[n2] - grad;
                this.CurrentWeightsError += Math.abs(grad);
            }
            weights = null;
            neuron = null;
            connexions = null;
        }
        layer = null;
        neurons = null;
        drop = null;
    }

    @Override
    public void LinkNeuralNetwork(NeuralNetwork nn) {
        this.Check(nn);
        this.neuralnet = nn;
        this.Layers = this.neuralnet.Layers();
        this.Allocate();
    }

    protected void Allocate() {
        this.dropout = new boolean[this.Layers.size()][];
        int length = this.Layers.size() - 1;
        for (int i2 = 0; i2 < length; ++i2) {
            BasicLayer layer = (BasicLayer)this.Layers.get(i2);
            if (layer instanceof InputLayer || layer instanceof FullyConnectedLayer) {
                this.dropout[i2] = new boolean[layer.Neurons().length];
            }
            layer = null;
        }
    }
}

