/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.neurons;

import arrayTiTi.ArrayArithmetic;
import dataMining.classifiers.neuralnet.neurons.NeuronSimple;
import dataMining.classifiers.neuralnet.neurons.SimpleNeuron;
import java.util.Arrays;
import mathematics.functions.Function;

public class NeuronSimpleBP
extends NeuronSimple {
    public float[] LearningRates;
    public float Error;
    public float[] GradientsK1;
    public float[] GradientsK2;

    public NeuronSimpleBP(Function Combination) {
        super(Combination);
    }

    public void Allocate() {
        if (this.LearningRates == null) {
            this.LearningRates = new float[this.Combination.Dimension()];
            this.GradientsK1 = new float[this.Combination.Dimension()];
            this.GradientsK2 = new float[this.Combination.Dimension()];
        }
        Arrays.fill(this.LearningRates, 0.1f);
        Arrays.fill(this.GradientsK1, 0.0f);
        Arrays.fill(this.GradientsK2, 0.0f);
    }

    @Override
    public SimpleNeuron Instance() {
        return new NeuronSimpleBP(null);
    }

    @Override
    public SimpleNeuron[] Instances(int length) {
        SimpleNeuron[] instances = new NeuronSimpleBP[length];
        for (int i2 = 0; i2 < length; ++i2) {
            instances[i2] = new NeuronSimpleBP(null);
        }
        return instances;
    }

    public float Error() {
        return this.Error;
    }

    public void AddError(float error) {
        this.Error += error;
    }

    public void ResetError() {
        this.Error = 0.0f;
    }

    public float[] LearningRates() {
        return this.LearningRates;
    }

    public void MultiplyLearningRates(float coefficient) {
        ArrayArithmetic.Multiply((float[])this.LearningRates, (float)coefficient, (float[])this.LearningRates);
    }

    public float[] GradientsK1() {
        return this.GradientsK1;
    }

    public float[] GradientsK2() {
        return this.GradientsK2;
    }

    public SimpleNeuron NonTrainableInstance() {
        return new NeuronSimple(null);
    }
}

