/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.neurons;

import dataMining.classifiers.neuralnet.neurons.SimpleNeuron;
import mathematics.Maths;

public class NeuronLp
extends SimpleNeuron {
    public final int p;

    public NeuronLp(int p) {
        if (p <= 0) {
            throw new IllegalArgumentException("p <= 0. A positive value is expected.");
        }
        this.p = p;
    }

    @Override
    public SimpleNeuron Instance() {
        return new NeuronLp(this.p);
    }

    @Override
    public SimpleNeuron[] Instances(int length) {
        SimpleNeuron[] instances = new NeuronLp[length];
        for (int i2 = 0; i2 < length; ++i2) {
            instances[i2] = new NeuronLp(this.p);
        }
        return instances;
    }

    @Override
    public void Compute(float[] buffer, boolean prefilled) {
        float pow = 1.0f / (float)this.p;
        this.Output = 0.0f;
        for (int i2 = 0; i2 < this.Synapses.length; ++i2) {
            this.Output += Maths.Power((float)this.Synapses[i2].Output, (int)this.p);
        }
        this.Output = (float)Math.pow(this.Output, pow);
    }
}

