/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.neurons;

import arrayTiTi.ArrayArithmetic;
import dataMining.classifiers.neuralnet.neurons.Neuron;
import dataMining.classifiers.neuralnet.neurons.NeuronBackProp;
import dataMining.classifiers.neuralnet.neurons.NeuronBackPropWeightsSharing;
import dataMining.classifiers.neuralnet.neurons.SimpleNeuron;
import dataMining.classifiers.neuralnet.optimization.backpropagation.GradientBP;
import java.util.Arrays;
import mathematics.functions.Differentiable;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class NeuronBP
extends Neuron
implements NeuronBackPropWeightsSharing {
    public float[] LearningRates;
    public float Error;
    public float[] GradientsK1;
    public float[] GradientsK2;

    public NeuronBP(Function Combination, Function1D Activation) {
        super(Combination, Activation);
    }

    @Override
    public void Allocate() {
        if (this.LearningRates == null) {
            this.LearningRates = new float[this.Combination.Dimension()];
            this.GradientsK1 = new float[this.Combination.Dimension()];
            this.GradientsK2 = new float[this.Combination.Dimension()];
        }
        Arrays.fill(this.LearningRates, 0.1f);
        Arrays.fill(this.GradientsK1, 0.0f);
        Arrays.fill(this.GradientsK2, 0.0f);
    }

    @Override
    public void RetropropagateError(boolean last) {
        Function1D derivative = ((Differentiable)this.Activation).Derivative();
        this.Error *= derivative.Compute(this.Combined);
        derivative = null;
        if (last) {
            return;
        }
        float[] weights = this.Combination.getCoefficients((float[])null);
        NeuronBackProp[] synapses = (NeuronBackProp[])this.Synapses;
        for (int ne = 0; ne < this.Synapses.length; ++ne) {
            synapses[ne].AddError(this.Error * weights[ne]);
        }
        weights = null;
        synapses = null;
    }

    @Override
    public float UpdateWeights(GradientBP function) {
        float CurrentWeightsError = 0.0f;
        float[] weights = this.Combination.getCoefficients((float[])null);
        int ne = 0;
        while (ne < weights.length) {
            float grad = function.Compute(this.Error * this.Synapses[ne].Output, ne, this.LearningRates, this.GradientsK1, this.GradientsK2);
            int n = ne++;
            weights[n] = weights[n] - grad;
            CurrentWeightsError += Math.abs(grad);
        }
        weights = null;
        return CurrentWeightsError;
    }

    @Override
    public void UpdateWeights(float[] buffer) {
        float[] weights = this.Combination.getCoefficients((float[])null);
        for (int ne = 0; ne < weights.length; ++ne) {
            int n = ne;
            buffer[n] = buffer[n] + this.Error * this.Synapses[ne].Output;
        }
        weights = null;
    }

    @Override
    public float UpdateWeights(float[] buffer, GradientBP function) {
        float CurrentWeightsError = 0.0f;
        float[] weights = this.Combination.getCoefficients((float[])null);
        int ne = 0;
        while (ne < weights.length) {
            float grad = function.Compute(buffer[ne], ne, this.LearningRates, this.GradientsK1, this.GradientsK2);
            int n = ne++;
            weights[n] = weights[n] - grad;
            CurrentWeightsError += Math.abs(grad);
        }
        return CurrentWeightsError;
    }

    @Override
    public SimpleNeuron Instance() {
        return new NeuronBP(null, null);
    }

    @Override
    public SimpleNeuron[] Instances(int length) {
        SimpleNeuron[] instances = new NeuronBP[length];
        for (int i2 = 0; i2 < length; ++i2) {
            instances[i2] = new NeuronBP(null, null);
        }
        return instances;
    }

    @Override
    public float Error() {
        return this.Error;
    }

    @Override
    public void AddError(float error) {
        this.Error += error;
    }

    @Override
    public void ResetError() {
        this.Error = 0.0f;
    }

    @Override
    public float[] LearningRates() {
        return this.LearningRates;
    }

    @Override
    public void MultiplyLearningRates(float coefficient) {
        ArrayArithmetic.Multiply((float[])this.LearningRates, (float)coefficient, (float[])this.LearningRates);
    }

    @Override
    public float[] GradientsK1() {
        return this.GradientsK1;
    }

    @Override
    public float[] GradientsK2() {
        return this.GradientsK2;
    }

    @Override
    public SimpleNeuron NonTrainableInstance() {
        return new Neuron(null, null);
    }
}

