/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers.pooling;

import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.pooling.SubSamplingLayer;
import dataMining.classifiers.neuralnet.neurons.BasicNeuron;
import dataMining.classifiers.neuralnet.neurons.NeuronBackProp;
import dataMining.classifiers.neuralnet.neurons.NeuronPooling;

public class PoolingLayer
extends SubSamplingLayer {
    public PoolingLayer(int DelayX, int DelayY, int StepX, int StepY, NeuronPooling neuronsample) {
        super(DelayX, DelayY, StepX, StepY, neuronsample);
    }

    @Override
    protected void BuildLayer() {
        this.prevwidth = this.previouslayer.Width();
        this.prevheight = this.previouslayer.Height();
        this.prevnbchar = this.previouslayer.nbFeaturesMaps();
        this.prevchardim = this.prevwidth * this.prevheight;
        this.previncy = this.prevwidth * this.StepY;
        if (this.prevwidth < this.DelayX) {
            throw new IllegalArgumentException("Previous layer characteristic width < DelayX.");
        }
        this.width = (this.prevwidth - this.DelayX) / this.StepX + 1;
        if (this.prevheight < this.DelayY) {
            throw new IllegalArgumentException("Previous layer characteristic height < DelayY.");
        }
        this.height = (this.prevheight - this.DelayY) / this.StepY + 1;
        this.nbfeaturesmaps = this.prevnbchar;
        this.chardim = this.width * this.height;
        if (this.chardim == 0) {
            throw new IllegalArgumentException("Dimension equal to 0.");
        }
        this.neurons = this.neuronsample.Instances(this.prevnbchar * this.chardim);
        BasicNeuron[] prevneurons = this.previouslayer.Neurons();
        int prevstartpos = 0;
        int pos = 0;
        int m = 0;
        while (m < this.nbfeaturesmaps) {
            int y = 0;
            int prevy = prevstartpos;
            while (y < this.height) {
                int x = 0;
                int prevpos = prevy;
                while (x < this.width) {
                    BasicNeuron[] synapses = this.previouslayer.NeuronSample().Instances(this.DelayX * this.DelayY);
                    int possyn = 0;
                    int dy = 0;
                    int py = prevpos;
                    while (dy < this.DelayY) {
                        int dx = 0;
                        int p = py;
                        while (dx < this.DelayX) {
                            synapses[possyn] = prevneurons[p];
                            ++dx;
                            ++possyn;
                            ++p;
                        }
                        ++dy;
                        py += this.prevwidth;
                    }
                    this.neurons[pos++].Synapses(synapses);
                    synapses = null;
                    ++x;
                    prevpos += this.StepX;
                }
                ++y;
                prevy += this.previncy;
            }
            ++m;
            prevstartpos += this.prevchardim;
        }
    }

    @Override
    public BasicLayer CleanedInstance() {
        return new PoolingLayer(this.DelayX, this.DelayY, this.StepX, this.StepY, (NeuronPooling)((NeuronBackProp)((Object)this.NeuronSample())).NonTrainableInstance());
    }

    @Override
    public void CopyInstance(BasicLayer layer) {
        BasicNeuron[] ns = layer.Neurons();
        if (layer.getClass() != this.getClass()) {
            throw new IllegalArgumentException("The same layer type is required.");
        }
        if (ns.length != this.neurons.length) {
            throw new IllegalArgumentException("The layer to copy does not have the same number of neurons.");
        }
        if (!(ns[0] instanceof NeuronPooling)) {
            throw new IllegalArgumentException("The layer to copy does not contain NeuronPooling instances.");
        }
        ns = null;
    }

    @Override
    public BasicLayer Instance() {
        return new PoolingLayer(this.DelayX, this.DelayY, this.StepX, this.StepY, (NeuronPooling)this.NeuronSample());
    }
}

