/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers.fullyconnected;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.fullyconnected.OutputLayer;
import dataMining.classifiers.neuralnet.neurons.Neuron;
import dataMining.classifiers.neuralnet.neurons.NeuronBackProp;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class OutputSoftMaxLayer
extends OutputLayer {
    private float[] Outputs = null;
    private float alpha = 1.0f;
    private ArrayFeatures AF = new ArrayFeatures();

    public OutputSoftMaxLayer(int nbfeaturesmaps, int width, int height, Function Combination, Function1D Activation, boolean addVirtualBias, float alpha, Neuron sampleneuron) {
        super(nbfeaturesmaps, width, height, Combination, Activation, addVirtualBias, sampleneuron);
        if (width == height && width == 1) {
            throw new IllegalArgumentException("A softmax layer does not make any sense with a single output.");
        }
        this.alpha = alpha;
    }

    @Override
    public void Compute() {
        super.Compute();
        for (int i2 = 0; i2 < this.neurons.length; ++i2) {
            this.Outputs[i2] = (float)Math.exp(this.alpha * this.neurons[i2].Output);
        }
        float sum = (float)this.AF.Integral(this.Outputs);
        ArrayArithmetic.Divide((float[])this.Outputs, (float)sum, (float[])this.Outputs);
    }

    @Override
    public float[] Predictions() {
        return this.Outputs;
    }

    @Override
    public void NextLayer(BasicLayer layer) {
        if (layer != null) {
            throw new IllegalArgumentException("An OutputLayer cannot have a next layer (it is the last).");
        }
        this.BuildLayer();
        this.Outputs = new float[this.neurons.length];
    }

    @Override
    public BasicLayer CleanedInstance() {
        return new OutputSoftMaxLayer(this.nbfeaturesmaps, this.width, this.height, this.combination, this.activation, this.addVirtualBias, this.alpha, (Neuron)((NeuronBackProp)((Object)this.NeuronSample())).NonTrainableInstance());
    }

    @Override
    public BasicLayer Instance() {
        return new OutputSoftMaxLayer(this.nbfeaturesmaps, this.width, this.height, this.combination, this.activation, this.addVirtualBias, this.alpha, (Neuron)this.NeuronSample());
    }
}

