/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers.fullyconnected;

import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.fullyconnected.FullyConnectedLayer;
import dataMining.classifiers.neuralnet.neurons.BasicNeuron;
import dataMining.classifiers.neuralnet.neurons.Neuron;
import dataMining.classifiers.neuralnet.neurons.NeuronBackProp;
import java.util.List;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class MultiStageLayer
extends FullyConnectedLayer {
    protected BasicLayer[] layers = null;

    public MultiStageLayer(int nbfeaturesmaps, int width, int height, Function combination, Function1D activation, boolean addVirtualBias, Neuron neuronsample, BasicLayer ... layers) {
        super(nbfeaturesmaps, width, height, combination, activation, addVirtualBias, neuronsample);
        if (layers == null || layers.length == 0) {
            throw new IllegalArgumentException("No connected layers (layers == null || layers.length == 0).");
        }
        this.layers = layers;
    }

    public MultiStageLayer(int nbfeaturesmaps, int width, int height, Function combination, Function1D activation, boolean addVirtualBias, Neuron neuronsample, List<BasicLayer> layers) {
        this(nbfeaturesmaps, width, height, combination, activation, addVirtualBias, neuronsample, layers.toArray((BasicLayer[])null));
    }

    protected void BuildLayer3() {
        int x;
        this.neurons = new Neuron[this.nbfeaturesmaps * this.height * this.width];
        BasicNeuron[] prevneurons = this.previouslayer.Neurons();
        this.buffer = new float[prevneurons.length + (this.addVirtualBias ? 1 : 0)];
        for (x = 0; x < this.neurons.length; ++x) {
            this.neurons[x] = this.neuronsample.Instance();
            ((Neuron)this.neurons[x]).Combination = this.combination.Instance(this.buffer);
            ((Neuron)this.neurons[x]).Activation = this.activation;
        }
        if (this.addVirtualBias) {
            this.virtualbias = (Neuron)this.neuronsample.Instance();
        }
        BasicNeuron[] connexions = new BasicNeuron[this.buffer.length];
        for (x = 0; x < prevneurons.length; ++x) {
            connexions[x] = prevneurons[x];
        }
        if (this.addVirtualBias) {
            connexions[x] = this.virtualbias;
        }
        for (x = 0; x < this.neurons.length; ++x) {
            this.neurons[x].Synapses(connexions);
        }
        prevneurons = null;
        connexions = null;
    }

    @Override
    protected void BuildLayer() {
        int x;
        this.neurons = new Neuron[this.nbfeaturesmaps * this.height * this.width];
        int nbsyn = this.previouslayer.Neurons().length;
        for (x = 0; x < this.layers.length; ++x) {
            nbsyn += this.layers[x].Neurons().length;
        }
        this.buffer = new float[nbsyn + (this.addVirtualBias ? 1 : 0)];
        for (x = 0; x < this.neurons.length; ++x) {
            this.neurons[x] = this.neuronsample.Instance();
            ((Neuron)this.neurons[x]).Combination = this.combination.Instance(this.buffer);
            ((Neuron)this.neurons[x]).Activation = this.activation;
        }
        if (this.addVirtualBias) {
            this.virtualbias = (Neuron)this.neuronsample.Instance();
        }
        BasicNeuron[] connexions = new BasicNeuron[this.buffer.length];
        BasicNeuron[] prevneurons = this.previouslayer.Neurons();
        int pos = 0;
        for (x = 0; x < prevneurons.length; ++x) {
            connexions[pos++] = prevneurons[x];
        }
        prevneurons = null;
        for (int y = 0; y < this.layers.length; ++y) {
            prevneurons = this.layers[y].Neurons();
            for (x = 0; x < prevneurons.length; ++x) {
                connexions[pos++] = prevneurons[x];
            }
            prevneurons = null;
        }
        if (this.addVirtualBias) {
            connexions[pos++] = this.virtualbias;
        }
        for (x = 0; x < this.neurons.length; ++x) {
            this.neurons[x].Synapses(connexions);
        }
        prevneurons = null;
        connexions = null;
    }

    @Override
    public BasicLayer CleanedInstance() {
        return new MultiStageLayer(this.nbfeaturesmaps, this.width, this.height, this.combination, this.activation, this.addVirtualBias, (Neuron)((NeuronBackProp)((Object)this.NeuronSample())).NonTrainableInstance(), this.layers);
    }

    @Override
    public BasicLayer Instance() {
        return new MultiStageLayer(this.nbfeaturesmaps, this.width, this.height, this.combination, this.activation, this.addVirtualBias, (Neuron)this.NeuronSample(), this.layers);
    }
}

