/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers.fullyconnected;

import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.fullyconnected.FullyConnectedLayer;
import dataMining.classifiers.neuralnet.neurons.BasicNeuron;
import dataMining.classifiers.neuralnet.neurons.Neuron;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class FullyConnectedLayerMT
extends FullyConnectedLayer {
    private FullyConnectedLayerThread[] threads = null;
    private int nbFreeThreads = 0;
    private int step = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullyConnectedLayerMT(int nbfeaturesmaps, int width, int height, Function Combination, Function1D Activation, boolean addVirtualBias, Neuron sampleneuron, int nbCPU) {
        super(nbfeaturesmaps, width, height, Combination, Activation, addVirtualBias, sampleneuron);
        this.threads = new FullyConnectedLayerThread[nbCPU];
        for (int i2 = 0; i2 < this.threads.length; ++i2) {
            this.threads[i2] = new FullyConnectedLayerThread();
            this.threads[i2].start();
        }
        FullyConnectedLayerMT fullyConnectedLayerMT = this;
        synchronized (fullyConnectedLayerMT) {
            while (this.nbFreeThreads != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void BuildLayerMT() {
        int i2 = 0;
        this.step = this.neurons.length / this.threads.length;
        BasicNeuron[] prevneurons = this.previouslayer.Neurons();
        for (i2 = 0; i2 < this.threads.length - 1; ++i2) {
            this.threads[i2].Activation = (Function1D)this.activation.Clone();
            this.threads[i2].buffer = new float[prevneurons.length + (this.addVirtualBias ? 1 : 0)];
        }
        this.threads[i2].buffer = this.buffer;
        this.threads[i2].Activation = this.activation;
        prevneurons = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void Compute() {
        Object object;
        int i2;
        this.nbFreeThreads = 0;
        BasicNeuron[] synapses = ((Neuron)this.neurons[0]).Synapses();
        for (i2 = 0; i2 < synapses.length; ++i2) {
            this.buffer[i2] = synapses[i2].Output;
        }
        synapses = null;
        for (i2 = 0; i2 < this.threads.length - 1; ++i2) {
            this.threads[i2].setConditions(i2 * this.step, (i2 + 1) * this.step, this.buffer);
            object = this.threads[i2].lock;
            synchronized (object) {
                this.threads[i2].lock.notify();
                continue;
            }
        }
        this.threads[i2].setConditions(i2 * this.step, this.neurons.length);
        object = this.threads[i2].lock;
        synchronized (object) {
            this.threads[i2].lock.notify();
        }
        object = this;
        synchronized (object) {
            while (this.nbFreeThreads != this.threads.length) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public BasicLayer CleanedInstance() {
        return new FullyConnectedLayerMT(this.nbfeaturesmaps, this.width, this.height, this.combination, this.activation, this.addVirtualBias, new Neuron(null, null), this.threads.length);
    }

    @Override
    public BasicLayer Instance() {
        return new FullyConnectedLayerMT(this.nbfeaturesmaps, this.width, this.height, this.combination, this.activation, this.addVirtualBias, (Neuron)this.NeuronSample(), this.threads.length);
    }

    @Override
    public void PreviousLayer(BasicLayer layer) {
        this.previouslayer = layer;
        this.BuildLayer();
        this.BuildLayerMT();
    }

    @Override
    public Function1D Activation() {
        return this.threads[0].Activation;
    }

    protected synchronized void addFreeThread() {
        ++this.nbFreeThreads;
        this.notify();
    }

    private class FullyConnectedLayerThread
    extends Thread {
        private int first;
        private int last;
        public Function1D Activation = null;
        public float[] buffer = null;
        public Object lock = new Object();

        public void setConditions(int first, int last) {
            this.first = first;
            this.last = last;
        }

        public void setConditions(int first, int last, float[] buffer) {
            System.arraycopy(buffer, 0, this.buffer, 0, buffer.length);
            this.first = first;
            this.last = last;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        FullyConnectedLayerMT.this.addFreeThread();
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    for (int i2 = this.first; i2 < this.last; ++i2) {
                        FullyConnectedLayerMT.this.neurons[i2].Compute(this.buffer, true);
                    }
                }
            }
        }
    }
}

