/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers.fullyconnected;

import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.Layer;
import dataMining.classifiers.neuralnet.neurons.BasicNeuron;
import dataMining.classifiers.neuralnet.neurons.Neuron;
import dataMining.classifiers.neuralnet.neurons.NeuronBackProp;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class FullyConnectedLayer
extends Layer {
    protected BasicNeuron virtualbias = null;
    protected float[] buffer = null;
    protected Neuron neuronsample = null;

    public FullyConnectedLayer(int nbfeaturesmaps, int width, int height, Function combination, Function1D activation, boolean addVirtualBias, Neuron neuronsample) {
        super(nbfeaturesmaps, width, height, combination, activation, addVirtualBias);
        this.neuronsample = neuronsample;
    }

    @Override
    protected void BuildLayer() {
        int x;
        this.neurons = this.neuronsample.Instances(this.nbfeaturesmaps * this.height * this.width);
        BasicNeuron[] prevneurons = this.previouslayer.Neurons();
        this.buffer = new float[prevneurons.length + (this.addVirtualBias ? 1 : 0)];
        for (x = 0; x < this.neurons.length; ++x) {
            ((Neuron)this.neurons[x]).Combination = this.combination.Instance(this.buffer);
            ((Neuron)this.neurons[x]).Activation = this.activation;
        }
        if (this.addVirtualBias) {
            this.virtualbias = this.previouslayer.NeuronSample().Instance();
        }
        BasicNeuron[] connexions = this.previouslayer.NeuronSample().Instances(this.buffer.length);
        for (x = 0; x < prevneurons.length; ++x) {
            connexions[x] = prevneurons[x];
        }
        if (this.addVirtualBias) {
            connexions[x] = this.virtualbias;
        }
        for (x = 0; x < this.neurons.length; ++x) {
            this.neurons[x].Synapses(connexions);
        }
        prevneurons = null;
        connexions = null;
    }

    @Override
    public void Compute() {
        BasicNeuron[] synapses = ((Neuron)this.neurons[0]).Synapses();
        for (int i2 = 0; i2 < synapses.length; ++i2) {
            this.buffer[i2] = synapses[i2].Output;
        }
        synapses = null;
        for (int x = 0; x < this.neurons.length; ++x) {
            this.neurons[x].Compute(this.buffer, true);
        }
    }

    @Override
    public BasicNeuron NeuronSample() {
        return this.neurons[0];
    }

    @Override
    public int nbWeights() {
        return this.nbfeaturesmaps * this.width * this.height * ((Neuron)this.neurons[0]).Combination.Dimension();
    }

    @Override
    public int nbConnexionsReal() {
        return this.nbWeights();
    }

    @Override
    public int nbConnexions() {
        return this.nbfeaturesmaps * this.width * this.height * (((Neuron)this.neurons[0]).Combination.Dimension() + (this.activation.hasConstant() ? 1 : 0));
    }

    @Override
    public BasicLayer CleanedInstance() {
        return new FullyConnectedLayer(this.nbfeaturesmaps, this.width, this.height, this.combination, this.activation, this.addVirtualBias, (Neuron)((NeuronBackProp)((Object)this.NeuronSample())).NonTrainableInstance());
    }

    @Override
    public void CopyInstance(BasicLayer layer) {
        BasicNeuron[] ns = layer.Neurons();
        if (!(layer instanceof FullyConnectedLayer)) {
            throw new IllegalArgumentException("The same layer type is required.");
        }
        if (ns.length != this.neurons.length) {
            throw new IllegalArgumentException("The layer to copy does not have the same number of neurons.");
        }
        if (!(ns[0] instanceof Neuron)) {
            throw new IllegalArgumentException("The layer to copy does not contain Neuron instances.");
        }
        for (int n = 0; n < ns.length; ++n) {
            Neuron n1 = (Neuron)ns[n];
            Neuron n2 = (Neuron)this.neurons[n];
            n2.Activation.setCoefficients(n1.Activation.getCoefficients((float[])null));
            n2.Combination.setCoefficients(n1.Combination.getCoefficients((float[])null));
            n2 = null;
            n1 = null;
        }
        ns = null;
    }

    @Override
    public BasicLayer Instance() {
        return new FullyConnectedLayer(this.nbfeaturesmaps, this.width, this.height, this.combination, this.activation, this.addVirtualBias, (Neuron)this.NeuronSample());
    }
}

