/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers.convolutional;

import arrayTiTi.ArrayOperations;
import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.convolutional.ConvolutionalLayer;
import dataMining.classifiers.neuralnet.neurons.Neuron;
import java.util.Arrays;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class ConvolutionalRandomLayer
extends ConvolutionalLayer {
    private final int MaxIterations = 1000;

    public ConvolutionalRandomLayer(int nbCharacteristics, int MinNumberFeaturesMap, int MaxNumberFeaturesMap, int DelayX, int DelayY, int StepX, int StepY, Function Combination, Function1D Activation, Neuron sampleneuron) {
        super(null, DelayX, DelayY, StepX, StepY, Combination, Activation, sampleneuron);
        if (nbCharacteristics < 1) {
            throw new IllegalArgumentException("nbCharacteristics < 1.");
        }
        if (MinNumberFeaturesMap < 1) {
            throw new IllegalArgumentException("MinNumberFeaturesMap < 1.");
        }
        if (MaxNumberFeaturesMap < MinNumberFeaturesMap) {
            throw new IllegalArgumentException("MaxNumberFeaturesMap < MinNumberFeaturesMap.");
        }
        this.nbfeaturesmaps = nbCharacteristics;
        this.MinNumberFeaturesMap = MinNumberFeaturesMap;
        this.MaxNumberFeaturesMap = MaxNumberFeaturesMap;
        this.ConnexionsMode = -3;
    }

    @Override
    public void PreviousLayer(BasicLayer layer) {
        boolean done;
        this.previouslayer = layer;
        int prevnbchar = this.previouslayer.nbFeaturesMaps();
        this.FeaturesMapConnexions = new byte[this.nbfeaturesmaps][prevnbchar];
        this.nbfm = new int[this.nbfeaturesmaps];
        int range = this.MaxNumberFeaturesMap - this.MinNumberFeaturesMap + 1;
        int safety = 0;
        int[] hist = new int[prevnbchar];
        do {
            int j;
            int i2;
            for (i2 = 0; i2 < this.nbfm.length; ++i2) {
                this.nbfm[i2] = (int)(Math.random() * (double)range) + this.MinNumberFeaturesMap;
            }
            Arrays.sort(this.nbfm);
            ArrayOperations.Fill((byte[][])this.FeaturesMapConnexions, (int)0);
            for (i2 = 0; i2 < this.FeaturesMapConnexions.length; ++i2) {
                Arrays.fill(this.FeaturesMapConnexions[i2], 0, this.nbfm[i2], (byte)1);
                for (j = 0; j < this.nbfm[i2]; ++j) {
                    int r = (int)(Math.random() * (double)prevnbchar);
                    byte tmp = this.FeaturesMapConnexions[i2][j];
                    this.FeaturesMapConnexions[i2][j] = this.FeaturesMapConnexions[i2][r];
                    this.FeaturesMapConnexions[i2][r] = tmp;
                }
            }
            Arrays.fill(hist, 0);
            for (i2 = 0; i2 < this.FeaturesMapConnexions.length; ++i2) {
                for (j = 0; j < prevnbchar; ++j) {
                    int n = j;
                    hist[n] = hist[n] + this.FeaturesMapConnexions[i2][j];
                }
            }
            done = true;
            for (i2 = 0; i2 < hist.length; ++i2) {
                if (hist[i2] != 0) continue;
                done = false;
            }
            if (1000 >= safety++) continue;
            throw new IllegalArgumentException("Random connexions safety exception. Cannot build the random connexions. Probably not features map enough, according to MinNumberFeaturesMap/MaxNumberFeaturesMap.");
        } while (!done);
        hist = null;
        this.BuildLayer();
    }

    @Override
    public BasicLayer Instance() {
        return new ConvolutionalRandomLayer(this.nbfeaturesmaps, this.MinNumberFeaturesMap, this.MaxNumberFeaturesMap, this.DelayX, this.DelayY, this.StepX, this.StepY, this.combination, this.activation, (Neuron)this.NeuronSample());
    }
}

