/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers.convolutional;

import arrayTiTi.ArrayFeatures;
import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.Layer;
import dataMining.classifiers.neuralnet.neurons.BasicNeuron;
import dataMining.classifiers.neuralnet.neurons.Neuron;
import dataMining.classifiers.neuralnet.neurons.NeuronBackProp;
import dataMining.classifiers.neuralnet.neurons.SimpleNeuron;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class ConvolutionalLayer
extends Layer {
    protected int MinNumberFeaturesMap = -1;
    protected int MaxNumberFeaturesMap = -1;
    protected byte[][] FeaturesMapConnexions = null;
    protected int[] nbfm = null;
    protected int chardim;
    protected int DelayX;
    protected int DelayY;
    protected int StepX;
    protected int StepY;
    protected Neuron sampleneuron = null;
    protected float[][] buffer = null;
    protected final int IMPOSED = -1;
    protected final int CYCLING = -2;
    protected final int RANDOM = -3;
    protected final int FULL = -4;
    protected int ConnexionsMode = 0;
    protected ArrayFeatures AF = new ArrayFeatures();

    public ConvolutionalLayer(byte[][] FeaturesMapConnexions, int DelayX, int DelayY, int StepX, int StepY, Function Combination, Function1D Activation, Neuron sampleneuron) {
        super(1, 1, 1, Combination, Activation, false);
        if (DelayX < 1) {
            throw new IllegalArgumentException("DelayX < 1.");
        }
        if (DelayY < 1) {
            throw new IllegalArgumentException("DelayY < 1.");
        }
        if (StepX < 1) {
            throw new IllegalArgumentException("StepX < 1.");
        }
        if (StepY < 1) {
            throw new IllegalArgumentException("StepY < 1.");
        }
        this.FeaturesMapConnexions = FeaturesMapConnexions;
        this.DelayX = DelayX;
        this.DelayY = DelayY;
        this.StepX = StepX;
        this.StepY = StepY;
        this.sampleneuron = sampleneuron;
        if (FeaturesMapConnexions != null) {
            this.nbfm = new int[FeaturesMapConnexions.length];
            for (int i2 = 0; i2 < this.nbfm.length; ++i2) {
                this.nbfm[i2] = (int)this.AF.Integral(FeaturesMapConnexions[i2]);
            }
            this.MinNumberFeaturesMap = this.AF.Minimum(this.nbfm);
            this.MaxNumberFeaturesMap = this.AF.Maximum(this.nbfm);
        }
        this.ConnexionsMode = -1;
    }

    @Override
    protected void BuildLayer() {
        int i2;
        if (this.ConnexionsMode == -1 && this.FeaturesMapConnexions == null || this.MinNumberFeaturesMap <= 0) {
            throw new IllegalArgumentException("The features map connexions array cannot be null.");
        }
        switch (this.ConnexionsMode) {
            case -4: 
            case -3: 
            case -2: 
            case -1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: Unknow connexion type. MUST NOT OCCURED!");
            }
        }
        int prevwidth = this.previouslayer.Width();
        int prevheight = this.previouslayer.Height();
        int prevchardim = prevwidth * prevheight;
        int prevnbchar = this.previouslayer.nbFeaturesMaps();
        if (prevnbchar < this.MaxNumberFeaturesMap) {
            throw new IllegalArgumentException("MaxNumberFeaturesMap greatter than the features map number.");
        }
        if (this.previouslayer.Width() < this.DelayX) {
            throw new IllegalArgumentException("Previous layer characteristic width < DelayX.");
        }
        this.width = (this.previouslayer.Width() - this.DelayX) / this.StepX + 1;
        if (this.previouslayer.Height() < this.DelayY) {
            throw new IllegalArgumentException("Previous layer characteristic height < DelayY.");
        }
        this.height = (this.previouslayer.Height() - this.DelayY) / this.StepY + 1;
        this.chardim = this.width * this.height;
        if (this.chardim == 0) {
            throw new IllegalArgumentException("Dimension equal to 0.");
        }
        this.nbfeaturesmaps = this.FeaturesMapConnexions.length;
        this.neurons = this.sampleneuron.Instances(this.nbfeaturesmaps * this.chardim);
        this.nbfm = new int[this.FeaturesMapConnexions.length];
        for (i2 = 0; i2 < this.nbfm.length; ++i2) {
            this.nbfm[i2] = (int)this.AF.Integral(this.FeaturesMapConnexions[i2]);
        }
        this.buffer = new float[this.MaxNumberFeaturesMap + 1][];
        for (i2 = this.MinNumberFeaturesMap; i2 <= this.MaxNumberFeaturesMap; ++i2) {
            this.buffer[i2] = new float[i2 * this.DelayX * this.DelayY];
        }
        int pos = 0;
        for (i2 = 0; i2 < this.nbfeaturesmaps; ++i2) {
            float[] weights = new float[this.nbfm[i2] * this.DelayX * this.DelayY];
            Function comb = this.combination.Instance(weights);
            for (int y = 0; y < this.height; ++y) {
                int x = 0;
                while (x < this.width) {
                    ((Neuron)this.neurons[pos]).Combination = comb;
                    ((Neuron)this.neurons[pos]).Activation = this.activation;
                    ++x;
                    ++pos;
                }
            }
            comb = null;
        }
        BasicNeuron[] prevneurons = this.previouslayer.Neurons();
        int pos2 = 0;
        for (int conf = 0; conf < this.FeaturesMapConnexions.length; ++conf) {
            byte[] connexions = this.FeaturesMapConnexions[conf];
            int y = 0;
            int prevstarty = 0;
            while (y < this.height) {
                int x = 0;
                int prevstartx = 0;
                while (x < this.width) {
                    BasicNeuron[] synapses = this.previouslayer.NeuronSample().Instances(((Neuron)this.neurons[pos2]).Combination.Dimension());
                    int prevstartpos = 0;
                    int posyn = 0;
                    int map = 0;
                    while (map < prevnbchar) {
                        if (connexions[map] != 0) {
                            int p = prevstartpos + prevstarty * prevwidth + prevstartx;
                            int dy = 0;
                            while (dy < this.DelayY) {
                                for (int dx = 0; dx < this.DelayX; ++dx) {
                                    synapses[posyn++] = prevneurons[p + dx];
                                }
                                ++dy;
                                p += prevwidth;
                            }
                        }
                        ++map;
                        prevstartpos += prevchardim;
                    }
                    this.neurons[pos2++].Synapses(synapses);
                    synapses = null;
                    ++x;
                    prevstartx += this.StepX;
                }
                ++y;
                prevstarty += this.StepY;
            }
            connexions = null;
        }
        prevneurons = null;
    }

    @Override
    public void Compute() {
        int pos = 0;
        for (int i2 = 0; i2 < this.nbfeaturesmaps; ++i2) {
            float[] buf = this.buffer[this.nbfm[i2]];
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.neurons[pos++].Compute(buf, false);
                }
            }
            Object var3_3 = null;
        }
    }

    @Override
    public BasicNeuron NeuronSample() {
        return this.neurons[0];
    }

    @Override
    public BasicLayer CleanedInstance() {
        return new ConvolutionalLayer(this.FeaturesMapConnexions, this.DelayX, this.DelayY, this.StepX, this.StepY, this.combination, this.activation, (Neuron)((NeuronBackProp)((Object)this.NeuronSample())).NonTrainableInstance());
    }

    @Override
    public void CopyInstance(BasicLayer layer) {
        BasicNeuron[] ns = layer.Neurons();
        if (!(layer instanceof ConvolutionalLayer)) {
            throw new IllegalArgumentException("The same layer type is required.");
        }
        if (ns.length != this.neurons.length) {
            throw new IllegalArgumentException("The layer to copy does not have the same number of neurons.");
        }
        if (!(ns[0] instanceof Neuron)) {
            throw new IllegalArgumentException("The layer to copy does not contain Neuron instances.");
        }
        for (int n = 0; n < ns.length; ++n) {
            Neuron n1 = (Neuron)ns[n];
            Neuron n2 = (Neuron)this.neurons[n];
            n2.Activation.setCoefficients(n1.Activation.getCoefficients((float[])null));
            n2.Combination.setCoefficients(n1.Combination.getCoefficients((float[])null));
            n2 = null;
            n1 = null;
        }
        ns = null;
    }

    @Override
    public BasicLayer Instance() {
        return new ConvolutionalLayer(this.FeaturesMapConnexions, this.DelayX, this.DelayY, this.StepX, this.StepY, this.combination, this.activation, (Neuron)this.NeuronSample());
    }

    public int StepX() {
        return this.StepX;
    }

    public int StepY() {
        return this.StepY;
    }

    public int DelayX() {
        return this.DelayX;
    }

    public int DelayY() {
        return this.DelayY;
    }

    @Override
    public int nbWeights() {
        int nb = 0;
        for (int i2 = 0; i2 < this.neurons.length; i2 += this.chardim) {
            nb += ((Neuron)this.neurons[i2]).Combination.Dimension();
        }
        return nb;
    }

    @Override
    public int nbConnexionsReal() {
        int nb = 0;
        int delta = this.combination.hasConstant() ? -1 : 0;
        for (SimpleNeuron neuron : this.neurons) {
            nb += ((Neuron)neuron).Combination.Dimension() + delta;
        }
        return nb;
    }

    @Override
    public int nbConnexions() {
        int nb = 0;
        for (SimpleNeuron neuron : this.neurons) {
            nb += ((Neuron)neuron).Combination.Dimension();
        }
        return nb;
    }

    public byte[][] FeaturesMapConnexions() {
        return this.FeaturesMapConnexions;
    }
}

