/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers.convolutional;

import arrayTiTi.ArrayOperations;
import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.convolutional.ConvolutionalLayer;
import dataMining.classifiers.neuralnet.neurons.Neuron;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public class ConvolutionalCyclicLayer
extends ConvolutionalLayer {
    public ConvolutionalCyclicLayer(int MinNumberFeaturesMap, int MaxNumberFeaturesMap, int DelayX, int DelayY, int StepX, int StepY, Function Combination, Function1D Activation, Neuron sampleneuron) {
        super(null, DelayX, DelayY, StepX, StepY, Combination, Activation, sampleneuron);
        if (MinNumberFeaturesMap < 1) {
            throw new IllegalArgumentException("MinNumberFeaturesMap < 1.");
        }
        if (MaxNumberFeaturesMap < MinNumberFeaturesMap) {
            throw new IllegalArgumentException("MaxNumberFeaturesMap < MinNumberFeaturesMap.");
        }
        this.MinNumberFeaturesMap = MinNumberFeaturesMap;
        this.MaxNumberFeaturesMap = MaxNumberFeaturesMap;
        this.ConnexionsMode = -2;
    }

    @Override
    public void PreviousLayer(BasicLayer layer) {
        this.previouslayer = layer;
        int prevnbchar = this.previouslayer.nbFeaturesMaps();
        this.FeaturesMapConnexions = new byte[(this.MaxNumberFeaturesMap - this.MinNumberFeaturesMap + 1) * prevnbchar][prevnbchar];
        ArrayOperations.Fill((byte[][])this.FeaturesMapConnexions, (int)0);
        int pos = 0;
        for (int y = this.MinNumberFeaturesMap; y <= this.MaxNumberFeaturesMap; ++y) {
            int x = 0;
            while (x < prevnbchar) {
                for (int i2 = 0; i2 < y; ++i2) {
                    this.FeaturesMapConnexions[pos][(x + i2) % prevnbchar] = 1;
                }
                ++x;
                ++pos;
            }
        }
        this.BuildLayer();
    }

    @Override
    public BasicLayer Instance() {
        return new ConvolutionalCyclicLayer(this.MinNumberFeaturesMap, this.MaxNumberFeaturesMap, this.DelayX, this.DelayY, this.StepX, this.StepY, this.combination, this.activation, (Neuron)this.NeuronSample());
    }
}

