/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers;

import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.neurons.SimpleNeuron;
import java.io.IOException;
import mathematics.functions.Function;
import mathematics.functions.Function1D;

public abstract class Layer
extends BasicLayer {
    protected SimpleNeuron[] neurons = null;
    protected float[] predictions = null;
    protected Function combination = null;
    protected Function1D activation = null;
    protected boolean addVirtualBias = false;

    public Layer(int nbfeaturesmaps, int width, int height, Function combination, Function1D activation, boolean addVirtualBias) {
        super(nbfeaturesmaps, width, height);
        this.activation = activation;
        this.combination = combination;
        this.addVirtualBias = addVirtualBias;
    }

    public abstract void Compute();

    public SimpleNeuron[] Neurons() {
        return this.neurons;
    }

    public float[] Predictions() {
        if (this.predictions == null) {
            this.predictions = new float[this.neurons.length];
        }
        for (int x = 0; x < this.neurons.length; ++x) {
            this.predictions[x] = this.neurons[x].Output;
        }
        return this.predictions;
    }

    public Function1D Activation() {
        return this.activation;
    }

    public Function Combination() {
        return this.combination;
    }

    public boolean hasVirtualBias() {
        return this.addVirtualBias;
    }

    @Override
    public void Informations(Appendable out) throws IOException {
        out.append(this.getClass().getName()).append("\n");
        out.append("Neuron: ").append(this.neurons[0].getClass().getName()).append("\n");
        out.append("Combination: ");
        if (this.combination == null) {
            out.append("null\n");
        } else {
            out.append("Combination: ").append(this.combination.getClass().getName()).append(this.combination.hasConstant() ? " with bias\n" : "\n");
        }
        out.append("Activation: ");
        if (this.activation == null) {
            out.append("null\n");
        } else {
            out.append(this.activation.getClass().getName()).append("\n");
        }
        out.append(String.valueOf(this.nbWeights())).append(" weight(s)\n");
        out.append(String.valueOf(this.nbConnexionsReal())).append(" real connexion(s)\n");
        out.append(String.valueOf(this.nbConnexions())).append(" connexion(s)\n");
        out.append("Output: ").append(String.valueOf(this.nbfeaturesmaps)).append(" feature(s) map, of dimensions ");
        out.append(String.valueOf(this.width)).append(" x ").append(String.valueOf(this.height)).append("\n");
    }
}

