/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers;

import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.Layer;
import dataMining.classifiers.neuralnet.neurons.BasicNeuron;

public class InputLayer
extends BasicLayer {
    public InputLayer(int nbfeaturesmaps, int width, int height) {
        super(nbfeaturesmaps, width, height);
        this.neurons = new BasicNeuron[nbfeaturesmaps * height * width];
        for (int x = 0; x < this.neurons.length; ++x) {
            this.neurons[x] = new BasicNeuron();
        }
    }

    @Override
    protected void BuildLayer() {
    }

    public void SetInputValues(float[] inputvalues, int nbfeaturesmaps, int width, int height) {
        if (inputvalues.length != this.neurons.length || this.nbfeaturesmaps != nbfeaturesmaps || this.width != width || this.height != height) {
            throw new IllegalArgumentException("Input dimensions does not match with layer dimensions.");
        }
        for (int x = 0; x < inputvalues.length; ++x) {
            this.neurons[x].Output = inputvalues[x];
        }
    }

    @Override
    public BasicNeuron NeuronSample() {
        return this.neurons[0];
    }

    public void PreviousLayer(Layer layer) {
        if (layer != null) {
            throw new IllegalArgumentException("An InputLayer cannot have a previous layer (it is the first).");
        }
    }

    @Override
    public int nbWeights() {
        return 0;
    }

    @Override
    public int nbConnexions() {
        return 0;
    }

    @Override
    public int nbConnexionsReal() {
        return 0;
    }

    @Override
    public BasicLayer CleanedInstance() {
        return new InputLayer(this.nbfeaturesmaps, this.width, this.height);
    }

    @Override
    public void CopyInstance(BasicLayer layer) {
    }

    @Override
    public BasicLayer Instance() {
        return this.CleanedInstance();
    }
}

