/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet.layers;

import dataMining.classifiers.neuralnet.neurons.BasicNeuron;
import java.io.IOException;

public abstract class BasicLayer {
    protected BasicNeuron[] neurons = null;
    protected int nbfeaturesmaps;
    protected int width;
    protected int height;
    protected BasicLayer previouslayer;
    protected BasicLayer nextlayer;

    public BasicLayer(int nbfeaturesmaps, int width, int height) {
        if (nbfeaturesmaps <= 0) {
            throw new IllegalArgumentException("nbfeaturesmaps <= 0.");
        }
        if (width <= 0) {
            throw new IllegalArgumentException("width <= 0.");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("height <= 0.");
        }
        this.nbfeaturesmaps = nbfeaturesmaps;
        this.width = width;
        this.height = height;
    }

    protected abstract void BuildLayer();

    public abstract BasicNeuron NeuronSample();

    public void PreviousLayer(BasicLayer layer) {
        this.previouslayer = layer;
        this.BuildLayer();
    }

    public void NextLayer(BasicLayer layer) {
        this.nextlayer = layer;
    }

    public int Width() {
        return this.width;
    }

    public int Height() {
        return this.height;
    }

    public int nbFeaturesMaps() {
        return this.nbfeaturesmaps;
    }

    public BasicNeuron[] Neurons() {
        return this.neurons;
    }

    public abstract BasicLayer CleanedInstance();

    public abstract void CopyInstance(BasicLayer var1);

    public abstract BasicLayer Instance();

    public abstract int nbWeights();

    public abstract int nbConnexions();

    public abstract int nbConnexionsReal();

    public void Informations(Appendable out) throws IOException {
        out.append(this.getClass().getName()).append("\n");
        out.append("Neuron: ").append(this.neurons[0].getClass().getName()).append("\n");
        out.append("Combination: null\n");
        out.append("Activation: null\n");
        out.append(String.valueOf(this.nbWeights())).append(" weight(s)\n");
        out.append(String.valueOf(this.nbConnexionsReal())).append(" real connexion(s)\n");
        out.append(String.valueOf(this.nbConnexions())).append(" connexion(s)\n");
        out.append("Output: ").append(String.valueOf(this.nbfeaturesmaps)).append(" feature(s) map, of dimensions ");
        out.append(String.valueOf(this.width)).append(" x ").append(String.valueOf(this.height)).append("\n");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1000);
        try {
            this.Informations(sb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

