/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayIO;
import dataMining.classifiers.neuralnet.NeuralNetwork;
import dataMining.classifiers.neuralnet.functions.CrossEntropy;
import dataMining.classifiers.neuralnet.functions.RBF;
import dataMining.classifiers.neuralnet.layers.InputLayer;
import dataMining.classifiers.neuralnet.layers.convolutional.ConvolutionalCyclicLayer;
import dataMining.classifiers.neuralnet.layers.convolutional.ConvolutionalFullLayer;
import dataMining.classifiers.neuralnet.layers.convolutional.ConvolutionalRandomLayer;
import dataMining.classifiers.neuralnet.layers.fullyconnected.FullyConnectedLayer;
import dataMining.classifiers.neuralnet.layers.fullyconnected.OutputLayer;
import dataMining.classifiers.neuralnet.layers.fullyconnected.OutputSoftMaxLayer;
import dataMining.classifiers.neuralnet.layers.pooling.PoolingLayer;
import dataMining.classifiers.neuralnet.neurons.Neuron;
import dataMining.classifiers.neuralnet.neurons.NeuronBP;
import dataMining.classifiers.neuralnet.neurons.NeuronStochasticBP;
import dataMining.classifiers.neuralnet.optimization.backpropagation.BackPropDropConnect;
import dataMining.classifiers.neuralnet.optimization.backpropagation.BackPropagation;
import dataMining.classifiers.neuralnet.optimization.backpropagation.momentums.AdaptiveDoubleMomentums;
import dataMining.classifiers.neuralnet.optimization.backpropagation.momentums.DoubleMomentums;
import displays.Colors;
import imageTiTi.ImageDrawer;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageOperations;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Random;
import mathematics.functions.Function;
import mathematics.functions.Function1D;
import mathematics.functions.HyperbolicTangent1;
import mathematics.functions.Identity;
import mathematics.functions.Sigmoid1;
import mathematics.functions.Sum;
import utils.times.Chronometer;

public class NeuralNetworks {
    public static NeuralNetwork LeNet5_1998() {
        NeuralNetwork nn = new NeuralNetwork();
        byte[][] connexions = new byte[][]{{1, 1, 1, 0, 0, 0}, {0, 1, 1, 1, 0, 0}, {0, 0, 1, 1, 1, 0}, {0, 0, 0, 1, 1, 1}, {1, 0, 0, 0, 1, 1}, {1, 1, 0, 0, 0, 1}, {1, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 1}, {1, 0, 0, 1, 1, 1}, {1, 1, 0, 0, 1, 1}, {1, 1, 1, 0, 0, 1}, {1, 1, 0, 1, 1, 0}, {0, 1, 1, 0, 1, 1}, {1, 0, 1, 1, 0, 1}, {1, 1, 1, 1, 1, 1}};
        return nn;
    }

    public static void Custom_TestTime(int nbmap, int sx, int sy, int nbinstances, int nbIterations) throws Exception {
        System.out.println("Custom Test Time: " + nbinstances + " instances on " + nbIterations + " iterations.");
        NeuralNetwork nn = NeuralNetworks.Custom(nbmap, sx, sy);
        System.out.println("Network architecture:");
        System.out.println(nn.toString());
        float[][] inputs = NeuralNetworks.Custom_Inputs(nbmap, sx, sy, nbinstances);
        Chronometer Chrono = new Chronometer();
        nn.Compute(inputs[0], nbmap, sx, sy);
        System.out.println("Let's work.");
        int marker = Chrono.NewMarker();
        for (int j = 0; j < nbIterations; ++j) {
            for (float[] input : inputs) {
                nn.Compute(input, nbmap, sx, sy);
            }
        }
        System.out.println("Time: " + Chrono.getTimeSinceMarker(marker));
        Chrono.FreeMarker(marker);
        Chrono = null;
        inputs = null;
        nn = null;
    }

    public static void Custom_Test(int nbmap, int sx, int sy, int nbinstances) throws Exception {
        float LearningRate = 0.43f;
        float momentum = 0.13f;
        float ConvergenceLimit = 1.0E-4f;
        int MaxEpoch = 10000;
        System.out.println("Custom Test:");
        NeuralNetwork nn = NeuralNetworks.Custom(nbmap, sx, sy);
        System.out.println("Network architecture:");
        System.out.println(nn.toString());
        float[][] inputs = NeuralNetworks.Custom_Inputs(nbmap, sx, sy, nbinstances);
        float[][] outputs = NeuralNetworks.Custom_Outputs1D(nbinstances);
        for (int i2 = 0; i2 < inputs.length; ++i2) {
            float[] in = inputs[i2];
            ArrayIO.Display(in, "Testing", " ");
            nn.Compute(in, nbmap, sx, sy);
            ArrayIO.Display(nn.Predictions(), "output", " ");
            ArrayIO.Display(outputs[i2], "expected", " ");
            in = null;
        }
    }

    public static NeuralNetwork Custom(int nbmap, int sx, int sy) {
        NeuralNetwork nn = new NeuralNetwork();
        nn.AddLayer(new InputLayer(nbmap, sx, sy));
        nn.AddLayer(new ConvolutionalFullLayer(3, 2, 2, 1, 1, (Function)new Sum(new float[]{1.0f}), (Function1D)new Identity(), new Neuron(null, null)));
        return nn;
    }

    public static float[][] Custom_Inputs(int nbmap, int sx, int sy, int nbinstances) {
        float[][] inputs;
        Random random = new Random();
        for (float[] input : inputs = new float[nbinstances][nbmap * sx * sy]) {
            int x = 0;
            int nb = 0;
            while (x < inputs[0].length) {
                input[x] = (float)random.nextGaussian();
                ++x;
                ++nb;
            }
        }
        return inputs;
    }

    public static float[][] Custom_Outputs1D(int nbinstances) {
        int i2;
        float[][] outputs = new float[nbinstances][1];
        int middle = nbinstances >> 1;
        for (i2 = 0; i2 < middle; ++i2) {
            outputs[i2][0] = 0.0f;
        }
        while (i2 < nbinstances) {
            outputs[i2][0] = 1.0f;
            ++i2;
        }
        return outputs;
    }

    public static float[] Custom_Weights(int nbinstances) {
        float[] weights = new float[nbinstances];
        Arrays.fill(weights, 1.0f);
        return weights;
    }

    public static void TwoSpirals_Test() throws Exception {
        float LearningRate = 0.07f;
        float momentum1 = 0.01f;
        float momentum2 = 0.005f;
        float ConvergenceLimit = 1.0E-4f;
        int MaxEpoch = 3000;
        int nbinstances = 5000;
        float[][] inputs = NeuralNetworks.TwoSpirals_Inputs(nbinstances);
        float[][] outputs = NeuralNetworks.TwoSpirals_Outputs(nbinstances);
        float[] weights = NeuralNetworks.TwoSpirals_Weights(nbinstances);
        System.out.println("Two Spirals Test:");
        NeuralNetwork nn = NeuralNetworks.TwoSpirals();
        nn.ShuffleEachEpoch = true;
        nn.LinkWeightOptimization(new BackPropagation(new CrossEntropy(), new AdaptiveDoubleMomentums(momentum1, momentum2), LearningRate, 0.99f, ConvergenceLimit, MaxEpoch, -3));
        System.out.println("Network architecture:");
        System.out.println(nn.toString());
        nn.Train(inputs, 1, 2, 1, outputs, weights, true);
        int marge = 50;
        int scale = 250;
        int width = (scale << 1) + (marge << 1);
        int height = (scale << 1) + (marge << 1);
        BufferedImage imin = new BufferedImage(width, height, 5);
        ImageOperations.Fill((BufferedImage)imin, (int)255, (int)255, (int)255);
        ArrayArithmetic.Multiply((float[][])inputs, (float)scale, (float[][])inputs);
        ArrayArithmetic.Add((float[][])inputs, (float)(scale + marge), (float[][])inputs);
        for (int i2 = 0; i2 < inputs.length; ++i2) {
            ImageDrawer.Point(imin, (int)inputs[i2][0], (int)inputs[i2][1], 0, outputs[i2][0] < 0.5f ? Colors.BLUE : Colors.RED);
        }
        ImageIO.Write(imin, "TwoSpirals_Inputs.png", 6);
        BufferedImage imres = new BufferedImage(width, height, 10);
        float[] test = new float[2];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                test[0] = (float)((double)(x - scale - marge) / (double)scale);
                test[1] = (float)((double)(y - scale - marge) / (double)scale);
                nn.Compute(test, 1, 2, 1);
                float[] predictions = nn.Predictions();
                imres.getRaster().setSample(x, y, 0, predictions[0] * 255.0f);
                predictions = null;
            }
        }
        System.out.println("Epoch: " + nn.Trainer().Epoch());
        ImageIO.Write(imres, "TwoSpirals_Results.png", 6);
    }

    public static NeuralNetwork TwoSpirals() {
        NeuralNetwork nn = new NeuralNetwork();
        nn.AddLayer(new InputLayer(1, 2, 1));
        nn.AddLayer(new FullyConnectedLayer(1, 30, 1, new Sum(1, null), new HyperbolicTangent1(), true, new NeuronBP(null, null)));
        nn.AddLayer(new FullyConnectedLayer(1, 30, 1, new Sum(1, null), new Sigmoid1(), true, new NeuronBP(null, null)));
        nn.AddLayer(new OutputLayer(1, 1, 1, new Sum(1, null), new Sigmoid1(), true, new NeuronBP(null, null)));
        return nn;
    }

    public static float[][] TwoSpirals_Inputs(int nbinstances) {
        Random random = new Random();
        double sd = 0.05;
        int pos = 0;
        float[][] inputs = new float[nbinstances << 1][2];
        double thetastart = 0.5;
        double thetaend = Math.PI * 6;
        double thetastep = (thetaend - thetastart) / (double)nbinstances;
        for (double theta = thetastart; theta < thetaend && pos < inputs.length; theta += thetastep) {
            inputs[pos][0] = (float)(theta / 15.0 * Math.cos(theta) + random.nextGaussian() * sd);
            inputs[pos++][1] = (float)(theta / 15.0 * Math.sin(theta) + random.nextGaussian() * sd);
            inputs[pos][0] = (float)(theta / 15.0 * Math.cos(theta + Math.PI) + random.nextGaussian() * sd);
            inputs[pos++][1] = (float)(theta / 15.0 * Math.sin(theta + Math.PI) + random.nextGaussian() * sd);
        }
        return inputs;
    }

    public static float[][] TwoSpirals_Outputs(int nbinstances) {
        float[][] outputs = new float[nbinstances << 1][1];
        for (int i2 = 0; i2 < outputs.length; ++i2) {
            outputs[i2][0] = i2 % 2;
        }
        return outputs;
    }

    public static float[] TwoSpirals_Weights(int nbinstances) {
        float[] weights = new float[nbinstances << 1];
        Arrays.fill(weights, 1.0f);
        return weights;
    }

    public static void Digit_Test2(float sd) throws Exception {
        float LearningRate = 0.13f;
        float momentum1 = 0.03f;
        float momentum2 = 0.01f;
        float ConvergenceLimit = 0.001f;
        int MaxEpoch = 750;
        float mult = 2.0f;
        boolean[][][] patrons = NeuralNetworks.Digits_Patrons();
        int scale = 2;
        float[][] outputs = NeuralNetworks.Digits_Outputs(patrons, 1);
        System.out.println("Digit Test:");
        ArrayFeatures AF = new ArrayFeatures();
        Chronometer chrono = new Chronometer();
        double[] performances = new double[10];
        for (int t = 0; t < performances.length; ++t) {
            NeuralNetwork nn = NeuralNetworks.Digits(patrons.length, patrons[0][0].length * scale, patrons[0].length * scale, outputs);
            nn.ShuffleEachEpoch = true;
            nn.LinkWeightOptimization(new BackPropagation(new RBF(), new AdaptiveDoubleMomentums(momentum1, momentum2), LearningRate, 0.95f, ConvergenceLimit, MaxEpoch, -3));
            if (t == 0) {
                System.out.println("Network architecture:");
                System.out.println(nn.toString());
            }
            float[][] inputs = NeuralNetworks.Digits_Inputs(patrons, 1.0f, scale, (int)(mult * (float)nn.nbWeights()));
            outputs = NeuralNetworks.Digits_Outputs(patrons, (int)(mult * (float)nn.nbWeights()));
            int marker = chrono.NewMarker();
            nn.Train(inputs, 1, patrons[0][0].length * scale, patrons[0].length * scale, outputs, NeuralNetworks.Digits_Weights(patrons, (int)(mult * (float)nn.nbWeights())), false);
            long time = chrono.getTimeSinceMarkerMilliSeconds(marker);
            chrono.FreeMarker(marker);
            int nbepoch = nn.Trainer().Epoch();
            System.out.println("perfo = " + (double)time / (double)nbepoch);
            System.out.flush();
            NeuralNetwork nntest = nn.CleanedInstance();
            if (t == 0) {
                System.out.println("Network architecture:");
                System.out.println(nntest.toString());
            }
            nn = null;
            int nberrortest = 0;
            float[][] test = NeuralNetworks.Digits_Inputs(patrons, 1.0f, scale, (int)(mult * (float)nntest.nbWeights()));
            outputs = NeuralNetworks.Digits_Outputs(patrons, (int)(mult * (float)nntest.nbWeights()));
            for (int i2 = 0; i2 < test.length; ++i2) {
                float[] in = test[i2];
                nntest.Compute(in, 1, patrons[0][0].length * scale, patrons[0].length * scale);
                float[] predictions = nntest.Predictions();
                int maxpos = AF.MaximumIndex(predictions);
                if (outputs[i2][maxpos] != 1.0f) {
                    ++nberrortest;
                }
                in = null;
            }
            System.out.println(t + " - nberrors = " + nberrortest + " <=> " + (double)nberrortest / (double)test.length * 100.0);
            performances[t] = (double)nberrortest / (double)test.length * 100.0;
            nntest = null;
            inputs = null;
            test = null;
        }
        AF.Ranks(performances);
        System.out.println("Median = " + AF.Rank50());
        AF.Moments(performances);
        System.out.println("Average = " + AF.Average());
    }

    public static void Digit_Test(float sd) throws Exception {
        float LearningRate = 0.23f;
        float momentum1 = 0.07f;
        float momentum2 = 0.03f;
        float ConvergenceLimit = 0.001f;
        int MaxEpoch = 150;
        float mult = 2.0f;
        boolean[][][] patrons = NeuralNetworks.Digits_Patrons();
        int scale = 2;
        float[][] outputs = NeuralNetworks.Digits_Outputs(patrons, 1);
        ArrayFeatures AF = new ArrayFeatures();
        System.out.println("Digit Test:");
        NeuralNetwork nn = NeuralNetworks.Digits(patrons.length, patrons[0][0].length * scale, patrons[0].length * scale, outputs);
        System.out.println("Network architecture:");
        System.out.println(nn.toString());
        double[] performances = new double[10];
        for (int t = 0; t < performances.length; ++t) {
            float[][] inputs = NeuralNetworks.Digits_Inputs(patrons, 1.0f, scale, (int)(mult * (float)nn.nbWeights()));
            outputs = NeuralNetworks.Digits_Outputs(patrons, (int)(mult * (float)nn.nbWeights()));
            nn.Train(inputs, 1, patrons[0][0].length * scale, patrons[0].length * scale, outputs, NeuralNetworks.Digits_Weights(patrons, (int)(mult * (float)nn.nbWeights())), false);
            int nberrortest = 0;
            float[][] test = NeuralNetworks.Digits_Inputs(patrons, 1.0f, scale, (int)(mult * (float)nn.nbWeights()));
            for (int i2 = 0; i2 < test.length; ++i2) {
                float[] in = test[i2];
                nn.Compute(in, 1, patrons[0][0].length * scale, patrons[0].length * scale);
                float[] predictions = nn.Predictions();
                int maxpos = AF.MaximumIndex(predictions);
                if (outputs[i2][maxpos] != 1.0f) {
                    ++nberrortest;
                }
                in = null;
            }
            System.out.println(t + " - nberrors = " + nberrortest + " <=> " + (double)nberrortest / (double)test.length * 100.0);
            performances[t] = (double)nberrortest / (double)test.length * 100.0;
        }
        AF.Ranks(performances);
        System.out.println("Median = " + AF.Rank50());
        AF.Moments(performances);
        System.out.println("Average = " + AF.Average());
    }

    public static NeuralNetwork Digits(int nbdigits, int width, int height, float[][] outputs) {
        NeuralNetwork nn = new NeuralNetwork();
        nn.AddLayer(new InputLayer(1, width, height));
        nn.AddLayer(new ConvolutionalFullLayer(nbdigits, 2, 2, 1, 1, (Function)new Sum(new float[]{1.0f}), (Function1D)new HyperbolicTangent1(), (Neuron)new NeuronBP(null, null)));
        nn.AddLayer(new PoolingLayer(2, 2, 1, 1, new NeuronStochasticBP()));
        nn.AddLayer(new ConvolutionalRandomLayer(nbdigits << 2, 2, 4, 2, 2, 1, 1, new Sum(new float[]{1.0f}), new HyperbolicTangent1(), new NeuronBP(null, null)));
        nn.AddLayer(new PoolingLayer(2, 2, 1, 1, new NeuronStochasticBP()));
        nn.AddLayer(new FullyConnectedLayer(1, nn.LastAddedLayer().Width() >> 1, nn.LastAddedLayer().Height() >> 1, new Sum(1, null), new HyperbolicTangent1(), true, new NeuronBP(null, null)));
        nn.AddLayer(new OutputSoftMaxLayer(1, outputs[0].length, 1, new Sum(1, null), new Sigmoid1(), true, 3.0f, new NeuronBP(null, null)));
        return nn;
    }

    public static float[][] Digits_Inputs(boolean[][][] patrons, float sd, int scale, int nbinstances) {
        Random random = new Random();
        int height = patrons[0].length * scale;
        int width = patrons[0][0].length * scale;
        float[][] inputs = new float[patrons.length * nbinstances][width * height];
        int nb = 0;
        for (int i2 = 0; i2 < nbinstances; ++i2) {
            int digit = 0;
            while (digit < patrons.length) {
                int y = 0;
                int pos = 0;
                while (y < patrons[digit].length) {
                    int x = 0;
                    while (x < patrons[digit][0].length) {
                        for (int dy = 0; dy < scale; ++dy) {
                            for (int dx = 0; dx < scale; ++dx) {
                                inputs[nb][pos + dy * width + dx] = patrons[digit][y][x] ? 1.0f + (float)random.nextGaussian() * sd : (float)random.nextGaussian() * sd;
                            }
                        }
                        ++x;
                        pos += scale;
                    }
                    ++y;
                    pos += width * (scale - 1);
                }
                ++digit;
                ++nb;
            }
        }
        random = null;
        return inputs;
    }

    public static float[][] Digits_Outputs(boolean[][][] patrons, int nbinstances) {
        float[][] outputs = new float[patrons.length * nbinstances][patrons.length];
        int nb = 0;
        for (int i2 = 0; i2 < nbinstances; ++i2) {
            int digit = 0;
            while (digit < patrons.length) {
                Arrays.fill(outputs[nb], 0.0f);
                outputs[nb][digit] = 1.0f;
                ++digit;
                ++nb;
            }
        }
        return outputs;
    }

    public static boolean[][][] Digits_Patrons() {
        boolean[][][] digits = new boolean[][][]{new boolean[][]{{true, true, true}, {true, false, true}, {true, false, true}, {true, false, true}, {true, true, true}}, new boolean[][]{{false, true, false}, {false, true, false}, {false, true, false}, {false, true, false}, {false, true, false}}, new boolean[][]{{true, true, true}, {false, false, true}, {true, true, true}, {true, false, false}, {true, true, true}}, new boolean[][]{{true, true, true}, {false, false, true}, {true, true, true}, {false, false, true}, {true, true, true}}};
        return digits;
    }

    public static float[] Digits_Weights(boolean[][][] patrons, int nbinstances) {
        float[] weights = new float[patrons.length * nbinstances];
        Arrays.fill(weights, 1.0f);
        return weights;
    }

    public static void Binary_Test(float[][] outputs) throws Exception {
        System.out.println("Binary Test:");
        float learningrate = 0.37f;
        float momentum1 = 0.1f;
        float momentum2 = 0.05f;
        int maxepoch = 10000;
        float safety = 0.999f;
        NeuralNetwork nn = NeuralNetworks.Binary(outputs);
        nn.ShuffleEachEpoch = false;
        nn.LinkWeightOptimization(new BackPropagation(new RBF(), new AdaptiveDoubleMomentums(momentum1, momentum2), learningrate, safety, 1.0E-5f, maxepoch, -3));
        System.out.println("Network architecture:");
        System.out.println(nn.toString());
        float[][] inputs = NeuralNetworks.Logical_Inputs();
        int success = 0;
        int failure = 0;
        int epoch = 0;
        int NB = 500;
        int[] epochs = new int[NB];
        for (int t = 0; t < NB; ++t) {
            nn.Train(inputs, 1, 2, 1, outputs, NeuralNetworks.Logical_Weights(), false);
            epoch += nn.Trainer().Epoch();
            epochs[t] = nn.Trainer().Epoch();
            for (int i2 = 0; i2 < inputs.length; ++i2) {
                float[] in = inputs[i2];
                nn.Compute(in, 1, 2, 1);
                float p = nn.Prediction(0);
                if (Math.abs(outputs[i2][0] - p) < 0.5f) {
                    ++success;
                } else {
                    ++failure;
                }
                in = null;
            }
        }
        System.out.println("Success = " + success + " => " + (double)success / (double)(success + failure));
        System.out.println("Failure = " + failure + " => " + (double)failure / (double)(success + failure));
        System.out.println("Average epoch: " + (double)epoch / (double)NB);
        Arrays.sort(epochs);
        System.out.println("Median epoch: " + epochs[NB >> 1]);
        epochs = null;
        inputs = null;
    }

    public static void Binary_Test2(float[][] outputs) throws Exception {
        int nbepoch = 10000;
        float safety = 0.9999f;
        System.out.println("Binary Test:");
        NeuralNetwork nn = NeuralNetworks.Binary(outputs);
        nn.ShuffleEachEpoch = false;
        nn.LinkWeightOptimization(new BackPropagation(new RBF(), new DoubleMomentums(0.1f, 0.05f), 0.35f, safety, 1.0E-5f, nbepoch, -3));
        NeuralNetwork nn2 = NeuralNetworks.Binary(outputs);
        nn2.ShuffleEachEpoch = false;
        nn2.LinkWeightOptimization(new BackPropagation(new RBF(), new AdaptiveDoubleMomentums(0.01f, 0.005f), 0.13f, safety, 1.0E-5f, nbepoch, -3));
        System.out.println("Network architecture:");
        System.out.println(nn.toString());
        float[][] inputs = NeuralNetworks.Logical_Inputs();
        int success = 0;
        int success2 = 0;
        int failure = 0;
        int failure2 = 0;
        Random random = new Random();
        for (int t = 0; t < 2500; ++t) {
            float p;
            float[] in;
            int i2;
            nn.Train(inputs, 1, 2, 1, outputs, NeuralNetworks.Logical_Weights(), false);
            for (i2 = 0; i2 < inputs.length; ++i2) {
                in = inputs[i2];
                nn.Compute(in, 1, 2, 1);
                p = nn.Predictions()[0];
                if (Math.abs(outputs[i2][0] - p) < 0.5f) {
                    ++success;
                } else {
                    ++failure;
                }
                in = null;
            }
            nn2.Train(inputs, 1, 2, 1, outputs, NeuralNetworks.Logical_Weights(), false);
            for (i2 = 0; i2 < inputs.length; ++i2) {
                in = inputs[i2];
                nn2.Compute(in, 1, 2, 1);
                p = nn2.Predictions()[0];
                if (Math.abs(outputs[i2][0] - p) < 0.5f) {
                    ++success2;
                } else {
                    ++failure2;
                }
                in = null;
            }
        }
        System.out.print("Success = " + success + " vs " + success2 + " => " + (double)success / (double)(success + failure));
        System.out.println(" vs " + (double)success2 / (double)(success2 + failure2));
        System.out.print("Failure = " + failure + " vs " + failure2 + " => " + (double)failure / (double)(success + failure));
        System.out.println(" vs " + (double)failure2 / (double)(success2 + failure2));
    }

    public static NeuralNetwork Binary(float[][] outputs) {
        NeuralNetwork nn = new NeuralNetwork();
        nn.AddLayer(new InputLayer(1, 2, 1));
        nn.AddLayer(new FullyConnectedLayer(1, 2, 1, new Sum(2, null), new HyperbolicTangent1(), false, new NeuronBP(null, null)));
        if (outputs[0].length == 1) {
            nn.AddLayer(new OutputLayer(1, 1, 1, new Sum(1, null), new HyperbolicTangent1(), false, new NeuronBP(null, null)));
        }
        return nn;
    }

    public static float[][] XOR_Outputs() {
        return new float[][]{{0.0f}, {1.0f}, {1.0f}, {0.0f}};
    }

    public static float[][] AND_Outputs() {
        return new float[][]{{0.0f}, {0.0f}, {0.0f}, {1.0f}};
    }

    public static float[][] OR_Outputs() {
        return new float[][]{{0.0f}, {1.0f}, {1.0f}, {1.0f}};
    }

    public static float[][] Logical_Inputs() {
        return new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 0.0f}, {1.0f, 1.0f}};
    }

    public static float[] Logical_Weights() {
        return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    }

    public static float[][] XOR_Double_Outputs() {
        return new float[][]{{0.0f, 1.0f}, {1.0f, 0.0f}, {1.0f, 0.0f}, {0.0f, 1.0f}};
    }

    public static float[][] AND_Double_Outputs() {
        return new float[][]{{0.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 1.0f}, {1.0f, 0.0f}};
    }

    public static float[][] OR_Double_Outputs() {
        return new float[][]{{0.0f, 1.0f}, {1.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 0.0f}};
    }

    public static void Rotaty_Test(String inputs, String extension, String xmlname, String imtest, String resname) throws Exception {
        NeuralNetwork nn = NeuralNetworks.Rotary2();
        nn.LinkWeightOptimization(new BackPropDropConnect(new RBF(), new AdaptiveDoubleMomentums(0.01f, 0.005f), 0.07f, 0.95f, 1.0E-4f, 50));
        nn.TrainMissingRAM(inputs, extension, 1, true, true);
        NeuralNetwork nntest = nn.CleanedInstance();
        nntest.SaveXml(xmlname);
        BufferedImage image = ImageIO.Read(imtest);
        BufferedImage result = ImageNew.Same((BufferedImage)image);
        nntest.Test(image, 23, 1, result);
        ImageIO.Write(result, resname, 6);
    }

    public static NeuralNetwork Rotary() {
        NeuralNetwork nn = new NeuralNetwork();
        nn.ShuffleEachEpoch = true;
        nn.AddLayer(new InputLayer(1, 23, 23));
        nn.AddLayer(new FullyConnectedLayer(1, 23, 1, new Sum(new float[]{1.0f}), new HyperbolicTangent1(), true, new NeuronBP(null, null)));
        nn.AddLayer(new FullyConnectedLayer(1, 13, 1, new Sum(new float[]{1.0f}), new HyperbolicTangent1(), true, new NeuronBP(null, null)));
        nn.AddLayer(new OutputSoftMaxLayer(1, 2, 1, new Sum(new float[]{1.0f}), new Sigmoid1(), true, 2.0f, new NeuronBP(null, null)));
        return nn;
    }

    public static NeuralNetwork Rotary2() {
        NeuralNetwork nn = new NeuralNetwork();
        nn.ShuffleEachEpoch = true;
        nn.AddLayer(new InputLayer(1, 23, 23));
        nn.AddLayer(new ConvolutionalFullLayer(13, 3, 3, 1, 1, (Function)new Sum(new float[]{1.0f}), (Function1D)new HyperbolicTangent1(), (Neuron)new NeuronBP(null, null)));
        nn.AddLayer(new PoolingLayer(3, 3, 1, 1, new NeuronStochasticBP()));
        nn.AddLayer(new ConvolutionalCyclicLayer(2, 4, 3, 3, 1, 1, new Sum(new float[]{1.0f}), new HyperbolicTangent1(), new NeuronBP(null, null)));
        nn.AddLayer(new PoolingLayer(3, 3, 1, 1, new NeuronStochasticBP()));
        nn.AddLayer(new ConvolutionalRandomLayer(53, 2, 5, 3, 3, 1, 1, new Sum(new float[]{1.0f}), new HyperbolicTangent1(), new NeuronBP(null, null)));
        nn.AddLayer(new PoolingLayer(3, 3, 1, 1, new NeuronStochasticBP()));
        nn.AddLayer(new ConvolutionalRandomLayer(73, 2, 5, 3, 3, 1, 1, new Sum(new float[]{1.0f}), new HyperbolicTangent1(), new NeuronBP(null, null)));
        nn.AddLayer(new PoolingLayer(3, 3, 1, 1, new NeuronStochasticBP()));
        nn.AddLayer(new ConvolutionalRandomLayer(113, 2, 5, 3, 3, 1, 1, new Sum(new float[]{1.0f}), new HyperbolicTangent1(), new NeuronBP(null, null)));
        nn.AddLayer(new PoolingLayer(3, 3, 1, 1, new NeuronStochasticBP()));
        nn.AddLayer(new OutputSoftMaxLayer(1, 2, 1, new Sum(1, null), new Sigmoid1(), true, 2.0f, new NeuronBP(null, null)));
        return nn;
    }
}

