/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet;

import arrayTiTi.ArrayArithmetic;
import java.awt.image.BufferedImage;

public class NeuralNetworkTools {
    public static void Shuffle(float[][] inputs, float[][] outputs, float[] weights) {
        float[] tmp = null;
        for (int i2 = 0; i2 < inputs.length; ++i2) {
            int rand = (int)(Math.random() * (double)inputs.length);
            tmp = inputs[rand];
            inputs[rand] = inputs[i2];
            inputs[i2] = tmp;
            tmp = null;
            tmp = outputs[rand];
            outputs[rand] = outputs[i2];
            outputs[i2] = tmp;
            tmp = null;
            float f = weights[rand];
            weights[rand] = weights[i2];
            weights[i2] = f;
        }
    }

    public static void Shuffle(String[] inputs) {
        String tmp = null;
        for (int i2 = 0; i2 < inputs.length; ++i2) {
            int rand = (int)(Math.random() * (double)inputs.length);
            tmp = inputs[rand];
            inputs[rand] = inputs[i2];
            inputs[i2] = tmp;
            tmp = null;
        }
    }

    public static void Rotate270(float[][] inputs, int dim) {
        float[] in = null;
        float[] tmp = new float[inputs[0].length];
        for (int i2 = 0; i2 < inputs.length; ++i2) {
            in = inputs[i2];
            int pos = 0;
            for (int y = 0; y < dim; ++y) {
                int x = 0;
                int p = dim - y - 1;
                while (x < dim) {
                    tmp[pos] = in[p];
                    ++x;
                    ++pos;
                    p += dim;
                }
            }
            System.arraycopy(tmp, 0, in, 0, tmp.length);
            in = null;
        }
        tmp = null;
    }

    public static void Rotate270(float[] input, int dim) {
        float[] tmp = new float[input.length];
        int pos = 0;
        for (int y = 0; y < dim; ++y) {
            int x = 0;
            int p = dim - y - 1;
            while (x < dim) {
                tmp[pos] = input[p];
                ++x;
                ++pos;
                p += dim;
            }
        }
        System.arraycopy(tmp, 0, input, 0, tmp.length);
        tmp = null;
    }

    public static void Rotate180(float[][] inputs) {
        for (int i2 = 0; i2 < inputs.length; ++i2) {
            NeuralNetworkTools.Rotate180(inputs[i2]);
        }
    }

    public static void Rotate180(float[] input) {
        int front = 0;
        for (int queue = input.length - 1; front < queue; ++front, --queue) {
            float tmp = input[front];
            input[front] = input[queue];
            input[queue] = tmp;
        }
    }

    public static void Rotate90(float[][] inputs, int dim) {
        float[] in = null;
        float[] tmp = new float[inputs[0].length];
        for (int i2 = 0; i2 < inputs.length; ++i2) {
            in = inputs[i2];
            int pos = 0;
            for (int y = 0; y < dim; ++y) {
                int x = 0;
                int p = (dim - 1) * dim + y;
                while (x < dim) {
                    tmp[pos] = in[p];
                    ++x;
                    ++pos;
                    p -= dim;
                }
            }
            System.arraycopy(tmp, 0, in, 0, tmp.length);
            in = null;
        }
        tmp = null;
    }

    public static void Rotate90(float[] input, int dim) {
        float[] tmp = new float[input.length];
        int pos = 0;
        for (int y = 0; y < dim; ++y) {
            int x = 0;
            int p = (dim - 1) * dim + y;
            while (x < dim) {
                tmp[pos] = input[p];
                ++x;
                ++pos;
                p -= dim;
            }
        }
        System.arraycopy(tmp, 0, input, 0, tmp.length);
        tmp = null;
    }

    public static void Normalize(float[][] data, int normalization, BufferedImage image) {
        switch (image.getType()) {
            case 10: {
                NeuralNetworkTools.Normalize(data, normalization, 255.0f);
                break;
            }
            case 11: {
                NeuralNetworkTools.Normalize(data, normalization, 65535.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static void Normalize(float[][] data, int normalization, float max) {
        switch (normalization) {
            case 0: {
                break;
            }
            case 1: {
                for (int i2 = 0; i2 < data.length; ++i2) {
                    ArrayArithmetic.Divide((float[])data[i2], (float)max, (float[])data[i2]);
                    ArrayArithmetic.Subtract((float[])data[i2], (float)0.5f, (float[])data[i2]);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown normalization.");
            }
        }
    }

    public static void Normalize(float[] data, int normalization, BufferedImage image) {
        switch (image.getType()) {
            case 10: {
                NeuralNetworkTools.Normalize(data, normalization, 255.0f);
                break;
            }
            case 11: {
                NeuralNetworkTools.Normalize(data, normalization, 65535.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static void Normalize(float[] data, int normalization, float max) {
        switch (normalization) {
            case 0: {
                break;
            }
            case 1: {
                ArrayArithmetic.Divide((float[])data, (float)max, (float[])data);
                ArrayArithmetic.Subtract((float[])data, (float)0.5f, (float[])data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown normalization.");
            }
        }
    }
}

