/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.neuralnet;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayOperations;
import dataMining.classifiers.neuralnet.NeuralNetworkTools;
import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.neuralnet.layers.InputLayer;
import dataMining.classifiers.neuralnet.layers.Layer;
import dataMining.classifiers.neuralnet.layers.fullyconnected.OutputLayer;
import dataMining.classifiers.neuralnet.optimization.NeuralNetworkTrainer;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import listTiTi.ListTools;
import utils.xml.XmlIO;

public class NeuralNetwork {
    private BasicLayer previous = null;
    private InputLayer inputlayer = null;
    private OutputLayer outputlayer = null;
    private List<BasicLayer> layers = null;
    private NeuralNetworkTrainer trainer = null;
    public boolean ShuffleEachEpoch = true;
    public boolean RotateEachEpoch = false;
    public static final int NO_NORMALIZATION = 0;
    public static final int SIMPLE_NORMALIZATION = 1;

    public NeuralNetwork() {
        this.layers = new ArrayList<BasicLayer>(13);
    }

    public NeuralNetwork(int nbLayers) {
        this.layers = new ArrayList<BasicLayer>(nbLayers);
    }

    public void AddLayer(BasicLayer layer) {
        this.layers.add(layer);
        if (this.layers.size() == 1) {
            if (!(layer instanceof InputLayer)) {
                throw new IllegalArgumentException("The first layer must be an InputLayer.");
            }
            this.inputlayer = (InputLayer)layer;
        } else {
            layer.PreviousLayer(this.previous);
            this.previous.NextLayer(layer);
            if (layer instanceof OutputLayer) {
                this.outputlayer = (OutputLayer)layer;
                layer.NextLayer(null);
            }
        }
        this.previous = layer;
    }

    private void Compute() {
        for (int i2 = 1; i2 < this.layers.size(); ++i2) {
            try {
                ((Layer)this.layers.get(i2)).Compute();
                continue;
            }
            catch (Exception E) {
                System.err.println("Layer " + i2);
                E.printStackTrace();
                System.exit(0);
            }
        }
    }

    public void Compute(float[] input, int nbfeaturesmap, int width, int height) {
        this.inputlayer.SetInputValues(input, nbfeaturesmap, width, height);
        this.Compute();
    }

    public void Train(float[] input, int nbfeaturesmap, int width, int height, float[] output, float weight) throws Exception {
        this.trainer.OptimizeWeights(input, nbfeaturesmap, width, height, output, weight);
    }

    public void Train(float[][] input, int nbfeaturesmap, int width, int height, float[][] output, float[] weights, boolean verbose) throws Exception {
        if (this.trainer == null) {
            throw new Exception("Any NeuralNetworkTrainer class defined.");
        }
        this.trainer.InitializeWeights();
        this.trainer.StartTraining();
        while (this.trainer.isTraining()) {
            if (this.ShuffleEachEpoch) {
                NeuralNetworkTools.Shuffle(input, output, weights);
            }
            for (int i2 = 0; i2 < input.length; ++i2) {
                if (input[i2] == null) continue;
                this.Train(input[i2], nbfeaturesmap, width, height, output[i2], weights[i2]);
            }
            this.trainer.EpochOver(verbose);
        }
    }

    public void Train(String inputs, final String extension, int normalization, boolean RotateEachEpoch, boolean verbose) throws Exception {
        int i2;
        int f;
        if (this.trainer == null) {
            throw new Exception("Any NeuralNetworkTrainer class defined.");
        }
        this.RotateEachEpoch = RotateEachEpoch;
        File[] images = null;
        File file = new File(inputs);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The input file is not a directory.");
        }
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.contains(extension);
            }
        };
        File[] files = file.listFiles();
        int nbclasses = 0;
        int nbimages = 0;
        for (f = 0; f < files.length; ++f) {
            if (!files[f].isDirectory()) continue;
            System.out.print(" - New class found '" + files[f].getName() + "'");
            images = files[f].listFiles(fnf);
            if (images == null || images.length == 0) {
                throw new Exception("No image found into the folder '" + files[f].getName() + "'");
            }
            nbimages += images.length;
            System.out.println(", it contains " + images.length + " images.");
            ++nbclasses;
        }
        if (nbclasses <= 1) {
            throw new Exception("Number of class/folder inferior or equal to 1.");
        }
        System.out.println("Total: " + nbclasses + " classes, " + nbimages + " images");
        BufferedImage image = ImageIO.Read(images[0].getAbsolutePath());
        int width = image.getWidth();
        int height = image.getHeight();
        if (RotateEachEpoch && width != height) {
            throw new IllegalArgumentException("Images are not squared, thus they cannot be rotated");
        }
        float[][] input = new float[nbimages][width * height];
        float[][] output = new float[nbimages][nbclasses];
        float[] weights = new float[nbimages];
        ArrayOperations.Fill((float[][])output, (float)0.0f);
        Arrays.fill(weights, 1.0f);
        nbclasses = 0;
        nbimages = 0;
        for (f = 0; f < files.length; ++f) {
            if (!files[f].isDirectory()) continue;
            images = files[f].listFiles(fnf);
            for (i2 = 0; i2 < images.length; ++i2) {
                BufferedImage im = ImageIO.Read(images[i2].getAbsolutePath());
                if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)im)) {
                    throw new Exception("Images have different type or dimensions.");
                }
                switch (im.getType()) {
                    case 10: {
                        ArrayNew.CopyUnsigned((byte[])((DataBufferByte)im.getRaster().getDataBuffer()).getData(), (float[])input[nbimages]);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet).");
                    }
                }
                output[nbimages][nbclasses] = 1.0f;
                ++nbimages;
                im = null;
            }
            images = null;
            ++nbclasses;
        }
        NeuralNetworkTools.Normalize(input, normalization, image);
        image = null;
        this.trainer.InitializeWeights();
        this.trainer.StartTraining();
        while (this.trainer.isTraining()) {
            if (this.ShuffleEachEpoch) {
                NeuralNetworkTools.Shuffle(input, output, weights);
            }
            if (RotateEachEpoch) {
                NeuralNetworkTools.Rotate90(input, width);
            }
            for (i2 = 0; i2 < input.length; ++i2) {
                this.Train(input[i2], 1, width, height, output[i2], weights[i2]);
            }
            this.trainer.EpochOver(verbose);
        }
    }

    public void TrainMissingRAM(String inputs, final String extension, int normalization, boolean RotateEachEpoch, boolean verbose) throws Exception {
        int i2;
        int f;
        if (this.trainer == null) {
            throw new Exception("Any NeuralNetworkTrainer class defined.");
        }
        this.RotateEachEpoch = RotateEachEpoch;
        File[] images = null;
        File file = new File(inputs);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The input file is not a directory.");
        }
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.contains(extension);
            }
        };
        ArrayList<String> classes = new ArrayList<String>(5);
        File[] files = file.listFiles();
        int nbimages = 0;
        for (f = 0; f < files.length; ++f) {
            if (!files[f].isDirectory()) continue;
            System.out.print(" - New class found '" + files[f].getName() + "'");
            classes.add(files[f].getName());
            images = files[f].listFiles(fnf);
            if (images == null || images.length == 0) {
                throw new Exception("No image found into the folder '" + files[f].getName() + "'");
            }
            nbimages += images.length;
            System.out.println(", it contains " + images.length + " images.");
        }
        if (classes.size() <= 1) {
            throw new Exception("Number of class/folder inferior or equal to 1.");
        }
        System.out.println("Total: " + classes.size() + " classes, " + nbimages + " images");
        BufferedImage image = ImageIO.Read(new File(images[0].getAbsolutePath()));
        int width = image.getWidth();
        int height = image.getHeight();
        image = null;
        if (RotateEachEpoch && width != height) {
            throw new IllegalArgumentException("Images are not squared, thus they cannot be rotated");
        }
        String[] imfiles = new String[nbimages];
        float[] input = new float[width * height];
        float[] output = new float[classes.size()];
        nbimages = 0;
        for (f = 0; f < files.length; ++f) {
            if (!files[f].isDirectory()) continue;
            images = files[f].listFiles(fnf);
            for (i2 = 0; i2 < images.length; ++i2) {
                imfiles[nbimages++] = images[i2].getAbsolutePath();
            }
            images = null;
        }
        this.trainer.InitializeWeights();
        this.trainer.StartTraining();
        int rotation = 0;
        BufferedImage im = null;
        while (this.trainer.isTraining()) {
            if (this.ShuffleEachEpoch) {
                NeuralNetworkTools.Shuffle(imfiles);
            }
            for (i2 = 0; i2 < imfiles.length; ++i2) {
                im = ImageIO.Read(new File(imfiles[i2]));
                switch (im.getType()) {
                    case 10: {
                        ArrayNew.CopyUnsigned((byte[])((DataBufferByte)im.getRaster().getDataBuffer()).getData(), (float[])input);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet).");
                    }
                }
                NeuralNetworkTools.Normalize(input, normalization, im);
                im = null;
                if (RotateEachEpoch) {
                    switch (rotation) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            NeuralNetworkTools.Rotate90(input, width);
                            break;
                        }
                        case 2: {
                            NeuralNetworkTools.Rotate180(input);
                            break;
                        }
                        case 3: {
                            NeuralNetworkTools.Rotate270(input, width);
                            break;
                        }
                        default: {
                            throw new Exception("Should not occur.");
                        }
                    }
                    rotation = (rotation + 1) % 4;
                }
                Arrays.fill(output, 0.0f);
                output[ListTools.isInSentence(classes, (String)imfiles[i2])] = 1.0f;
                this.Train(input, 1, width, height, output, 1.0f);
            }
            this.trainer.EpochOver(verbose);
        }
    }

    public void Test(BufferedImage image, int windowsize, int normalization, BufferedImage result) {
        float max;
        switch (image.getType()) {
            case 10: {
                max = 255.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        int margin = windowsize >> 1;
        int endx = image.getWidth() - margin - 1;
        int endy = image.getHeight() - margin - 1;
        BufferedImage subim = new BufferedImage(windowsize, windowsize, image.getType());
        float[] buffer = new float[windowsize * windowsize];
        for (int y = margin; y < endy; ++y) {
            for (int x = margin; x < endx; ++x) {
                ImageNew.SubImageWH((BufferedImage)image, (int)(x - margin), (int)(y - margin), (int)windowsize, (int)windowsize, (BufferedImage)subim);
                switch (image.getType()) {
                    case 10: {
                        ArrayNew.CopyUnsigned((byte[])((DataBufferByte)subim.getRaster().getDataBuffer()).getData(), (float[])buffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported (yet).");
                    }
                }
                switch (normalization) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ArrayArithmetic.Divide((float[])buffer, (float)max, (float[])buffer);
                        ArrayArithmetic.Subtract((float[])buffer, (float)0.5f, (float[])buffer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown normalization.");
                    }
                }
                this.Compute(buffer, 1, windowsize, windowsize);
                float[] predictions = this.Predictions();
                result.getRaster().setSample(x, y, 0, (int)(predictions[0] * max + 0.5f));
            }
        }
    }

    public void LinkWeightOptimization(NeuralNetworkTrainer trainer) {
        this.trainer = trainer;
        trainer.LinkNeuralNetwork(this);
    }

    public NeuralNetworkTrainer Trainer() {
        return this.trainer;
    }

    public float[] Predictions() {
        return this.outputlayer.Predictions();
    }

    public float Prediction(int index) {
        return this.outputlayer.Prediction(index);
    }

    public List<BasicLayer> Layers() {
        return this.layers;
    }

    public BasicLayer LastAddedLayer() {
        return this.previous;
    }

    public int nbWeights() {
        int sum = 0;
        for (int l = 0; l < this.layers.size(); ++l) {
            sum += this.layers.get(l).nbWeights();
        }
        return sum;
    }

    public int nbConnexionsReal() {
        int sum = 0;
        for (int l = 0; l < this.layers.size(); ++l) {
            sum += this.layers.get(l).nbConnexionsReal();
        }
        return sum;
    }

    public int nbConnexions() {
        int sum = 0;
        for (int l = 0; l < this.layers.size(); ++l) {
            sum += this.layers.get(l).nbConnexions();
        }
        return sum;
    }

    public NeuralNetwork CleanedInstance() {
        NeuralNetwork nn = new NeuralNetwork();
        for (int l = 0; l < this.layers.size(); ++l) {
            nn.AddLayer(this.layers.get(l).CleanedInstance());
        }
        List<BasicLayer> newlayers = nn.Layers();
        for (int l = 0; l < newlayers.size(); ++l) {
            newlayers.get(l).CopyInstance(this.layers.get(l));
        }
        return nn;
    }

    public NeuralNetwork Clone() {
        NeuralNetwork nn = new NeuralNetwork();
        for (int l = 0; l < this.layers.size(); ++l) {
            nn.AddLayer(this.layers.get(l).Instance());
        }
        List<BasicLayer> newlayers = nn.Layers();
        for (int l = 0; l < newlayers.size(); ++l) {
            newlayers.get(l).CopyInstance(this.layers.get(l));
        }
        return nn;
    }

    public void SaveXml(String file) throws Exception {
        boolean mkfile = true;
        File f = new File(file);
        if (!f.exists()) {
            mkfile = f.createNewFile();
        }
        if (!mkfile) {
            throw new Error("Can not create the Xml file.");
        }
        XmlIO.WriteXStream(this, file);
    }

    public void SaveCleanedXml(String file) throws Exception {
        boolean mkfile = true;
        File f = new File(file);
        if (!f.exists()) {
            mkfile = f.createNewFile();
        }
        if (!mkfile) {
            throw new Error("Cannot create the Xml file.");
        }
        XmlIO.WriteXStream(this.CleanedInstance(), file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.layers.size() * 300);
        try {
            sb.append(this.getClass().getName()).append(":\n\n");
            for (int l = 0; l < this.layers.size(); ++l) {
                sb.append(" - Layer ").append(l).append(":\n");
                this.layers.get(l).Informations(sb);
                sb.append("\n");
            }
            sb.append("Global informations:\n");
            sb.append(String.valueOf(this.nbWeights())).append(" weight(s)\n");
            sb.append(String.valueOf(this.nbConnexionsReal())).append(" real connexion(s)\n");
            sb.append(String.valueOf(this.nbConnexions())).append(" connexion(s)\n");
            if (this.trainer != null) {
                sb.append("\nWeights optimization:\n");
                sb.append(this.trainer.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

