/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers;

import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import dataMining.InstancesTools;
import dataMining.classifiers.Classification;
import dataMining.classifiers.neuralnet.NeuralNetwork;
import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import dataMining.imbalanceDataSet.DataSetBalancer;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jsat.SimpleDataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.CategoricalResults;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.Classifier;
import jsat.regression.RegressionDataSet;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;

public class GenericClassifier {
    private final int WEKA = -1;
    private final int JSAT = -2;
    private final int NEURALNETWORK = -3;
    public static final int SPLIT = 0;
    public static final int KFCV = 1;
    public static final int BSCV = 2;
    private int type = 0;
    private Object classifier = null;
    private Object classifiercopy = null;
    private Object classifierparameters = null;
    private String[] svalues = null;
    private double[][] probabilities = null;
    private String[] predictions = null;
    private int[] prediction = null;
    public final String[] checknames = new String[]{"Prediction", "ErrorRate", "TruePositive", "TrueNegative", "FalsePositive", "FalseNegative", "AUROC", "WeightedPrecision", "WeightedRecall", "Sensitivity", "Specificity"};
    private final double[] checks = new double[this.checknames.length];
    private final double[] weightedchecks = new double[this.checknames.length];
    private final List<String> classes = new ArrayList<String>(13);
    private DataSetBalancer dsb = null;
    private final ArrayFeatures AF = new ArrayFeatures();

    public GenericClassifier(Object classifier, Object ... parameters) {
        if (classifier instanceof weka.classifiers.Classifier) {
            this.type = -1;
        } else if (classifier instanceof Classifier) {
            this.type = -2;
        } else if (classifier instanceof NeuralNetwork) {
            this.type = -3;
        } else {
            throw new IllegalArgumentException("The object \"classifier\" is not a supported instance type.");
        }
        this.classifier = classifier;
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            if (parameters[i2] instanceof ClassifierParameterFunction) {
                if (!(classifier instanceof weka.classifiers.Classifier)) {
                    throw new IllegalArgumentException("The classifier and the parameter function don't match.");
                }
                this.classifierparameters = parameters[0];
                continue;
            }
            if (parameters[i2] instanceof String) {
                this.classes.add((String)parameters[i2]);
                continue;
            }
            if (parameters[i2] instanceof List) {
                List list = (List)parameters[i2];
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    this.classes.add((String)iter.next());
                }
                continue;
            }
            if (parameters[i2] instanceof DataSetBalancer) {
                this.dsb = (DataSetBalancer)parameters[i2];
                continue;
            }
            throw new IllegalArgumentException("Optional parameter " + i2 + ": type not supported.");
        }
        if (this.dsb != null && this.classes.isEmpty()) {
            throw new IllegalArgumentException("At least one class must be specified when the DataSetBalancer is given.");
        }
    }

    public void Train(FichierTabule dataset) throws Exception {
        FichierTabule balancedfile = this.dsb != null ? this.dsb.Balance(dataset, this.classes, true) : dataset;
        switch (this.type) {
            case -2: {
                ClassificationDataSet cds = FichierTabuleConverter.FichierTabuleToJsatClassificationDataSet(balancedfile);
                this.Train(cds);
                cds = null;
                break;
            }
            case -1: {
                Instances instances = FichierTabuleConverter.FichierTabuleToWekaInstances(dataset, "balancedfile");
                this.Train(instances);
                instances.clear();
                instances = null;
                break;
            }
            case -3: {
                float[][] data = FichierTabuleConverter.FichierTabuleToNeuralNetworkDataSet(balancedfile);
                float[][] targets = FichierTabuleConverter.FichierTabuleToNeuralNetworkTarget(balancedfile);
                float[] weights = FichierTabuleConverter.FichierTabuleToNeuralNetworkWeights(balancedfile);
                this.Train(data, targets, weights);
                targets = null;
                data = null;
                weights = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported/unknown classifier type: " + this.type + ". Must not occured!");
            }
        }
        if (this.dsb != null) {
            balancedfile.Kill();
            balancedfile = null;
        }
    }

    public void Train(Instances dataset) throws Exception {
        if (this.type != -1) {
            throw new IllegalArgumentException("The classifier is not a weka.classifiers.Classifier instance => Incompatible dataset.");
        }
        this.classifiercopy = null;
        this.classifiercopy = AbstractClassifier.makeCopy((weka.classifiers.Classifier)((weka.classifiers.Classifier)this.classifier));
        if (this.classifierparameters != null) {
            ((ClassifierParameterFunction)this.classifierparameters).Compute((weka.classifiers.Classifier)this.classifiercopy, dataset);
        }
        ((weka.classifiers.Classifier)this.classifiercopy).buildClassifier(dataset);
        int nbvalues = dataset.classAttribute().numValues();
        if (nbvalues <= 1) {
            throw new IllegalArgumentException("Only one class to predict.");
        }
        this.svalues = new String[nbvalues];
        for (int i2 = 0; i2 < nbvalues; ++i2) {
            this.svalues[i2] = dataset.classAttribute().value(i2);
        }
    }

    public void Train(ClassificationDataSet dataset) {
        if (this.type != -2) {
            throw new IllegalArgumentException("The classifier used is not a jsat.classifiers.Classifier instance => Incompatible dataset.");
        }
        this.classifiercopy = ((Classifier)this.classifier).clone();
        ((Classifier)this.classifiercopy).trainC(dataset);
        CategoricalData pred = dataset.getPredicting();
        int nbvalues = pred.getNumOfCategories();
        if (nbvalues <= 1) {
            throw new IllegalArgumentException("Only one class to predict.");
        }
        this.svalues = new String[nbvalues];
        for (int i2 = 0; i2 < nbvalues; ++i2) {
            this.svalues[i2] = pred.getOptionName(i2);
        }
    }

    public void Train(float[][] dataset, float[][] target, float[] weights) throws Exception {
        if (this.type != -3) {
            throw new IllegalArgumentException("The classifier is not a NeuralNetwork from the FiReTiTiLiB => Incompatible dataset.");
        }
        this.classifiercopy = null;
        NeuralNetwork nn = (NeuralNetwork)this.classifier;
        List<BasicLayer> layers = nn.Layers();
        BasicLayer fl = layers.get(0);
        nn.Train(dataset, fl.nbFeaturesMaps(), fl.Width(), fl.Height(), target, weights, false);
        this.classifiercopy = nn.CleanedInstance();
        fl = null;
        layers = null;
        nn = null;
    }

    public void Classify(FichierTabule dataset) throws Exception {
        Classification.CheckFile(dataset);
        switch (this.type) {
            case -2: {
                SimpleDataSet sds = FichierTabuleConverter.FichierTabuleToJsatDataSet(dataset);
                this.Classify(sds);
                sds = null;
                break;
            }
            case -1: {
                Instances inst = FichierTabuleConverter.FichierTabuleToWekaInstances(dataset, "");
                if (inst.numInstances() == 0) {
                    FichierTabuleConverter.FillWekaInstances(dataset, inst);
                }
                this.Classify(inst);
                inst.clear();
                inst = null;
                break;
            }
            case -3: {
                float[][] data = FichierTabuleConverter.FichierTabuleToNeuralNetworkDataSet(dataset);
                this.Classify(data);
                data = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported/unknown classifier type: " + this.type + ". Must not occured!");
            }
        }
    }

    public void Classify(Instances dataset) throws Exception {
        if (this.type != -1) {
            throw new IllegalArgumentException("The classifier used is not a weka.classifiers.Classifier instance => Incompatible dataset.");
        }
        this.Allocations(dataset.numInstances());
        for (int t = 0; t < dataset.numInstances(); ++t) {
            this.probabilities[t] = null;
            this.probabilities[t] = this.Classify(dataset.instance(t));
            this.prediction[t] = this.AF.MaximumIndex(this.probabilities[t]);
            this.predictions[t] = null;
            this.predictions[t] = this.svalues[this.prediction[t]];
        }
    }

    public void Classify(Instances dataset, String ClassToEvaluate) throws Exception {
        if (this.type != -1) {
            throw new IllegalArgumentException("The classifier used is not a weka.classifiers.Classifier instance => Incompatible dataset.");
        }
        this.Allocations(dataset.numInstances());
        int classpos = -1;
        for (int i2 = 0; i2 < this.svalues.length; ++i2) {
            if (!this.svalues[i2].equalsIgnoreCase(ClassToEvaluate)) continue;
            classpos = i2;
        }
        if (classpos < 0) {
            throw new IllegalArgumentException("The class to evaluate was not found.");
        }
        Evaluation evaluation = new Evaluation(dataset, null);
        for (int t = 0; t < dataset.numInstances(); ++t) {
            this.probabilities[t] = null;
            this.probabilities[t] = this.Classify(dataset.instance(t));
            this.prediction[t] = this.AF.MaximumIndex(this.probabilities[t]);
            this.predictions[t] = null;
            this.predictions[t] = this.svalues[this.prediction[t]];
            evaluation.evaluateModelOnceAndRecordPrediction((weka.classifiers.Classifier)this.classifiercopy, dataset.instance(t));
        }
        this.checks[0] = evaluation.pctCorrect();
        this.checks[1] = evaluation.errorRate();
        this.checks[2] = evaluation.truePositiveRate(classpos);
        this.checks[3] = evaluation.trueNegativeRate(classpos);
        this.checks[4] = evaluation.falsePositiveRate(classpos);
        this.checks[5] = evaluation.falseNegativeRate(classpos);
        this.checks[6] = evaluation.areaUnderROC(classpos);
        this.checks[7] = evaluation.precision(classpos);
        this.checks[8] = evaluation.recall(classpos);
        this.checks[9] = evaluation.numTruePositives(classpos) / (evaluation.numTruePositives(classpos) + evaluation.numFalseNegatives(classpos));
        this.checks[10] = evaluation.trueNegativeRate(classpos) / (evaluation.trueNegativeRate(classpos) + evaluation.numFalsePositives(classpos));
        this.weightedchecks[0] = evaluation.pctCorrect();
        this.weightedchecks[1] = evaluation.errorRate();
        this.weightedchecks[2] = evaluation.weightedTruePositiveRate();
        this.weightedchecks[3] = evaluation.weightedTrueNegativeRate();
        this.weightedchecks[4] = evaluation.weightedFalsePositiveRate();
        this.weightedchecks[5] = evaluation.weightedFalseNegativeRate();
        this.weightedchecks[6] = evaluation.weightedAreaUnderROC();
        this.weightedchecks[7] = evaluation.weightedPrecision();
        this.weightedchecks[8] = evaluation.weightedRecall();
        this.weightedchecks[9] = evaluation.numTruePositives(classpos) / (evaluation.numTruePositives(classpos) + evaluation.numFalseNegatives(classpos));
        this.weightedchecks[10] = evaluation.trueNegativeRate(classpos) / (evaluation.trueNegativeRate(classpos) + evaluation.numFalsePositives(classpos));
    }

    public double[] Classify(Instance instance) throws Exception {
        if (this.type != -1) {
            throw new IllegalArgumentException("The classifier used is not a weka.classifiers.Classifier instance => Incompatible dataset.");
        }
        return ((weka.classifiers.Classifier)this.classifiercopy).distributionForInstance(instance);
    }

    public void Classify(ClassificationDataSet dataset) {
        if (this.type != -2) {
            throw new IllegalArgumentException("The classifier used is not a jsat.classifiers.Classifier instance => Incompatible dataset.");
        }
        this.Allocations(dataset.getSampleSize());
        Classifier classif = (Classifier)this.classifiercopy;
        for (int t = 0; t < dataset.getSampleSize(); ++t) {
            CategoricalResults cr = classif.classify(dataset.getDataPoint(t));
            this.prediction[t] = cr.mostLikely();
            this.predictions[t] = this.svalues[cr.mostLikely()];
            double[] probas = new double[this.svalues.length];
            for (int p = 0; p < probas.length; ++p) {
                probas[p] = cr.getProb(p);
            }
            this.probabilities[t] = probas;
            probas = null;
            cr = null;
        }
    }

    public void Classify(float[][] dataset) throws Exception {
        this.Allocations(dataset.length);
        NeuralNetwork nn = (NeuralNetwork)this.classifiercopy;
        List<BasicLayer> layers = nn.Layers();
        BasicLayer layer = layers.get(0);
        int nbclass = nn.LastAddedLayer().Neurons().length;
        for (int i2 = 0; i2 < this.predictions.length; ++i2) {
            this.probabilities[i2] = new double[nbclass];
        }
        for (int t = 0; t < dataset.length; ++t) {
            float[] res = this.Classify(dataset[t], layer.nbFeaturesMaps(), layer.Width(), layer.Height());
            ArrayConverter.FloatToDouble((float[])res, (double[])this.probabilities[t]);
            this.prediction[t] = this.AF.MaximumIndex(res);
            res = null;
        }
        layer = null;
        layers = null;
        nn = null;
    }

    public float[] Classify(float[] instance, int nbFeaturesMap, int width, int height) throws Exception {
        if (this.type != -3) {
            throw new IllegalArgumentException("The classifier used is not a NeuralNetwork instance => Incompatible dataset.");
        }
        ((NeuralNetwork)this.classifiercopy).Compute(instance, nbFeaturesMap, width, height);
        return ((NeuralNetwork)this.classifiercopy).Predictions();
    }

    public void Classify(SimpleDataSet dataset) {
        if (this.type != -2) {
            throw new IllegalArgumentException("The classifier used is not a jsat.classifiers.Classifier instance => Incompatible dataset.");
        }
        this.Allocations(dataset.getSampleSize());
        Classifier classif = (Classifier)this.classifiercopy;
        for (int t = 0; t < dataset.getSampleSize(); ++t) {
            CategoricalResults cr = classif.classify(dataset.getDataPoint(t));
            this.prediction[t] = cr.mostLikely();
            this.predictions[t] = this.svalues[cr.mostLikely()];
            double[] probas = new double[this.svalues.length];
            for (int p = 0; p < probas.length; ++p) {
                probas[p] = cr.getProb(p);
            }
            this.probabilities[t] = probas;
            probas = null;
            cr = null;
        }
    }

    public void LearnPredictEvaluate(FichierTabule dataset, int validation, int parameter, String ClassToEvaluate) throws Exception {
        FichierTabule balancedfile = this.dsb != null ? this.dsb.Balance(dataset, this.classes, true) : dataset;
        switch (this.type) {
            case -2: {
                RegressionDataSet sds = FichierTabuleConverter.FichierTabuleToJsatRegressionDataSet(balancedfile);
                this.LearnPredictEvaluate(sds, validation, parameter);
                sds = null;
                break;
            }
            case -1: {
                Instances inst = FichierTabuleConverter.FichierTabuleToWekaInstances(balancedfile, "Training Set");
                this.LearnPredictEvaluate(inst, validation, parameter, ClassToEvaluate);
                inst.clear();
                inst = null;
                break;
            }
            case -3: {
                float[][] data = FichierTabuleConverter.FichierTabuleToNeuralNetworkDataSet(balancedfile);
                float[][] targets = FichierTabuleConverter.FichierTabuleToNeuralNetworkTarget(balancedfile);
                float[] weights = FichierTabuleConverter.FichierTabuleToNeuralNetworkWeights(balancedfile);
                this.svalues = FichierTabuleConverter.FichierTabuleToNeuralNetworkClassesNames(balancedfile);
                this.LearnPredictEvaluate(data, targets, weights, validation, parameter, ClassToEvaluate);
                targets = null;
                data = null;
                weights = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported/unknown classifier type: " + this.type + ". Must not occured!");
            }
        }
    }

    public void LearnPredictEvaluate(Instances dataset, int validation, int parameter, String ClassToEvaluate) throws Exception {
        if (this.type != -1) {
            throw new IllegalArgumentException("The classifier used is not a weka.classifiers.Classifier instance => Incompatible dataset.");
        }
        if (this.predictions == null || this.predictions.length != dataset.numInstances()) {
            this.predictions = null;
            this.predictions = new String[dataset.numInstances()];
            this.prediction = null;
            this.prediction = new int[this.predictions.length];
            this.probabilities = null;
            this.probabilities = new double[this.predictions.length][];
        }
        int nbvalues = dataset.classAttribute().numValues();
        int classpos = -1;
        this.svalues = new String[nbvalues];
        for (int i2 = 0; i2 < nbvalues; ++i2) {
            this.svalues[i2] = dataset.classAttribute().value(i2);
            if (!this.svalues[i2].equalsIgnoreCase(ClassToEvaluate)) continue;
            classpos = i2;
        }
        if (classpos < 0) {
            throw new IllegalArgumentException("The class to evaluate was not found.");
        }
        int[] folds = new int[dataset.numInstances()];
        Classification.FillAndRandomize(folds, parameter, true);
        Instances train = InstancesTools.CreateEmpty(dataset, "train");
        Instances test = InstancesTools.CreateEmpty(dataset, "test");
        weka.classifiers.Classifier classif = (weka.classifiers.Classifier)this.classifier;
        Evaluation evaluation = new Evaluation(dataset, null);
        if (this.classifierparameters != null) {
            ((ClassifierParameterFunction)this.classifierparameters).Compute(classif, train);
        }
        switch (validation) {
            case 1: {
                for (int n = 0; n < parameter; ++n) {
                    for (int i3 = 0; i3 < folds.length; ++i3) {
                        if (folds[i3] == n) {
                            test.add(dataset.instance(i3));
                            continue;
                        }
                        train.add(dataset.instance(i3));
                    }
                    weka.classifiers.Classifier currentclassifier = AbstractClassifier.makeCopy((weka.classifiers.Classifier)classif);
                    currentclassifier.buildClassifier(train);
                    int p = 0;
                    for (int t = 0; t < test.numInstances(); ++t) {
                        while (folds[p] != n) {
                            ++p;
                        }
                        this.probabilities[p] = currentclassifier.distributionForInstance(test.instance(t));
                        this.prediction[p] = this.AF.MaximumIndex(this.probabilities[p]);
                        this.predictions[p] = this.svalues[this.prediction[p]];
                        evaluation.evaluateModelOnceAndRecordPrediction(currentclassifier, test.instance(t));
                        ++p;
                    }
                    train.clear();
                    test.clear();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation type unknown or not supported (yet).");
            }
        }
        this.checks[0] = evaluation.pctCorrect();
        this.checks[1] = evaluation.errorRate();
        this.checks[2] = evaluation.truePositiveRate(classpos);
        this.checks[3] = evaluation.trueNegativeRate(classpos);
        this.checks[4] = evaluation.falsePositiveRate(classpos);
        this.checks[5] = evaluation.falseNegativeRate(classpos);
        this.checks[6] = evaluation.areaUnderROC(classpos);
        this.checks[7] = evaluation.weightedPrecision();
        this.checks[8] = evaluation.weightedRecall();
        this.checks[9] = evaluation.numTruePositives(classpos) / (evaluation.numTruePositives(classpos) + evaluation.numFalseNegatives(classpos));
        this.checks[10] = evaluation.trueNegativeRate(classpos) / (evaluation.trueNegativeRate(classpos) + evaluation.numFalsePositives(classpos));
        folds = null;
        classif = null;
        test = null;
        train = null;
        evaluation = null;
    }

    public void LearnPredictEvaluate(RegressionDataSet dataset, int validation, int parameter) throws Exception {
        throw new UnsupportedOperationException("Not implemented (yet).");
    }

    public void LearnPredictEvaluate(float[][] dataset, float[][] targets, float[] weights, int validation, int parameter, String ClassToEvaluate) throws Exception {
        int i2;
        if (this.type != -3) {
            throw new IllegalArgumentException("The classifier used is not a NeuralNetwork instance => Incompatible dataset.");
        }
        if (this.predictions == null || this.predictions.length != dataset.length) {
            this.predictions = null;
            this.predictions = new String[dataset.length];
            this.prediction = null;
            this.prediction = new int[this.predictions.length];
            this.probabilities = null;
            this.probabilities = new double[this.predictions.length][1];
        }
        if (this.svalues.length != 2) {
            throw new IllegalArgumentException("Only binary problems supported (so far).");
        }
        if (targets[0].length != this.svalues.length) {
            throw new IllegalArgumentException("targets[0].length != svalues.length.");
        }
        int classpos = -1;
        for (i2 = 0; i2 < this.svalues.length; ++i2) {
            if (!this.svalues[i2].equalsIgnoreCase(ClassToEvaluate)) continue;
            classpos = i2;
        }
        if (classpos < 0) {
            throw new IllegalArgumentException("The class to evaluate was not found.");
        }
        int[] folds = new int[dataset.length];
        Classification.FillAndRandomize(folds, parameter, true);
        float[][] train = new float[dataset.length][];
        float[][] test = new float[dataset.length][];
        NeuralNetwork nn = (NeuralNetwork)this.classifier;
        List<BasicLayer> layers = nn.Layers();
        BasicLayer layer = layers.get(0);
        int nbfm = layer.nbFeaturesMaps();
        int width = layer.Width();
        int height = layer.Height();
        layer = null;
        layers = null;
        int nb = 0;
        int correct = 0;
        int notcorrect = 0;
        int truepositive = 0;
        int truenegative = 0;
        int falsepositive = 0;
        int falsenegative = 0;
        switch (validation) {
            case 1: {
                for (int n = 0; n < parameter; ++n) {
                    for (i2 = 0; i2 < folds.length; ++i2) {
                        if (folds[i2] == n) {
                            test[i2] = dataset[i2];
                            train[i2] = null;
                            continue;
                        }
                        train[i2] = dataset[i2];
                        test[i2] = null;
                    }
                    nn.Train(train, nbfm, width, height, targets, weights, false);
                    for (int t = 0; t < test.length; ++t) {
                        if (test[t] == null) continue;
                        nn.Compute(test[t], nbfm, width, height);
                        this.probabilities[t] = ArrayConverter.FloatToDouble((float[])nn.Predictions());
                        this.prediction[t] = 0.5 < this.probabilities[t][0] ? 0 : 1;
                        this.predictions[t] = this.svalues[this.prediction[t]];
                        double p = this.probabilities[t][classpos];
                        float tar = targets[t][classpos];
                        if (0.5 < p && 0.5f < tar) {
                            ++correct;
                            ++truepositive;
                        } else if (p < 0.5 && tar < 0.5f) {
                            ++correct;
                            ++truenegative;
                        } else if (p < 0.5 && 0.5f < tar) {
                            ++notcorrect;
                            ++falsenegative;
                        } else {
                            ++notcorrect;
                            ++falsepositive;
                        }
                        ++nb;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation type unknown or not supported (yet).");
            }
        }
        this.checks[0] = (double)correct / (double)nb;
        this.checks[1] = (double)notcorrect / (double)nb;
        this.checks[2] = (double)truepositive / (double)nb;
        this.checks[3] = (double)truenegative / (double)nb;
        this.checks[4] = (double)falsepositive / (double)nb;
        this.checks[5] = (double)falsenegative / (double)nb;
        this.checks[6] = -1.0;
        this.checks[7] = -1.0;
        this.checks[8] = -1.0;
        this.checks[9] = (double)truepositive / (double)(truepositive + falsenegative);
        this.checks[10] = (double)truenegative / (double)(truenegative + falsepositive);
        folds = null;
        nn = null;
        test = null;
        train = null;
    }

    private void Allocations(int length) {
        if (this.probabilities != null && this.probabilities.length == length) {
            Arrays.fill((Object[])this.probabilities, null);
            Arrays.fill(this.predictions, null);
            Arrays.fill(this.prediction, 0);
            return;
        }
        this.prediction = null;
        this.prediction = new int[length];
        this.predictions = null;
        this.predictions = new String[length];
        this.probabilities = null;
        this.probabilities = new double[length][];
    }

    public double[][] Probabilities() {
        return this.probabilities;
    }

    public String[] Predictions() {
        return this.predictions;
    }

    public int[] PredictionS() {
        return this.prediction;
    }

    public String[] Classes() {
        return this.svalues;
    }

    public int ClassIndexOf(String s) {
        for (int i2 = 0; i2 < this.svalues.length; ++i2) {
            if (!s.equalsIgnoreCase(this.svalues[i2])) continue;
            return i2;
        }
        return -1;
    }

    public Object Classifier() {
        return this.classifier;
    }

    public double[] Checks() {
        return this.checks;
    }

    public double[] WeightedChecks() {
        return this.checks;
    }
}

