/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers;

import arrayTiTi.ArrayFeatures;
import dataMining.InstancesTools;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import java.util.Arrays;
import java.util.Random;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.ClassificationModelEvaluation;
import jsat.classifiers.Classifier;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.CostMatrix;
import weka.classifiers.Evaluation;
import weka.core.Debug;
import weka.core.Instances;

public class Classification {
    public static final int SPLIT = 0;
    public static final int KFCV = 1;
    public static final int BSCV = 2;
    private double[][] probabilities = null;
    private String[] predictions = null;
    private int[] prediction = null;
    private String[] svalues = null;
    private static int target = -1;
    private static int RandomSeed = 1;
    private CostMatrix costmatrix = null;
    private Evaluation evaluation = null;
    private ClassificationModelEvaluation modelEvaluation = null;
    private int nbInstances = -1;
    private int nbCorrect = -1;
    private int nbIncorrect = -1;
    private double PercentageCorrect = -1.0;
    private double PercentageIncorrect = -1.0;
    private final ArrayFeatures AF = new ArrayFeatures();

    public void Classify(FichierTabule data, weka.classifiers.Classifier classifier, ClassifierParameterFunction paramfunc, int validation, int nb) throws Exception {
        Classification.CheckFile(data);
        Instances instances = FichierTabuleConverter.FichierTabuleToWekaInstances(data, data.Name() + "Instances");
        this.Classify(instances, classifier, paramfunc, validation, nb);
        instances = null;
    }

    public void Classify(Instances data, weka.classifiers.Classifier classifier, ClassifierParameterFunction paramfunc, int validation, int nb) throws Exception {
        Debug.Random random = new Debug.Random((long)RandomSeed);
        weka.classifiers.Classifier current = null;
        Instances train = null;
        Instances test = null;
        this.costmatrix = null;
        if (data.classAttribute().isNominal()) {
            this.costmatrix = new CostMatrix(data.attribute(data.classIndex()).numValues());
        }
        this.evaluation = null;
        this.evaluation = new Evaluation(data, this.costmatrix);
        switch (validation) {
            case 0: {
                data.randomize((Random)random);
                int trainSize = (int)Math.round((double)(data.numInstances() * nb) / 100.0);
                int testSize = data.numInstances() - trainSize;
                train = new Instances(data, 0, trainSize);
                test = new Instances(data, trainSize, testSize);
                current = AbstractClassifier.makeCopy((weka.classifiers.Classifier)classifier);
                if (paramfunc != null) {
                    paramfunc.Compute(current, train);
                }
                current.buildClassifier(train);
                this.evaluation.evaluateModel(current, test, new Object[0]);
                current = null;
                test = null;
                train = null;
                break;
            }
            case 1: {
                if (paramfunc != null) {
                    paramfunc.Compute(classifier, data);
                }
                this.evaluation.crossValidateModel(classifier, data, nb, (Random)random, new Object[0]);
                break;
            }
            case 2: {
                boolean[] used = new boolean[data.numInstances()];
                data.randomize((Random)random);
                for (int f = 0; f < nb; ++f) {
                    int t;
                    Arrays.fill(used, false);
                    train = InstancesTools.CreateEmpty(data, "TrainSet");
                    train.setClassIndex(data.classIndex());
                    test = InstancesTools.CreateEmpty(data, "TestSet");
                    test.setClassIndex(data.classIndex());
                    while (train.numInstances() < data.numInstances()) {
                        t = (int)(random.nextDouble() * (double)data.numInstances());
                        train.add(data.instance(t));
                        used[t] = true;
                    }
                    for (t = 0; t < used.length; ++t) {
                        if (used[t]) continue;
                        test.add(data.instance(t));
                    }
                    current = AbstractClassifier.makeCopy((weka.classifiers.Classifier)classifier);
                    if (paramfunc != null) {
                        paramfunc.Compute(current, train);
                    }
                    current.buildClassifier(train);
                    for (t = 0; t < test.numInstances(); ++t) {
                        this.evaluation.evaluateModelOnceAndRecordPrediction(current, test.instance(t));
                    }
                    current = null;
                    test = null;
                    train = null;
                }
                used = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation type unknown or not supported.");
            }
        }
        this.nbInstances = data.numInstances();
        this.nbCorrect = (int)this.evaluation.correct();
        this.nbIncorrect = (int)this.evaluation.incorrect();
        this.PercentageCorrect = this.evaluation.pctCorrect();
        this.PercentageIncorrect = this.evaluation.pctIncorrect();
        random = null;
        this.modelEvaluation = null;
    }

    public void ClassifyAndPredict(FichierTabule data, weka.classifiers.Classifier classifier, ClassifierParameterFunction paramfunc, int validation, int nb) throws Exception {
        int i2;
        int[] folds = new int[data.Height()];
        Classification.FillAndRandomize(folds, nb, true);
        weka.classifiers.Classifier currentclassifier = null;
        Instances instances = FichierTabuleConverter.FichierTabuleToWekaInstances(data, "instances");
        Instances train = InstancesTools.CreateEmpty(instances, "train");
        Instances test = InstancesTools.CreateEmpty(instances, "test");
        int nbvalues = instances.classAttribute().numValues();
        this.svalues = new String[nbvalues];
        for (i2 = 0; i2 < nbvalues; ++i2) {
            this.svalues[i2] = instances.classAttribute().value(i2);
        }
        if (this.probabilities == null || this.probabilities.length != instances.numInstances()) {
            this.prediction = null;
            this.prediction = new int[instances.numInstances()];
            this.predictions = null;
            this.predictions = new String[instances.numInstances()];
            this.probabilities = null;
            this.probabilities = new double[instances.numInstances()][];
        }
        this.costmatrix = null;
        if (instances.classAttribute().isNominal()) {
            this.costmatrix = new CostMatrix(instances.attribute(instances.classIndex()).numValues());
        }
        this.evaluation = null;
        this.evaluation = new Evaluation(instances, this.costmatrix);
        if (paramfunc != null) {
            paramfunc.Compute(classifier, train);
        }
        train.clear();
        switch (validation) {
            case 1: {
                for (int n = 0; n < nb; ++n) {
                    data.ClearSelectionRows();
                    for (i2 = 0; i2 < folds.length; ++i2) {
                        if (folds[i2] == n) {
                            test.add(instances.instance(i2));
                            data.setSelected(i2, true);
                            continue;
                        }
                        train.add(instances.instance(i2));
                        data.setSelected(i2, false);
                    }
                    currentclassifier = AbstractClassifier.makeCopy((weka.classifiers.Classifier)classifier);
                    currentclassifier.buildClassifier(train);
                    for (int t = 0; t < test.numInstances(); ++t) {
                        i2 = data.NextSelected();
                        this.probabilities[i2] = currentclassifier.distributionForInstance(test.instance(t));
                        this.prediction[i2] = this.AF.MaximumIndex(this.probabilities[i2]);
                        this.predictions[i2] = this.svalues[this.prediction[i2]];
                        this.evaluation.evaluateModelOnceAndRecordPrediction(currentclassifier, test.instance(t));
                    }
                    i2 = data.NextSelected();
                    if (i2 != -1) {
                        throw new Error("Souci: i != -1.");
                    }
                    train.clear();
                    test.clear();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation type unknown or not supported.");
            }
        }
        this.nbInstances = data.Height();
        this.nbCorrect = (int)this.evaluation.correct();
        this.nbIncorrect = (int)this.evaluation.incorrect();
        this.PercentageCorrect = this.evaluation.pctCorrect();
        this.PercentageIncorrect = this.evaluation.pctIncorrect();
        this.modelEvaluation = null;
    }

    public static void FillAndRandomize(int[] array, int nb, boolean randomseed) {
        int i2;
        int pos = 0;
        for (i2 = 0; i2 < array.length; ++i2) {
            if (pos == nb) {
                pos = 0;
            }
            array[i2] = pos++;
        }
        Debug.Random random = randomseed ? new Debug.Random((long)RandomSeed) : new Debug.Random();
        for (i2 = 0; i2 < array.length; ++i2) {
            pos = (int)(random.nextDouble() * (double)array.length);
            int tmp = array[i2];
            array[i2] = array[pos];
            array[pos] = tmp;
        }
    }

    public void LearnAndPredict(FichierTabule train, FichierTabule test, weka.classifiers.Classifier classifier, ClassifierParameterFunction paramfunc) throws Exception {
        Classification.CheckFile(train);
        Instances trainset = FichierTabuleConverter.FichierTabuleToWekaInstances(train, train.Name() + "TrainSet");
        trainset.setClassIndex(target);
        Classification.CheckFile(test);
        Instances testset = FichierTabuleConverter.FichierTabuleToWekaInstances(test, test.Name() + "TestSet");
        testset.setClassIndex(target);
        this.LearnAndPredict(trainset, testset, classifier, paramfunc);
        trainset = null;
        testset = null;
    }

    public void LearnAndPredict(Instances train, Instances test, weka.classifiers.Classifier classifier, ClassifierParameterFunction paramfunc) throws Exception {
        if (!train.equalHeaders(test)) {
            throw new IllegalArgumentException("Data files (train and test) have different headers.");
        }
        int nbvalues = train.classAttribute().numValues();
        this.svalues = new String[nbvalues];
        for (int i2 = 0; i2 < nbvalues; ++i2) {
            this.svalues[i2] = train.classAttribute().value(i2);
        }
        if (this.probabilities == null || this.probabilities.length != test.numInstances()) {
            this.prediction = null;
            this.prediction = new int[test.numInstances()];
            this.predictions = null;
            this.predictions = new String[test.numInstances()];
            this.probabilities = null;
            this.probabilities = new double[test.numInstances()][];
        }
        this.costmatrix = null;
        this.evaluation = null;
        weka.classifiers.Classifier current = AbstractClassifier.makeCopy((weka.classifiers.Classifier)classifier);
        if (paramfunc != null) {
            paramfunc.Compute(current, train);
        }
        current.buildClassifier(train);
        for (int t = 0; t < test.numInstances(); ++t) {
            this.probabilities[t] = current.distributionForInstance(test.instance(t));
            this.prediction[t] = this.AF.MaximumIndex(this.probabilities[t]);
            this.predictions[t] = this.svalues[this.prediction[t]];
        }
        this.modelEvaluation = null;
        this.nbIncorrect = -1;
        this.nbCorrect = -1;
        this.nbInstances = -1;
        this.PercentageIncorrect = -1.0;
        this.PercentageCorrect = -1.0;
        current = null;
    }

    public void Classify(FichierTabule data, Classifier classifier, int validation, int nb) throws Exception {
        Classification.CheckFile(data);
        SimpleDataSet dataset = FichierTabuleConverter.FichierTabuleToJsatDataSet(data);
        this.Classify(dataset, classifier, validation, nb);
        dataset = null;
    }

    public void Classify(SimpleDataSet data, Classifier classifier, int validation, int nb) throws Exception {
        Debug.Random random = new Debug.Random((long)RandomSeed);
        ClassificationDataSet cDataSet = new ClassificationDataSet((DataSet)data, 0);
        this.modelEvaluation = new ClassificationModelEvaluation(classifier, cDataSet);
        this.evaluation = null;
        switch (validation) {
            case 1: {
                this.modelEvaluation.evaluateCrossValidation(nb, (Random)random);
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation type unknown or not supported (yet).");
            }
        }
        this.nbInstances = data.getSampleSize();
        this.PercentageIncorrect = this.modelEvaluation.getErrorRate();
        this.PercentageCorrect = 1.0 - this.PercentageIncorrect;
        this.nbCorrect = (int)((double)this.nbInstances * this.PercentageCorrect);
        this.nbIncorrect = this.nbInstances - this.nbCorrect;
        random = null;
    }

    public static void CheckFile(FichierTabule data) {
        target = -1;
        for (int x = 0; x < data.Width(); ++x) {
            if (data.isNominal(x)) {
                if (target != -1) {
                    throw new IllegalArgumentException("More than 1 nominal columns in data file.");
                }
                target = x;
            }
            if (data.ColumnType(x) != 2 || data.isNominal(x) || data.isExcludedColumn(x)) continue;
            throw new IllegalArgumentException("Column " + x + " is STRING, not nominal and not excluded.");
        }
        if (target == -1) {
            throw new IllegalArgumentException("Any nominal column in data file.");
        }
        if (data.nbColumn() - data.nbExcludedColumn() <= 1) {
            throw new IllegalArgumentException("Number of non excluded colums lower than 2.");
        }
        if (data.nbRows() == data.nbExcluded()) {
            throw new IllegalArgumentException("Empty file or all rows excluded.");
        }
    }

    public Evaluation WekaEvaluation() {
        return this.evaluation;
    }

    public ClassificationModelEvaluation JsatEvaluation() {
        return this.modelEvaluation;
    }

    public int nbInstances() {
        return this.nbInstances;
    }

    public int nbCorrect() {
        return this.nbCorrect;
    }

    public int nbIncorrect() {
        return this.nbIncorrect;
    }

    public double Prediction() {
        return this.PercentageCorrect;
    }

    public double PercentageCorrect() {
        return this.PercentageCorrect;
    }

    public double PercentageIncorrect() {
        return this.PercentageIncorrect;
    }

    public double[][] Probabilities() {
        return this.probabilities;
    }

    public String[] Predictions() {
        return this.predictions;
    }

    public int[] PredictionS() {
        return this.prediction;
    }

    public FichierTabule ProbabilitiesPredictions() {
        int[] columns = new int[this.probabilities[0].length + 1];
        Arrays.fill(columns, 1);
        columns[this.probabilities[0].length] = 2;
        FichierTabule result = new FichierTabule(this.probabilities.length, columns, "");
        for (int i2 = 0; i2 < this.probabilities.length; ++i2) {
            for (int j = 0; j < this.probabilities[0].length; ++j) {
                result.setValue(i2, j, this.probabilities[i2][j]);
            }
        }
        result.setColumn(this.probabilities[0].length, this.predictions);
        for (int j = 0; j < this.probabilities[0].length; ++j) {
            result.setColumnName(j, "Probability " + this.svalues[j]);
        }
        result.setColumnName(this.probabilities[0].length, "Prediction");
        columns = null;
        return result;
    }

    public void RandomSeed(int RandomSeed) {
        Classification.RandomSeed = RandomSeed;
    }

    public boolean EqualHeaders(Instances dataset1, Instances dataset2) {
        if (dataset1.classIndex() != dataset2.classIndex()) {
            return false;
        }
        if (dataset1.numAttributes() != dataset2.numAttributes()) {
            return false;
        }
        for (int i2 = 0; i2 < dataset1.numAttributes(); ++i2) {
            if (i2 == dataset1.classIndex() || dataset1.attribute(i2).equals((Object)dataset2.attribute(i2))) continue;
            return false;
        }
        return true;
    }
}

