/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers;

import dataMining.InstancesTools;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import java.util.Iterator;
import java.util.List;
import utils.times.Chronometer;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class Boosting {
    public static final int SPLIT = 0;
    public static final int KFCV = 1;
    public static final int BSCV = 2;
    protected FichierTabule Predictions = null;
    protected double PourcentagePrediction;
    protected int ModelePrediction = -1;
    protected int[] RepartitionKFold = null;
    protected double[][] PredictionsAverages = null;
    protected Instances instances = null;
    protected List<Classifier> classifiers = null;

    public Boosting(List<Classifier> classifiers, Instances instances, int Cible) {
        this.Initialiser(classifiers, instances, Cible);
    }

    public Boosting(List<Classifier> classifiers, Instances instances) {
        this(classifiers, instances, instances.numAttributes() - 1);
    }

    public Boosting(List<Classifier> classifiers, FichierTabule fichier, int Cible) {
        for (int i2 = 0; i2 < fichier.Height(); ++i2) {
            fichier.setNominal(i2, false);
        }
        fichier.setNominal(Cible, true);
        this.Initialiser(classifiers, FichierTabuleConverter.FichierTabuleToWekaInstances(fichier, "Nouveau classement"), Cible);
    }

    public Boosting(List<Classifier> classifiers, FichierTabule fichier) {
        this(classifiers, FichierTabuleConverter.FichierTabuleToWekaInstances(fichier, "Nouveau classement"));
    }

    protected void Initialiser(List<Classifier> classifiers, Instances instances, int Cible) {
        if (instances == null) {
            throw new NullPointerException("instances = null");
        }
        if (classifiers == null) {
            throw new NullPointerException("Classifiers = null");
        }
        Iterator<Classifier> iter = classifiers.iterator();
        while (iter.hasNext()) {
            if (iter.next() != null) continue;
            throw new NullPointerException("Classifiers[?] = null.");
        }
        if (Cible < 0 || Cible >= instances.numAttributes()) {
            throw new IllegalArgumentException("Valeur de la Cible incorrecte : " + Cible);
        }
        this.instances = instances;
        this.classifiers = classifiers;
        this.instances.setClassIndex(Cible);
        this.PredictionsAverages = new double[instances.numInstances()][instances.attribute(Cible).numValues()];
    }

    public void ComputeModelAndPredictions(int ModelePrediction, int Pourcentage, int Nb, Chronometer Chrono) {
        int i2;
        int k;
        int j;
        int length = this.PredictionsAverages[0].length;
        int marker = 0;
        double[] tab = null;
        int[] Types = new int[this.instances.attribute(this.instances.classIndex()).numValues() + 1];
        this.ModelePrediction = ModelePrediction;
        Instances AppSet = null;
        Instances ValSet = null;
        Iterator<Classifier> iter = this.classifiers.iterator();
        Classifier classifier2 = null;
        if (Chrono != null) {
            System.out.print("Simple boosting, " + this.classifiers.size() + " classifiers, ");
            marker = Chrono.NewMarker();
        }
        for (j = 0; j < this.instances.numInstances(); ++j) {
            for (k = 0; k < length; ++k) {
                this.PredictionsAverages[j][k] = 0.0;
            }
        }
        for (i2 = 0; i2 < length; ++i2) {
            Types[i2] = 1;
        }
        Types[length] = 2;
        this.Predictions = null;
        this.Predictions = new FichierTabule(this.instances.numInstances(), Types, "Predictions");
        try {
            switch (ModelePrediction) {
                case 1: {
                    if (Chrono != null) {
                        System.out.print("prediction \"K-fold Cross Validation\" : ");
                    }
                    int nbVal = 0;
                    this.RepartitionKFold = this.TirageAleatoireKFCV(this.instances.numInstances(), Nb);
                    for (i2 = 0; i2 < Nb; ++i2) {
                        AppSet = null;
                        ValSet = null;
                        AppSet = InstancesTools.CreateEmpty(this.instances, "TrainingSet" + i2);
                        ValSet = InstancesTools.CreateEmpty(this.instances, "ValidationSet" + i2);
                        for (j = 0; j < this.instances.numInstances(); ++j) {
                            if (this.RepartitionKFold[j] == i2) {
                                ValSet.add(this.instances.instance(j));
                                continue;
                            }
                            AppSet.add(this.instances.instance(j));
                        }
                        AppSet.setClassIndex(this.instances.classIndex());
                        ValSet.setClassIndex(this.instances.classIndex());
                        iter = null;
                        for (Classifier classifier2 : this.classifiers) {
                            classifier2.buildClassifier(AppSet);
                            int nb = 0;
                            for (j = 0; j < this.instances.numInstances(); ++j) {
                                if (this.RepartitionKFold[j] != i2) continue;
                                tab = classifier2.distributionForInstance(ValSet.instance(nb++));
                                for (k = 0; k < length; ++k) {
                                    double[] dArray = this.PredictionsAverages[j];
                                    int n = k;
                                    dArray[n] = dArray[n] + tab[k] / (double)length;
                                }
                                tab = null;
                            }
                            classifier2 = null;
                        }
                        for (j = 0; j < this.instances.numInstances(); ++j) {
                            if (this.RepartitionKFold[j] != i2) continue;
                            int max = 0;
                            for (k = 0; k < length; ++k) {
                                this.Predictions.setValue(j, k, this.PredictionsAverages[j][k]);
                                if (!(this.PredictionsAverages[j][max] < this.PredictionsAverages[j][k])) continue;
                                max = k;
                            }
                            this.Predictions.setValue(j, length, this.instances.attribute(this.instances.classIndex()).value(max));
                            if (!this.instances.attribute(this.instances.classIndex()).value(max).equalsIgnoreCase(this.instances.instance(j).stringValue(this.instances.classIndex()))) continue;
                            ++nbVal;
                        }
                    }
                    this.PourcentagePrediction = (double)nbVal / (double)this.instances.numInstances() * 100.0;
                    System.out.println("Prediction = " + this.PourcentagePrediction);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Type de prediction incorrecte : " + ModelePrediction);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AppSet = null;
        ValSet = null;
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
    }

    protected boolean[] TirageAleatoireSPLITCV(int Total, int nbApp) {
        int i2;
        boolean[] Tableau = new boolean[Total];
        for (i2 = 0; i2 < nbApp; ++i2) {
            Tableau[i2] = true;
        }
        for (i2 = nbApp; i2 < Total; ++i2) {
            Tableau[i2] = false;
        }
        for (i2 = 0; i2 < nbApp; ++i2) {
            int x = (int)(Math.random() * (double)Total);
            int y = (int)(Math.random() * (double)Total);
            boolean Tampon = Tableau[x];
            Tableau[x] = Tableau[y];
            Tableau[y] = Tampon;
        }
        return Tableau;
    }

    protected int[] TirageAleatoireKFCV(int Total, int nbClusters) {
        int i2;
        int nb = (int)Math.round((double)Total / (double)nbClusters);
        int[] Tableau = new int[Total];
        boolean Fin = false;
        int y = 0;
        int x = 0;
        for (i2 = 0; i2 < Total; ++i2) {
            Tableau[i2] = x++;
            ++y;
            if (Fin) {
                // empty if block
            }
            if (y != nb || Fin) continue;
            if (++x == nbClusters) {
                Fin = true;
                x = 0;
            }
            y = 0;
        }
        for (i2 = 0; i2 < Total; ++i2) {
            x = (int)(Math.random() * (double)Total);
            y = (int)(Math.random() * (double)Total);
            int Tampon = Tableau[x];
            Tableau[x] = Tableau[y];
            Tableau[y] = Tampon;
        }
        return Tableau;
    }

    public FichierTabule getPredictions() {
        return this.Predictions;
    }
}

