/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers;

import arrayTiTi.ArrayFeatures;
import characterization.ComputableFeatures;
import dataMining.WorkingSetBuilder;
import dataMining.imbalanceDataSet.DataSetBalancer;
import dataMining.imbalanceDataSet.WeightedSampling;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class AutoMultiClassifierSimple {
    private final List<ComputableFeatures> characterizers = new ArrayList<ComputableFeatures>(10);
    private final List<String> characterizerfile = new ArrayList<String>(10);
    private final List<Classifier> classifiers = new ArrayList<Classifier>(10);
    private final List<String> classes = new ArrayList<String>(10);
    private ClassModels[] cmd = null;
    private final DataSetBalancer dsb = new WeightedSampling();
    private final ArrayFeatures AF = new ArrayFeatures();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Classify(String folder, String imagextension, String result, int nbCPU) {
        File[] files = new File(folder).listFiles();
        double[] probabilities = new double[this.cmd.length];
        double[] features = null;
        double[] dist = null;
        int[] types = new int[this.cmd.length + 2];
        int nbimage = 0;
        for (File file : files) {
            if (!file.isFile() || !file.getName().contains(imagextension) || file.getName().charAt(0) == '.') continue;
            ++nbimage;
        }
        Arrays.fill(types, 1);
        types[types.length - 2] = 2;
        types[types.length - 1] = 2;
        FichierTabule resfile = new FichierTabule(nbimage, types, "Result");
        for (int classe = 0; classe < this.cmd.length; ++classe) {
            resfile.setColumnName(classe, this.cmd[classe].name);
        }
        resfile.setColumnName(resfile.Width() - 2, "Image");
        resfile.setColumnName(resfile.Width() - 1, "Class");
        nbimage = 0;
        for (int f = 0; f < files.length; ++f) {
            if (!files[f].isFile() || !files[f].getName().contains(imagextension) || files[f].getName().charAt(0) == '.') continue;
            try {
                BufferedImage image = ImageIO.Read(files[f].getAbsolutePath());
                resfile.setValue(nbimage, resfile.Width() - 2, this.JustName(files[f].getName()));
                for (int classe = 0; classe < this.cmd.length; ++classe) {
                    double proba = 0.0;
                    double sumweights = 0.0;
                    for (int mod = 0; mod < this.cmd[classe].models.size(); ++mod) {
                        Model model = this.cmd[classe].models.get(mod);
                        model.characterizer.Compute(image, null, -1, nbCPU);
                        features = model.characterizer.Features();
                        int nb = 0;
                        Instance instance = model.instance;
                        for (int att = 0; att < features.length; ++att) {
                            instance.setValue(nb++, features[att]);
                        }
                        if (nb != model.instance.numAttributes() - 1) {
                            throw new Error("nb != model.instance.numAttributes()-1.");
                        }
                        dist = model.classifier.distributionForInstance(instance);
                        proba += dist[model.pos] * model.weight;
                        sumweights += model.weight;
                    }
                    probabilities[classe] = proba / sumweights;
                    resfile.setValue(nbimage, classe, probabilities[classe]);
                }
                int index = this.AF.MaximumIndex(probabilities);
                resfile.setValue(nbimage, resfile.Width() - 1, this.cmd[index].name);
                image = null;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                resfile.setValue(nbimage, resfile.Width() - 1, "-1.0");
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                resfile.setValue(nbimage, resfile.Width() - 1, "-1.0");
                continue;
            }
            finally {
                ++nbimage;
            }
        }
        resfile.Write(result, false);
    }

    public void BuildModels(String folder, List<String> coltodelete) throws Exception {
        System.out.println("Classifiers files under construction...");
        System.out.flush();
        File folderout = new File("./OneClassClassifiers/");
        if (!folderout.exists()) {
            folderout.mkdirs();
        }
        for (int charac = 0; charac < this.characterizers.size(); ++charac) {
            FichierTabule ftc = new FichierTabule(folder + "/" + this.characterizerfile.get(charac), true);
            ftc.setNominalAndTarget(ftc.Width() - 1);
            Iterator<String> iter = coltodelete.iterator();
            while (iter.hasNext()) {
                ftc.setExcludedColumn(iter.next(), true);
            }
            iter = null;
            WorkingSetBuilder.CreateOneClassClassifier(ftc, this.dsb, folderout.getAbsolutePath(), this.characterizerfile.get(charac) + "_", this.classes);
            ftc.Kill();
            ftc = null;
        }
        System.out.println("Files construction done.");
        System.out.flush();
        System.out.println("Classifiers under construction...");
        System.out.flush();
        this.cmd = new ClassModels[this.classes.size()];
        for (int classe = 0; classe < this.cmd.length; ++classe) {
            this.cmd[classe] = new ClassModels(this.classes.get(classe));
            for (int charac = 0; charac < this.characterizers.size(); ++charac) {
                ComputableFeatures characterizer = this.characterizers.get(charac);
                FichierTabule training = new FichierTabule(folderout.getAbsolutePath() + "/" + this.characterizerfile.get(charac) + "_" + this.classes.get(classe) + ".txt", true);
                training.setNominalAndTarget(training.Width() - 1);
                Instances instances = FichierTabuleConverter.FichierTabuleToWekaInstances(training, "Instances");
                for (int classif = 0; classif < this.classifiers.size(); ++classif) {
                    Classifier classifier = this.classifiers.get(classif);
                    System.out.print("Building model ('" + classifier.getClass().getSimpleName() + "', '" + this.classes.get(classe) + "', '" + characterizer.getClass().getSimpleName() + "')... ");
                    System.out.flush();
                    int pos = instances.attribute("Class").indexOfValue(this.classes.get(classe));
                    Model model = new Model(characterizer.getClass().getSimpleName() + "_" + classifier.getClass().getSimpleName(), characterizer, classifier, 1.0, pos);
                    model.instance = new DenseInstance(instances.firstInstance());
                    model.instance.setDataset(instances);
                    model.classifier.buildClassifier(instances);
                    this.cmd[classe].AddModel(model);
                    System.out.println("successfully.");
                    System.out.flush();
                    model = null;
                    classifier = null;
                }
            }
        }
        System.out.println("Classifiers built.");
        System.out.flush();
    }

    private String JustName(String str) {
        int i2;
        for (i2 = str.length() - 1; 0 <= i2 && str.charAt(i2) != '/'; --i2) {
        }
        if (i2 < 0) {
            return str;
        }
        return str.substring(i2 + 1);
    }

    public void AddCharacterizer(ComputableFeatures characterizer, String charfile) {
        this.characterizers.add(characterizer);
        this.characterizerfile.add(charfile);
    }

    public void AddClassifier(Classifier classifier) {
        this.classifiers.add(classifier);
    }

    public void AddClass(String classe) {
        this.classes.add(classe);
    }

    private class ClassModels {
        public String name = null;
        public List<Model> models = new ArrayList<Model>(10);

        public ClassModels(String name) {
            this.name = name.substring(0);
        }

        public void AddModel(Model model) {
            this.models.add(model);
        }
    }

    private class Model {
        String name = null;
        public ComputableFeatures characterizer = null;
        public Classifier classifier = null;
        public Instance instance = null;
        public double weight = 1.0;
        public int pos = 0;

        public Model(String name, ComputableFeatures characterizer, Classifier classifier, double weight, int pos) throws Exception {
            this.name = name.substring(0);
            this.characterizer = characterizer;
            this.classifier = AbstractClassifier.makeCopy((Classifier)classifier);
            this.weight = weight;
            this.pos = pos;
        }
    }
}

