/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers;

import arrayTiTi.ArrayFeatures;
import characterization.ComputableFeatures;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import imageTiTi.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class AutoMultiClassifier {
    private final List<ComputableFeatures> characterizers = new ArrayList<ComputableFeatures>(10);
    private final List<String> characterizerextensions = new ArrayList<String>(10);
    private final List<Classifier> classifiers = new ArrayList<Classifier>(10);
    private final List<String> classifierextensions = new ArrayList<String>(10);
    private final List<String> classes = new ArrayList<String>(10);
    private final List<String> classextensions = new ArrayList<String>(10);
    private ClassModels[] cmd = null;
    private final ArrayFeatures AF = new ArrayFeatures();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Classify(String folder, String imagextension, String result, int nbCPU) {
        File[] files = new File(folder).listFiles();
        double[] probabilities = new double[this.cmd.length];
        double[] features = null;
        double[] dist = null;
        int[] types = new int[this.cmd.length + 2];
        int nbimage = 0;
        for (File file : files) {
            if (!file.isFile() || !file.getName().contains(imagextension) || file.getName().charAt(0) == '.') continue;
            ++nbimage;
        }
        Arrays.fill(types, 1);
        types[types.length - 2] = 2;
        types[types.length - 1] = 2;
        FichierTabule resfile = new FichierTabule(nbimage, types, "Result");
        for (int classe = 0; classe < this.cmd.length; ++classe) {
            resfile.setColumnName(classe, this.cmd[classe].name);
        }
        resfile.setColumnName(resfile.Width() - 2, "Image");
        resfile.setColumnName(resfile.Width() - 1, "Class");
        nbimage = 0;
        for (int f = 0; f < files.length; ++f) {
            if (!files[f].isFile() || !files[f].getName().contains(imagextension) || files[f].getName().charAt(0) == '.') continue;
            try {
                BufferedImage image = ImageIO.Read(files[f].getAbsolutePath());
                resfile.setValue(nbimage, resfile.Width() - 2, files[f].getName());
                for (int classe = 0; classe < this.cmd.length; ++classe) {
                    double proba = 0.0;
                    double sumweights = 0.0;
                    int mod = 0;
                    if (mod < this.cmd[classe].models.size()) {
                        Model model = this.cmd[classe].models.get(mod);
                        model.characterizer.Compute(image, null, -1, nbCPU);
                        features = model.characterizer.Features();
                        int nb = 0;
                        Instance instance = model.instance;
                        for (int att = 0; att < features.length; ++att) {
                            if (model.excluded[att]) continue;
                            instance.setValue(nb++, features[att]);
                        }
                        if (nb != model.instance.numAttributes() - 1) {
                            throw new Error("nb != model.instance.numAttributes()-1.");
                        }
                        dist = model.classifier.distributionForInstance(instance);
                        throw new Error("Bug to fix...");
                    }
                    probabilities[classe] = proba / sumweights;
                    resfile.setValue(nbimage, classe, probabilities[classe]);
                }
                int index = this.AF.MaximumIndex(probabilities);
                resfile.setValue(nbimage, resfile.Width() - 1, this.cmd[index].name);
                image = null;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                resfile.setValue(nbimage, resfile.Width() - 1, "-1.0");
                continue;
            }
            catch (Error e) {
                e.printStackTrace();
                resfile.setValue(nbimage, resfile.Width() - 1, "-1.0");
                continue;
            }
            finally {
                ++nbimage;
            }
        }
        resfile.Write(result, false);
    }

    public void BuildModels(String folder, String best, String sysres, boolean weighted) throws Exception {
        System.out.println("Classifiers under construction...");
        System.out.flush();
        File[] files = new File(folder).listFiles();
        this.cmd = new ClassModels[this.classes.size()];
        for (int classe = 0; classe < this.cmd.length; ++classe) {
            String classext = this.classextensions.get(classe);
            this.cmd[classe] = new ClassModels(this.classes.get(classe));
            for (int charac = 0; charac < this.characterizers.size(); ++charac) {
                String charext = this.characterizerextensions.get(charac);
                ComputableFeatures characterizer = this.characterizers.get(charac);
                FichierTabule training = this.FindTrain(files, best, sysres, classext, charext);
                for (int classif = 0; classif < this.classifiers.size(); ++classif) {
                    String classifext = this.classifierextensions.get(classif);
                    Classifier classifier = this.classifiers.get(classif);
                    FichierTabule srfile = this.FindSysRes(files, sysres, best, classext, charext, classifext);
                    FichierTabule bestfile = this.FindBest(files, best, classext, charext, classifext);
                    double weight = weighted ? bestfile.getValueDouble(0, 0) : 100.0;
                    int row = bestfile.getValueInt(0, 2);
                    if (weighted && srfile.getValueDouble(row, srfile.Width() - 1) != weight) {
                        throw new Error("Souci srfile.getValueDouble(row, srfile.Width()-1) != weight => " + srfile.getValueDouble(row, srfile.Width() - 1) + " " + weight);
                    }
                    weight /= 100.0;
                    int width = training.Width();
                    if (srfile.Width() != width) {
                        throw new Error("SysResfile.Width() != training.Width().");
                    }
                    boolean[] excluded = new boolean[width];
                    for (int x = 0; x < width - 1; ++x) {
                        excluded[x] = srfile.getValueInt(row, x) != 1;
                    }
                    this.cmd[classe].AddModel(new Model(classext + "_" + charext + "_" + classifext, characterizer, classifier, excluded, weight));
                    System.out.print("Building model ('" + classext + "', '" + charext + "', '" + classifext + "')... ");
                    System.out.flush();
                    Model model = this.cmd[classe].models.get(this.cmd[classe].models.size() - 1);
                    training.setExcludedColumn(excluded);
                    FichierTabule trainingnew = FichierTabuleTools.DeleteExcludedColumns(training);
                    trainingnew.setNominal(trainingnew.Width() - 1, true);
                    Instances instances = FichierTabuleConverter.FichierTabuleToWekaInstances(trainingnew, "Instances");
                    instances.setClassIndex(instances.numAttributes() - 1);
                    model.instance = new DenseInstance(instances.firstInstance());
                    model.instance.setDataset(instances);
                    model.classifier.buildClassifier(instances);
                    System.out.println("successfully.");
                    System.out.flush();
                    model = null;
                    trainingnew = null;
                    excluded = null;
                    bestfile = null;
                    srfile = null;
                    classifier = null;
                    classifext = null;
                }
            }
        }
        System.out.println("Classifiers built.");
        System.out.flush();
    }

    private FichierTabule FindSysRes(File[] files, String sysres, String best, String classext, String charext, String classifext) throws Exception {
        int index = -1;
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (!files[i2].isFile() || !files[i2].getName().contains(sysres) || files[i2].getName().contains(best) || !files[i2].getName().contains(classext) || !files[i2].getName().contains(charext) || !files[i2].getName().contains(classifext) || files[i2].getName().charAt(0) == '.') continue;
            if (0 <= index) {
                throw new FileNotFoundException("Two files found for SysRes ('" + sysres + "', '" + classext + "', '" + charext + "', '" + classifext + "'): " + files[i2].getName() + " & " + files[index].getName());
            }
            index = i2;
        }
        if (index < 0) {
            throw new Error("No file found for SysRes ('" + sysres + "', '" + classext + "', '" + charext + "', '" + classifext + "').");
        }
        return new FichierTabule(files[index].getAbsolutePath(), true);
    }

    private FichierTabule FindBest(File[] files, String best, String classext, String charext, String classifext) throws Exception {
        int index = -1;
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (!files[i2].isFile() || !files[i2].getName().contains(best) || files[i2].getName().charAt(0) == '.' || !files[i2].getName().contains(classext) || !files[i2].getName().contains(charext) || !files[i2].getName().contains(classifext)) continue;
            if (0 <= index) {
                throw new Error("Two files found for Best ('" + best + "', '" + classext + "', '" + charext + "', '" + classifext + "'): " + files[i2].getName() + " & " + files[index].getName());
            }
            index = i2;
        }
        if (index < 0) {
            throw new FileNotFoundException("No file found for Best ('" + best + "', '" + classext + "', '" + charext + "', '" + classifext + "').");
        }
        return new FichierTabule(files[index].getAbsolutePath(), false);
    }

    private FichierTabule FindTrain(File[] files, String best, String sysres, String classext, String charext) throws Exception {
        int index = -1;
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (!files[i2].isFile() || files[i2].getName().contains(best) || files[i2].getName().contains(sysres) || files[i2].getName().charAt(0) == '.' || !files[i2].getName().contains(classext) || !files[i2].getName().contains(charext)) continue;
            if (0 <= index) {
                throw new Error("Two files found for training ('" + classext + "', '" + charext + "'): " + files[i2].getName() + " & " + files[index].getName());
            }
            index = i2;
        }
        if (index < 0) {
            throw new Error("No file found for Best ('" + best + "', '" + classext + "', '" + charext + "').");
        }
        return new FichierTabule(files[index].getAbsolutePath(), true);
    }

    public void AddCharacterizer(ComputableFeatures characterizer, String extension) {
        this.characterizers.add(characterizer);
        this.characterizerextensions.add(extension);
    }

    public void AddClassifier(Classifier classifier, String extension) {
        this.classifiers.add(classifier);
        this.classifierextensions.add(extension);
    }

    public void AddClass(String classe, String extension) {
        this.classes.add(classe);
        this.classextensions.add(extension);
    }

    private class ClassModels {
        public String name = null;
        public List<Model> models = new ArrayList<Model>(10);

        public ClassModels(String name) {
            this.name = name.substring(0);
        }

        public void AddModel(Model model) {
            this.models.add(model);
        }
    }

    private class Model {
        String name = null;
        public ComputableFeatures characterizer = null;
        public Classifier classifier = null;
        public Instance instance = null;
        public boolean[] excluded = null;
        public double weight = 1.0;

        public Model(String name, ComputableFeatures characterizer, Classifier classifier, boolean[] excluded, double weight) throws Exception {
            this.name = name.substring(0);
            this.characterizer = characterizer;
            this.classifier = AbstractClassifier.makeCopy((Classifier)classifier);
            this.excluded = Arrays.copyOf(excluded, excluded.length);
            this.weight = weight;
        }
    }
}

