/*
 * Decompiled with CFR 0.152.
 */
package dataMining;

import dataMining.imbalanceDataSet.DataSetBalancer;
import dataMining.imbalanceDataSet.WeightedSampling;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class WorkingSetBuilder {
    public static void Create1vs1(FichierTabule file, String target, DataSetBalancer dsb, String outputfolder, String prefix, String ... classes) {
        WorkingSetBuilder.Create1vs1(file, file.ColumnNumber(target), dsb, outputfolder, prefix, classes);
    }

    public static void Create1vs1(FichierTabule file, int target, DataSetBalancer dsb, String outputfolder, String prefix, String ... classes) {
        boolean weights = dsb != null && dsb instanceof WeightedSampling;
        ArrayList<String> list = new ArrayList<String>(13);
        File outputfile = new File(outputfolder);
        if (!outputfile.exists()) {
            outputfile.mkdirs();
        }
        outputfile = null;
        FichierTabule tmp = file.nbExcluded() != 0 || file.nbExcludedColumn() != 0 ? FichierTabuleTools.DeleteExcluded(file) : file;
        for (int c0 = 0; c0 < classes.length; ++c0) {
            String str0 = classes[c0];
            list.add(str0);
            tmp.SelectWhere(target, 0, str0);
            FichierTabule class0 = FichierTabuleTools.SaveSelectedRows(tmp);
            tmp.ClearSelection();
            for (int ci = c0 + 1; ci < classes.length; ++ci) {
                String stri = classes[ci];
                list.add(stri);
                tmp.SelectWhere(target, 0, stri);
                FichierTabule classi = FichierTabuleTools.SaveSelectedRows(tmp);
                tmp.ClearSelection();
                FichierTabule merge = FichierTabuleTools.Merge(class0, classi);
                merge.setNominal(target, true);
                FichierTabule result = dsb != null ? dsb.Balance(merge, list, true) : merge;
                result.Write(outputfolder + "/" + prefix + str0 + "_vs_" + stri + ".txt", weights);
                list.remove(1);
            }
            list.clear();
        }
        if (tmp != file) {
            tmp.Kill();
        }
        tmp = null;
    }

    public static void CreateOneClassClassifier(String folderpath, String target, List<String> todelete, DataSetBalancer balancer, String outputfolder, String ... classes) {
        File[] files = new File(folderpath).listFiles();
        for (int f = 0; f < files.length; ++f) {
            if (!files[f].isFile() || files[f].getName().contains(".DS_Store")) continue;
            try {
                FichierTabule file = new FichierTabule(files[f].getAbsolutePath(), true);
                file.setNominalAndTarget(target);
                Iterator<String> iter = todelete.iterator();
                while (iter.hasNext()) {
                    file.setExcludedColumn(iter.next(), true);
                }
                iter = null;
                WorkingSetBuilder.CreateOneClassClassifier(file, balancer, outputfolder + "/" + files[f].getName().replace(".txt", "") + "/", files[f].getName().replace(".txt", "") + "_", classes);
                file = null;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        files = null;
    }

    public static void CreateOneClassClassifier(FichierTabule file, DataSetBalancer dsb, String outputfolder, String prefix, String ... classes) {
        WorkingSetBuilder.CreateOneClassClassifier(file, dsb, outputfolder, prefix, Arrays.asList(classes));
    }

    public static void CreateOneClassClassifier(FichierTabule file, DataSetBalancer dsb, String outputfolder, String prefix, List<String> classes) {
        int target = file.Target();
        if (target == -1) {
            throw new IllegalArgumentException("Any target column defined.");
        }
        boolean weights = dsb != null && dsb instanceof WeightedSampling;
        ArrayList<String> list = new ArrayList<String>(13);
        FichierTabule clone = null;
        File outputfile = new File(outputfolder);
        if (!outputfile.exists()) {
            outputfile.mkdirs();
        }
        outputfile = null;
        FichierTabule tmp = file.nbExcluded() != 0 || file.nbExcludedColumn() != 0 ? FichierTabuleTools.DeleteExcluded(file) : file;
        target = tmp.Target();
        for (int c0 = 0; c0 < classes.size(); ++c0) {
            list.add(classes.get(c0));
            if (clone == null) {
                clone = FichierTabuleTools.Clone(tmp);
            } else {
                FichierTabuleTools.Copy(tmp, clone);
            }
            clone.SelectWhere(target, 5, classes.get(c0));
            clone.setValueInSelection(target, "Others");
            FichierTabule result = dsb != null ? dsb.Balance(clone, list, true) : clone;
            result.Write(outputfolder + "/" + prefix + classes.get(c0) + ".txt", weights);
            list.clear();
        }
    }

    public static void CreateOneVersusAll(String folderpath, String target, List<String> todelete, DataSetBalancer balancer, String outputfolder, String ... classes) {
        File[] files = new File(folderpath).listFiles();
        for (int f = 0; f < files.length; ++f) {
            if (!files[f].isFile() || files[f].getName().contains(".DS_Store")) continue;
            try {
                FichierTabule file = new FichierTabule(files[f].getAbsolutePath(), true);
                file.setNominalAndTarget(target);
                Iterator<String> iter = todelete.iterator();
                while (iter.hasNext()) {
                    file.setExcludedColumn(iter.next(), true);
                }
                iter = null;
                WorkingSetBuilder.CreateOneVersusAll(file, balancer, outputfolder + "/" + files[f].getName().replace(".txt", "") + "/", files[f].getName().replace(".txt", "") + "_", classes);
                file.Kill();
                file = null;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        files = null;
    }

    public static void CreateOneVersusAll(FichierTabule file, DataSetBalancer dsb, String outputfolder, String prefix, String ... classes) {
        WorkingSetBuilder.CreateOneVersusAll(file, dsb, outputfolder, prefix, Arrays.asList(classes));
    }

    public static void CreateOneVersusAll(FichierTabule file, DataSetBalancer dsb, String outputfolder, String prefix, List<String> classes) {
        boolean weights = dsb != null && dsb instanceof WeightedSampling;
        FichierTabule result = null;
        File outputfile = new File(outputfolder);
        if (!outputfile.exists()) {
            outputfile.mkdirs();
        }
        FichierTabule tmp = file.nbExcluded() != 0 || file.nbExcludedColumn() != 0 ? FichierTabuleTools.DeleteExcluded(file) : file;
        result = dsb != null ? dsb.Balance(tmp, classes, true) : file;
        result.Write(outputfolder + "/" + prefix + "OneVersusAll.txt", weights);
        outputfile = null;
        result = null;
        tmp = null;
    }
}

