/*
 * Decompiled with CFR 0.152.
 */
package dataMining;

import arrayTiTi.ArrayComparator;
import dataMining.classifiers.Classification;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import dataMining.imbalanceDataSet.DataSetBalancer;
import filesAndFolders.FileFilters;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weka.classifiers.Classifier;
import weka.core.Attribute;

public class QuickPerformances {
    public static final int SPLIT = 0;
    public static final int KFCV = 1;
    public static final int BSCV = 2;
    private Classification classification = new Classification();

    public void Evaluate(String folderpath, String target, Classifier classifier, ClassifierParameterFunction cpf, int validation, int nb, String output) throws IOException {
        File[] folders = new File(folderpath).listFiles();
        DataOutputStream out = new DataOutputStream(new FileOutputStream(output));
        for (int f = 0; f < folders.length; ++f) {
            if (!folders[f].isDirectory()) continue;
            File[] files = new File(folders[f].getAbsolutePath()).listFiles();
            for (int i2 = 0; i2 < files.length; ++i2) {
                if (!files[i2].isFile() || !files[i2].getName().contains(".txt")) continue;
                try {
                    FichierTabule file = new FichierTabule(files[i2].getAbsolutePath(), true);
                    file.setNominalAndTarget(target);
                    out.write((files[i2].getName() + " => ").getBytes("ISO-8859-1"));
                    out.write((this.Evaluate(file, classifier, cpf, validation, nb) + "\n").getBytes("ISO-8859-1"));
                    continue;
                }
                catch (FileNotFoundException ex) {
                    out.write(("Cannot read file '" + files[i2].getName() + "'\n.").getBytes("ISO-8859-1"));
                    continue;
                }
                catch (Exception ex) {
                    out.write("error during evaluation.\n".getBytes("ISO-8859-1"));
                }
            }
        }
    }

    public double Evaluate(FichierTabule file, Classifier classifier, ClassifierParameterFunction cpf, int validation, int nb) throws Exception {
        this.classification.Classify(file, classifier, cpf, validation, nb);
        return this.classification.Prediction();
    }

    public void AnalyzeAndGenerateResults(String f, List<String> classes, List<String> techniques, String output) throws Exception {
        FichierTabule file = new FichierTabule(f, false);
        file.ClearAll();
        File fil = new File(f);
        String name = fil.getName().replace(".txt", "");
        File out = new File(output);
        if (!out.exists()) {
            out.mkdirs();
        }
        out = null;
        fil = null;
        String[] colnames = new String[]{"Files", "Predictions"};
        boolean[] tosave = new boolean[file.Height()];
        ArrayList<String> list = new ArrayList<String>(techniques.size());
        for (String c : classes) {
            file.SelectWhere(0, 6, c);
            System.arraycopy(file.getSelected(), 0, tosave, 0, tosave.length);
            ArrayComparator.Compare((boolean[])file.getExcluded(), (String)"==", (boolean)false, (boolean[])tosave, (boolean)false, (boolean[])tosave);
            FichierTabule tmp1 = FichierTabuleTools.SaveRows(file, tosave);
            file.ExcludeSelected();
            tmp1.setExcludedColumn(1, true);
            FichierTabule tmp2 = FichierTabuleTools.DeleteExcludedColumns(tmp1);
            FichierTabuleTools.Sort(tmp2, 1);
            tmp2.setColumnsNames(colnames);
            tmp2.Write(output + "/" + name + "_" + c + ".txt", false);
            Iterator<String> itertech = techniques.iterator();
            while (itertech.hasNext()) {
                list.add(itertech.next());
            }
            itertech = null;
            for (int row = tmp2.Height() - 1; row >= 0; --row) {
                String s = tmp2.getValueString(row, 0);
                boolean found = false;
                int l = 0;
                while (l < list.size()) {
                    if (s.indexOf((String)list.get(l)) == 0) {
                        if (found) {
                            System.out.println("SOuci, double found");
                        }
                        found = true;
                        list.remove(l);
                        continue;
                    }
                    ++l;
                }
                if (found) continue;
                tmp2.setSelected(row, true);
            }
            tmp2.ExcludeSelected();
            FichierTabule result = FichierTabuleTools.DeleteExcludedRows(tmp2);
            result.Write(output + "/" + name + "_Best_" + c + ".txt", false);
            result = null;
            tmp2 = null;
            tmp1 = null;
        }
    }

    public void Evaluate(String dirpath, List<String> columnstodelete, String target, DataSetBalancer dsb, Classifier classifier, ClassifierParameterFunction cpf, int validation, int nb, String output) throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(output));
        File[] dirs = new File(dirpath).listFiles(FileFilters.Directories);
        for (int d = 0; d < dirs.length; ++d) {
            this.Evaluate(dirs[d].getAbsolutePath(), columnstodelete, target, dsb, classifier, cpf, validation, nb, out);
        }
        dirs = null;
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Evaluate(String dirpath, List<String> columnstodelete, String target, DataSetBalancer dsb, Classifier classifier, ClassifierParameterFunction cpf, int validation, int nb, DataOutputStream out) throws IOException {
        File[] files = new File(dirpath).listFiles(FileFilters.TextFiles);
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (!files[i2].isFile() || !files[i2].getName().contains(".txt")) continue;
            try {
                int c;
                FichierTabule file = new FichierTabule(files[i2].getAbsolutePath(), true);
                file.setNominalAndTarget(target);
                if (dsb != null) {
                    file = dsb.Balance(file, true);
                }
                Iterator<String> iter = columnstodelete.iterator();
                while (iter.hasNext()) {
                    file.setExcludedColumn(iter.next(), true);
                }
                out.write((files[i2].getName() + " => ").getBytes("ISO-8859-1"));
                this.classification.Classify(file, classifier, cpf, validation, nb);
                Attribute att = this.classification.WekaEvaluation().getHeader().attribute(this.classification.WekaEvaluation().getHeader().classIndex());
                double[][] cm = this.classification.WekaEvaluation().confusionMatrix();
                for (c = 0; c < cm.length; ++c) {
                    file.SelectWhere(target, 0, att.value(c));
                    out.write((cm[c][c] / (double)file.nbSelected() * 100.0 + " ").getBytes("ISO-8859-1"));
                }
                cm = null;
                out.write("=> ".getBytes("ISO-8859-1"));
                for (c = 0; c < att.numValues(); ++c) {
                    out.write((att.value(c) + " ").getBytes("ISO-8859-1"));
                }
                out.write(("=> " + this.classification.Prediction()).getBytes("ISO-8859-1"));
                continue;
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            finally {
                out.write("\n".getBytes("ISO-8859-1"));
            }
        }
    }
}

