/*
 * Decompiled with CFR 0.152.
 */
package dataMining;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import arrayTiTi.ArrayTools;
import dataMining.classifiers.GenericClassifier;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import dataMining.imbalanceDataSet.DataSetBalancer;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListTools;
import mathematics.statistics.CenterReduce;
import mathematics.statistics.Normalize;

public class ModelsEvaluation {
    FileFilter ffdir = pathname -> pathname.isDirectory() && pathname.getName().charAt(0) != '.' && pathname.getName().contains("_Training");
    FileFilter ffclasses = pathname -> pathname.isFile() && pathname.getName().charAt(0) != '.';
    FileFilter fffeatures = pathname -> pathname.isFile() && pathname.getName().charAt(0) != '.' && pathname.getName().contains(".txt");
    FilenameFilter fnf = (dir, name) -> name.charAt(0) != '.';
    public static final int NONE = 0;
    public static final int NORMALIZE = -1;
    public static final int CENTER_REDUCE = -2;
    public int Preprocessing = 0;
    private final Normalize norm = new Normalize();
    private final CenterReduce cr = new CenterReduce();
    private final ArrayFeatures AF = new ArrayFeatures();

    public void EvaluateOneClassClassifier(String featuresdirectory, String testdirectory, Object classifier, ClassifierParameterFunction cpf, List<String> toexclude, String resultdirectory) throws Exception {
        File[] featuressets = new File(featuresdirectory).listFiles(this.ffdir);
        File resdir = new File(resultdirectory);
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        if (!resdir.isDirectory()) {
            throw new IllegalArgumentException("The result file is not a directory.");
        }
        for (File featuresset : featuressets) {
            File[] classesfiles = featuresset.listFiles(this.ffclasses);
            String setname = featuresset.getName();
            System.out.println("Processing: " + setname);
            ArrayList<String> classesnames = new ArrayList<String>(13);
            ArrayList<GenericClassifier> classifiers = new ArrayList<GenericClassifier>(13);
            ArrayList<Integer> indexes = new ArrayList<Integer>(13);
            for (File classesfile : classesfiles) {
                if (!classesfile.getName().contains(setname)) continue;
                String classname = classesfile.getName().substring(setname.length() + 1, classesfile.getName().length() - 4);
                classesnames.add(classname);
                GenericClassifier gc = cpf == null ? new GenericClassifier(classifier, classname) : new GenericClassifier(classifier, cpf, classname);
                FichierTabule file = new FichierTabule(classesfile.getAbsolutePath(), true);
                file.TargetNominal("Class");
                indexes.add(file.getValueString(0, file.ColumnNumber("Class")).equalsIgnoreCase(classname) ? 0 : 1);
                gc.Train(file);
                classifiers.add(gc);
                gc = null;
                classname = null;
                file.Kill();
                file = null;
            }
            FichierTabule test = new FichierTabule(testdirectory + "/" + setname.replace("_Training", "_Test.txt"), true);
            Iterator<String> iterex = toexclude.iterator();
            while (iterex.hasNext()) {
                test.setExcludedColumn(iterex.next(), true);
            }
            test.TargetNominal("Class");
            iterex = null;
            int col = 0;
            int[] cols = new int[classesnames.size() + 2];
            Arrays.fill(cols, 1);
            cols[cols.length - 2] = 2;
            cols[cols.length - 1] = 2;
            FichierTabule results = new FichierTabule(test.Height(), cols, "results");
            String[] colnames = new String[cols.length];
            Iterator iterclasses = classesnames.iterator();
            while (iterclasses.hasNext()) {
                colnames[col++] = (String)iterclasses.next();
            }
            iterclasses = null;
            colnames[colnames.length - 2] = "Prediction";
            colnames[colnames.length - 1] = "Class";
            results.setColumnsNames(colnames);
            col = 0;
            Iterator itergc = classifiers.iterator();
            Iterator iterindexes = indexes.iterator();
            while (itergc.hasNext()) {
                GenericClassifier gc = (GenericClassifier)itergc.next();
                gc.Classify(test);
                int pos = (Integer)iterindexes.next();
                double[][] pred = gc.Probabilities();
                for (int p = 0; p < pred.length; ++p) {
                    results.setValue(p, col, pred[p][pos]);
                }
                pred = null;
                ++col;
            }
            itergc = null;
            iterindexes = null;
            int nbclasses = classesnames.size();
            for (int r = 0; r < test.Height(); ++r) {
                int index = 0;
                double best = results.getValueDouble(r, 0);
                for (int c = 1; c < nbclasses; ++c) {
                    if (!(best < results.getValueDouble(r, c))) continue;
                    best = results.getValueDouble(r, c);
                    index = c;
                }
                results.setValue(r, nbclasses, colnames[index]);
            }
            results.setColumn(results.Width() - 1, test.getColumnString(test.Target()));
            results.Write(resdir.getAbsolutePath() + "/MEresult_" + setname.replace("_Training", ".txt"), false);
            colnames = null;
            cols = null;
            results.Kill();
            results = null;
            test.Kill();
            test = null;
            setname = null;
            classesfiles = null;
            classesnames = null;
            classifiers = null;
            indexes = null;
        }
        featuressets = null;
        resdir = null;
    }

    public void EvaluateOneVsAll(String featuresdirectory, String testdirectory, Object classifier, ClassifierParameterFunction cpf, List<String> toexclude, String resultdirectory) throws Exception {
        FichierTabule tmp;
        File[] featuressets = new File(featuresdirectory).listFiles(this.ffdir);
        File resdir = new File(resultdirectory);
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        if (!resdir.isDirectory()) {
            throw new IllegalArgumentException("The result file is not a directory.");
        }
        for (File featuresset : featuressets) {
            File[] classesfiles = featuresset.listFiles(this.ffclasses);
            if (classesfiles.length != 1) {
                throw new Exception("Many files into this directory: " + featuresset.getAbsolutePath());
            }
            String setname = featuresset.getName();
            System.out.println("Processing: " + setname);
            GenericClassifier gc = null;
            List classesnames = null;
            if (classesfiles[0].getName().contains(setname)) {
                FichierTabule file = new FichierTabule(classesfiles[0].getAbsolutePath(), true);
                file.TargetNominal("Class");
                switch (this.Preprocessing) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        if (ArrayTools.Contains((int[])file.ColumnType(), (int)0)) {
                            tmp = this.norm.Compute(file);
                            file.Kill();
                            file = null;
                            file = tmp;
                            break;
                        }
                        this.norm.ComputeDouble(file);
                        break;
                    }
                    case -2: {
                        if (ArrayTools.Contains((int[])file.ColumnType(), (int)0)) {
                            tmp = CenterReduce.Compute(file);
                            file.Kill();
                            file = null;
                            file = tmp;
                            break;
                        }
                        CenterReduce.ComputeDouble(file);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown preprocessing.");
                    }
                }
                classesnames = ArrayTools.ListOfUniqueItems((String[])file.getColumnString("Class"));
                gc = cpf == null ? new GenericClassifier(classifier, "") : new GenericClassifier(classifier, cpf, classesnames);
                gc.Train(file);
                file.Kill();
                file = null;
            }
            FichierTabule test = new FichierTabule(testdirectory + "/" + setname.replace("_Training", "_Test.txt"), true);
            Iterator<String> iterex = toexclude.iterator();
            while (iterex.hasNext()) {
                test.setExcludedColumn(iterex.next(), true);
            }
            test.TargetNominal("Class");
            iterex = null;
            int[] cols = new int[classesnames.size() + 2];
            Arrays.fill(cols, 1);
            cols[cols.length - 2] = 2;
            cols[cols.length - 1] = 2;
            FichierTabule results = new FichierTabule(test.Height(), cols, "results");
            int col = 0;
            String[] colnames = new String[cols.length];
            Iterator iterclasses = classesnames.iterator();
            while (iterclasses.hasNext()) {
                colnames[col++] = (String)iterclasses.next();
            }
            iterclasses = null;
            colnames[colnames.length - 2] = "Prediction";
            colnames[colnames.length - 1] = "Class";
            results.setColumnsNames(colnames);
            int nbclasses = classesnames.size();
            switch (this.Preprocessing) {
                case 0: {
                    break;
                }
                case -1: {
                    if (ArrayTools.Contains((int[])test.ColumnType(), (int)0)) {
                        tmp = this.norm.Compute(test, this.norm.Minima(), this.norm.Maxima());
                        test.Kill();
                        test = null;
                        test = tmp;
                        break;
                    }
                    this.norm.ComputeDouble(test, this.norm.Minima(), this.norm.Maxima());
                    break;
                }
                case -2: {
                    throw new IllegalStateException("To update");
                }
            }
            gc.Classify(test);
            double[][] pred = gc.Probabilities();
            for (int p = 0; p < pred.length; ++p) {
                for (int c = 0; c < pred[p].length; ++c) {
                    results.setValue(p, c, pred[p][c]);
                }
                results.setValue(p, nbclasses, colnames[this.AF.MaximumIndex(pred[p])]);
            }
            pred = null;
            results.setColumn(results.Width() - 1, test.getColumnString(test.Target()));
            results.Write(resdir.getAbsolutePath() + "/MEresult_" + setname.replace("_Training", ".txt"), false);
            colnames = null;
            cols = null;
            results.Kill();
            results = null;
            test.Kill();
            test = null;
            setname = null;
            classesfiles = null;
            classesnames = null;
            gc = null;
        }
        tmp = null;
        featuressets = null;
        resdir = null;
    }

    public void EvaluateOneVsAll2(String featuresdirectory, String testdirectory, Object classifier, ClassifierParameterFunction cpf, List<String> toexclude, String resultdirectory) throws Exception {
        FichierTabule tmp;
        File[] featuressets = new File(featuresdirectory).listFiles(this.fffeatures);
        File resdir = new File(resultdirectory);
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        if (!resdir.isDirectory()) {
            throw new IllegalArgumentException("The result file is not a directory.");
        }
        for (File featuresset : featuressets) {
            String setname = featuresset.getName();
            System.out.println("Processing: " + setname);
            GenericClassifier gc = null;
            List classesnames = null;
            FichierTabule file = new FichierTabule(featuresset.getAbsolutePath(), true);
            file.TargetNominal("Class");
            switch (this.Preprocessing) {
                case 0: {
                    break;
                }
                case -1: {
                    if (ArrayTools.Contains((int[])file.ColumnType(), (int)0)) {
                        tmp = this.norm.Compute(file);
                        file.Kill();
                        file = null;
                        file = tmp;
                        break;
                    }
                    this.norm.ComputeDouble(file);
                    break;
                }
                case -2: {
                    if (ArrayTools.Contains((int[])file.ColumnType(), (int)0)) {
                        tmp = CenterReduce.Compute(file);
                        file.Kill();
                        file = null;
                        file = tmp;
                        break;
                    }
                    CenterReduce.ComputeDouble(file);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown preprocessing.");
                }
            }
            Iterator<String> iterex = toexclude.iterator();
            while (iterex.hasNext()) {
                file.setExcludedColumn(iterex.next(), true);
            }
            file.TargetNominal("Class");
            classesnames = ArrayTools.ListOfUniqueItems((String[])file.getColumnString("Class"));
            gc = cpf == null ? new GenericClassifier(classifier, "") : new GenericClassifier(classifier, cpf, classesnames);
            gc.Train(file);
            file.Kill();
            file = null;
            FichierTabule test = new FichierTabule(testdirectory + "/" + setname.replace("_Training.txt", "_Test.txt"), true);
            Iterator<String> iterex2 = toexclude.iterator();
            while (iterex2.hasNext()) {
                test.setExcludedColumn(iterex2.next(), true);
            }
            test.TargetNominal("Class");
            iterex2 = null;
            int[] cols = new int[classesnames.size() + 2];
            Arrays.fill(cols, 1);
            cols[cols.length - 2] = 2;
            cols[cols.length - 1] = 2;
            FichierTabule results = new FichierTabule(test.Height(), cols, "results");
            int col = 0;
            String[] colnames = new String[cols.length];
            Iterator iterclasses = classesnames.iterator();
            while (iterclasses.hasNext()) {
                colnames[col++] = (String)iterclasses.next();
            }
            iterclasses = null;
            colnames[colnames.length - 2] = "Prediction";
            colnames[colnames.length - 1] = "Class";
            results.setColumnsNames(colnames);
            int nbclasses = classesnames.size();
            switch (this.Preprocessing) {
                case 0: {
                    break;
                }
                case -1: {
                    if (ArrayTools.Contains((int[])test.ColumnType(), (int)0)) {
                        tmp = this.norm.Compute(test, this.norm.Minima(), this.norm.Maxima());
                        test.Kill();
                        test = null;
                        test = tmp;
                        break;
                    }
                    this.norm.ComputeDouble(test, this.norm.Minima(), this.norm.Maxima());
                    break;
                }
                case -2: {
                    throw new IllegalStateException("To update");
                }
            }
            gc.Classify(test);
            double[][] pred = gc.Probabilities();
            for (int p = 0; p < pred.length; ++p) {
                for (int c = 0; c < pred[p].length; ++c) {
                    results.setValue(p, c, pred[p][c]);
                }
                results.setValue(p, nbclasses, colnames[this.AF.MaximumIndex(pred[p])]);
            }
            pred = null;
            results.setColumn(results.Width() - 1, test.getColumnString(test.Target()));
            results.Write(resdir.getAbsolutePath() + "/MEresult_" + setname.replace("_Training", ".txt"), false);
            colnames = null;
            cols = null;
            results.Kill();
            results = null;
            test.Kill();
            test = null;
            setname = null;
            classesnames = null;
            gc = null;
        }
        tmp = null;
        featuressets = null;
        resdir = null;
    }

    public void Evaluate_LeaveOneOut_OneVsAll(String featuresdirectory, Object classifier, ClassifierParameterFunction cpf, List<String> toexclude, DataSetBalancer dsb, String resultdirectory) throws Exception {
        FichierTabule tmp;
        File[] features = new File(featuresdirectory).listFiles(this.fffeatures);
        File resdir = new File(resultdirectory);
        if (!resdir.exists()) {
            resdir.mkdirs();
        }
        if (!resdir.isDirectory()) {
            throw new IllegalArgumentException("The result file is not a directory.");
        }
        boolean work = false;
        for (File feature : features) {
            String setname = feature.getName();
            GenericClassifier gc = null;
            FichierTabule file = new FichierTabule(feature.getAbsolutePath(), true);
            file.TargetNominal("Class");
            switch (this.Preprocessing) {
                case 0: {
                    break;
                }
                case -1: {
                    if (ArrayTools.Contains((int[])file.ColumnType(), (int)0)) {
                        tmp = this.norm.Compute(file);
                        file.Kill();
                        file = null;
                        file = tmp;
                        break;
                    }
                    this.norm.ComputeDouble(file);
                    break;
                }
                case -2: {
                    if (ArrayTools.Contains((int[])file.ColumnType(), (int)0)) {
                        tmp = CenterReduce.Compute(file);
                        file.Kill();
                        file = null;
                        file = tmp;
                        break;
                    }
                    CenterReduce.ComputeDouble(file);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown preprocessing.");
                }
            }
            List classes = ArrayTools.ListOfUniqueItems((String[])file.getColumnString("Class"));
            List<String> images = this.FindImages(file.getColumnString("Images"));
            int[] cols = new int[classes.size() + 2];
            Arrays.fill(cols, 1);
            cols[cols.length - 2] = 2;
            cols[cols.length - 1] = 2;
            FichierTabule results = new FichierTabule(file.Height(), cols, "results");
            int col = 0;
            String[] colnames = new String[cols.length];
            Iterator iterclasses = classes.iterator();
            while (iterclasses.hasNext()) {
                colnames[col++] = (String)iterclasses.next();
            }
            iterclasses = null;
            colnames[colnames.length - 2] = "Prediction";
            colnames[colnames.length - 1] = "Class";
            results.setColumnsNames(colnames);
            results.setColumn("Class", file.getColumnString("Class"));
            Iterator<String> iterex = toexclude.iterator();
            while (iterex.hasNext()) {
                file.setExcludedColumn(iterex.next(), true);
            }
            iterex = null;
            gc = cpf == null ? new GenericClassifier(classifier, "") : new GenericClassifier(classifier, cpf, classes);
            for (String imname : images) {
                file.SelectWhere("Images", 6, imname);
                int pos = file.FirstSelected();
                if (pos < 0) {
                    throw new Error("pos < 0");
                }
                FichierTabule test = FichierTabuleTools.SaveSelectedRows(file);
                test.TargetNominal("Class");
                test.setExcludedColumn("Images", true);
                file.ExcludeSelectedRows();
                FichierTabule train = dsb.Balance(file, classes, true);
                train.TargetNominal("Class");
                train.setExcludedColumn("Images", true);
                gc.Train(train);
                gc.Classify(test);
                double[][] pred = gc.Probabilities();
                int p = 0;
                while (p < pred.length) {
                    for (int c = 0; c < pred[p].length; ++c) {
                        results.setValue(pos, c, pred[p][c]);
                    }
                    results.setValue(pos, pred[p].length, colnames[this.AF.MaximumIndex(pred[p])]);
                    ++p;
                    ++pos;
                }
                pred = null;
                train = null;
                test = null;
            }
            results.Write(resultdirectory + "/MEresult_" + setname, false);
            colnames = null;
            results.Kill();
            file.Kill();
            results = null;
            file = null;
        }
        tmp = null;
        features = null;
        resdir = null;
    }

    private List<String> FindImages(String[] names) {
        String[] ims = new String[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            ims[i2] = names[i2].substring(0, names[i2].indexOf(95) + 1);
        }
        List result = ArrayTools.ListOfUniqueItems((String[])ims);
        ims = null;
        return result;
    }

    public void Results(String directory, FilenameFilter fnf, String resultfile) throws Exception {
        double[][] globalmatrix = null;
        double[][] maxmatrix = null;
        int[][] currentmatrix = null;
        List classes = null;
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(resultfile));
        File[] files = new File(directory).listFiles(fnf);
        for (int f = 0; f < files.length; ++f) {
            FichierTabule file = new FichierTabule(files[f].getAbsolutePath(), true);
            int colclass = file.Width() - 1;
            int n = file.Width() - 2;
            if (f == 0) {
                classes = ArrayTools.ListOfUniqueItems((String[])file.getColumnString(colclass));
                globalmatrix = new double[classes.size()][classes.size()];
                maxmatrix = new double[classes.size()][classes.size()];
                currentmatrix = new int[classes.size()][classes.size()];
                Iterator iter = classes.iterator();
                while (iter.hasNext()) {
                    dos.write(("\"" + (String)iter.next() + "\" ").getBytes("ISO-8859-1"));
                }
                dos.write("\n".getBytes("ISO-8859-1"));
                iter = null;
            } else {
                ArrayOperations.Fill(currentmatrix, (int)0);
            }
            for (int y = 0; y < file.Height(); ++y) {
                void v0 = currentmatrix[ListTools.PositionInList((List)classes, (String)file.getValueString(y, colclass))];
                int n2 = ListTools.PositionInList((List)classes, (String)file.getValueString(y, n));
                v0[n2] = v0[n2] + true;
            }
            dos.write((files[f].getAbsolutePath() + "\n").getBytes("ISO-8859-1"));
            for (int i2 = 0; i2 < currentmatrix.length; ++i2) {
                int sum = (int)this.AF.Integral(currentmatrix[i2]);
                for (int j = 0; j < classes.size(); ++j) {
                    double val = (double)currentmatrix[i2][j] / (double)sum;
                    dos.write((val + " ").getBytes("ISO-8859-1"));
                    double[] dArray = globalmatrix[i2];
                    int n3 = j;
                    dArray[n3] = dArray[n3] + val;
                    if (!(maxmatrix[i2][j] < val)) continue;
                    maxmatrix[i2][j] = val;
                }
                dos.write("\n".getBytes("ISO-8859-1"));
            }
            dos.write("\n".getBytes("ISO-8859-1"));
        }
        ArrayArithmetic.Divide(globalmatrix, (double)files.length, globalmatrix);
        dos.write("\n\nGlobal\n".getBytes("ISO-8859-1"));
        for (int i3 = 0; i3 < currentmatrix.length; ++i3) {
            for (int j = 0; j < classes.size(); ++j) {
                dos.write(((double)globalmatrix[i3][j] + " ").getBytes("ISO-8859-1"));
            }
            dos.write("\n".getBytes("ISO-8859-1"));
        }
        dos.write("\n\nBest\n".getBytes("ISO-8859-1"));
        for (void var13_17 : maxmatrix) {
            for (int j = 0; j < classes.size(); ++j) {
                dos.write(((double)var13_17[j] + " ").getBytes("ISO-8859-1"));
            }
            dos.write("\n".getBytes("ISO-8859-1"));
        }
        dos.flush();
        dos = null;
        currentmatrix = null;
        classes.clear();
        classes = null;
        files = null;
    }

    public void ResultsImageLevel(String directory, FilenameFilter fnf, List<Integer> impos, String resultfile) throws Exception {
        double[][] globalmatrix = null;
        double[][] maxmatrix = null;
        int[][] currentmatrix = null;
        int[] votes = null;
        List classes = null;
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(resultfile));
        File[] files = new File(directory).listFiles(fnf);
        for (int f = 0; f < files.length; ++f) {
            int y;
            FichierTabule file = new FichierTabule(files[f].getAbsolutePath(), true);
            int colclass = file.Width() - 1;
            int n = file.Width() - 2;
            if (f == 0) {
                classes = ArrayTools.ListOfUniqueItems((String[])file.getColumnString(colclass));
                globalmatrix = new double[classes.size()][classes.size()];
                maxmatrix = new double[classes.size()][classes.size()];
                currentmatrix = new int[classes.size()][classes.size()];
                votes = new int[classes.size()];
                Iterator iter = classes.iterator();
                while (iter.hasNext()) {
                    dos.write(("\"" + (String)iter.next() + "\" ").getBytes("ISO-8859-1"));
                }
                dos.write("\n".getBytes("ISO-8859-1"));
                iter = null;
            } else {
                ArrayOperations.Fill(currentmatrix, (int)0);
            }
            Iterator<Integer> iterpos = impos.iterator();
            int posstart = iterpos.next();
            while (iterpos.hasNext()) {
                int posend = iterpos.next();
                Arrays.fill(votes, 0);
                for (y = posstart; y < posend; ++y) {
                    int n2 = ListTools.PositionInList((List)classes, (String)file.getValueString(y, n));
                    votes[n2] = votes[n2] + 1;
                }
                int[] nArray = currentmatrix[this.AF.MaximumIndex(votes)];
                int n3 = ListTools.PositionInList((List)classes, (String)file.getValueString(posstart, colclass));
                nArray[n3] = nArray[n3] + 1;
                posstart = posend;
            }
            iterpos = null;
            dos.write((files[f].getAbsolutePath() + "\n").getBytes("ISO-8859-1"));
            int[][] posend = currentmatrix;
            y = posend.length;
            for (int j = 0; j < y; ++j) {
                int[] currentmatrix1 = posend[j];
                for (int j2 = 0; j2 < classes.size(); ++j2) {
                    dos.write((currentmatrix1[j2] + " ").getBytes("ISO-8859-1"));
                }
                dos.write("\n".getBytes("ISO-8859-1"));
            }
            dos.write("-----\n".getBytes("ISO-8859-1"));
            for (int i2 = 0; i2 < currentmatrix.length; ++i2) {
                int sum = (int)this.AF.Integral(currentmatrix[i2]);
                for (int j = 0; j < classes.size(); ++j) {
                    double val = (double)currentmatrix[i2][j] / (double)sum;
                    dos.write((val + " ").getBytes("ISO-8859-1"));
                    double[] dArray = globalmatrix[i2];
                    int n4 = j;
                    dArray[n4] = dArray[n4] + val;
                    if (!(maxmatrix[i2][j] < val)) continue;
                    maxmatrix[i2][j] = val;
                }
                dos.write("\n".getBytes("ISO-8859-1"));
            }
            dos.write("\n".getBytes("ISO-8859-1"));
        }
        ArrayArithmetic.Divide(globalmatrix, (double)files.length, globalmatrix);
        dos.write("\n\nGlobal\n".getBytes("ISO-8859-1"));
        for (int i3 = 0; i3 < currentmatrix.length; ++i3) {
            for (int j = 0; j < classes.size(); ++j) {
                dos.write(((double)globalmatrix[i3][j] + " ").getBytes("ISO-8859-1"));
            }
            dos.write("\n".getBytes("ISO-8859-1"));
        }
        dos.write("\n\nBest\n".getBytes("ISO-8859-1"));
        for (void var15_19 : maxmatrix) {
            for (int j = 0; j < classes.size(); ++j) {
                dos.write(((double)var15_19[j] + " ").getBytes("ISO-8859-1"));
            }
            dos.write("\n".getBytes("ISO-8859-1"));
        }
        dos.flush();
        dos = null;
        currentmatrix = null;
        classes.clear();
        classes = null;
        votes = null;
        files = null;
    }

    public List<Integer> ImagesPositions(FichierTabule file, int column) {
        int pos = 0;
        LinkedList<Integer> list = new LinkedList<Integer>();
        String s = file.getValueString(pos++, column);
        list.add(0);
        while (pos < file.Height()) {
            if (file.getValueString(pos, column).equalsIgnoreCase(s)) {
                ++pos;
                continue;
            }
            list.add(pos);
            s = file.getValueString(pos++, column);
        }
        list.add(file.Height());
        return list;
    }
}

