/*
 * Decompiled with CFR 0.152.
 */
package dataMining;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffSaver;

public class InstancesTools {
    public static void Display(Instances instances) {
        int i2;
        System.out.println("relationName = " + instances.relationName());
        System.out.println("numInstances = " + instances.numInstances());
        System.out.println("numAttributes = " + instances.numAttributes());
        System.out.print("Columns names: ");
        for (i2 = 0; i2 < instances.numAttributes(); ++i2) {
            System.out.print(instances.attribute(i2).name() + " ");
        }
        System.out.println("{Weight}");
        for (i2 = 0; i2 < instances.numInstances(); ++i2) {
            InstancesTools.Display(instances.instance(i2));
        }
    }

    public static void Display(Instance instance) {
        for (int j = 0; j < instance.numAttributes(); ++j) {
            if (instance.attribute(j).isNominal()) {
                if (instance.isMissing(j)) {
                    System.out.print("? ");
                    continue;
                }
                System.out.print(instance.stringValue(j) + " ");
                continue;
            }
            if (instance.attribute(j).isNumeric()) {
                if (instance.isMissing(j)) {
                    System.out.print("? ");
                    continue;
                }
                System.out.print(instance.value(j) + " ");
                continue;
            }
            if (instance.attribute(j).isString()) {
                if (instance.isMissing(j)) {
                    System.out.print("? ");
                    continue;
                }
                System.out.print(instance.toString(j) + " ");
                continue;
            }
            System.out.println("soucis ");
        }
        System.out.println("{" + instance.weight() + "}");
    }

    public static void DisplayLikeARFF(Instances instances) {
        System.out.println(instances);
    }

    public static void WriteInARFF(Instances instances, String Name2) {
        try {
            PrintStream old = System.out;
            FileOutputStream fos = new FileOutputStream(Name2, false);
            System.setOut(new PrintStream(fos, true));
            System.out.println(instances);
            fos.close();
            System.setOut(old);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Instances CreateEmpty(Instances instances, String Name2) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(instances.numAttributes());
        for (int i2 = 0; i2 < instances.numAttributes(); ++i2) {
            attributes.add(instances.attribute(i2));
        }
        Instances inst = new Instances(Name2, attributes, 0);
        if (0 <= instances.classIndex()) {
            inst.setClassIndex(instances.classIndex());
        }
        return inst;
    }

    public static Instances Read(String path) throws FileNotFoundException, IOException {
        System.out.print("Loading '" + path + "'... ");
        Instances instances = new Instances((Reader)new InputStreamReader(new FileInputStream(path)));
        System.out.println("(" + instances.numInstances() + " instances, " + instances.numAttributes() + " attributes) successfully.");
        return instances;
    }

    public static void WriteArffFile(Instances inst) {
        ArffSaver saver = new ArffSaver();
        saver.setInstances(inst);
        try {
            System.out.print("Writing file: " + inst.relationName() + " ...");
            saver.setFile(new File(inst.relationName() + ".arff"));
            saver.writeBatch();
            System.out.println(" succesfully.");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("IOException while writing Arff file.");
        }
    }
}

