/*
 * Decompiled with CFR 0.152.
 */
package dataMining;

import dataMining.WorkingSetBuilder;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import dataMining.imbalanceDataSet.DataSetBalancer;
import dataMining.variables.selections.SystematicResearch;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.File;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import listTiTi.ListConverter;
import weka.classifiers.Classifier;

public class AutomaticModel {
    private SystematicResearch sr = new SystematicResearch();
    private String prefix = "DataSet_";

    public void Classify(FichierTabule file, String Target, List<String> Classes, List<String> ToReject, Classifier classifier, ClassifierParameterFunction paramfunc, int Validation, int Nb, DataSetBalancer dsb, boolean OneClassClassifier, File out, int nbCPU) throws Exception {
        String TargetClean = this.Clean(Target);
        int target = file.ColumnNumber(TargetClean);
        Iterator<String> iter = null;
        File folderOut = new File(out.getAbsolutePath() + "/Classification results " + TargetClean + " " + this.ClassesName(Classes) + "/");
        folderOut.mkdirs();
        Calendar cal = Calendar.getInstance();
        System.out.println(cal.get(5) + "/" + (cal.get(2) + 1) + " at " + cal.get(11) + ":" + cal.get(12) + ":" + cal.get(13) + "\t");
        file.ClearExclusion();
        file.ClearSelection();
        iter = ToReject.iterator();
        while (iter.hasNext()) {
            file.ExtendSelectionWhere(Target, 0, iter.next());
        }
        file.ExcludeSelected();
        FichierTabule workingfile = FichierTabuleTools.DeleteExcluded(file);
        workingfile.Write(folderOut.getAbsolutePath() + "/Data.txt", false);
        workingfile.TargetNominal(target);
        if (OneClassClassifier) {
            WorkingSetBuilder.CreateOneClassClassifier(workingfile, dsb, folderOut.getAbsolutePath() + "/", this.prefix, ListConverter.ListToArray(Classes));
        } else {
            WorkingSetBuilder.CreateOneVersusAll(workingfile, dsb, folderOut.getAbsolutePath() + "/", this.prefix, ListConverter.ListToArray(Classes));
        }
        workingfile = null;
        File[] files = folderOut.listFiles();
        for (int f = 0; f < files.length; ++f) {
            if (!files[f].isFile() || !files[f].getName().substring(0, 8).equalsIgnoreCase(this.prefix) || files[f].getName().contains("_SR")) continue;
            workingfile = new FichierTabule(files[f].getAbsolutePath(), true);
            workingfile.setNominalAndTarget(workingfile.Width() - 1);
            this.sr.Start(classifier, paramfunc, workingfile, folderOut.getAbsolutePath() + "/" + workingfile.Name() + "_SR.txt", Validation, Nb, nbCPU);
            workingfile = null;
        }
        cal = null;
        iter = null;
        TargetClean = null;
        workingfile = null;
    }

    private String Clean(String s) {
        return s.replace(":", "").replace(" ", "");
    }

    private String ClassesName(List<String> classes) {
        Iterator<String> iter = classes.iterator();
        StringBuilder sb = new StringBuilder(classes.size());
        while (iter.hasNext()) {
            sb.append(iter.next());
        }
        iter = null;
        return sb.toString();
    }
}

