/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.textureIndexes;

import characterization.textures.textureIndexes.ResultatsIndiceDeTextures;
import characterization.textures.textureIndexes.TextureIndex;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import measures.Measures2D;

public class AllongementAxePrincipal
implements TextureIndex {
    private int Alpha = -1;
    private double[] AlphaValues = null;
    private List<Double> Values = new Vector<Double>(5);
    private List<Integer> Tailles = new Vector<Integer>(5);
    private ResultatsIndiceDeTextures LastResults = null;

    public AllongementAxePrincipal() {
        this.AlphaValues = new double[256];
        this.NewTexture();
    }

    @Override
    public void ComputeForThisConnectedComponent(Measures2D mesures) {
        this.Tailles.add(mesures.getSurface());
        if (mesures.MainAxis01.Length() > mesures.SecondAxis02.Length()) {
            this.Values.add(mesures.SecondAxis02.Length() / mesures.MainAxis01.Length());
        } else {
            this.Values.add(mesures.MainAxis01.Length() / mesures.SecondAxis02.Length());
        }
    }

    @Override
    public void ComputeForThisAlpha() {
        if (this.Tailles.size() != this.Values.size()) {
            throw new Error("Bug => Tailles.size() != Values.size()");
        }
        int Sum2 = 0;
        double Result = 0.0;
        Iterator<Integer> iterTailles = this.Tailles.iterator();
        Iterator<Double> iterValues = this.Values.iterator();
        while (iterTailles.hasNext()) {
            int Taille = iterTailles.next();
            double Value = iterValues.next();
            Sum2 += Taille;
            Result += (double)Taille * Value;
        }
        this.AlphaValues[this.Alpha] = Sum2 > 0 ? Result / (double)Sum2 : 0.0;
        this.ResetForCurrentAlpha();
        ++this.Alpha;
    }

    @Override
    public ResultatsIndiceDeTextures ComputeFinalValues() {
        this.LastResults = new ResultatsIndiceDeTextures(this.AlphaValues);
        return this.LastResults;
    }

    @Override
    public ResultatsIndiceDeTextures getLastResults() {
        return this.LastResults;
    }

    @Override
    public int getCurrentAlpha() {
        return this.Alpha;
    }

    @Override
    public void setCurrentAlpha(int Alpha) {
        if (Alpha < 0 || Alpha > 255) {
            throw new Error("Valeur de Alpha incorrecte : " + Alpha + " attendu [0..255]");
        }
        this.Alpha = Alpha;
    }

    @Override
    public double[] getAlphaResults() {
        return this.AlphaValues;
    }

    @Override
    public double getAlphaIthResult(int Alpha) {
        if (Alpha < 0 || Alpha > 255) {
            throw new Error("Valeur de Alpha incorrecte : " + Alpha + " attendu [0..255]");
        }
        return this.AlphaValues[Alpha];
    }

    @Override
    public void NewTexture() {
        this.LastResults = null;
        this.ResetForCurrentAlpha();
        this.Alpha = 1;
        for (int i2 = 0; i2 < 256; ++i2) {
            this.AlphaValues[i2] = 0.0;
        }
    }

    @Override
    public void ResetForCurrentAlpha() {
        this.Tailles.clear();
        this.Values.clear();
    }
}

