/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.szm;

import arrayTiTi.ArrayFeatures;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import java.util.List;
import mathematics.Maths;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import processing.reducer.ColorReducer;

public class SizeZoneMatrix {
    protected int nbGrayLevel = -1;
    protected int nbSizes = -1;
    protected int Width = -1;
    protected double[][] matrix = null;
    protected BufferedImage Reduced = null;
    protected DV Reduced3D = null;
    protected ConnectedComponentLabeling ccl = new UnionFindCcl();
    protected ColorReducer reducer = null;
    protected int ForbiddenValue = -1;
    protected boolean EightConnex = true;
    protected ArrayFeatures AF = new ArrayFeatures();

    public synchronized void Kill() {
        this.matrix = null;
        this.Reduced = null;
        if (this.Reduced3D != null) {
            this.Reduced3D.Kill();
        }
        this.Reduced3D = null;
        this.ccl.Kill();
        this.ccl = null;
        this.reducer = null;
        this.AF = null;
    }

    public void FillMatrix(BufferedImage image, BufferedImage mask, int nbGrayLevel, int nbSizes, ColorReducer reducer, int ForbiddenValue, boolean EightConnex) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        if (nbGrayLevel < 2 || !Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("Incorrect gray level number: " + nbGrayLevel + ", wished [2...2^N[");
        }
        this.nbGrayLevel = nbGrayLevel;
        this.nbSizes = nbSizes;
        this.reducer = reducer;
        this.ForbiddenValue = ForbiddenValue;
        this.EightConnex = EightConnex;
        if (Maths.isDyadic((int)nbGrayLevel) < 0) {
            throw new IllegalArgumentException("The gray level number must be dyadic (a power of 2): " + nbGrayLevel);
        }
        this.Reduced = reducer.Reduce(image, nbGrayLevel, ForbiddenValue);
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)this.Reduced, (int)0, (BufferedImage)this.Reduced);
        }
        this.ccl.Label(this.Reduced, 0, EightConnex);
        this.FillMatrix(this.Reduced, this.ccl);
    }

    public void FillMatrix(BufferedImage ImageReduced, ConnectedComponentLabeling Ccl) {
        if (!ImageTools.isGrayLevel((BufferedImage)ImageReduced)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.Reduced = ImageReduced;
        int[] Sizes = this.ccl.Sizes();
        int width = this.AF.Maximum(Sizes, 1, Sizes.length);
        this.Width = width / this.nbSizes + 1;
        this.matrix = null;
        this.matrix = new double[this.nbGrayLevel][this.Width];
        switch (this.Reduced.getType()) {
            case 10: {
                byte[] bytecolors = (byte[])this.ccl.Colors();
                for (int i2 = 1; i2 < Sizes.length; ++i2) {
                    double[] dArray = this.matrix[(bytecolors[i2] & 0xFF) - 1];
                    int n = Sizes[i2] / this.nbSizes;
                    dArray[n] = dArray[n] + 1.0;
                }
                bytecolors = null;
                break;
            }
            case 11: {
                short[] shortcolors = (short[])this.ccl.Colors();
                for (int i3 = 1; i3 < Sizes.length; ++i3) {
                    double[] dArray = this.matrix[(shortcolors[i3] & 0xFFFF) - 1];
                    int n = Sizes[i3] / this.nbSizes;
                    dArray[n] = dArray[n] + 1.0;
                }
                shortcolors = null;
                break;
            }
            default: {
                int[] colors = (int[])this.ccl.Colors();
                for (int i4 = 1; i4 < Sizes.length; ++i4) {
                    double[] dArray = this.matrix[colors[i4] - 1];
                    int n = Sizes[i4] / this.nbSizes;
                    dArray[n] = dArray[n] + 1.0;
                }
                colors = null;
            }
        }
        Sizes = null;
    }

    public void FillMatrix(int[] sizes, int[] colors, boolean[] used) {
        int i2;
        int Largeur = 0;
        for (i2 = 1; i2 < sizes.length; ++i2) {
            if (!used[i2] || Largeur >= sizes[i2]) continue;
            Largeur = sizes[i2];
        }
        this.Width = Largeur / this.nbSizes + 1;
        this.matrix = null;
        this.matrix = new double[this.nbGrayLevel][this.Width];
        for (i2 = 1; i2 < sizes.length; ++i2) {
            if (!used[i2]) continue;
            double[] dArray = this.matrix[colors[i2] - 1];
            int n = sizes[i2] / this.nbSizes;
            dArray[n] = dArray[n] + 1.0;
        }
    }

    public void FillMatrix(List<BufferedImage> list) {
        int nb = 0;
        BufferedImage shape = null;
        int[] Sizes = new int[list.size()];
        Iterator<BufferedImage> iter = list.iterator();
        WritableRaster wr = null;
        int Largeur = 0;
        while (iter.hasNext()) {
            shape = iter.next();
            wr = shape.getRaster();
            if (!ImageTools.isGrayLevel((BufferedImage)shape)) {
                throw new IllegalArgumentException("Only gray level image required.");
            }
            int width = shape.getWidth();
            int height = shape.getHeight();
            Sizes[nb] = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (wr.getSample(x, y, 0) <= 0) continue;
                    int n = nb;
                    Sizes[n] = Sizes[n] + 1;
                }
            }
            if (Largeur < Sizes[nb]) {
                Largeur = Sizes[nb];
            }
            wr = null;
            shape = null;
            ++nb;
        }
        this.Width = Largeur / this.nbSizes + 1;
        this.matrix = null;
        this.matrix = new double[this.nbGrayLevel][this.Width];
        for (int i2 = 0; i2 < nb; ++i2) {
            double[] dArray = this.matrix[this.FindColor(list.get(i2)) - 1];
            int n = Sizes[i2] / this.nbSizes;
            dArray[n] = dArray[n] + 1.0;
        }
    }

    public void FillMatrix(DV dv, int nbGrayLevel, int BinSizes, ColorReducer reducer, int ForbiddenValue, boolean EightConnex) {
        if (nbGrayLevel < 2 || !Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("Incorrect gray level number: " + nbGrayLevel + ", wished [2...2^N[");
        }
        this.nbGrayLevel = nbGrayLevel;
        this.nbSizes = BinSizes;
        this.reducer = reducer;
        this.ForbiddenValue = ForbiddenValue;
        this.EightConnex = EightConnex;
        if (this.Reduced3D == null || !DvTools.areDimensionsAndTypeEqual((DV)dv, (DV)this.Reduced3D)) {
            this.Reduced3D = null;
            this.Reduced3D = DvNew.Same((DV)dv);
        }
        reducer.Reduce(dv, this.Reduced3D, nbGrayLevel, ForbiddenValue);
        switch (dv.Type) {
            case 8: {
                this.ccl.Label(this.Reduced3D.getDataBufferByte(0), this.Reduced3D.SizeX, this.Reduced3D.SizeY, this.Reduced3D.SizeZ, (byte)0, EightConnex);
                break;
            }
            case 16: {
                this.ccl.Label(this.Reduced3D.getDataBufferShort(0), this.Reduced3D.SizeX, this.Reduced3D.SizeY, this.Reduced3D.SizeZ, (short)0, EightConnex);
            }
        }
        this.FillMatrix(this.Reduced3D, this.ccl);
    }

    public void FillMatrix(DV DvReduced, ConnectedComponentLabeling Ccl) {
        this.Reduced3D = DvReduced;
        int[] Sizes = this.ccl.Sizes();
        int width = this.AF.Maximum(Sizes, 1, Sizes.length);
        this.Width = width / this.nbSizes + 1;
        this.matrix = null;
        this.matrix = new double[this.nbGrayLevel][this.Width];
        switch (this.Reduced3D.Type) {
            case 8: {
                byte[] bytecolors = (byte[])this.ccl.Colors();
                for (int i2 = 1; i2 < Sizes.length; ++i2) {
                    double[] dArray = this.matrix[(bytecolors[i2] & 0xFF) - 1];
                    int n = Sizes[i2] / this.nbSizes;
                    dArray[n] = dArray[n] + 1.0;
                }
                bytecolors = null;
                break;
            }
            case 16: {
                short[] shortcolors = (short[])this.ccl.Colors();
                for (int i3 = 1; i3 < Sizes.length; ++i3) {
                    double[] dArray = this.matrix[(shortcolors[i3] & 0xFFFF) - 1];
                    int n = Sizes[i3] / this.nbSizes;
                    dArray[n] = dArray[n] + 1.0;
                }
                shortcolors = null;
                break;
            }
            default: {
                int[] colors = (int[])this.ccl.Colors();
                for (int i4 = 1; i4 < Sizes.length; ++i4) {
                    double[] dArray = this.matrix[colors[i4] - 1];
                    int n = Sizes[i4] / this.nbSizes;
                    dArray[n] = dArray[n] + 1.0;
                }
                colors = null;
            }
        }
    }

    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.FillMatrix(image, mask, this.nbGrayLevel, this.nbSizes, this.reducer, ForbiddenValue, this.EightConnex);
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 5) {
            throw new IllegalArgumentException("5 parameters required.");
        }
        this.nbGrayLevel = (Integer)parameters[0];
        this.nbSizes = (Integer)parameters[1];
        this.reducer = (ColorReducer)parameters[2];
        this.ForbiddenValue = (Integer)parameters[3];
        this.EightConnex = (Boolean)parameters[4];
    }

    private int FindColor(BufferedImage image) {
        WritableRaster wr = image.getRaster();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                return wr.getSample(x, y, 0);
            }
        }
        throw new Error("Color not found. This error must not occured.");
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.nbGrayLevel * this.nbSizes * 3);
        for (int j = 0; j < this.nbGrayLevel; ++j) {
            for (int i2 = 0; i2 < this.nbSizes; ++i2) {
                sb.append(this.matrix[j][i2]).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

