/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.szm;

import characterization.PreComputable;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.SizeZoneMatrix;
import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import measures.cclh.ConnectedComponentLabeling;
import processing.reducer.ColorReducer;

public class SZMfeatures
extends SizeZoneMatrix
implements PreComputable {
    private double[] Features = new double[16];
    private double Sum = 0.0;
    private String[] FeaturesNames = new String[]{"SZM_SZE", "SZM_LZE", "SZM_LGZE", "SZM_HGZE", "SZM_SZLGE", "SZM_SZHGE", "SZM_LZLGE", "SZM_LZHGE", "SZM_GLNU", "SZM_SZNU", "SZM_ZPC", "SZM_BARYGL", "SZM_BARYS", "SZM_VARGL", "SZM_VARS", "SZM_ORIE"};
    private int[] sizes;
    private int[] colors;
    private boolean[] used;

    @Override
    public synchronized void Kill() {
        super.Kill();
        this.Features = null;
        this.FeaturesNames = null;
        this.colors = null;
        this.sizes = null;
        this.used = null;
    }

    public void Compute(BufferedImage image, BufferedImage mask, int nbGrayLevel, int nbSizes, ColorReducer reducer, int ForbiddenValue, boolean EightConnex) {
        this.FillMatrix(image, mask, nbGrayLevel, nbSizes, reducer, ForbiddenValue, EightConnex);
        this.ComputeFeatures();
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Compute(image, mask, this.nbGrayLevel, this.nbSizes, this.reducer, ForbiddenValue, this.EightConnex);
        this.ComputeFeatures();
    }

    public void Compute(BufferedImage ImageReduced, ConnectedComponentLabeling Ccl) {
        if (!ImageTools.isGrayLevel((BufferedImage)ImageReduced)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.FillMatrix(ImageReduced, Ccl);
        this.ComputeFeatures();
    }

    public void Compute(DV dv, int nbGrayLevel, int BinSizes, ColorReducer reducer, int ForbiddenValue, boolean TwentySixConnex) {
        this.FillMatrix(dv, nbGrayLevel, BinSizes, reducer, ForbiddenValue, TwentySixConnex);
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        this.Compute(dv, this.nbGrayLevel, this.nbSizes, this.reducer, this.ForbiddenValue, this.EightConnex);
        this.ComputeFeatures();
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    @Override
    public void PreCompute(BufferedImage image, int nbCPU) {
        if (nbCPU < 0) {
            throw new Error("Parameters must be set before the call to this method.");
        }
        int height = image.getHeight();
        int width = image.getWidth();
        BufferedImage reduced = this.reducer.Reduce(image, this.nbGrayLevel, this.ForbiddenValue);
        this.ccl.Label(reduced, this.ForbiddenValue, this.EightConnex);
        int counter = this.ccl.ConnectedComponentsNumber();
        int[] labels = this.ccl.Labels1D();
        WritableRaster wrred = reduced.getRaster();
        if (this.sizes == null || this.sizes.length != counter + 1) {
            this.colors = null;
            this.colors = new int[counter + 1];
            this.sizes = null;
            this.sizes = new int[counter + 1];
            this.used = null;
            this.used = new boolean[counter + 1];
        }
        Arrays.fill(this.colors, 0);
        Arrays.fill(this.sizes, 0);
        Arrays.fill(this.used, false);
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (0 < wrred.getSample(x, y, 0)) {
                    int n = labels[pos];
                    this.sizes[n] = this.sizes[n] + 1;
                    this.colors[labels[pos]] = wrred.getSample(x, y, 0);
                }
                ++x;
                ++pos;
            }
        }
        wrred = null;
        labels = null;
    }

    @Override
    public void FastCompute(int startx, int starty, int endx, int endy) {
        if (this.sizes == null) {
            throw new Error("Method PreCompute must be called before this one.");
        }
        int width = this.ccl.Width();
        int[] labels = this.ccl.Labels1D();
        Arrays.fill(this.used, false);
        for (int y = starty; y <= endy; ++y) {
            int x;
            int pos = y * width + x;
            for (x = startx; x <= endx; ++x) {
                this.used[labels[pos]] = true;
            }
        }
        this.used[0] = false;
        this.FillMatrix(this.sizes, this.colors, this.used);
        this.ComputeFeatures();
    }

    private void ComputeFeatures() {
        this.Sum = this.AF.Sum(this.matrix);
        this.Features[0] = this.SZE();
        this.Features[1] = this.LZE();
        this.Features[2] = this.LGZE();
        this.Features[3] = this.HGZE();
        this.Features[4] = this.SZLGE();
        this.Features[5] = this.SZHGE();
        this.Features[6] = this.LZLGE();
        this.Features[7] = this.LZHGE();
        this.Features[8] = this.GLNU();
        this.Features[9] = this.SZNU();
        this.Features[10] = this.ZPC();
        this.Features[11] = this.BARYGL();
        this.Features[12] = this.BARYS();
        this.Features[13] = this.VARGL(this.Features[11]);
        this.Features[14] = this.VARS(this.Features[12]);
        this.Features[15] = this.ORIE(this.Features[11], this.Features[12]);
    }

    public void ComputeFromStack(BufferedImage[] images, BufferedImage[] masks, int nbGrayLevel, int nbSizes, ColorReducer reducer, int ForbiddenValue, boolean EightConnex) {
        int j;
        int[] nbNanF1 = new int[this.Features.length];
        double[] F1 = new double[this.Features.length];
        for (int i2 = 0; i2 < images.length; ++i2) {
            this.Compute(images[i2], masks[i2], nbGrayLevel, nbSizes, reducer, ForbiddenValue, EightConnex);
            for (j = 0; j < F1.length; ++j) {
                if (Double.isNaN(this.Features[j])) {
                    int n = j;
                    nbNanF1[n] = nbNanF1[n] + 1;
                    continue;
                }
                int n = j;
                F1[n] = F1[n] + this.Features[j];
            }
        }
        for (j = 0; j < F1.length; ++j) {
            this.Features[j] = F1[j] / (double)(images.length - nbNanF1[j]);
        }
        F1 = null;
        nbNanF1 = null;
    }

    private double SZE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / (double)(s + 1) / (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double LZE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] * (double)(s + 1) * (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double LGZE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / n2;
            }
        }
        return val / this.Sum;
    }

    private double HGZE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * n2;
            }
        }
        return val / this.Sum;
    }

    private double SZLGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / n2 / (double)(s + 1) / (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double SZHGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(n + 1) / (double)(s + 1);
                val += this.matrix[n][s] * v * v;
            }
        }
        return val / this.Sum;
    }

    private double LZLGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(s + 1) / (double)(n + 1);
                val += this.matrix[n][s] * v * v;
            }
        }
        return val / this.Sum;
    }

    private double LZHGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.Width; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] * n2 * (double)(s + 1) * (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            double v = 0.0;
            for (int s = 0; s < this.Width; ++s) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SZNU() {
        double val = 0.0;
        for (int s = 0; s < this.Width; ++s) {
            double v = 0.0;
            for (int n = 0; n < this.nbGrayLevel; ++n) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double ZPC() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return this.Sum / val;
    }

    private double BARYGL() {
        double mean = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                mean += (double)(n + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double BARYS() {
        double mean = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                mean += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double VARGL(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                double v = (double)(n + 1) * this.matrix[n][s] - mean;
                val += v * v;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VARS(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                double v = (double)(s + 1) * this.matrix[n][s] - mean;
                val += v * v;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double ORIE(double bgl, double bs) {
        double m11 = 0.0;
        double m02 = 0.0;
        double m20 = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                double m = this.matrix[n][s];
                if (Double.compare(m, 0.0) == 0) continue;
                m11 += (double)(n + 1) * (double)(s + 1) * m;
                m02 += (double)(n + 1) * (double)(n + 1) * m;
                m20 += (double)(s + 1) * (double)(s + 1) * m;
            }
        }
        double b = m11 / this.Sum - bgl * bs;
        double a = m20 / this.Sum - bs * bs;
        double c = m02 / this.Sum - bgl * bgl;
        double val = Math.atan(2.0 * b / (a - c)) / 2.0;
        if (Double.isNaN(val)) {
            return 0.0;
        }
        return val;
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        String glrid = this.reducer.ID();
        String[] names = new String[this.FeaturesNames.length];
        for (int i2 = 0; i2 < this.FeaturesNames.length; ++i2) {
            names[i2] = this.FeaturesNames[i2] + "_" + glrid;
        }
        glrid = null;
        return names;
    }
}

