/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.szm;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import arrayTiTi.ArrayOperations;
import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.FuzzyZone;
import characterization.textures.statisticalmatrices.FuzzyZone3D;
import characterization.textures.statisticalmatrices.FuzzyZone3DComparatorColor;
import characterization.textures.statisticalmatrices.FuzzyZone3DComparatorSize;
import characterization.textures.statisticalmatrices.FuzzyZoneComparatorColor;
import characterization.textures.statisticalmatrices.FuzzyZoneComparatorSize;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.FuzzySZM;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import mathematics.functions.Function;
import mathematics.functions.LinearFunctions;
import processing.reducer.ColorReducer;
import processing.reducer.FuzzyGLR;

public class MultiFuzzySZM
implements ComputableFeatures {
    private final FuzzySZM fszm = new FuzzySZM();
    private FuzzyGLR glr = null;
    private List<FuzzyZone> list = null;
    private List<FuzzyZone3D> list3d = null;
    private double[][] matrix = null;
    private double[] Coefficients = null;
    private double[] Features = new double[16];
    private double Sum = 0.0;
    private String[] FeaturesNames = new String[]{"MultiFuzzySZM_SZE", "MultiFuzzySZM_LZE", "MultiFuzzySZM_LGZE", "MultiFuzzySZM_HGZE", "MultiFuzzySZM_SZLGE", "MultiFuzzySZM_SZHGE", "MultiFuzzySZM_LZLGE", "MultiFuzzySZM_LZHGE", "MultiFuzzySZM_GLNU", "MultiFuzzySZM_SZNU", "MultiFuzzySZM_ZPC", "MultiFuzzySZM_BARYGL", "MultiFuzzySZM_BARYS", "MultiFuzzySZM_VARGL", "MultiFuzzySZM_VARS", "MultiFuzzySZM_ORIE"};
    private boolean FillMatrix = false;
    private int mode = -1;
    private int ForbiddenValue = -1;
    private boolean EightConnex = true;
    private boolean TwentySixConnex = true;
    private int fuzzystart = 1;
    private int fuzzyend = 5;
    private int step = 2;
    private final ArrayFeatures AF = new ArrayFeatures();

    @Override
    public synchronized void Kill() {
        this.fszm.Kill();
        this.Features = null;
        this.FeaturesNames = null;
        this.matrix = null;
        this.Coefficients = null;
        this.glr = null;
        if (this.list != null) {
            this.list.clear();
        }
        this.list = null;
        if (this.list3d != null) {
            this.list3d.clear();
        }
        this.list3d = null;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Compute(image, mask, this.mode, ForbiddenValue, this.EightConnex, this.fuzzystart, this.fuzzyend, this.step, nbCPU);
    }

    public void Compute(BufferedImage image, BufferedImage mask, int mode, int ForbiddenValue, boolean EightConnex, int fuzzystart, int fuzzyend, int step, int nbCPU) {
        int height;
        BufferedImage reduced = null;
        Iterator<FuzzyZone> iter = null;
        FuzzyZone zone2 = null;
        if (this.Coefficients == null) {
            this.AllocCoefficients((fuzzyend - fuzzystart) / step + 1);
        }
        this.mode = mode;
        this.ForbiddenValue = ForbiddenValue;
        this.EightConnex = EightConnex;
        this.fuzzystart = fuzzystart;
        this.fuzzyend = fuzzyend;
        this.step = step;
        this.matrix = null;
        if (this.list != null) {
            this.list.clear();
        }
        switch (image.getType()) {
            case 10: {
                height = 256;
                break;
            }
            case 11: {
                height = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        BufferedImage im = null;
        if (mask != null) {
            im = ImageNew.Clone((BufferedImage)image);
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)im, (int)ForbiddenValue, (BufferedImage)im);
        } else {
            im = image;
        }
        int fuzzy = fuzzyend;
        int n = this.Coefficients.length - 1;
        while (fuzzystart <= fuzzy) {
            this.glr = new FuzzyGLR(fuzzy, EightConnex ? 8 : 4, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy));
            double c = this.Coefficients[n];
            switch (mode) {
                case -2: 
                case -1: {
                    reduced = null;
                    break;
                }
                case -3: {
                    if (reduced != null && ImageTools.areDimensionsAndTypeEqual((BufferedImage)im, reduced)) break;
                    reduced = ImageNew.Same((BufferedImage)im);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mode: " + mode);
                }
            }
            this.glr.Reduce(im, reduced, ForbiddenValue, nbCPU);
            if (this.FillMatrix) {
                int maxsize = 0;
                for (FuzzyZone zone2 : this.glr.FuzzyZones()) {
                    if (maxsize < zone2.Size) {
                        maxsize = zone2.Size;
                    }
                    zone2 = null;
                }
                iter = null;
                if (this.matrix == null) {
                    this.matrix = new double[height][maxsize + 1];
                } else if (this.matrix[0].length < maxsize + 1) {
                    double[][] mat = new double[height][maxsize + 1];
                    ArrayNew.CopyRough((double[][])this.matrix, (double[][])mat);
                    this.matrix = null;
                    this.matrix = mat;
                    mat = null;
                }
                iter = this.glr.FuzzyZones().iterator();
                switch (mode) {
                    case -1: {
                        while (iter.hasNext()) {
                            zone2 = iter.next();
                            double[] dArray = this.matrix[zone2.Color];
                            int n2 = zone2.Size;
                            dArray[n2] = dArray[n2] + c * zone2.Probability * (double)zone2.Counter;
                            zone2 = null;
                        }
                        break;
                    }
                    case -3: 
                    case -2: {
                        while (iter.hasNext()) {
                            zone2 = iter.next();
                            double[] dArray = this.matrix[zone2.Color];
                            int n3 = zone2.Size;
                            dArray[n3] = dArray[n3] + c * zone2.Probability;
                            zone2 = null;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown mode: " + mode);
                    }
                }
                iter = null;
            } else {
                if (this.list == null) {
                    this.list = new LinkedList<FuzzyZone>();
                }
                iter = this.glr.FuzzyZones().iterator();
                while (iter.hasNext()) {
                    this.list.add(iter.next());
                }
                iter = null;
            }
            this.glr.Kill();
            this.glr = null;
            fuzzy -= step;
            --n;
        }
        this.ComputeFeatures(2);
    }

    public void Compute(BufferedImage image, BufferedImage mask, boolean FixedSize, int nbSizes, ColorReducer reducer, int ForbiddenValue, Function function, int radius, boolean EightConnex, int nbCPU) {
        int GrayLevelMax;
        switch (image.getType()) {
            case 10: {
                int nbCoefs;
                GrayLevelMax = 256;
                if (this.Coefficients == null || this.Coefficients.length != 8) {
                    this.AllocCoefficients(8);
                }
                if ((nbCoefs = this.Coefficients.length) == 8) break;
                throw new Error("Wrong number of coefficients (8 waited for BYTE_GRAY images): " + nbCoefs);
            }
            case 11: {
                int nbCoefs;
                GrayLevelMax = 65536;
                if (this.Coefficients == null || this.Coefficients.length != 16) {
                    this.AllocCoefficients(16);
                }
                if ((nbCoefs = this.Coefficients.length) == 16) break;
                throw new Error("Wrong number of coefficients (16 waited for USHORT_GRAY images): " + nbCoefs);
            }
            default: {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
        }
        this.matrix = null;
        int n = 2;
        int nb = 0;
        while (n <= GrayLevelMax) {
            this.fszm.FillMatrix(image, mask, FixedSize, nbSizes, reducer, n, ForbiddenValue, function, radius, EightConnex, nbCPU);
            double[][] m = this.fszm.matrix;
            if (this.matrix == null) {
                this.matrix = new double[GrayLevelMax][m[0].length];
                ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
            }
            this.step = GrayLevelMax / n;
            int width = m[0].length;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < n; ++y) {
                    for (int i2 = 0; i2 < this.step; ++i2) {
                        double[] dArray = this.matrix[this.step * y + i2];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + this.Coefficients[nb] * m[y][x];
                    }
                }
            }
            m = null;
            n <<= 1;
            ++nb;
        }
        this.ComputeFeatures(2);
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        this.Compute(dv, this.mode, this.ForbiddenValue, this.TwentySixConnex, this.fuzzystart, this.fuzzyend, this.step, nbCPU);
    }

    public void Compute(DV dv, int mode, int ForbiddenValue, boolean TwentySixConnex, int fuzzystart, int fuzzyend, int step, int nbCPU) {
        int height;
        DV reduced = null;
        Iterator<FuzzyZone3D> iter = null;
        FuzzyZone3D zone2 = null;
        if (this.Coefficients == null) {
            this.AllocCoefficients((fuzzyend - fuzzystart) / step + 1);
        }
        this.mode = mode;
        this.ForbiddenValue = ForbiddenValue;
        this.TwentySixConnex = TwentySixConnex;
        this.fuzzystart = fuzzystart;
        this.fuzzyend = fuzzyend;
        this.step = step;
        this.matrix = null;
        if (this.list3d != null) {
            this.list3d.clear();
        }
        switch (dv.Type) {
            case 8: {
                height = 256;
                break;
            }
            case 16: {
                height = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        int fuzzy = fuzzyend;
        int n = this.Coefficients.length - 1;
        while (fuzzystart <= fuzzy) {
            this.glr = new FuzzyGLR(fuzzy, TwentySixConnex ? 26 : 6, LinearFunctions.DecreasingLinearFrom_01_N0(fuzzy));
            double c = this.Coefficients[n];
            switch (mode) {
                case -2: 
                case -1: {
                    reduced = null;
                    break;
                }
                case -3: {
                    if (reduced != null && DvTools.areDimensionsAndTypeEqual((DV)dv, reduced)) break;
                    reduced = DvNew.Same((DV)dv);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mode: " + mode);
                }
            }
            this.glr.Reduce(dv, reduced, ForbiddenValue, nbCPU);
            if (this.FillMatrix) {
                int maxsize = 0;
                for (FuzzyZone3D zone2 : this.glr.FuzzyZones3D()) {
                    if (maxsize < zone2.Size) {
                        maxsize = zone2.Size;
                    }
                    zone2 = null;
                }
                iter = null;
                if (this.matrix == null) {
                    this.matrix = new double[height][maxsize + 1];
                } else if (this.matrix[0].length < maxsize + 1) {
                    double[][] mat = new double[height][maxsize + 1];
                    ArrayNew.CopyRough((double[][])this.matrix, (double[][])mat);
                    this.matrix = null;
                    this.matrix = mat;
                    mat = null;
                }
                iter = this.glr.FuzzyZones3D().iterator();
                switch (mode) {
                    case -1: {
                        while (iter.hasNext()) {
                            zone2 = iter.next();
                            double[] dArray = this.matrix[zone2.Color];
                            int n2 = zone2.Size;
                            dArray[n2] = dArray[n2] + c * zone2.Probability * (double)zone2.Counter;
                            zone2 = null;
                        }
                        break;
                    }
                    case -3: 
                    case -2: {
                        while (iter.hasNext()) {
                            zone2 = iter.next();
                            double[] dArray = this.matrix[zone2.Color];
                            int n3 = zone2.Size;
                            dArray[n3] = dArray[n3] + c * zone2.Probability;
                            zone2 = null;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown mode: " + mode);
                    }
                }
                iter = null;
            } else {
                if (this.list3d == null) {
                    this.list3d = new LinkedList<FuzzyZone3D>();
                }
                iter = this.glr.FuzzyZones3D().iterator();
                while (iter.hasNext()) {
                    this.list3d.add(iter.next());
                }
                iter = null;
            }
            this.glr.Kill();
            this.glr = null;
            fuzzy -= step;
            --n;
        }
        this.ComputeFeatures(3);
    }

    public void Compute(DV dv, boolean FixedSize, int nbSizes, ColorReducer reducer, int ForbiddenValue, Function function, int radius, boolean TwentySixConnex, int nbCPU) {
        int GrayLevelMax;
        double[][] m = null;
        switch (dv.Type) {
            case 8: {
                int nbCoefs;
                GrayLevelMax = 256;
                if (this.Coefficients == null || this.Coefficients.length != 8) {
                    this.AllocCoefficients(8);
                }
                if ((nbCoefs = this.Coefficients.length) == 8) break;
                throw new Error("Wrong number of coefficients (8 waited for BYTE_GRAY DV): " + nbCoefs);
            }
            case 16: {
                int nbCoefs;
                GrayLevelMax = 65536;
                if (this.Coefficients == null || this.Coefficients.length != 16) {
                    this.AllocCoefficients(16);
                }
                if ((nbCoefs = this.Coefficients.length) == 16) break;
                throw new Error("Wrong number of coefficients (16 waited for SHORT_GRAY DV): " + nbCoefs);
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        this.matrix = null;
        int n = 2;
        int nb = 0;
        while (n <= GrayLevelMax) {
            this.fszm.FillMatrix(dv, FixedSize, nbSizes, reducer, n, ForbiddenValue, function, radius, TwentySixConnex, nbCPU);
            m = this.fszm.matrix;
            if (this.matrix == null) {
                int Width = m[0].length;
                this.matrix = new double[GrayLevelMax][Width];
                ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
            }
            this.step = GrayLevelMax / n;
            int width = m[0].length;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < n; ++y) {
                    for (int i2 = 0; i2 < this.step; ++i2) {
                        double[] dArray = this.matrix[this.step * y + i2];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + this.Coefficients[nb] * m[y][x];
                    }
                }
            }
            m = null;
            n <<= 1;
            ++nb;
        }
        this.ComputeFeatures(3);
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    public void AllocCoefficients(int size) {
        this.Coefficients = null;
        this.Coefficients = new double[size];
        Arrays.fill(this.Coefficients, 1.0);
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 7) {
            throw new IllegalArgumentException("7 parameters required.");
        }
        this.fuzzystart = (Integer)parameters[0];
        this.fuzzyend = (Integer)parameters[1];
        this.step = (Integer)parameters[2];
        this.mode = (Integer)parameters[3];
        this.ForbiddenValue = (Integer)parameters[4];
        this.EightConnex = this.TwentySixConnex = ((Boolean)parameters[5]).booleanValue();
        this.Coefficients = Arrays.copyOf((double[])parameters[6], ((double[])parameters[6]).length);
    }

    private void ComputeFeatures(int dim) {
        if (!this.FillMatrix) {
            switch (dim) {
                case 2: {
                    this.ComputeFeaturesFromFZ();
                    break;
                }
                case 3: {
                    this.ComputeFeaturesFromFZ3D();
                    break;
                }
                default: {
                    throw new Error("Must not occur.");
                }
            }
            return;
        }
        this.Sum = this.AF.Sum(this.matrix);
        this.Features[0] = this.SZE();
        this.Features[1] = this.LZE();
        this.Features[2] = this.LGZE();
        this.Features[3] = this.HGZE();
        this.Features[4] = this.SZLGE();
        this.Features[5] = this.SZHGE();
        this.Features[6] = this.LZLGE();
        this.Features[7] = this.LZHGE();
        this.Features[8] = this.GLNU();
        this.Features[9] = this.SZNU();
        this.Features[10] = this.ZPC();
        this.Features[11] = this.BARYGL();
        this.Features[12] = this.BARYS();
        this.Features[13] = this.VARGL(this.Features[11]);
        this.Features[14] = this.VARS(this.Features[12]);
        this.Features[15] = this.ORIE(this.Features[11], this.Features[12]);
    }

    private void ComputeFeaturesFromFZ() {
        double v;
        double val;
        FuzzyZone fz2;
        double coef = 1.0;
        PriorityQueue<FuzzyZone> pqcolor = new PriorityQueue<FuzzyZone>(this.list.size() + 13, new FuzzyZoneComparatorColor());
        PriorityQueue<FuzzyZone> pqsize = new PriorityQueue<FuzzyZone>(this.list.size() + 13, new FuzzyZoneComparatorSize());
        double barys = 0.0;
        double barygl = 0.0;
        double zpc = 0.0;
        double lzhge = 0.0;
        double lzlge = 0.0;
        double szhge = 0.0;
        double szlge = 0.0;
        double hgze = 0.0;
        double lgze = 0.0;
        double lze = 0.0;
        double sze = 0.0;
        this.Sum = 0.0;
        for (FuzzyZone fz2 : this.list) {
            pqcolor.add(fz2);
            pqsize.add(fz2);
            if (this.mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            int n2 = (fz2.Color + 1) * (fz2.Color + 1);
            int s2 = (fz2.Size + 1) * (fz2.Size + 1);
            this.Sum += val;
            sze += val / (double)(fz2.Size + 1) / (double)(fz2.Size + 1);
            lze += val * (double)s2;
            lgze += val / (double)n2;
            hgze += val * (double)n2;
            szlge += val / (double)n2 / (double)(fz2.Size + 1) / (double)(fz2.Size + 1);
            v = (double)(fz2.Color + 1) / (double)(fz2.Size + 1);
            szhge += val * v * v;
            v = (double)(fz2.Size + 1) / (double)(fz2.Color + 1);
            lzlge += val * v * v;
            lzhge += val * (double)n2 * (double)s2;
            zpc += val * (double)(fz2.Size + 1);
            barygl += val * (double)(fz2.Color + 1);
            barys += val * (double)(fz2.Size + 1);
            fz2 = null;
        }
        Iterator<FuzzyZone> iter = null;
        this.Features[0] = sze / this.Sum;
        this.Features[1] = lze / this.Sum;
        this.Features[2] = lgze / this.Sum;
        this.Features[3] = hgze / this.Sum;
        this.Features[4] = szlge / this.Sum;
        this.Features[5] = szhge / this.Sum;
        this.Features[6] = lzlge / this.Sum;
        this.Features[7] = lzhge / this.Sum;
        this.Features[10] = this.Sum / zpc;
        double mn = barygl / this.Sum;
        double ms = barys / this.Sum;
        this.Features[11] = mn;
        this.Features[12] = ms;
        v = 0.0;
        double glnu = 0.0;
        while (!pqcolor.isEmpty()) {
            fz2 = pqcolor.poll();
            v += fz2.Probability * (double)(this.mode == -1 ? fz2.Counter : 1);
            if (pqcolor.peek() != null && pqcolor.peek().Color == fz2.Color) continue;
            glnu += v * v;
            v = 0.0;
        }
        this.Features[8] = glnu / this.Sum;
        v = 0.0;
        double sznu = 0.0;
        while (!pqsize.isEmpty()) {
            fz2 = pqsize.poll();
            v += fz2.Probability * (double)(this.mode == -1 ? fz2.Counter : 1);
            if (pqsize.peek() != null && pqsize.peek().Size == fz2.Size) continue;
            sznu += v * v;
            v = 0.0;
        }
        this.Features[9] = sznu / this.Sum;
        double vars = 0.0;
        double vargl = 0.0;
        for (FuzzyZone fz2 : this.list) {
            if (this.mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            v = (double)(fz2.Color + 1) * val - mn;
            vargl += v * v;
            v = (double)(fz2.Size + 1) * val - ms;
            vars += v * v;
            fz2 = null;
        }
        iter = null;
        this.Features[13] = Math.sqrt(vargl / this.Sum);
        this.Features[14] = Math.sqrt(vars / this.Sum);
        double m02 = 0.0;
        double m20 = 0.0;
        double m11 = 0.0;
        for (FuzzyZone fz2 : this.list) {
            if (this.mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            m11 += (double)(fz2.Color + 1) * (double)(fz2.Size + 1) * val;
            m02 += (double)(fz2.Color + 1) * (double)(fz2.Color + 1) * val;
            m20 += (double)(fz2.Size + 1) * (double)(fz2.Size + 1) * val;
            fz2 = null;
        }
        iter = null;
        double a = m20 / this.Sum - ms * ms;
        double b = m11 / this.Sum - mn * ms;
        double c = m02 / this.Sum - mn * mn;
        this.Features[15] = Math.atan(2.0 * b / (a - c)) / 2.0;
    }

    private void ComputeFeaturesFromFZ3D() {
        double v;
        double val;
        FuzzyZone3D fz2;
        double coef = 1.0;
        PriorityQueue<FuzzyZone3D> pqcolor = new PriorityQueue<FuzzyZone3D>(this.list3d.size() + 13, new FuzzyZone3DComparatorColor());
        PriorityQueue<FuzzyZone3D> pqsize = new PriorityQueue<FuzzyZone3D>(this.list3d.size() + 13, new FuzzyZone3DComparatorSize());
        double barys = 0.0;
        double barygl = 0.0;
        double zpc = 0.0;
        double lzhge = 0.0;
        double lzlge = 0.0;
        double szhge = 0.0;
        double szlge = 0.0;
        double hgze = 0.0;
        double lgze = 0.0;
        double lze = 0.0;
        double sze = 0.0;
        this.Sum = 0.0;
        for (FuzzyZone3D fz2 : this.list3d) {
            pqcolor.add(fz2);
            pqsize.add(fz2);
            if (this.mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            int n2 = (fz2.Color + 1) * (fz2.Color + 1);
            int s2 = (fz2.Size + 1) * (fz2.Size + 1);
            this.Sum += val;
            sze += val / (double)(fz2.Size + 1) / (double)(fz2.Size + 1);
            lze += val * (double)s2;
            lgze += val / (double)n2;
            hgze += val * (double)n2;
            szlge += val / (double)n2 / (double)(fz2.Size + 1) / (double)(fz2.Size + 1);
            v = (double)(fz2.Color + 1) / (double)(fz2.Size + 1);
            szhge += val * v * v;
            v = (double)(fz2.Size + 1) / (double)(fz2.Color + 1);
            lzlge += val * v * v;
            lzhge += val * (double)n2 * (double)s2;
            zpc += val * (double)(fz2.Size + 1);
            barygl += val * (double)(fz2.Color + 1);
            barys += val * (double)(fz2.Size + 1);
            fz2 = null;
        }
        Iterator<FuzzyZone3D> iter = null;
        this.Features[0] = sze / this.Sum;
        this.Features[1] = lze / this.Sum;
        this.Features[2] = lgze / this.Sum;
        this.Features[3] = hgze / this.Sum;
        this.Features[4] = szlge / this.Sum;
        this.Features[5] = szhge / this.Sum;
        this.Features[6] = lzlge / this.Sum;
        this.Features[7] = lzhge / this.Sum;
        this.Features[10] = this.Sum / zpc;
        double mn = barygl / this.Sum;
        double ms = barys / this.Sum;
        this.Features[11] = mn;
        this.Features[12] = ms;
        v = 0.0;
        double glnu = 0.0;
        while (!pqcolor.isEmpty()) {
            fz2 = pqcolor.poll();
            v += fz2.Probability * (double)(this.mode == -1 ? fz2.Counter : 1);
            if (pqcolor.peek() != null && pqcolor.peek().Color == fz2.Color) continue;
            glnu += v * v;
            v = 0.0;
        }
        this.Features[8] = glnu / this.Sum;
        v = 0.0;
        double sznu = 0.0;
        while (!pqsize.isEmpty()) {
            fz2 = pqsize.poll();
            v += fz2.Probability * (double)(this.mode == -1 ? fz2.Counter : 1);
            if (pqsize.peek() != null && pqsize.peek().Size == fz2.Size) continue;
            sznu += v * v;
            v = 0.0;
        }
        this.Features[9] = sznu / this.Sum;
        double vars = 0.0;
        double vargl = 0.0;
        for (FuzzyZone3D fz2 : this.list3d) {
            if (this.mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            v = (double)(fz2.Color + 1) * val - mn;
            vargl += v * v;
            v = (double)(fz2.Size + 1) * val - ms;
            vars += v * v;
            fz2 = null;
        }
        iter = null;
        this.Features[13] = Math.sqrt(vargl / this.Sum);
        this.Features[14] = Math.sqrt(vars / this.Sum);
        double m02 = 0.0;
        double m20 = 0.0;
        double m11 = 0.0;
        for (FuzzyZone3D fz2 : this.list3d) {
            if (this.mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            m11 += (double)(fz2.Color + 1) * (double)(fz2.Size + 1) * val;
            m02 += (double)(fz2.Color + 1) * (double)(fz2.Color + 1) * val;
            m20 += (double)(fz2.Size + 1) * (double)(fz2.Size + 1) * val;
            fz2 = null;
        }
        iter = null;
        double a = m20 / this.Sum - ms * ms;
        double b = m11 / this.Sum - mn * ms;
        double c = m02 / this.Sum - mn * mn;
        this.Features[15] = Math.atan(2.0 * b / (a - c)) / 2.0;
    }

    private double SZE() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                val += matrix1[s] / (double)(s + 1) / (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double LZE() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                val += matrix1[s] * (double)((s + 1) * (s + 1));
            }
        }
        return val / this.Sum;
    }

    private double LGZE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / n2;
            }
        }
        return val / this.Sum;
    }

    private double HGZE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                val += this.matrix[n][s] * n2;
            }
        }
        return val / this.Sum;
    }

    private double SZLGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / n2 / (double)(s + 1) / (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double SZHGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(n + 1) / (double)(s + 1);
                val += this.matrix[n][s] * v * v;
            }
        }
        return val / this.Sum;
    }

    private double LZLGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(s + 1) / (double)(n + 1);
                val += this.matrix[n][s] * v * v;
            }
        }
        return val / this.Sum;
    }

    private double LZHGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] * n2 * (double)(s + 1) * (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            double v = 0.0;
            for (int s = 0; s < matrix1.length; ++s) {
                v += matrix1[s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SZNU() {
        double val = 0.0;
        for (int s = 0; s < this.matrix[0].length; ++s) {
            double v = 0.0;
            for (double[] matrix1 : this.matrix) {
                v += matrix1[s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double ZPC() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                val += (double)(s + 1) * matrix1[s];
            }
        }
        return this.Sum / val;
    }

    private double BARYGL() {
        double mean = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                mean += (double)(n + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double BARYS() {
        double mean = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                mean += (double)(s + 1) * matrix1[s];
            }
        }
        return mean / this.Sum;
    }

    private double VARGL(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(n + 1) * this.matrix[n][s] - mean;
                val += v * v;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VARS(double mean) {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                double v = (double)(s + 1) * matrix1[s] - mean;
                val += v * v;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double ORIE(double bgl, double bs) {
        double m11 = 0.0;
        double m02 = 0.0;
        double m20 = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                double m = this.matrix[n][s];
                if (Double.compare(m, 0.0) == 0) continue;
                m11 += (double)(n + 1) * (double)(s + 1) * m;
                m02 += (double)(n + 1) * (double)(n + 1) * m;
                m20 += (double)(s + 1) * (double)(s + 1) * m;
            }
        }
        double a = m20 / this.Sum - bs * bs;
        double b = m11 / this.Sum - bgl * bs;
        double c = m02 / this.Sum - bgl * bgl;
        return Math.atan(2.0 * b / (a - c)) / 2.0;
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        String[] names = new String[this.FeaturesNames.length];
        for (int i2 = 0; i2 < this.FeaturesNames.length; ++i2) {
            names[i2] = this.FeaturesNames[i2] + "_" + this.fuzzystart + "_" + this.fuzzyend + "_" + this.step;
        }
        this.glr = null;
        return names;
    }

    public void FillMatrix(boolean ToFill) {
        this.FillMatrix = ToFill;
    }
}

