/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.szm;

import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.FuzzyZone;
import characterization.textures.statisticalmatrices.FuzzyZone3D;
import characterization.textures.statisticalmatrices.FuzzyZone3DComparatorColor;
import characterization.textures.statisticalmatrices.FuzzyZone3DComparatorSize;
import characterization.textures.statisticalmatrices.FuzzyZoneComparatorColor;
import characterization.textures.statisticalmatrices.FuzzyZoneComparatorSize;
import characterization.textures.statisticalmatrices.thibaultmatrices.szm.FuzzySZM;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import mathematics.functions.Function;
import processing.reducer.ColorReducer;
import processing.reducer.FuzzyGLR;

public class FuzzySZMfeatures
extends FuzzySZM
implements ComputableFeatures {
    private double[] Features = new double[16];
    private double Sum = 0.0;
    private String[] FeaturesNames = new String[]{"SZE", "LZE", "LGZE", "HGZE", "SZLGE", "SZHGE", "LZLGE", "LZHGE", "GLNU", "SZNU", "ZPC", "BARYGL", "BARYS", "VARGL", "VARS", "ORIE"};

    @Override
    public synchronized void Kill() {
        super.Kill();
        this.Features = null;
        this.FeaturesNames = null;
    }

    public void Compute(BufferedImage image, BufferedImage mask, int mode, FuzzyGLR fuzzyglr, int ForbiddenValue, boolean EightConnex, int nbCPU) {
        this.FillMatrix(image, mask, mode, fuzzyglr, ForbiddenValue, EightConnex, nbCPU);
        this.ComputeFeatures(2);
    }

    public void Compute(BufferedImage image, List<FuzzyZone> list, int mode) {
        this.FillMatrix(image, list, mode);
        this.ComputeFeatures(2);
    }

    public void Compute(BufferedImage image, BufferedImage mask, boolean FixedSize, int nbSizes, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, Function function, int radius, boolean EightConnex, int nbCPU) {
        this.FillMatrix(image, mask, FixedSize, nbSizes, reducer, nbGrayLevel, ForbiddenValue, function, radius, EightConnex, nbCPU);
        this.ComputeFeatures(2);
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.FillMatrix(image, mask, this.Mode, this.Reducer, ForbiddenValue, this.EightConnex, nbCPU);
        this.ComputeFeatures(2);
    }

    public void Compute(DV dv, int mode, FuzzyGLR fuzzyglr, int ForbiddenValue, boolean TwentySixConnex, int nbCPU) {
        this.FillMatrix(dv, mode, fuzzyglr, ForbiddenValue, TwentySixConnex, nbCPU);
        this.ComputeFeatures(3);
    }

    public void Compute(DV dv, List<FuzzyZone3D> list, int mode) {
        this.FillMatrix(dv, list, mode);
        this.ComputeFeatures(3);
    }

    public void Compute(DV dv, boolean FixedSize, int nbSizes, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, Function function, int radius, boolean TwentySixConnex, int nbCPU) {
        this.FillMatrix(dv, FixedSize, nbSizes, reducer, nbGrayLevel, ForbiddenValue, function, radius, TwentySixConnex, nbCPU);
        this.ComputeFeatures(3);
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        this.FillMatrix(dv, this.Mode, this.Reducer, this.ForbiddenValue, this.TwentySixConnex, nbCPU);
        this.ComputeFeatures(3);
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    private void ComputeFeatures(int dim) {
        if (!this.FillMatrix) {
            switch (dim) {
                case 2: {
                    this.ComputeFeaturesFromFZ();
                    break;
                }
                case 3: {
                    this.ComputeFeaturesFromFZ3D();
                    break;
                }
                default: {
                    throw new Error("Must not occur.");
                }
            }
            return;
        }
        this.Sum = this.AF.Sum(this.matrix);
        this.Features[0] = this.SZE();
        this.Features[1] = this.LZE();
        this.Features[2] = this.LGZE();
        this.Features[3] = this.HGZE();
        this.Features[4] = this.SZLGE();
        this.Features[5] = this.SZHGE();
        this.Features[6] = this.LZLGE();
        this.Features[7] = this.LZHGE();
        this.Features[8] = this.GLNU();
        this.Features[9] = this.SZNU();
        this.Features[10] = this.ZPC();
        this.Features[11] = this.BARYGL();
        this.Features[12] = this.BARYS();
        this.Features[13] = this.VARGL(this.Features[11]);
        this.Features[14] = this.VARS(this.Features[12]);
        this.Features[15] = this.ORIE(this.Features[11], this.Features[12]);
    }

    private void ComputeFeaturesFromFZ() {
        double v;
        double val;
        FuzzyZone fz2;
        double coef = 1.0;
        PriorityQueue<FuzzyZone> pqcolor = new PriorityQueue<FuzzyZone>(this.Reducer.FuzzyZones().size() + 13, new FuzzyZoneComparatorColor());
        PriorityQueue<FuzzyZone> pqsize = new PriorityQueue<FuzzyZone>(this.Reducer.FuzzyZones().size() + 13, new FuzzyZoneComparatorSize());
        double barys = 0.0;
        double barygl = 0.0;
        double zpc = 0.0;
        double lzhge = 0.0;
        double lzlge = 0.0;
        double szhge = 0.0;
        double szlge = 0.0;
        double hgze = 0.0;
        double lgze = 0.0;
        double lze = 0.0;
        double sze = 0.0;
        this.Sum = 0.0;
        for (FuzzyZone fz2 : this.Reducer.FuzzyZones()) {
            pqcolor.add(fz2);
            pqsize.add(fz2);
            if (this.Mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            int n2 = (fz2.Color + 1) * (fz2.Color + 1);
            int s2 = (fz2.Size + 1) * (fz2.Size + 1);
            this.Sum += val;
            sze += val / (double)(fz2.Size + 1) / (double)(fz2.Size + 1);
            lze += val * (double)s2;
            lgze += val / (double)n2;
            hgze += val * (double)n2;
            szlge += val / (double)n2 / (double)(fz2.Size + 1) / (double)(fz2.Size + 1);
            v = (double)(fz2.Color + 1) / (double)(fz2.Size + 1);
            szhge += val * v * v;
            v = (double)(fz2.Size + 1) / (double)(fz2.Color + 1);
            lzlge += val * v * v;
            lzhge += val * (double)n2 * (double)s2;
            zpc += val * (double)(fz2.Size + 1);
            barygl += val * (double)(fz2.Color + 1);
            barys += val * (double)(fz2.Size + 1);
            fz2 = null;
        }
        Iterator<FuzzyZone> iter = null;
        this.Features[0] = sze / this.Sum;
        this.Features[1] = lze / this.Sum;
        this.Features[2] = lgze / this.Sum;
        this.Features[3] = hgze / this.Sum;
        this.Features[4] = szlge / this.Sum;
        this.Features[5] = szhge / this.Sum;
        this.Features[6] = lzlge / this.Sum;
        this.Features[7] = lzhge / this.Sum;
        this.Features[10] = this.Sum / zpc;
        double mn = barygl / this.Sum;
        double ms = barys / this.Sum;
        this.Features[11] = mn;
        this.Features[12] = ms;
        v = 0.0;
        double glnu = 0.0;
        while (!pqcolor.isEmpty()) {
            fz2 = pqcolor.poll();
            v += fz2.Probability * (double)(this.Mode == -1 ? fz2.Counter : 1);
            if (pqcolor.peek() != null && pqcolor.peek().Color == fz2.Color) continue;
            glnu += v * v;
            v = 0.0;
        }
        this.Features[8] = glnu / this.Sum;
        v = 0.0;
        double sznu = 0.0;
        while (!pqsize.isEmpty()) {
            fz2 = pqsize.poll();
            v += fz2.Probability * (double)(this.Mode == -1 ? fz2.Counter : 1);
            if (pqsize.peek() != null && pqsize.peek().Size == fz2.Size) continue;
            sznu += v * v;
            v = 0.0;
        }
        this.Features[9] = sznu / this.Sum;
        double vars = 0.0;
        double vargl = 0.0;
        for (FuzzyZone fz2 : this.Reducer.FuzzyZones()) {
            if (this.Mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            v = (double)(fz2.Color + 1) * val - mn;
            vargl += v * v;
            v = (double)(fz2.Size + 1) * val - ms;
            vars += v * v;
            fz2 = null;
        }
        iter = null;
        this.Features[13] = Math.sqrt(vargl / this.Sum);
        this.Features[14] = Math.sqrt(vars / this.Sum);
        double m02 = 0.0;
        double m20 = 0.0;
        double m11 = 0.0;
        for (FuzzyZone fz2 : this.Reducer.FuzzyZones()) {
            if (this.Mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            m11 += (double)(fz2.Color + 1) * (double)(fz2.Size + 1) * val;
            m02 += (double)(fz2.Color + 1) * (double)(fz2.Color + 1) * val;
            m20 += (double)(fz2.Size + 1) * (double)(fz2.Size + 1) * val;
            fz2 = null;
        }
        iter = null;
        double a = m20 / this.Sum - ms * ms;
        double b = m11 / this.Sum - mn * ms;
        double c = m02 / this.Sum - mn * mn;
        this.Features[15] = Math.atan(2.0 * b / (a - c)) / 2.0;
    }

    private void ComputeFeaturesFromFZ3D() {
        double v;
        double val;
        FuzzyZone3D fz2;
        double coef = 1.0;
        PriorityQueue<FuzzyZone3D> pqcolor = new PriorityQueue<FuzzyZone3D>(this.Reducer.FuzzyZones3D().size() + 13, new FuzzyZone3DComparatorColor());
        PriorityQueue<FuzzyZone3D> pqsize = new PriorityQueue<FuzzyZone3D>(this.Reducer.FuzzyZones3D().size() + 13, new FuzzyZone3DComparatorSize());
        double barys = 0.0;
        double barygl = 0.0;
        double zpc = 0.0;
        double lzhge = 0.0;
        double lzlge = 0.0;
        double szhge = 0.0;
        double szlge = 0.0;
        double hgze = 0.0;
        double lgze = 0.0;
        double lze = 0.0;
        double sze = 0.0;
        this.Sum = 0.0;
        for (FuzzyZone3D fz2 : this.Reducer.FuzzyZones3D()) {
            pqcolor.add(fz2);
            pqsize.add(fz2);
            if (this.Mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            int n2 = (fz2.Color + 1) * (fz2.Color + 1);
            int s2 = (fz2.Size + 1) * (fz2.Size + 1);
            this.Sum += val;
            sze += val / (double)(fz2.Size + 1) / (double)(fz2.Size + 1);
            lze += val * (double)s2;
            lgze += val / (double)n2;
            hgze += val * (double)n2;
            szlge += val / (double)n2 / (double)(fz2.Size + 1) / (double)(fz2.Size + 1);
            v = (double)(fz2.Color + 1) / (double)(fz2.Size + 1);
            szhge += val * v * v;
            v = (double)(fz2.Size + 1) / (double)(fz2.Color + 1);
            lzlge += val * v * v;
            lzhge += val * (double)n2 * (double)s2;
            zpc += val * (double)(fz2.Size + 1);
            barygl += val * (double)(fz2.Color + 1);
            barys += val * (double)(fz2.Size + 1);
            fz2 = null;
        }
        Iterator<FuzzyZone3D> iter = null;
        this.Features[0] = sze / this.Sum;
        this.Features[1] = lze / this.Sum;
        this.Features[2] = lgze / this.Sum;
        this.Features[3] = hgze / this.Sum;
        this.Features[4] = szlge / this.Sum;
        this.Features[5] = szhge / this.Sum;
        this.Features[6] = lzlge / this.Sum;
        this.Features[7] = lzhge / this.Sum;
        this.Features[10] = this.Sum / zpc;
        double mn = barygl / this.Sum;
        double ms = barys / this.Sum;
        this.Features[11] = mn;
        this.Features[12] = ms;
        v = 0.0;
        double glnu = 0.0;
        while (!pqcolor.isEmpty()) {
            fz2 = pqcolor.poll();
            v += fz2.Probability * (double)(this.Mode == -1 ? fz2.Counter : 1);
            if (pqcolor.peek() != null && pqcolor.peek().Color == fz2.Color) continue;
            glnu += v * v;
            v = 0.0;
        }
        this.Features[8] = glnu / this.Sum;
        v = 0.0;
        double sznu = 0.0;
        while (!pqsize.isEmpty()) {
            fz2 = pqsize.poll();
            v += fz2.Probability * (double)(this.Mode == -1 ? fz2.Counter : 1);
            if (pqsize.peek() != null && pqsize.peek().Size == fz2.Size) continue;
            sznu += v * v;
            v = 0.0;
        }
        this.Features[9] = sznu / this.Sum;
        double vars = 0.0;
        double vargl = 0.0;
        for (FuzzyZone3D fz2 : this.Reducer.FuzzyZones3D()) {
            if (this.Mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            v = (double)(fz2.Color + 1) * val - mn;
            vargl += v * v;
            v = (double)(fz2.Size + 1) * val - ms;
            vars += v * v;
            fz2 = null;
        }
        iter = null;
        this.Features[13] = Math.sqrt(vargl / this.Sum);
        this.Features[14] = Math.sqrt(vars / this.Sum);
        double m02 = 0.0;
        double m20 = 0.0;
        double m11 = 0.0;
        for (FuzzyZone3D fz2 : this.Reducer.FuzzyZones3D()) {
            if (this.Mode == -1) {
                coef = fz2.Counter;
            }
            val = coef * fz2.Probability;
            m11 += (double)(fz2.Color + 1) * (double)(fz2.Size + 1) * val;
            m02 += (double)(fz2.Color + 1) * (double)(fz2.Color + 1) * val;
            m20 += (double)(fz2.Size + 1) * (double)(fz2.Size + 1) * val;
            fz2 = null;
        }
        iter = null;
        double a = m20 / this.Sum - ms * ms;
        double b = m11 / this.Sum - mn * ms;
        double c = m02 / this.Sum - mn * mn;
        this.Features[15] = Math.atan(2.0 * b / (a - c)) / 2.0;
    }

    private double SZE() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                val += matrix1[s] / (double)(s + 1) / (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double LZE() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                val += matrix1[s] * (double)((s + 1) * (s + 1));
            }
        }
        return val / this.Sum;
    }

    private double LGZE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / n2;
            }
        }
        return val / this.Sum;
    }

    private double HGZE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                val += this.matrix[n][s] * n2;
            }
        }
        return val / this.Sum;
    }

    private double SZLGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] / n2 / (double)(s + 1) / (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double SZHGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(n + 1) / (double)(s + 1);
                val += this.matrix[n][s] * v * v;
            }
        }
        return val / this.Sum;
    }

    private double LZLGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(s + 1) / (double)(n + 1);
                val += this.matrix[n][s] * v * v;
            }
        }
        return val / this.Sum;
    }

    private double LZHGE() {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            double n2 = (n + 1) * (n + 1);
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                val += this.matrix[n][s] * n2 * (double)(s + 1) * (double)(s + 1);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            double v = 0.0;
            for (int s = 0; s < matrix1.length; ++s) {
                v += matrix1[s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SZNU() {
        double val = 0.0;
        for (int s = 0; s < this.matrix[0].length; ++s) {
            double v = 0.0;
            for (double[] matrix1 : this.matrix) {
                v += matrix1[s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double ZPC() {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                val += (double)(s + 1) * matrix1[s];
            }
        }
        return this.Sum / val;
    }

    private double BARYGL() {
        double mean = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                mean += (double)(n + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double BARYS() {
        double mean = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < matrix1.length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                mean += (double)(s + 1) * matrix1[s];
            }
        }
        return mean / this.Sum;
    }

    private double VARGL(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(this.matrix[n][s], 0.0) == 0) continue;
                double v = (double)(n + 1) * this.matrix[n][s] - mean;
                val += v * v;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VARS(double mean) {
        double val = 0.0;
        for (double[] matrix1 : this.matrix) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                if (Double.compare(matrix1[s], 0.0) == 0) continue;
                double v = (double)(s + 1) * matrix1[s] - mean;
                val += v * v;
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double ORIE(double bgl, double bs) {
        double m11 = 0.0;
        double m02 = 0.0;
        double m20 = 0.0;
        for (int n = 0; n < this.matrix.length; ++n) {
            for (int s = 0; s < this.matrix[0].length; ++s) {
                double m = this.matrix[n][s];
                if (Double.compare(m, 0.0) == 0) continue;
                m11 += (double)(n + 1) * (double)(s + 1) * m;
                m02 += (double)(n + 1) * (double)(n + 1) * m;
                m20 += (double)(s + 1) * (double)(s + 1) * m;
            }
        }
        double a = m20 / this.Sum - bs * bs;
        double b = m11 / this.Sum - bgl * bs;
        double c = m02 / this.Sum - bgl * bgl;
        return Math.atan(2.0 * b / (a - c)) / 2.0;
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        String id = this.ID();
        String[] names = new String[this.FeaturesNames.length];
        for (int i2 = 0; i2 < this.FeaturesNames.length; ++i2) {
            names[i2] = id + "_" + this.FeaturesNames[i2];
        }
        id = null;
        return names;
    }

    @Override
    public String ID() {
        Object id = "FuzzySZM_";
        switch (this.Mode) {
            case -1: {
                id = (String)id + "All";
                break;
            }
            case -2: {
                id = (String)id + "Un";
                break;
            }
            case -3: {
                id = (String)id + "Best";
                break;
            }
            default: {
                throw new IllegalStateException("Must not occur.");
            }
        }
        return (String)id + "_" + this.Reducer.ID();
    }
}

