/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.szm;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayOperations;
import characterization.textures.statisticalmatrices.FuzzyZone;
import characterization.textures.statisticalmatrices.FuzzyZone3D;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mathematics.functions.Function;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import processing.reducer.ColorReducer;
import processing.reducer.FuzzyGLR;

public class FuzzySZM {
    protected int ForbiddenValue = -1;
    protected boolean EightConnex = true;
    protected boolean TwentySixConnex = true;
    protected int nbCPU = -1;
    protected boolean FillMatrix = false;
    protected double[][] matrix = null;
    protected BufferedImage reduced = null;
    protected DV reduced3d = null;
    protected ConnectedComponentLabeling ccl = new UnionFindCcl();
    protected int Mode = 0;
    protected FuzzyGLR Reducer = null;
    private Function function = null;
    private int radius = -1;
    private List<CoordinatesWeighted> se = null;
    public static final int AllPossibleFuzzyZones = -1;
    public static final int AllUniqueFuzzyZones = -2;
    public static final int BestFuzzyTexture = -3;
    protected ArrayFeatures AF = new ArrayFeatures();

    public synchronized void Kill() {
        this.se = null;
        if (this.matrix != null && this.matrix[0] != null) {
            Arrays.fill((Object[])this.matrix, null);
        }
        this.matrix = null;
        this.reduced = null;
        if (this.reduced3d != null) {
            this.reduced3d.Kill();
        }
        this.reduced3d = null;
        this.ccl.Kill();
        this.ccl = null;
        if (this.Reducer != null) {
            this.Reducer.Kill();
        }
        this.Reducer = null;
        this.function = null;
        if (this.se != null) {
            this.se.clear();
        }
        this.se = null;
    }

    public void FillMatrix(BufferedImage image, BufferedImage mask, int mode, FuzzyGLR reducer, int ForbiddenValue, boolean EightConnex, int nbCPU) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.Reducer = reducer;
        this.ForbiddenValue = ForbiddenValue;
        this.EightConnex = EightConnex;
        this.Mode = mode;
        this.nbCPU = nbCPU;
        reducer.FullZoneComputation = false;
        switch (mode) {
            case -2: 
            case -1: {
                this.reduced = null;
                break;
            }
            case -3: {
                if (!this.FillMatrix || this.reduced != null && ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)this.reduced)) break;
                this.reduced = null;
                this.reduced = ImageNew.Same((BufferedImage)image);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        BufferedImage im = null;
        if (mask != null) {
            im = ImageNew.Clone((BufferedImage)image);
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)im, (int)ForbiddenValue, (BufferedImage)im);
        } else {
            im = image;
        }
        reducer.Reduce(im, this.reduced, ForbiddenValue, nbCPU);
        if (this.FillMatrix) {
            this.FillMatrix(this.reduced, reducer.FuzzyZones(), mode);
        }
    }

    public void FillMatrix(BufferedImage image, List<FuzzyZone> list, int mode) {
        int height;
        int maxsize = 0;
        FuzzyZone zone2 = null;
        this.Reducer = null;
        for (FuzzyZone zone2 : list) {
            if (maxsize < zone2.Size) {
                maxsize = zone2.Size;
            }
            zone2 = null;
        }
        Iterator<FuzzyZone> iter = null;
        switch (image.getType()) {
            case 10: {
                height = 256;
                break;
            }
            case 11: {
                height = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        if (this.matrix == null || this.matrix.length != height || this.matrix[0].length != maxsize + 1) {
            this.matrix = null;
            this.matrix = new double[height][maxsize + 1];
        } else {
            ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        }
        iter = list.iterator();
        switch (mode) {
            case -1: {
                while (iter.hasNext()) {
                    zone2 = iter.next();
                    double[] dArray = this.matrix[zone2.Color];
                    int n = zone2.Size;
                    dArray[n] = dArray[n] + zone2.Probability * (double)zone2.Counter;
                    zone2 = null;
                }
                break;
            }
            case -3: 
            case -2: {
                while (iter.hasNext()) {
                    zone2 = iter.next();
                    double[] dArray = this.matrix[zone2.Color];
                    int n = zone2.Size;
                    dArray[n] = dArray[n] + zone2.Probability;
                    zone2 = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        iter = null;
    }

    public void FillMatrix(BufferedImage image, BufferedImage mask, boolean FixedSize, int nbSizes, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, Function function, int radius, boolean EightConnex, int nbCPU) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.ForbiddenValue = ForbiddenValue;
        this.EightConnex = EightConnex;
        this.nbCPU = nbCPU;
        this.CreateSE(function, radius);
        BufferedImage im = null;
        if (mask != null) {
            im = ImageNew.Clone((BufferedImage)image);
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)im, (int)ForbiddenValue, (BufferedImage)im);
        } else {
            im = image;
        }
        this.reduced = reducer.Reduce(im, nbGrayLevel, ForbiddenValue);
        this.ccl.Label(this.reduced, 0, EightConnex);
        int[] Sizes = this.ccl.Sizes();
        Object Colors2 = this.ccl.Colors();
        int width = this.AF.Maximum(Sizes, 1, Sizes.length);
        if (FixedSize) {
            if (this.matrix == null || this.matrix.length != nbGrayLevel || this.matrix[0].length != nbSizes) {
                this.matrix = null;
                this.matrix = new double[nbGrayLevel][nbSizes];
            } else {
                ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
            }
            int type = this.reduced.getType();
            for (int i2 = 1; i2 < Sizes.length; ++i2) {
                int y;
                int x = (int)((double)(Sizes[i2] - 1) / (double)width * (double)nbSizes);
                switch (type) {
                    case 10: {
                        y = (((byte[])Colors2)[i2] & 0xFF) - 1;
                        break;
                    }
                    case 11: {
                        y = (((short[])Colors2)[i2] & 0xFFFF) - 1;
                        break;
                    }
                    default: {
                        y = ((int[])Colors2)[i2] - 1;
                    }
                }
                for (int s = 0; s < this.se.size(); ++s) {
                    CoordinatesWeighted c = this.se.get(s);
                    int X = x + c.X;
                    int Y = y + c.Y;
                    if (0 > X || X >= this.matrix[0].length || 0 > Y || Y >= this.matrix.length) continue;
                    double[] dArray = this.matrix[Y];
                    int n = X;
                    dArray[n] = dArray[n] + c.Wd;
                }
            }
        } else {
            this.matrix = null;
            this.matrix = new double[nbGrayLevel][width / nbSizes + 1];
            int type = this.reduced.getType();
            for (int i3 = 1; i3 < Sizes.length; ++i3) {
                int y;
                int x = Sizes[i3] / nbSizes;
                switch (type) {
                    case 10: {
                        y = (((byte[])Colors2)[i3] & 0xFF) - 1;
                        break;
                    }
                    case 11: {
                        y = (((short[])Colors2)[i3] & 0xFFFF) - 1;
                        break;
                    }
                    default: {
                        y = ((int[])Colors2)[i3] - 1;
                    }
                }
                for (int s = 0; s < this.se.size(); ++s) {
                    CoordinatesWeighted c = this.se.get(s);
                    int X = x + c.X;
                    int Y = y + c.Y;
                    if (0 > X || X >= this.matrix[0].length || 0 > Y || Y >= this.matrix.length) continue;
                    double[] dArray = this.matrix[Y];
                    int n = X;
                    dArray[n] = dArray[n] + c.Wd;
                }
            }
        }
    }

    private void CreateSE(Function function, int radius) {
        if (this.function != null && this.function.equals(function) && this.radius == radius) {
            return;
        }
        double[] arg = new double[1];
        Euclidian metric = new Euclidian();
        this.se = new ArrayList<CoordinatesWeighted>((radius + 1) * (radius + 1));
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                arg[0] = metric.Distance((double)x, (double)y, 0.0, 0.0, 0.0, 0.0);
                double v = function.Compute(arg);
                if (Double.compare(0.0, v) == 0) continue;
                this.se.add(new CoordinatesWeighted(x, y, 0, -1, v));
            }
        }
    }

    public void FillMatrix(DV dv, int mode, FuzzyGLR reducer, int ForbiddenValue, boolean TwentySixConnex, int nbCPU) {
        this.Reducer = reducer;
        this.ForbiddenValue = ForbiddenValue;
        this.TwentySixConnex = TwentySixConnex;
        this.Mode = mode;
        this.nbCPU = nbCPU;
        reducer.FullZoneComputation = false;
        switch (mode) {
            case -2: 
            case -1: {
                this.reduced = null;
                break;
            }
            case -3: {
                if (!this.FillMatrix || this.reduced != null && DvTools.areDimensionsAndTypeEqual((DV)dv, (DV)this.reduced3d)) break;
                this.reduced3d = null;
                this.reduced3d = DvNew.Same((DV)dv);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        reducer.Reduce(dv, this.reduced3d, ForbiddenValue, nbCPU);
        if (this.FillMatrix) {
            this.FillMatrix(dv, reducer.FuzzyZones3D(), mode);
        }
    }

    public void FillMatrix(DV dv, List<FuzzyZone3D> list, int mode) {
        int height;
        int maxsize = 0;
        FuzzyZone3D zone2 = null;
        this.Reducer = null;
        for (FuzzyZone3D zone2 : list) {
            if (maxsize < zone2.Size) {
                maxsize = zone2.Size;
            }
            zone2 = null;
        }
        Iterator<FuzzyZone3D> iter = null;
        switch (dv.Type) {
            case 8: {
                height = 256;
                break;
            }
            case 16: {
                height = 65536;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        if (this.matrix == null || this.matrix.length != height || this.matrix[0].length != maxsize + 1) {
            this.matrix = null;
            this.matrix = new double[height][maxsize + 1];
        } else {
            ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        }
        iter = list.iterator();
        switch (mode) {
            case -1: {
                while (iter.hasNext()) {
                    zone2 = iter.next();
                    double[] dArray = this.matrix[zone2.Color];
                    int n = zone2.Size;
                    dArray[n] = dArray[n] + zone2.Probability * (double)zone2.Counter;
                    zone2 = null;
                }
                break;
            }
            case -3: 
            case -2: {
                while (iter.hasNext()) {
                    zone2 = iter.next();
                    double[] dArray = this.matrix[zone2.Color];
                    int n = zone2.Size;
                    dArray[n] = dArray[n] + zone2.Probability;
                    zone2 = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + mode);
            }
        }
        iter = null;
    }

    public void FillMatrix(DV dv, boolean FixedSize, int nbSizes, ColorReducer reducer, int nbGrayLevel, int ForbiddenValue, Function function, int radius, boolean TwentySixConnex, int nbCPU) {
        this.ForbiddenValue = ForbiddenValue;
        this.TwentySixConnex = TwentySixConnex;
        this.nbCPU = nbCPU;
        this.CreateSE(function, radius);
        this.reduced3d = reducer.Reduce(dv, nbGrayLevel, ForbiddenValue);
        switch (dv.Type) {
            case 8: {
                this.ccl.Label(this.reduced3d.getDataBufferByte(0), dv.SizeX, dv.SizeY, dv.SizeZ, (byte)0, this.EightConnex);
                break;
            }
            case 16: {
                this.ccl.Label(this.reduced3d.getDataBufferShort(0), dv.SizeX, dv.SizeY, dv.SizeZ, (short)0, this.EightConnex);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        int[] Sizes = this.ccl.Sizes();
        Object Colors2 = this.ccl.Colors();
        int width = this.AF.Maximum(Sizes, 1, Sizes.length);
        CoordinatesWeighted c = null;
        if (FixedSize) {
            if (this.matrix == null || this.matrix.length != nbGrayLevel || this.matrix[0].length != nbSizes) {
                this.matrix = null;
                this.matrix = new double[nbGrayLevel][nbSizes];
            } else {
                ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
            }
            int type = this.reduced.getType();
            for (int i2 = 1; i2 < Sizes.length; ++i2) {
                int y;
                int x = (int)((double)(Sizes[i2] - 1) / (double)width * (double)nbSizes);
                switch (type) {
                    case 10: {
                        y = (((byte[])Colors2)[i2] & 0xFF) - 1;
                        break;
                    }
                    case 11: {
                        y = (((short[])Colors2)[i2] & 0xFFFF) - 1;
                        break;
                    }
                    default: {
                        y = ((int[])Colors2)[i2] - 1;
                    }
                }
                for (int s = 0; s < this.se.size(); ++s) {
                    c = this.se.get(s);
                    int X = x + c.X;
                    int Y = y + c.Y;
                    if (0 > X || X >= this.matrix[0].length || 0 > Y || Y >= this.matrix.length) continue;
                    double[] dArray = this.matrix[Y];
                    int n = X;
                    dArray[n] = dArray[n] + c.Wd;
                }
            }
        } else {
            this.matrix = null;
            this.matrix = new double[nbGrayLevel][width / nbSizes + 1];
            int type = this.reduced.getType();
            for (int i3 = 1; i3 < Sizes.length; ++i3) {
                int y;
                int x = Sizes[i3] / nbSizes;
                switch (type) {
                    case 10: {
                        y = (((byte[])Colors2)[i3] & 0xFF) - 1;
                        break;
                    }
                    case 11: {
                        y = (((short[])Colors2)[i3] & 0xFFFF) - 1;
                        break;
                    }
                    default: {
                        y = ((int[])Colors2)[i3] - 1;
                    }
                }
                for (int s = 0; s < this.se.size(); ++s) {
                    c = this.se.get(s);
                    int X = x + c.X;
                    int Y = y + c.Y;
                    if (0 <= X && X < this.matrix[0].length && 0 <= Y && Y < this.matrix.length) {
                        double[] dArray = this.matrix[Y];
                        int n = X;
                        dArray[n] = dArray[n] + c.Wd;
                    }
                    c = null;
                }
            }
        }
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 4) {
            throw new IllegalArgumentException("Exactly 4 parameters required.");
        }
        this.Mode = (Integer)parameters[0];
        this.Reducer = (FuzzyGLR)parameters[1];
        this.ForbiddenValue = (Integer)parameters[2];
        this.EightConnex = (Boolean)parameters[3];
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public void FillMatrix(boolean ToFill) {
        this.FillMatrix = ToFill;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.matrix.length * this.matrix[0].length * 3);
        for (double[] matrix1 : this.matrix) {
            for (int i2 = 0; i2 < this.matrix[0].length; ++i2) {
                sb.append(matrix1[i2]).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

