/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.pm;

import arrayTiTi.ArrayOperations;
import dataMining.pca.PCA;
import imageTiTi.ImageComparator;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import mathematics.Geometry2D;
import mathematics.Maths;
import measures.BasicMeasures;
import morphee.levelings.Leveling;
import processing.filters.Gaussian;
import processing.reducer.ColorReducer;

public class GrayLevelPolarMatrix {
    protected int nbGrayLevel = -1;
    protected int nbDistance = -1;
    protected int width = -1;
    protected int height = -1;
    protected double[][] matrix = null;
    protected BasicMeasures bbcps = new BasicMeasures();
    protected PCA pca = new PCA();
    private final Gaussian gauss = new Gaussian(1, 1.0, 2);
    protected ColorReducer reducer = null;
    protected Leveling leveling = null;
    protected int ForbiddenValue = -1;
    protected boolean weighted = true;
    protected int nbCPU = -1;

    public void FillMatrix(BufferedImage image, BufferedImage mask, int nbGrayLevel, int nbDistance, boolean weighted, ColorReducer reducer, Leveling leveling, int ForbiddenValue, int nbCPU) {
        double rho;
        int x;
        int y;
        if (nbGrayLevel < 2) {
            throw new IllegalArgumentException("Bad number of gray level: " + nbGrayLevel + ", wish [2...2^N[");
        }
        this.nbGrayLevel = nbGrayLevel;
        if (!Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("Number of gray level must be a power of 2: " + nbGrayLevel);
        }
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.height = image.getHeight();
        this.width = image.getWidth();
        BufferedImage Reduced = null;
        Reduced = leveling == null ? reducer.Reduce(image, nbGrayLevel, ForbiddenValue) : reducer.Reduce(leveling.Filter(image, nbCPU, this.gauss.Filter(image, nbCPU)), nbGrayLevel, ForbiddenValue);
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)Reduced, (int)0, (BufferedImage)Reduced);
        }
        this.bbcps.Compute(image, false);
        double bx = this.bbcps.Centroid.X;
        double by = this.bbcps.Centroid.Y;
        this.pca.Compute(image, this.bbcps.Centroid);
        double origin = Geometry2D.AngleFromVector(this.pca.getEigenVectors()[0], true);
        if (origin < 0.0) {
            origin += 360.0;
        }
        WritableRaster wr = image.getRaster();
        WritableRaster wrred = Reduced.getRaster();
        int max = 0;
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (wr.getSample(x, y, 0) == ForbiddenValue || !((rho = Math.sqrt(Math.pow((double)x - bx, 2.0) + Math.pow((double)y - by, 2.0)) / (double)nbDistance + 0.5) >= (double)max)) continue;
                max = (int)rho + 1;
            }
        }
        if (this.matrix == null || this.matrix[0].length != max) {
            this.matrix = null;
            this.matrix = new double[360][max];
        } else {
            ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        }
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                if (wr.getSample(x, y, 0) == ForbiddenValue) continue;
                rho = Math.sqrt(Math.pow((double)x - bx, 2.0) + Math.pow((double)y - by, 2.0)) / (double)nbDistance;
                double theta = Math.toDegrees(Math.atan2((double)y - by, (double)x - bx));
                if (theta < 0.0) {
                    theta += 360.0;
                }
                if ((theta -= origin) < 0.0) {
                    theta += 360.0;
                }
                if ((int)(theta + 0.5) == 360) {
                    theta = 0.0;
                }
                int w = weighted ? wrred.getSample(x, y, 0) : 1;
                double[] dArray = this.matrix[(int)(theta + 0.5)];
                int n = (int)(rho + 0.5);
                dArray[n] = dArray[n] + (double)w;
            }
        }
        this.height = this.matrix.length;
        this.width = this.matrix[0].length;
        wrred = null;
        wr = null;
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 7) {
            throw new IllegalArgumentException("Exactly 12 parameters are required.");
        }
        this.nbGrayLevel = (Integer)parameters[0];
        this.nbDistance = (Integer)parameters[1];
        this.weighted = (Boolean)parameters[2];
        this.reducer = (ColorReducer)parameters[3];
        this.leveling = (Leveling)parameters[4];
        this.ForbiddenValue = (Integer)parameters[5];
        this.nbCPU = (Integer)parameters[6];
    }

    public double[][] getMatrix() {
        return this.matrix;
    }
}

