/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.ozm;

import arrayTiTi.ArrayOperations;
import dataMining.pca.PCA;
import imageTiTi.ImageComparator;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mathematics.Geometry2D;
import mathematics.Maths;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import measures.BasicMeasures;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FifoCcl;
import morphee.levelings.Leveling;
import processing.filters.Gaussian;
import processing.reducer.ColorReducer;

public class GrayLevelOrientationZoneMatrix {
    protected int nbGrayLevel = 32;
    protected int nbOrientation = 8;
    protected double[][] matrix = null;
    protected BufferedImage Reduced = null;
    private final ConnectedComponentLabeling ccl = new FifoCcl();
    private final List<BufferedImage> list = new ArrayList<BufferedImage>(1000);
    protected BasicMeasures bbcps = new BasicMeasures();
    protected PCA pca = new PCA();
    private final Gaussian gauss = new Gaussian(1, 1.0, 2);

    public void FillMatrix(BufferedImage image, BufferedImage mask, int nbGrayLevel, int nbOrientation, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, int nbCPU) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        if (!Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("Number of gray level must be a power of 2: " + nbGrayLevel);
        }
        this.nbGrayLevel = nbGrayLevel;
        this.nbOrientation = nbOrientation;
        this.matrix = new double[nbGrayLevel][nbOrientation];
        int height = image.getHeight();
        int width = image.getWidth();
        int[] Map2 = null;
        BufferedImage vig = null;
        this.Reduced = null;
        this.Reduced = leveling == null ? reducer.Reduce(image, nbGrayLevel, ForbiddenValue) : reducer.Reduce(leveling.Filter(image, nbCPU, this.gauss.Filter(image, nbCPU)), nbGrayLevel, ForbiddenValue);
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)this.Reduced, (int)0, (BufferedImage)this.Reduced);
        }
        this.ccl.Label(this.Reduced, 0, EightConnex);
        this.list.clear();
        int nbZones = this.ccl.ConnectedComponentsNumber();
        Map2 = this.ccl.Labels1D();
        int[] minx = new int[nbZones + 1];
        int[] maxx = new int[nbZones + 1];
        int[] miny = new int[nbZones + 1];
        int[] maxy = new int[nbZones + 1];
        for (int x = 0; x <= nbZones; ++x) {
            minx[x] = width;
            miny[x] = height;
            maxy[x] = 0;
            maxx[x] = 0;
        }
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (0 < Map2[pos]) {
                    int p = Map2[pos];
                    if (minx[p] > x) {
                        minx[p] = x;
                    }
                    if (maxx[p] < x) {
                        maxx[p] = x;
                    }
                    if (miny[p] > y) {
                        miny[p] = y;
                    }
                    if (maxy[p] < y) {
                        maxy[p] = y;
                    }
                }
                ++x;
                ++pos;
            }
        }
        WritableRaster wrred = this.Reduced.getRaster();
        WritableRaster wrvig = null;
        for (int i2 = 1; i2 <= nbZones; ++i2) {
            width = maxx[i2] - minx[i2] + 1;
            height = maxy[i2] - miny[i2] + 1;
            this.list.add(new BufferedImage(width, height, image.getType()));
            vig = this.list.get(this.list.size() - 1);
            wrvig = vig.getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (Map2[(miny[i2] + y) * width + minx[i2] + x] == i2) {
                        wrvig.setSample(x, y, 0, wrred.getSample(minx[i2] + x, miny[i2] + y, 0));
                        continue;
                    }
                    wrvig.setSample(x, y, 0, 0);
                }
            }
            wrvig = null;
            vig = null;
        }
        this.FillMatrix(this.list);
        wrred = null;
        minx = null;
        maxx = null;
        miny = null;
        maxy = null;
    }

    public void FillMatrix(List<BufferedImage> list) {
        BufferedImage shape = null;
        Iterator<BufferedImage> iter = list.iterator();
        ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        while (iter.hasNext()) {
            double Orientation;
            shape = iter.next();
            if (!ImageTools.isGrayLevel((BufferedImage)shape)) {
                throw new IllegalArgumentException("Only gray level image required.");
            }
            if (shape.getWidth() == 1 && shape.getHeight() == 1) {
                Orientation = 0.0;
            } else if (shape.getWidth() == 1) {
                Orientation = 90.0;
            } else if (shape.getHeight() == 1) {
                Orientation = 0.0;
            } else {
                this.bbcps.Compute(shape, false);
                this.pca.Compute(shape, this.bbcps.Centroid);
                Orientation = Geometry2D.AngleBAC(new Point3DF(1.0, 0.0), (Point)new Point3DF(0.0, 0.0), new Point3DF(this.pca.getEigenVectors()[0].get(0), this.pca.getEigenVectors()[0].get(1)), true);
                if (Orientation >= 180.0) {
                    Orientation -= 180.0;
                }
                if (Orientation >= 180.0) {
                    Orientation -= 180.0;
                }
            }
            double[] dArray = this.matrix[this.FindColor(shape) - 1];
            int n = (int)(Orientation / 180.0 * (double)this.nbOrientation);
            dArray[n] = dArray[n] + 1.0;
            shape = null;
        }
    }

    private int FindColor(BufferedImage image) {
        WritableRaster wr = image.getRaster();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                return wr.getSample(x, y, 0);
            }
        }
        throw new Error("Color not found. This error must not occured.");
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.nbGrayLevel * this.nbOrientation * 3);
        for (int j = 0; j < this.nbGrayLevel; ++j) {
            for (int i2 = 0; i2 < this.nbOrientation; ++i2) {
                sb.append(this.matrix[j][i2]).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

