/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.olzm;

import arrayTiTi.ArrayOperations;
import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.olzm.GrayLevelOrientationLengthZoneMatrix;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import measures.hedgehop.Distance;
import morphee.StructuringElement;
import morphee.levelings.Leveling;
import processing.reducer.ColorReducer;

public class MGlolzm
implements ComputableFeatures {
    private final double[] Features = new double[16];
    private double Sum = 0.0;
    private final String[] FeaturesNames = new String[]{"SLE", "LLE", "ONU", "SLNU", "LP", "SLSE", "LLSE", "SLLOE", "SLHOE", "LLLOE", "LLHOE", "BARYO", "BARYL", "VARO", "VARL", "ORIE"};
    private final GrayLevelOrientationLengthZoneMatrix glolzm = new GrayLevelOrientationLengthZoneMatrix();
    private int GrayLevelMax = -1;
    private int nbLength = -1;
    private int nbOrientation = -1;
    private int Width = -1;
    private int Height = -1;
    private boolean FixedSize = false;
    private double[][] matrix = null;
    private double[] Coefficients = null;
    private boolean UseAverageOrientation;
    private boolean UseGapToAO;
    private StructuringElement se = null;
    private ColorReducer reducer = null;
    private Leveling leveling = null;
    private int ForbiddenValue = -1;
    private boolean EightConnex = true;

    @Override
    public synchronized void Kill() {
        throw new UnsupportedOperationException("Method not implemented (yet).");
    }

    public void Compute(BufferedImage image, BufferedImage mask, int nbLength, int nbOrientation, boolean FixedSize, boolean UseAverageOrientation, boolean UseGapToAO, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, StructuringElement se, int nbCPU) {
        int nbCoefs;
        double[][][] m = null;
        switch (image.getType()) {
            case 10: {
                this.GrayLevelMax = 256;
                if (this.Coefficients == null || this.Coefficients.length != 8) {
                    this.AllocCoefficients(8);
                }
                if ((nbCoefs = this.Coefficients.length) == 8) break;
                throw new Error("Wrong number of coefficients (8 waited for BYTE_GRAY images): " + nbCoefs);
            }
            case 11: {
                this.GrayLevelMax = 65536;
                if (this.Coefficients == null || this.Coefficients.length != 16) {
                    this.AllocCoefficients(16);
                }
                if ((nbCoefs = this.Coefficients.length) == 16) break;
                throw new Error("Wrong number of coefficients (16 waited for USHORT_GRAY images): " + nbCoefs);
            }
            default: {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
        }
        this.matrix = null;
        this.nbLength = nbLength;
        this.nbOrientation = nbOrientation;
        this.FixedSize = FixedSize;
        m = new double[nbCoefs][][];
        int n = 2;
        this.Width = 0;
        int nb = 0;
        while (n <= this.GrayLevelMax) {
            this.glolzm.FillMatrix(image, mask, n, nbLength, nbOrientation, FixedSize, UseAverageOrientation, UseGapToAO, reducer, leveling, ForbiddenValue, EightConnex, se, nbCPU);
            m[nb] = this.glolzm.matrix;
            if (this.Width < m[nb][0].length) {
                this.Width = m[nb][0].length;
            }
            n *= 2;
            ++nb;
        }
        this.Height = m[0].length;
        this.matrix = new double[this.Height][this.Width];
        ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        for (n = 0; n < nbCoefs; ++n) {
            int width = m[n][0].length;
            for (int y = 0; y < this.Height; ++y) {
                for (int x = 0; x < width; ++x) {
                    double[] dArray = this.matrix[y];
                    int n2 = x;
                    dArray[n2] = dArray[n2] + this.Coefficients[n] * m[n][y][x];
                }
            }
        }
        m = null;
        this.ComputeFeatures();
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Compute(image, mask, this.nbLength, this.nbOrientation, this.FixedSize, this.UseAverageOrientation, this.UseGapToAO, this.reducer, this.leveling, ForbiddenValue, this.EightConnex, this.se, nbCPU);
    }

    public void Compute(List<BufferedImage> images, int nbLength, int nbOrientation, boolean FixedSize, boolean UseAverageOrientation, boolean UseGapToAO, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, Distance Montanary, int nbCPU) {
        double[][] m = null;
        switch (images.get(0).getType()) {
            case 10: {
                int nbCoefs;
                this.GrayLevelMax = 256;
                if (this.Coefficients == null || this.Coefficients.length != 8) {
                    this.AllocCoefficients(8);
                }
                if ((nbCoefs = this.Coefficients.length) == 8) break;
                throw new Error("Wrong number of coefficients (8 waited for BYTE_GRAY images): " + nbCoefs);
            }
            case 11: {
                int nbCoefs;
                this.GrayLevelMax = 65536;
                if (this.Coefficients == null || this.Coefficients.length != 16) {
                    this.AllocCoefficients(16);
                }
                if ((nbCoefs = this.Coefficients.length) == 16) break;
                throw new Error("Wrong number of coefficients (16 waited for USHORT_GRAY images): " + nbCoefs);
            }
            default: {
                throw new IllegalArgumentException("Only gray level images are supported.");
            }
        }
        this.matrix = null;
        this.nbLength = nbLength;
        this.nbOrientation = nbOrientation;
        this.FixedSize = FixedSize;
        int n = 2;
        int nb = 0;
        while (n <= this.GrayLevelMax) {
            this.glolzm.FillMatrix(images, n, nbLength, nbOrientation, FixedSize, UseAverageOrientation, UseGapToAO, reducer, leveling, ForbiddenValue, EightConnex, this.se, nbCPU);
            m = this.glolzm.matrix;
            if (this.matrix == null) {
                this.Width = m[0].length;
                this.matrix = new double[this.GrayLevelMax][this.Width];
                ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
            }
            int step = this.GrayLevelMax / n;
            int width = m[0].length;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < n; ++y) {
                    for (int i2 = 0; i2 < step; ++i2) {
                        double[] dArray = this.matrix[step * y + i2];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + this.Coefficients[nb] * m[y][x];
                    }
                }
            }
            m = null;
            n *= 2;
            ++nb;
        }
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    private void AllocCoefficients(int size) {
        this.AllocCoefficients(size, 2.0, 0.0);
    }

    private void AllocCoefficients(int size, double sigma, double decalage) {
        int x;
        double middle = (double)(size - 1) / 2.0 + decalage;
        if (this.Coefficients == null || this.Coefficients.length != size) {
            this.Coefficients = null;
            this.Coefficients = new double[size];
        }
        double sum = 0.0;
        for (x = 0; x < size; ++x) {
            double val;
            double d2 = Math.pow(middle - (double)x, 2.0) / (2.0 * Math.pow(sigma, 2.0));
            this.Coefficients[x] = val = Math.exp(-d2);
            sum += val;
        }
        x = 0;
        while (x < size) {
            int n = x++;
            this.Coefficients[n] = this.Coefficients[n] / sum;
        }
    }

    private void ComputeFeatures() {
        this.Sum = 0.0;
        for (int y = 0; y < this.Height; ++y) {
            for (int x = 0; x < this.Width; ++x) {
                this.Sum += this.matrix[y][x];
            }
        }
        this.Features[0] = this.SLE();
        this.Features[1] = this.LLE();
        this.Features[2] = this.ONU();
        this.Features[3] = this.SLNU();
        this.Features[4] = this.LP();
        this.Features[5] = this.SLSE();
        this.Features[6] = this.LLSE();
        this.Features[7] = this.SLLOE();
        this.Features[8] = this.SLHOE();
        this.Features[9] = this.LLLOE();
        this.Features[10] = this.LLHOE();
        this.Features[11] = this.BARYO();
        this.Features[12] = this.BARYL();
        this.Features[13] = this.VARO(this.Features[11]);
        this.Features[14] = this.VARL(this.Features[12]);
        this.Features[15] = this.ORIE(this.Features[11], this.Features[12]);
    }

    private double SLE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LLE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double ONU() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            double v = 0.0;
            for (int s = 0; s < this.Width; ++s) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SLNU() {
        double val = 0.0;
        for (int s = 0; s < this.Width; ++s) {
            double v = 0.0;
            for (int n = 0; n < this.Height; ++n) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double LP() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return this.Sum / val;
    }

    private double SLSE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LLSE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double SLLOE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / (Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0));
            }
        }
        return val / this.Sum;
    }

    private double SLHOE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(n + 1) / (double)(s + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LLLOE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(s + 1) / (double)(n + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LLHOE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double BARYO() {
        int size = 0;
        double sumx = 0.0;
        double sumy = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                if (!(this.matrix[n][s] > 0.0)) continue;
                sumx += Math.cos(Math.toRadians(n));
                sumy += Math.sin(Math.toRadians(n));
                ++size;
            }
        }
        double Average2 = sumx >= 0.0 && sumy >= 0.0 ? Math.atan(sumy / sumx) : (sumx < 0.0 && sumy >= 0.0 ? Math.atan(-sumy / sumx) : (sumx >= 0.0 && sumy >= 0.0 ? Math.atan(-sumy / sumx) : Math.atan((sumy /= (double)size) / (sumx /= (double)size))));
        return Math.toDegrees(Average2);
    }

    private double BARYL() {
        double mean = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                mean += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double VARO(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += Math.pow(Math.min(Math.toRadians(n) - mean, Math.PI * 2 - Math.toRadians(n) - mean) * this.matrix[n][s], 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VARL(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += Math.pow(((double)(s + 1) - mean) * this.matrix[n][s], 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double ORIE(double bgl, double bs) {
        double m11 = 0.0;
        double m02 = 0.0;
        double m20 = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                double m = this.matrix[n][s];
                m11 += (double)(n + 1) * (double)(s + 1) * m;
                m02 = Math.pow(n + 1, 2.0) * m;
                m20 = Math.pow(s + 1, 2.0) * m;
            }
        }
        double a = m20 / this.Sum - bs * bs;
        double b = 2.0 * (m11 / this.Sum - bgl * bs);
        double c = m02 / this.Sum - bgl * bgl;
        return Math.atan(b / (a - c)) / 2.0;
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 10) {
            throw new IllegalArgumentException("10 parameters required.");
        }
        this.nbLength = (Integer)parameters[0];
        this.nbOrientation = (Integer)parameters[1];
        this.FixedSize = (Boolean)parameters[2];
        this.UseAverageOrientation = (Boolean)parameters[3];
        this.UseGapToAO = (Boolean)parameters[4];
        this.reducer = (ColorReducer)parameters[5];
        this.leveling = (Leveling)parameters[6];
        this.ForbiddenValue = (Integer)parameters[7];
        this.EightConnex = (Boolean)parameters[8];
        this.se = (StructuringElement)parameters[9];
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        return this.FeaturesNames;
    }

    public void Coefficients(double[] Coefficients) {
        this.Coefficients = Arrays.copyOf(Coefficients, Coefficients.length);
    }

    public double[] Coefficients() {
        return this.Coefficients;
    }
}

