/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.olzm;

import dataMining.pca.PCA;
import imageTiTi.ImageComparator;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mathematics.Geometry2D;
import mathematics.Maths;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import mathematics.statistics.CircularStatistics;
import measures.BasicMeasures;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.GeodesicDiameter;
import morphee.StructuringElement;
import morphee.levelings.Leveling;
import processing.filters.Gaussian;
import processing.reducer.ColorReducer;

public class GrayLevelOrientationLengthZoneMatrix {
    protected int nbGrayLevel = -1;
    protected int nbLength = -1;
    protected int nbOrientation = -1;
    protected int Width = -1;
    protected int Height = -1;
    protected boolean FixedSize = false;
    protected boolean UseAverageOrientation;
    protected boolean UseGapToAO;
    protected double[][] matrix = null;
    protected StructuringElement se = null;
    protected GeodesicDiameter gd = new GeodesicDiameter();
    protected BasicMeasures bbcps = new BasicMeasures();
    protected PCA pca = new PCA();
    protected ConnectedComponentLabeling ccl = new UnionFindCcl();
    private List<BufferedImage> list = new ArrayList<BufferedImage>(1000);
    private Gaussian gauss = new Gaussian(1, 1.0, 2);
    private CircularStatistics circstats = new CircularStatistics();
    protected ColorReducer reducer = null;
    protected Leveling leveling = null;
    protected int ForbiddenValue = -1;
    protected boolean EightConnex = true;
    protected int nbCPU = -1;

    public void FillMatrix(BufferedImage image, BufferedImage mask, int nbGrayLevel, int nbLength, int nbOrientation, boolean FixedSize, boolean UseAverageOrientation, boolean UseGapToAO, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, StructuringElement se, int nbCPU) {
        int y;
        int x;
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        if (nbGrayLevel < 2) {
            throw new IllegalArgumentException("Number of gray level incorrect: " + nbGrayLevel + ", wish [2...2^N[");
        }
        if (UseGapToAO) {
            UseAverageOrientation = true;
        }
        this.nbGrayLevel = nbGrayLevel;
        this.nbLength = nbLength;
        this.nbOrientation = nbOrientation;
        this.FixedSize = FixedSize;
        this.UseAverageOrientation = UseAverageOrientation;
        this.UseGapToAO = UseGapToAO;
        this.reducer = reducer;
        this.leveling = leveling;
        this.ForbiddenValue = ForbiddenValue;
        this.EightConnex = EightConnex;
        this.se = se;
        this.nbCPU = nbCPU;
        if (FixedSize) {
            this.Width = nbLength;
            this.Height = nbOrientation;
            this.matrix = new double[this.Height][this.Width];
        }
        if (!Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("Number of gray level must be a power of 2: " + nbGrayLevel);
        }
        int height = image.getHeight();
        int width = image.getWidth();
        BufferedImage Reduced = null;
        int[] Map2 = null;
        BufferedImage vig = null;
        Reduced = leveling == null ? reducer.Reduce(image, nbGrayLevel, ForbiddenValue) : reducer.Reduce(leveling.Filter(image, nbCPU, this.gauss.Filter(image, nbCPU)), nbGrayLevel, ForbiddenValue);
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)Reduced, (int)0, (BufferedImage)Reduced);
        }
        this.ccl.Label(Reduced, 0, EightConnex);
        this.list.clear();
        int nbZones = this.ccl.ConnectedComponentsNumber();
        Map2 = this.ccl.Labels1D();
        int[] minx = new int[nbZones + 1];
        int[] maxx = new int[nbZones + 1];
        int[] miny = new int[nbZones + 1];
        int[] maxy = new int[nbZones + 1];
        for (x = 0; x <= nbZones; ++x) {
            minx[x] = width;
            miny[x] = height;
            maxy[x] = 0;
            maxx[x] = 0;
        }
        int pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (0 < Map2[pos]) {
                    int p = Map2[pos];
                    if (minx[p] > x) {
                        minx[p] = x;
                    }
                    if (maxx[p] < x) {
                        maxx[p] = x;
                    }
                    if (miny[p] > y) {
                        miny[p] = y;
                    }
                    if (maxy[p] < y) {
                        maxy[p] = y;
                    }
                }
                ++x;
                ++pos;
            }
        }
        WritableRaster wrred = Reduced.getRaster();
        WritableRaster wrvig = null;
        for (int i2 = 1; i2 <= nbZones; ++i2) {
            width = maxx[i2] - minx[i2] + 1;
            height = maxy[i2] - miny[i2] + 1;
            this.list.add(new BufferedImage(width, height, image.getType()));
            vig = this.list.get(this.list.size() - 1);
            wrvig = vig.getRaster();
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (Map2[(miny[i2] + y) * width + minx[i2] + x] == i2) {
                        wrvig.setSample(x, y, 0, wrred.getSample(minx[i2] + x, miny[i2] + y, 0));
                        continue;
                    }
                    wrvig.setSample(x, y, 0, 0);
                }
            }
            wrvig = null;
            vig = null;
        }
        this.FillMatrix(this.list, se);
        wrred = null;
        minx = null;
        maxx = null;
        miny = null;
        maxy = null;
    }

    public void FillMatrix(List<BufferedImage> images, int nbGrayLevel, int nbLength, int nbOrientation, boolean FixedSize, boolean UseAverageOrientation, boolean UseGapToAO, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, StructuringElement se, int nbCPU) {
        if (nbGrayLevel < 2) {
            throw new IllegalArgumentException("Number of gray level incorrect: " + nbGrayLevel + ", wish [2...2^N[");
        }
        if (UseGapToAO) {
            UseAverageOrientation = true;
        }
        this.nbGrayLevel = nbGrayLevel;
        this.nbLength = nbLength;
        this.nbOrientation = nbOrientation;
        this.FixedSize = FixedSize;
        this.UseAverageOrientation = UseAverageOrientation;
        this.UseGapToAO = UseGapToAO;
        if (FixedSize) {
            this.Width = nbLength;
            this.Height = nbOrientation;
            this.matrix = new double[this.Height][this.Width];
        }
        if (!Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("Number of gray level must be a power of 2: " + nbGrayLevel);
        }
        int height = images.get(0).getHeight();
        int width = images.get(0).getWidth();
        int type = images.get(0).getType();
        BufferedImage Reduced = null;
        int[] Map2 = null;
        BufferedImage vig = null;
        Iterator<BufferedImage> iter = images.iterator();
        BufferedImage image = null;
        this.list.clear();
        while (iter.hasNext()) {
            int y;
            int x;
            image = iter.next();
            if (!ImageTools.isGrayLevel((BufferedImage)image)) {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
            if (image.getHeight() != height || image.getWidth() != width) {
                throw new IllegalArgumentException("All images must have same dimensions.");
            }
            if (image.getType() != type) {
                throw new IllegalArgumentException("All images must have same type.");
            }
            Reduced = leveling == null ? reducer.Reduce(image, nbGrayLevel, ForbiddenValue) : reducer.Reduce(leveling.Filter(image, nbCPU, this.gauss.Filter(image, nbCPU)), nbGrayLevel, ForbiddenValue);
            this.ccl.Label(Reduced, 0, EightConnex);
            int nbZones = this.ccl.ConnectedComponentsNumber();
            Map2 = this.ccl.Labels1D();
            int[] minx = new int[nbZones + 1];
            int[] maxx = new int[nbZones + 1];
            int[] miny = new int[nbZones + 1];
            int[] maxy = new int[nbZones + 1];
            for (x = 0; x <= nbZones; ++x) {
                minx[x] = width;
                miny[x] = height;
                maxy[x] = 0;
                maxx[x] = 0;
            }
            int pos = 0;
            for (y = 0; y < height; ++y) {
                x = 0;
                while (x < width) {
                    if (0 < Map2[pos]) {
                        int p = Map2[pos];
                        if (minx[p] > x) {
                            minx[p] = x;
                        }
                        if (maxx[p] < x) {
                            maxx[p] = x;
                        }
                        if (miny[p] > y) {
                            miny[p] = y;
                        }
                        if (maxy[p] < y) {
                            maxy[p] = y;
                        }
                    }
                    ++x;
                    ++pos;
                }
            }
            WritableRaster wrred = Reduced.getRaster();
            WritableRaster wrvig = null;
            for (int i2 = 1; i2 <= nbZones; ++i2) {
                width = maxx[i2] - minx[i2] + 1;
                height = maxy[i2] - miny[i2] + 1;
                this.list.add(new BufferedImage(width, height, image.getType()));
                vig = this.list.get(this.list.size() - 1);
                wrvig = vig.getRaster();
                for (y = 0; y < height; ++y) {
                    for (x = 0; x < width; ++x) {
                        if (Map2[(miny[i2] + y) * width + minx[i2] + x] == i2) {
                            wrvig.setSample(x, y, 0, wrred.getSample(minx[i2] + x, miny[i2] + y, 0));
                            continue;
                        }
                        wrvig.setSample(x, y, 0, 0);
                    }
                }
                wrvig = null;
                vig = null;
            }
            wrred = null;
            minx = null;
            maxx = null;
            miny = null;
            maxy = null;
        }
        this.FillMatrix(this.list, se);
    }

    public void FillMatrix(List<BufferedImage> list, StructuringElement se) {
        if (se.getType() != -15) {
            throw new IllegalArgumentException("Only Montanary type SE required.");
        }
        this.se = se;
        BufferedImage shape = null;
        int[] length = new int[list.size()];
        double[] orientation = new double[list.size()];
        boolean[] used = new boolean[list.size()];
        Iterator<BufferedImage> iter = list.iterator();
        int nb = 0;
        int width = 0;
        while (iter.hasNext()) {
            shape = iter.next();
            if (!ImageTools.isGrayLevel((BufferedImage)shape)) {
                throw new IllegalArgumentException("Only gray level image required.");
            }
            this.bbcps.Compute(shape, true);
            if (this.bbcps.Boundary.Size() == 1) {
                length[nb] = 1;
            } else {
                this.gd.Compute(shape, this.bbcps.Boundary, this.bbcps.Centroid, se, null, true);
                length[nb] = (int)(this.gd.getLength() + 0.5) + 1;
            }
            if (width < length[nb]) {
                width = length[nb];
            }
            if (shape.getWidth() == 1 && shape.getHeight() == 1) {
                orientation[nb] = 0.0;
            } else if (shape.getWidth() == 1) {
                orientation[nb] = 90.0;
            } else if (shape.getHeight() == 1) {
                orientation[nb] = 0.0;
            } else {
                this.pca.Compute(shape, this.bbcps.Centroid);
                orientation[nb] = Geometry2D.AngleBAC(new Point3DF(1.0, 0.0), (Point)new Point3DF(0.0, 0.0), new Point3DF(this.pca.getEigenVectors()[0].get(0), this.pca.getEigenVectors()[0].get(1)), true);
                if (orientation[nb] >= 180.0) {
                    int n = nb;
                    orientation[n] = orientation[n] - 180.0;
                }
                if (orientation[nb] >= 180.0) {
                    int n = nb;
                    orientation[n] = orientation[n] - 180.0;
                }
            }
            ++nb;
            shape = null;
        }
        Arrays.fill(used, true);
        this.FillMatrix(used, orientation, length, width);
    }

    public void FillMatrix(boolean[] used, double[] orientations, int[] lengths, int width) {
        int size = used.length;
        if (this.matrix == null || this.Width != width / this.nbLength + 1) {
            this.Width = width / this.nbLength + 1;
            this.Height = this.UseGapToAO ? 90 / this.nbOrientation + 1 : 180 / this.nbOrientation + 1;
            this.matrix = null;
            this.matrix = new double[this.Height][this.Width];
        }
        double oriave = 0.0;
        if (this.UseAverageOrientation) {
            this.circstats.ComputeDegres(orientations);
            oriave = this.circstats.getAverage() / this.circstats.CSTE;
        }
        Arrays.fill((Object[])this.matrix, (Object)0.0);
        if (this.FixedSize) {
            if (!this.UseAverageOrientation) {
                for (int i2 = 0; i2 < size; ++i2) {
                    if (!used[i2]) continue;
                    double[] dArray = this.matrix[(int)(orientations[i2] / 180.0 * (double)this.nbOrientation)];
                    int n = (int)((double)(lengths[i2] - 1) / (double)width * (double)this.nbLength);
                    dArray[n] = dArray[n] + 1.0;
                }
            } else if (!this.UseGapToAO) {
                for (int i3 = 0; i3 < size; ++i3) {
                    if (!used[i3]) continue;
                    double gap = orientations[i3] - oriave;
                    double[] dArray = this.matrix[(int)((gap > 0.0 ? gap : gap + 180.0) / 180.0 * (double)this.nbOrientation)];
                    int n = (int)((double)(lengths[i3] - 1) / (double)width * (double)this.nbLength);
                    dArray[n] = dArray[n] + 1.0;
                }
            } else {
                for (int i4 = 0; i4 < size; ++i4) {
                    if (!used[i4]) continue;
                    double[] dArray = this.matrix[(int)(Math.abs(oriave - orientations[i4]) / 90.0 * (double)this.nbOrientation)];
                    int n = (int)((double)(lengths[i4] - 1) / (double)width * (double)this.nbLength);
                    dArray[n] = dArray[n] + 1.0;
                }
            }
        } else if (!this.UseAverageOrientation) {
            for (int i5 = 0; i5 < size; ++i5) {
                if (!used[i5]) continue;
                double[] dArray = this.matrix[(int)(orientations[i5] / (double)this.nbOrientation)];
                int n = lengths[i5] / this.nbLength;
                dArray[n] = dArray[n] + 1.0;
            }
        } else if (!this.UseGapToAO) {
            for (int i6 = 0; i6 < size; ++i6) {
                if (!used[i6]) continue;
                double gap = orientations[i6] - oriave;
                double[] dArray = this.matrix[(int)((gap > 0.0 ? gap : gap + 180.0) / (double)this.nbOrientation)];
                int n = lengths[i6] / this.nbLength;
                dArray[n] = dArray[n] + 1.0;
            }
        } else {
            double gap = 0.0;
            int i7 = 0;
            try {
                for (i7 = 0; i7 < size; ++i7) {
                    if (!used[i7]) continue;
                    gap = Math.abs(orientations[i7] - oriave) < Math.abs(oriave - (orientations[i7] - 180.0)) ? Math.abs(orientations[i7] - oriave) : Math.abs(oriave - (orientations[i7] - 180.0));
                    double[] dArray = this.matrix[(int)(gap / (double)this.nbOrientation)];
                    int n = lengths[i7] / this.nbLength;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
            catch (Exception E) {
                System.out.println("matrix = " + this.matrix.length + "\t" + this.matrix[0].length);
                System.out.print(gap + "\t" + this.nbOrientation + "\t" + lengths[i7] + "\t" + this.nbLength + " \t => \t ");
                System.out.println((int)(gap / (double)this.nbOrientation) + "\t" + lengths[i7] / this.nbLength);
            }
        }
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 12) {
            throw new IllegalArgumentException("Exactly 12 parameters are required.");
        }
        this.nbGrayLevel = (Integer)parameters[0];
        this.nbLength = (Integer)parameters[1];
        this.nbOrientation = (Integer)parameters[2];
        this.FixedSize = (Boolean)parameters[3];
        this.UseAverageOrientation = (Boolean)parameters[4];
        this.UseGapToAO = (Boolean)parameters[5];
        this.reducer = (ColorReducer)parameters[6];
        this.leveling = (Leveling)parameters[7];
        this.ForbiddenValue = (Integer)parameters[8];
        this.EightConnex = (Boolean)parameters[9];
        this.se = (StructuringElement)parameters[10];
        this.nbCPU = (Integer)parameters[11];
    }

    public double[][] getMatrix() {
        return this.matrix;
    }
}

