/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.olzm;

import characterization.PreComputable;
import characterization.textures.statisticalmatrices.thibaultmatrices.olzm.GrayLevelOrientationLengthZoneMatrix;
import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.List;
import mathematics.Geometry2D;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import morphee.StructuringElement;
import morphee.levelings.Leveling;
import processing.reducer.ColorReducer;
import utils.memory.Allocator;

public class GlolzmFeatures
extends GrayLevelOrientationLengthZoneMatrix
implements PreComputable {
    private final Allocator allocator = Allocator.Instance();
    private final double[] Features = new double[16];
    private double Sum = 0.0;
    private final String[] FeaturesNames = new String[]{"SLE", "LLE", "ONU", "SLNU", "LP", "SLSE", "LLSE", "SLLOE", "SLHOE", "LLLOE", "LLHOE", "BARYO", "BARYL", "VARO", "VARL", "ORIE"};
    private int[] lengths;
    private double[] orientations;
    private boolean[] used;
    public int HugeImageThreshold = 500000;

    @Override
    public synchronized void Kill() {
        throw new UnsupportedOperationException("Method not implemented (yet).");
    }

    public void Compute(BufferedImage image, BufferedImage mask, int nbGrayLevel, int nbLength, int nbOrientation, boolean FixedSize, boolean UseAverageOrientation, boolean UseGapToAO, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, StructuringElement se, int nbCPU) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.FillMatrix(image, mask, nbGrayLevel, nbLength, nbOrientation, FixedSize, UseAverageOrientation, UseGapToAO, reducer, leveling, ForbiddenValue, EightConnex, se, nbCPU);
        this.ComputeFeatures();
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (this.nbGrayLevel == -1) {
            throw new Error("Parameters must be set before the call to this method.");
        }
        this.Compute(image, mask, this.nbGrayLevel, this.nbLength, this.nbOrientation, this.FixedSize, this.UseAverageOrientation, this.UseGapToAO, this.reducer, this.leveling, ForbiddenValue, this.EightConnex, this.se, nbCPU);
    }

    public void Compute(List<BufferedImage> images, int nbGrayLevel, int nbLength, int nbOrientation, boolean FixedSize, boolean UseAverageOrientation, boolean UseGapToAO, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, StructuringElement se, int nbCPU) {
        this.FillMatrix(images, nbGrayLevel, nbLength, nbOrientation, FixedSize, UseAverageOrientation, UseGapToAO, reducer, leveling, ForbiddenValue, EightConnex, se, nbCPU);
        this.ComputeFeatures();
    }

    public void Compute(List<BufferedImage> list, StructuringElement se) {
        this.FillMatrix(list, se);
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    @Override
    public void PreCompute(BufferedImage image, int nbCPU) {
        if (nbCPU < 0) {
            throw new Error("Parameters must be set before the call to this method.");
        }
        BufferedImage reduced = this.reducer.Reduce(image, this.nbGrayLevel, this.ForbiddenValue);
        this.ccl.Label(reduced, this.ForbiddenValue, this.EightConnex);
        if (this.ccl.ConnectedComponentsNumber() > this.HugeImageThreshold) {
            this.PreComputeHugeImage(reduced, nbCPU);
            return;
        }
        BufferedImage[] list = this.ccl.SeparateAllComponents(reduced, 0, 0);
        if (this.lengths == null || this.lengths.length != list.length) {
            this.lengths = this.allocator.Release(this.lengths);
            this.lengths = this.allocator.newIntArray(list.length);
            this.orientations = this.allocator.Release(this.orientations);
            this.orientations = this.allocator.newDoubleArray(list.length);
            this.used = this.allocator.Release(this.used);
            this.used = this.allocator.newBooleanArray(list.length);
        }
        for (int i2 = 1; i2 < list.length; ++i2) {
            BufferedImage shape = list[i2];
            this.bbcps.Compute(shape, true);
            if (this.bbcps.Boundary.Size() == 1) {
                this.lengths[i2] = 1;
            } else {
                this.gd.Compute(shape, this.bbcps.Boundary, this.bbcps.Centroid, this.se, null, true);
                this.lengths[i2] = (int)(this.gd.getLength() + 0.5) + 1;
            }
            if (shape.getWidth() == 1 && shape.getHeight() == 1) {
                this.orientations[i2] = 0.0;
            } else if (shape.getWidth() == 1) {
                this.orientations[i2] = 90.0;
            } else if (shape.getHeight() == 1) {
                this.orientations[i2] = 0.0;
            } else {
                this.pca.Compute(shape, this.bbcps.Centroid);
                this.orientations[i2] = (int)(Geometry2D.AngleBAC(new Point3DF(1.0, 0.0), (Point)new Point3DF(0.0, 0.0), new Point3DF(this.pca.getEigenVectors()[0].get(0), this.pca.getEigenVectors()[0].get(1)), true) + 0.5);
                if (this.orientations[i2] >= 180.0) {
                    int n = i2;
                    this.orientations[n] = this.orientations[n] - 180.0;
                }
                if (this.orientations[i2] >= 180.0) {
                    int n = i2;
                    this.orientations[n] = this.orientations[n] - 180.0;
                }
            }
            shape = null;
        }
        list = null;
        reduced = null;
    }

    public void PreComputeHugeImage(BufferedImage image, int nbCPU) {
        int x;
        int y;
        int channel;
        int Counter = this.ccl.ConnectedComponentsNumber();
        int[] labels = this.ccl.Labels1D();
        int width = image.getWidth();
        int height = image.getHeight();
        int[] minx = new int[Counter + 1];
        int[] maxx = new int[Counter + 1];
        int[] miny = new int[Counter + 1];
        int[] maxy = new int[Counter + 1];
        BufferedImage shape = null;
        WritableRaster wr = null;
        switch (image.getType()) {
            case 10: 
            case 11: 
            case 12: {
                channel = 1;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                channel = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        int pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                if (0 < labels[pos]) {
                    int v = labels[pos];
                    if (x < minx[v]) {
                        minx[v] = x;
                    }
                    if (x > maxx[v]) {
                        maxx[v] = x;
                    }
                    if (y < miny[v]) {
                        miny[v] = y;
                    }
                    if (y > maxy[v]) {
                        maxy[v] = y;
                    }
                }
                ++x;
                ++pos;
            }
        }
        if (this.lengths == null || this.lengths.length != Counter + 1) {
            this.lengths = null;
            this.lengths = new int[Counter + 1];
            this.orientations = null;
            this.orientations = new double[Counter + 1];
            this.used = null;
            this.used = new boolean[Counter + 1];
        }
        for (int i2 = 1; i2 <= Counter; ++i2) {
            shape = image.getSubimage(minx[i2], miny[i2], maxx[i2] - minx[i2] + 1, maxy[i2] - miny[i2] + 1);
            wr = shape.getRaster();
            for (y = miny[i2]; y <= maxy[i2]; ++y) {
                x = minx[i2];
                pos = y * width + x;
                while (x <= maxx[i2]) {
                    if (labels[pos] != i2) {
                        for (int c = 0; c < channel; ++c) {
                            wr.setSample(x - minx[i2], y - miny[i2], c, 0);
                        }
                    }
                    ++x;
                    ++pos;
                }
            }
            this.bbcps.Compute(shape, true);
            if (this.bbcps.Boundary.Size() <= 1) {
                this.lengths[i2] = 1;
            } else {
                this.gd.Compute(shape, this.bbcps.Boundary, this.bbcps.Centroid, this.se, null, true);
                this.lengths[i2] = (int)(this.gd.getLength() + 0.5) + 1;
            }
            if (shape.getWidth() == 1 && shape.getHeight() == 1) {
                this.orientations[i2] = 0.0;
            } else if (shape.getWidth() == 1) {
                this.orientations[i2] = 90.0;
            } else if (shape.getHeight() == 1) {
                this.orientations[i2] = 0.0;
            } else {
                this.pca.Compute(shape, this.bbcps.Centroid);
                this.orientations[i2] = (int)(Geometry2D.AngleBAC(new Point3DF(1.0, 0.0), (Point)new Point3DF(0.0, 0.0), new Point3DF(this.pca.getEigenVectors()[0].get(0), this.pca.getEigenVectors()[0].get(1)), true) + 0.5);
                if (this.orientations[i2] >= 180.0) {
                    int n = i2;
                    this.orientations[n] = this.orientations[n] - 180.0;
                }
                if (this.orientations[i2] >= 180.0) {
                    int n = i2;
                    this.orientations[n] = this.orientations[n] - 180.0;
                }
            }
            shape = null;
            wr = null;
        }
    }

    @Override
    public void FastCompute(int startx, int starty, int endx, int endy) {
        int width = 0;
        int[] labels = this.ccl.Labels1D();
        Arrays.fill(this.used, false);
        for (int y = starty; y <= endy; ++y) {
            int x = startx;
            int pos = y * width + x;
            while (x <= endx) {
                this.used[labels[pos] - 1] = true;
                if (width < this.lengths[labels[pos] - 1]) {
                    width = (int)((double)this.lengths[labels[pos] - 1] + 0.5);
                }
                ++x;
                ++pos;
            }
        }
        this.FillMatrix(this.used, this.orientations, this.lengths, width);
        this.ComputeFeatures();
    }

    private void ComputeFeatures() {
        this.Sum = 0.0;
        for (int y = 0; y < this.Height; ++y) {
            for (int x = 0; x < this.Width; ++x) {
                this.Sum += this.matrix[y][x];
            }
        }
        this.Features[0] = this.SLE();
        this.Features[1] = this.LLE();
        this.Features[2] = this.ONU();
        this.Features[3] = this.SLNU();
        this.Features[4] = this.LP();
        this.Features[5] = this.SLSE();
        this.Features[6] = this.LLSE();
        this.Features[7] = this.SLLOE();
        this.Features[8] = this.SLHOE();
        this.Features[9] = this.LLLOE();
        this.Features[10] = this.LLHOE();
        this.Features[11] = this.BARYO();
        this.Features[12] = this.BARYL();
        this.Features[13] = this.VARO(this.Features[11]);
        this.Features[14] = this.VARL(this.Features[12]);
        this.Features[15] = this.ORIE(this.Features[11], this.Features[12]);
    }

    private double SLE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LLE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double ONU() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            double v = 0.0;
            for (int s = 0; s < this.Width; ++s) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SLNU() {
        double val = 0.0;
        for (int s = 0; s < this.Width; ++s) {
            double v = 0.0;
            for (int n = 0; n < this.Height; ++n) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double LP() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return this.Sum / val;
    }

    private double SLSE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LLSE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double SLLOE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / (Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0));
            }
        }
        return val / this.Sum;
    }

    private double SLHOE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(n + 1) / (double)(s + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LLLOE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(s + 1) / (double)(n + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LLHOE() {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double BARYO() {
        int size = 0;
        double sumx = 0.0;
        double sumy = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                if (!(this.matrix[n][s] > 0.0)) continue;
                sumx += Math.cos(Math.toRadians(n));
                sumy += Math.sin(Math.toRadians(n));
                ++size;
            }
        }
        double Average2 = sumx >= 0.0 && sumy >= 0.0 ? Math.atan(sumy / sumx) : (sumx < 0.0 && sumy >= 0.0 ? Math.atan(-sumy / sumx) : (sumx >= 0.0 && sumy >= 0.0 ? Math.atan(-sumy / sumx) : Math.atan((sumy /= (double)size) / (sumx /= (double)size))));
        return Math.toDegrees(Average2);
    }

    private double BARYL() {
        double mean = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                mean += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double VARO(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += Math.pow(Math.min(Math.toRadians(n) - mean, Math.PI * 2 - Math.toRadians(n) - mean) * this.matrix[n][s], 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VARL(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += Math.pow(((double)(s + 1) - mean) * this.matrix[n][s], 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double ORIE(double bgl, double bs) {
        double m11 = 0.0;
        double m02 = 0.0;
        double m20 = 0.0;
        for (int n = 0; n < this.Height; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                double m = this.matrix[n][s];
                m11 += (double)(n + 1) * (double)(s + 1) * m;
                m02 += Math.pow(n + 1, 2.0) * m;
                m20 += Math.pow(s + 1, 2.0) * m;
            }
        }
        double a = m20 / this.Sum - bs * bs;
        double b = 2.0 * (m11 / this.Sum - bgl * bs);
        double c = m02 / this.Sum - bgl * bgl;
        return Math.atan(b / (a - c)) / 2.0;
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        return this.FeaturesNames;
    }
}

