/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.glglzm;

import arrayTiTi.ArrayOperations;
import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.glglzm.GrayLevelGeodesicLengthZoneMatrix;
import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import morphee.StructuringElement;
import morphee.levelings.Leveling;
import processing.reducer.ColorReducer;

public class MGlglzm
implements ComputableFeatures {
    protected GrayLevelGeodesicLengthZoneMatrix glglzm = new GrayLevelGeodesicLengthZoneMatrix();
    protected int GrayLevelMax = -1;
    protected int nbSizes = -1;
    protected int Width = -1;
    protected boolean FixedSize = false;
    protected double[][] matrix = null;
    protected double[] Coefficients = null;
    private final double[] Features = new double[16];
    private double Sum = 0.0;
    private final String[] FeaturesNames = new String[]{"SZE", "LZE", "LGZE", "HGZE", "SZLGE", "SZHGE", "LZLGE", "LZHGE", "GLNU", "SZNU", "ZPC", "BARYGL", "BARYS", "VARGL", "VARS", "ORIE"};

    @Override
    public synchronized void Kill() {
        throw new UnsupportedOperationException("Method not implemented (yet).");
    }

    public void Compute(BufferedImage image, BufferedImage mask, int nbSizes, boolean FixedSize, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, StructuringElement se, int nbCPU) {
        int nbCoefs;
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.nbSizes = nbSizes;
        this.FixedSize = FixedSize;
        switch (image.getType()) {
            case 10: {
                this.GrayLevelMax = 256;
                if (this.Coefficients == null || this.Coefficients.length != 8) {
                    this.AllocCoefficients(8);
                }
                if ((nbCoefs = this.Coefficients.length) == 8) break;
                throw new Error("Wrong number of coefficients (8 waited for BYTE_GRAY images): " + nbCoefs);
            }
            case 11: {
                this.GrayLevelMax = 65536;
                if (this.Coefficients == null || this.Coefficients.length != 16) {
                    this.AllocCoefficients(16);
                }
                if ((nbCoefs = this.Coefficients.length) == 16) break;
                throw new Error("Wrong number of coefficients (16 waited for USHORT_GRAY images): " + nbCoefs);
            }
            default: {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
        }
        double[][][] m = new double[nbCoefs][][];
        this.matrix = null;
        int n = 2;
        int nb = 0;
        while (n <= this.GrayLevelMax) {
            this.glglzm.FillMatrix(image, mask, n, nbSizes, FixedSize, reducer, leveling, ForbiddenValue, EightConnex, se, nbCPU);
            m[nb] = this.glglzm.matrix;
            n *= 2;
            ++nb;
        }
        this.Width = 0;
        for (n = 0; n < nbCoefs; ++n) {
            if (this.Width >= m[n][0].length) continue;
            this.Width = m[n][0].length;
        }
        this.matrix = new double[this.GrayLevelMax][this.Width];
        ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        n = 2;
        nb = 0;
        while (n <= this.GrayLevelMax) {
            int step = this.GrayLevelMax / n;
            int width = m[nb][0].length;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < n; ++y) {
                    for (int i2 = 0; i2 < step; ++i2) {
                        double[] dArray = this.matrix[step * y + i2];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + this.Coefficients[nb] * m[nb][y][x];
                    }
                }
            }
            n *= 2;
            ++nb;
        }
        m = null;
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    public void AllocCoefficients(int size) {
        this.AllocCoefficients(size, 2.0, 0.0);
    }

    public void AllocCoefficients(int size, double sigma, double decalage) {
        int x;
        double middle = (double)(size - 1) / 2.0 + decalage;
        if (this.Coefficients == null || this.Coefficients.length != size) {
            this.Coefficients = null;
            this.Coefficients = new double[size];
        }
        double sum = 0.0;
        for (x = 0; x < size; ++x) {
            double val;
            double d2 = Math.pow(middle - (double)x, 2.0) / (2.0 * sigma * sigma);
            this.Coefficients[x] = val = Math.exp(-d2);
            sum += val;
        }
        x = 0;
        while (x < size) {
            int n = x++;
            this.Coefficients[n] = this.Coefficients[n] / sum;
        }
    }

    private void ComputeFeatures() {
        this.Sum = 0.0;
        for (int y = 0; y < this.GrayLevelMax; ++y) {
            for (int x = 0; x < this.Width; ++x) {
                this.Sum += this.matrix[y][x];
            }
        }
        this.Features[0] = this.SSE();
        this.Features[1] = this.LSE();
        this.Features[2] = this.GLNU();
        this.Features[3] = this.SLNU();
        this.Features[4] = this.SP();
        this.Features[5] = this.LGLSE();
        this.Features[6] = this.HGLSE();
        this.Features[7] = this.SSLGLE();
        this.Features[8] = this.SSHGLE();
        this.Features[9] = this.LSLGLE();
        this.Features[10] = this.LSHGLE();
        this.Features[11] = this.VAR1();
        this.Features[12] = this.VAR2();
    }

    private double SSE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LSE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            double v = 0.0;
            for (int s = 0; s < this.Width; ++s) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SLNU() {
        double val = 0.0;
        for (int s = 0; s < this.Width; ++s) {
            double v = 0.0;
            for (int n = 0; n < this.GrayLevelMax; ++n) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SP() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return this.Sum / val;
    }

    private double LGLSE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HGLSE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double SSLGLE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / (Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0));
            }
        }
        return val / this.Sum;
    }

    private double SSHGLE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(n + 1) / (double)(s + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LSLGLE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(s + 1) / (double)(n + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LSHGLE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double VAR1() {
        int l;
        int n;
        double mean = 0.0;
        double val = 0.0;
        for (n = 0; n < this.GrayLevelMax; ++n) {
            for (l = 0; l < this.Width; ++l) {
                mean += (double)n * this.matrix[n][l];
            }
        }
        mean /= this.Sum;
        for (n = 0; n < this.GrayLevelMax; ++n) {
            for (l = 0; l < this.Width; ++l) {
                val += Math.pow((double)n * this.matrix[n][l] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VAR2() {
        int l;
        int n;
        double mean = 0.0;
        double val = 0.0;
        for (n = 0; n < this.GrayLevelMax; ++n) {
            for (l = 0; l < this.Width; ++l) {
                mean += (double)l * this.matrix[n][l];
            }
        }
        mean /= this.Sum;
        for (n = 0; n < this.GrayLevelMax; ++n) {
            for (l = 0; l < this.Width; ++l) {
                val += Math.pow((double)l * this.matrix[n][l] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        return this.FeaturesNames;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        throw new Error("Method not implemented (yet).");
    }

    @Override
    public void Parameters(Object ... parameters) {
    }
}

