/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.glglzm;

import arrayTiTi.ArrayOperations;
import imageTiTi.ImageComparator;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mathematics.Maths;
import measures.BasicMeasures;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FifoCcl;
import measures.hedgehop.GeodesicDiameter;
import morphee.StructuringElement;
import morphee.levelings.Leveling;
import processing.filters.Gaussian;
import processing.reducer.ColorReducer;

public class GrayLevelGeodesicLengthZoneMatrix {
    protected int nbGrayLevel = -1;
    protected int nbLength = -1;
    protected int Width = -1;
    protected boolean FixedSize = false;
    protected double[][] matrix = null;
    protected StructuringElement se = null;
    protected GeodesicDiameter gd = new GeodesicDiameter();
    protected BasicMeasures bbcps = new BasicMeasures();
    private final ConnectedComponentLabeling ccl = new FifoCcl();
    private final List<BufferedImage> list = new LinkedList<BufferedImage>();
    private final Gaussian gauss = new Gaussian(1, 1.0, 2);

    public void FillMatrix(BufferedImage image, BufferedImage mask, int nbGrayLevel, int nbLength, boolean FixedSize, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, StructuringElement se, int nbCPU) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        if (nbGrayLevel < 2) {
            throw new IllegalArgumentException("Number of gray level incorrect: " + nbGrayLevel + ", wish [2...2^N[");
        }
        this.nbGrayLevel = nbGrayLevel;
        this.nbLength = nbLength;
        this.FixedSize = FixedSize;
        if (FixedSize) {
            this.Width = nbLength;
            this.matrix = new double[nbGrayLevel][this.Width];
        }
        if (!Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("Number of gray level must be a power of 2: " + nbGrayLevel);
        }
        int height = image.getHeight();
        int width = image.getWidth();
        BufferedImage Reduced = null;
        int[] Map2 = null;
        BufferedImage vig = null;
        Reduced = leveling == null ? reducer.Reduce(image, nbGrayLevel, ForbiddenValue) : reducer.Reduce(leveling.Filter(image, nbCPU, this.gauss.Filter(image, nbCPU)), nbGrayLevel, ForbiddenValue);
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)Reduced, (int)0, (BufferedImage)Reduced);
        }
        this.ccl.Label(Reduced, 0, EightConnex);
        this.list.clear();
        int nbZones = this.ccl.ConnectedComponentsNumber();
        Map2 = this.ccl.Labels1D();
        int[] minx = new int[nbZones + 1];
        int[] maxx = new int[nbZones + 1];
        int[] miny = new int[nbZones + 1];
        int[] maxy = new int[nbZones + 1];
        for (int x = 0; x <= nbZones; ++x) {
            minx[x] = width;
            miny[x] = height;
            maxy[x] = 0;
            maxx[x] = 0;
        }
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (0 < Map2[pos]) {
                    int p = Map2[pos];
                    if (minx[p] > x) {
                        minx[p] = x;
                    }
                    if (maxx[p] < x) {
                        maxx[p] = x;
                    }
                    if (miny[p] > y) {
                        miny[p] = y;
                    }
                    if (maxy[p] < y) {
                        maxy[p] = y;
                    }
                }
                ++x;
                ++pos;
            }
        }
        WritableRaster wrred = Reduced.getRaster();
        WritableRaster wrvig = null;
        for (int i2 = 1; i2 <= nbZones; ++i2) {
            width = maxx[i2] - minx[i2] + 1;
            height = maxy[i2] - miny[i2] + 1;
            vig = new BufferedImage(width, height, image.getType());
            this.list.add(vig);
            wrvig = vig.getRaster();
            int pos2 = 0;
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    if (Map2[(miny[i2] + y) * width + minx[i2] + x] == i2) {
                        wrvig.setSample(x, y, 0, wrred.getSample(minx[i2] + x, miny[i2] + y, 0));
                    } else {
                        wrvig.setSample(x, y, 0, 0);
                    }
                    ++x;
                    ++pos2;
                }
            }
            wrvig = null;
            vig = null;
        }
        this.FillMatrix(this.list, se);
        minx = null;
        maxx = null;
        miny = null;
        maxy = null;
        wrred = null;
    }

    public void FillMatrix(List<BufferedImage> list, StructuringElement se) {
        if (se.getType() != -15) {
            throw new IllegalArgumentException("Only Montanary type SE required.");
        }
        this.se = se;
        int nb = 0;
        BufferedImage shape = null;
        int[] length = new int[list.size()];
        Iterator<BufferedImage> iter = list.iterator();
        int width = 0;
        while (iter.hasNext()) {
            shape = iter.next();
            if (!ImageTools.isGrayLevel((BufferedImage)shape)) {
                throw new IllegalArgumentException("Only gray level image required.");
            }
            this.bbcps.Compute(shape, true);
            if (this.bbcps.Boundary.Size() == 1) {
                length[nb++] = 1;
            } else {
                this.gd.Compute(shape, this.bbcps.Boundary, this.bbcps.Centroid, se, null, true);
                length[nb++] = (int)(this.gd.getLength() + 0.5) + 1;
            }
            if (width < length[nb - 1]) {
                width = length[nb - 1];
            }
            shape = null;
        }
        if (this.FixedSize) {
            ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
            for (int i2 = 1; i2 < nb; ++i2) {
                double[] dArray = this.matrix[this.FindColor(list.get(i2)) - 1];
                int n = (int)((double)(length[i2] - 1) / (double)width * (double)this.nbLength);
                dArray[n] = dArray[n] + 1.0;
            }
        } else {
            this.Width = width / this.nbLength + 1;
            this.matrix = null;
            this.matrix = new double[this.nbGrayLevel][this.Width];
            for (int i3 = 0; i3 < nb; ++i3) {
                double[] dArray = this.matrix[this.FindColor(list.get(i3)) - 1];
                int n = length[i3] / this.nbLength;
                dArray[n] = dArray[n] + 1.0;
            }
        }
    }

    private int FindColor(BufferedImage image) {
        WritableRaster wr = image.getRaster();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                return wr.getSample(x, y, 0);
            }
        }
        throw new Error("Color not found. This error must not occured.");
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.nbGrayLevel * this.nbLength * 3);
        for (int j = 0; j < this.nbGrayLevel; ++j) {
            for (int i2 = 0; i2 < this.nbLength; ++i2) {
                sb.append(this.matrix[j][i2]).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

