/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.glglzm;

import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.glglzm.GrayLevelGeodesicLengthZoneMatrix;
import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.util.List;
import morphee.StructuringElement;
import morphee.levelings.Leveling;
import processing.reducer.ColorReducer;

public class GlglzmFeatures
extends GrayLevelGeodesicLengthZoneMatrix
implements ComputableFeatures {
    private final double[] Features = new double[13];
    private double Sum = 0.0;
    private final String[] FeaturesNames = new String[]{"SRE", "LRE", "GLNU", "RLNU", "RP", "LGLRE", "HGLRE", "SRLGLE", "SRHLGE", "LRLGLE", "LRHGLE", "VAR1", "VAR2"};

    @Override
    public synchronized void Kill() {
        throw new UnsupportedOperationException("Method not implemented (yet).");
    }

    public void Compute(BufferedImage image, BufferedImage mask, int nbGrayLevel, int nbLength, boolean FixedSize, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, StructuringElement se, int nbCPU) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.FillMatrix(image, mask, nbGrayLevel, nbLength, FixedSize, reducer, leveling, ForbiddenValue, EightConnex, se, nbCPU);
        this.ComputeFeatures();
    }

    public void Compute(List<BufferedImage> list, StructuringElement se) {
        this.FillMatrix(list, se);
        this.ComputeFeatures();
    }

    private void ComputeFeatures() {
        this.Sum = 0.0;
        for (int y = 0; y < this.nbGrayLevel; ++y) {
            for (int x = 0; x < this.nbLength; ++x) {
                this.Sum += this.matrix[y][x];
            }
        }
        this.Features[0] = this.SSE();
        this.Features[1] = this.LSE();
        this.Features[2] = this.GLNU();
        this.Features[3] = this.SLNU();
        this.Features[4] = this.SP();
        this.Features[5] = this.LGLSE();
        this.Features[6] = this.HGLSE();
        this.Features[7] = this.SSLGLE();
        this.Features[8] = this.SSHGLE();
        this.Features[9] = this.LSLGLE();
        this.Features[10] = this.LSHGLE();
        this.Features[11] = this.VAR1();
        this.Features[12] = this.VAR2();
    }

    public void ComputeFromStack(BufferedImage[] images, BufferedImage[] masks, int nbGrayLevel, int nbLength, boolean FixedSize, ColorReducer reducer, Leveling leveling, int ForbiddenValue, boolean EightConnex, StructuringElement se, int nbCPU) {
        int j;
        int[] nbNanF1 = new int[this.Features.length];
        double[] F1 = new double[this.Features.length];
        for (int i2 = 0; i2 < images.length; ++i2) {
            this.Compute(images[i2], masks[i2], nbGrayLevel, nbLength, FixedSize, reducer, leveling, ForbiddenValue, EightConnex, se, nbCPU);
            for (j = 0; j < F1.length; ++j) {
                if (Double.isNaN(this.Features[j])) {
                    int n = j;
                    nbNanF1[n] = nbNanF1[n] + 1;
                    continue;
                }
                int n = j;
                F1[n] = F1[n] + this.Features[j];
            }
        }
        for (j = 0; j < F1.length; ++j) {
            this.Features[j] = F1[j] / (double)(images.length - nbNanF1[j]);
        }
        F1 = null;
        nbNanF1 = null;
    }

    private double SSE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.nbLength; ++s) {
                val += this.matrix[n][s] / Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LSE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.nbLength; ++s) {
                val += this.matrix[n][s] * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            double v = 0.0;
            for (int s = 0; s < this.nbLength; ++s) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SLNU() {
        double val = 0.0;
        for (int s = 0; s < this.nbLength; ++s) {
            double v = 0.0;
            for (int n = 0; n < this.nbGrayLevel; ++n) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double SP() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.nbLength; ++s) {
                val += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return this.Sum / val;
    }

    private double LGLSE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.nbLength; ++s) {
                val += this.matrix[n][s] / Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HGLSE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.nbLength; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double SSLGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.nbLength; ++s) {
                val += this.matrix[n][s] / (Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0));
            }
        }
        return val / this.Sum;
    }

    private double SSHGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.nbLength; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(n + 1) / (double)(s + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LSLGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.nbLength; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(s + 1) / (double)(n + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LSHGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.nbLength; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double VAR1() {
        int l;
        int n;
        double mean = 0.0;
        double val = 0.0;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.nbLength; ++l) {
                mean += (double)n * this.matrix[n][l];
            }
        }
        mean /= this.Sum;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.nbLength; ++l) {
                val += Math.pow((double)n * this.matrix[n][l] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VAR2() {
        int l;
        int n;
        double mean = 0.0;
        double val = 0.0;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.nbLength; ++l) {
                mean += (double)l * this.matrix[n][l];
            }
        }
        mean /= this.Sum;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.nbLength; ++l) {
                val += Math.pow((double)l * this.matrix[n][l] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        return this.FeaturesNames;
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        throw new Error("Method not yet implemented.");
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        throw new IllegalStateException("Method not implemented (yet).");
    }

    @Override
    public void Parameters(Object ... parameters) {
    }
}

