/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.dzm;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayOperations;
import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.GrayLevelDistanceZoneMatrix;
import dv.DV;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.reducer.ColorReducer;

public class MultiDZM
implements ComputableFeatures {
    protected GrayLevelDistanceZoneMatrix gldzm = new GrayLevelDistanceZoneMatrix();
    protected int GrayLevelMax = -1;
    protected int nbDistances = -1;
    protected int Width = -1;
    protected boolean FixedSize = false;
    protected boolean centroid = true;
    protected double[][] matrix = null;
    protected double[] Coefficients = null;
    protected StructuringElement se = null;
    protected StructuringElement3D se3 = null;
    protected ColorReducer reducer = null;
    protected int ForbiddenValue = -1;
    protected boolean EightConnex = true;
    private double[] Features = new double[16];
    private double Sum = 0.0;
    private final String[] FeaturesNames = new String[]{"MultiDZM_SDE", "MultiDZM_HDE", "MultiDZM_LGDE", "MultiDZM_HGZE", "MultiDZM_SDLGE", "MultiDZM_SDHGE", "MultiDZM_HDLGE", "MultiDZM_HDHGE", "MultiDZM_GLNU", "MultiDZM_DZNU", "MultiDZM_DPC", "MultiDZM_BARYGL", "MultiDZM_BARYD", "MultiDZM_VARGL", "MultiDZM_VARD", "MultiDZM_ORIE"};

    @Override
    public synchronized void Kill() {
        this.gldzm.Kill();
        this.gldzm = null;
        this.Coefficients = null;
        this.Features = null;
        Arrays.fill((Object[])this.matrix, null);
        this.matrix = null;
        this.reducer = null;
    }

    public void Compute(BufferedImage image, BufferedImage mask, int nbDistances, StructuringElement se, boolean centroid, boolean FixedSize, ColorReducer reducer, int ForbiddenValue, boolean EightConnex, int nbCPU) {
        int nbCoefs;
        switch (image.getType()) {
            case 10: {
                this.GrayLevelMax = 256;
                if (this.Coefficients == null || this.Coefficients.length != 8) {
                    this.AllocCoefficients(8);
                }
                if ((nbCoefs = this.Coefficients.length) == 8) break;
                throw new Error("Wrong number of coefficients (8 waited for BYTE_GRAY images): " + nbCoefs);
            }
            case 11: {
                this.GrayLevelMax = 65536;
                if (this.Coefficients == null || this.Coefficients.length != 16) {
                    this.AllocCoefficients(16);
                }
                if ((nbCoefs = this.Coefficients.length) == 16) break;
                throw new Error("Wrong number of coefficients (16 waited for USHORT_GRAY images): " + nbCoefs);
            }
            default: {
                throw new IllegalArgumentException("Only gray level images supported.");
            }
        }
        this.matrix = null;
        this.nbDistances = nbDistances;
        this.FixedSize = FixedSize;
        double[][][] m = new double[nbCoefs][][];
        this.matrix = null;
        int n = 2;
        int nb = 0;
        while (n <= this.GrayLevelMax) {
            this.gldzm.FillMatrix(image, mask, n, nbDistances, se, centroid, FixedSize, reducer, ForbiddenValue, EightConnex, nbCPU);
            m[nb] = this.gldzm.matrix;
            n *= 2;
            ++nb;
        }
        this.Width = 0;
        for (n = 0; n < nbCoefs; ++n) {
            if (this.Width >= m[n][0].length) continue;
            this.Width = m[n][0].length;
        }
        this.matrix = new double[this.GrayLevelMax][this.Width];
        ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        n = 2;
        nb = 0;
        while (n <= this.GrayLevelMax) {
            int step = this.GrayLevelMax / n;
            int width = m[nb][0].length;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < n; ++y) {
                    for (int i2 = 0; i2 < step; ++i2) {
                        double[] dArray = this.matrix[step * y + i2];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + this.Coefficients[nb] * m[nb][y][x];
                    }
                }
            }
            n *= 2;
            ++nb;
        }
        m = null;
        this.ComputeFeatures();
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Compute(image, mask, this.nbDistances, this.se, this.centroid, this.FixedSize, this.reducer, ForbiddenValue, this.EightConnex, nbCPU);
    }

    public void Compute(DV source, int nbDistances, StructuringElement3D se, boolean centroid, boolean FixedSize, ColorReducer reducer, int ForbiddenValue, boolean EightConnex, int nbCPU) {
        int nbCoefs;
        double[][][] m = null;
        switch (source.Type) {
            case 8: {
                this.GrayLevelMax = 256;
                if (this.Coefficients == null || this.Coefficients.length != 8) {
                    this.AllocCoefficients(8);
                }
                if ((nbCoefs = this.Coefficients.length) == 8) break;
                throw new Error("Wrong number of coefficients (8 waited for BYTE_GRAY volumes): " + nbCoefs);
            }
            case 16: {
                this.GrayLevelMax = 65536;
                if (this.Coefficients == null || this.Coefficients.length != 16) {
                    this.AllocCoefficients(16);
                }
                if ((nbCoefs = this.Coefficients.length) == 16) break;
                throw new Error("Wrong number of coefficients (16 waited for USHORT_GRAY volumes): " + nbCoefs);
            }
            default: {
                throw new IllegalArgumentException("Only gray level volumess supported.");
            }
        }
        this.matrix = null;
        this.nbDistances = nbDistances;
        this.FixedSize = FixedSize;
        m = new double[nbCoefs][][];
        this.matrix = null;
        int n = 2;
        int nb = 0;
        while (n <= this.GrayLevelMax) {
            this.gldzm.FillMatrix(source, n, nbDistances, se, centroid, FixedSize, reducer, ForbiddenValue, EightConnex, nbCPU);
            m[nb] = this.gldzm.matrix;
            n *= 2;
            ++nb;
        }
        this.Width = 0;
        for (n = 0; n < nbCoefs; ++n) {
            if (this.Width >= m[n][0].length) continue;
            this.Width = m[n][0].length;
        }
        this.matrix = new double[this.GrayLevelMax][this.Width];
        ArrayOperations.Fill((double[][])this.matrix, (double)0.0);
        n = 2;
        nb = 0;
        while (n <= this.GrayLevelMax) {
            int step = this.GrayLevelMax / n;
            int width = m[nb][0].length;
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < n; ++y) {
                    for (int i2 = 0; i2 < step; ++i2) {
                        double[] dArray = this.matrix[step * y + i2];
                        int n2 = x;
                        dArray[n2] = dArray[n2] + this.Coefficients[nb] * m[nb][y][x];
                    }
                }
            }
            n *= 2;
            ++nb;
        }
        m = null;
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV source, int nbCPU) {
        this.Compute(source, this.nbDistances, this.se3, this.centroid, this.FixedSize, this.reducer, this.ForbiddenValue, this.EightConnex, nbCPU);
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    public void AllocCoefficients(int size) {
        this.AllocCoefficients(size, 2.0, 0.0);
    }

    public void AllocCoefficients(int size, double sigma, double decalage) {
        double middle = (double)(size - 1) / 2.0 + decalage;
        if (this.Coefficients == null || this.Coefficients.length != size) {
            this.Coefficients = null;
            this.Coefficients = new double[size];
        }
        double sum = 0.0;
        for (int x = 0; x < size; ++x) {
            double val;
            double d2 = (middle - (double)x) * (middle - (double)x) / (2.0 * sigma * sigma);
            this.Coefficients[x] = val = Math.exp(-d2);
            sum += val;
        }
        ArrayArithmetic.Divide((double[])this.Coefficients, (double)sum, (double[])this.Coefficients);
    }

    private void ComputeFeatures() {
        this.Sum = 0.0;
        for (int y = 0; y < this.GrayLevelMax; ++y) {
            for (int x = 0; x < this.Width; ++x) {
                this.Sum += this.matrix[y][x];
            }
        }
        this.Features[0] = this.SDE();
        this.Features[1] = this.HDE();
        this.Features[2] = this.LGDE();
        this.Features[3] = this.HGDE();
        this.Features[4] = this.SDLGE();
        this.Features[5] = this.SDHGE();
        this.Features[6] = this.HDLGE();
        this.Features[7] = this.HDHGE();
        this.Features[8] = this.GLNU();
        this.Features[9] = this.DZNU();
        this.Features[10] = this.DPC();
        this.Features[11] = this.BARYGL();
        this.Features[12] = this.BARYD();
        this.Features[13] = this.VARGL(this.Features[11]);
        this.Features[14] = this.VARD(this.Features[12]);
        this.Features[15] = this.ORIE(this.Features[11], this.Features[12]);
    }

    private double SDE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HDE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LGDE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HGDE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double SDLGE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / (Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0));
            }
        }
        return val / this.Sum;
    }

    private double SDHGE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(n + 1) / (double)(s + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HDLGE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(s + 1) / (double)(n + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HDHGE() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            double v = 0.0;
            for (int s = 0; s < this.Width; ++s) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double DZNU() {
        double val = 0.0;
        for (int s = 0; s < this.Width; ++s) {
            double v = 0.0;
            for (int n = 0; n < this.GrayLevelMax; ++n) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double DPC() {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return this.Sum / val;
    }

    private double BARYGL() {
        double mean = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                mean += (double)(n + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double BARYD() {
        double mean = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                mean += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double VARGL(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += Math.pow((double)(n + 1) * this.matrix[n][s] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VARD(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += Math.pow((double)(s + 1) * this.matrix[n][s] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double ORIE(double bgl, double bs) {
        double m11 = 0.0;
        double m02 = 0.0;
        double m20 = 0.0;
        for (int n = 0; n < this.GrayLevelMax; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                double m = this.matrix[n][s];
                m11 += (double)(n + 1) * (double)(s + 1) * m;
                m02 = Math.pow(n + 1, 2.0) * m;
                m20 = Math.pow(s + 1, 2.0) * m;
            }
        }
        double a = m20 / this.Sum - bs * bs;
        double b = 2.0 * (m11 / this.Sum - bgl * bs);
        double c = m02 / this.Sum - bgl * bgl;
        return Math.atan(b / (a - c)) / 2.0;
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        return this.FeaturesNames;
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 7) {
            throw new IllegalArgumentException("Exactly 7 parameters are required.");
        }
        this.nbDistances = (Integer)parameters[0];
        if (parameters[1] instanceof StructuringElement) {
            this.se = (StructuringElement)parameters[1];
        } else if (parameters[1] instanceof StructuringElement3D) {
            this.se3 = (StructuringElement3D)parameters[1];
        } else {
            throw new IllegalArgumentException("The second parameter is not ");
        }
        this.centroid = (Boolean)parameters[2];
        this.FixedSize = (Boolean)parameters[3];
        this.reducer = (ColorReducer)parameters[4];
        this.ForbiddenValue = (Integer)parameters[5];
        this.EightConnex = (Boolean)parameters[6];
    }
}

