/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.dzm;

import dv.DV;
import dv.DvTools;
import imageTiTi.ImageComparator;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import mathematics.Maths;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.UnionFindCcl;
import measures.hedgehop.DistanceMap3DComputer;
import measures.hedgehop.DistanceMapComputer;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.reducer.ColorReducer;

public class GrayLevelDistanceZoneMatrix {
    protected int nbGrayLevel = -1;
    protected int nbDistances = -1;
    protected int Width = -1;
    protected boolean FixedSize = false;
    protected boolean centroid = true;
    protected double[][] matrix = null;
    protected float[] distances = null;
    private ConnectedComponentLabeling ccl = new UnionFindCcl();
    private DistanceMapComputer dmc = new DistanceMapComputer();
    private DistanceMap3DComputer dmc3 = new DistanceMap3DComputer();
    protected StructuringElement se = null;
    protected StructuringElement3D se3 = null;
    protected ColorReducer reducer = null;
    protected int ForbiddenValue = -1;
    protected boolean EightConnex = true;

    public synchronized void Kill() {
        this.dmc.Kill();
        this.dmc = null;
        this.dmc3.Kill();
        this.dmc3 = null;
        this.ccl.Kill();
        this.ccl = null;
        this.distances = null;
        for (int i2 = 0; i2 < this.matrix.length; ++i2) {
            this.matrix[i2] = null;
        }
        this.matrix = null;
    }

    public void FillMatrix(BufferedImage image, BufferedImage mask, int nbGrayLevel, int nbDistances, StructuringElement se, boolean centroid, boolean FixedSize, ColorReducer reducer, int ForbiddenValue, boolean EightConnex, int nbCPU) {
        int i2;
        if (nbGrayLevel < 2 || !Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("Number of gray level must be dyadic [2...2^N[");
        }
        if (nbDistances < 1) {
            throw new IllegalArgumentException("Wrong value nbDistances: " + nbDistances + ", wait [2...[.");
        }
        if (se.getType() != -15) {
            throw new IllegalArgumentException("Montanari structuring element required.");
        }
        this.nbGrayLevel = nbGrayLevel;
        this.nbDistances = nbDistances;
        this.se = se;
        this.centroid = centroid;
        this.FixedSize = FixedSize;
        this.reducer = reducer;
        if (FixedSize) {
            this.Width = nbDistances + 1;
            this.matrix = new double[nbGrayLevel][this.Width];
        }
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        int height = image.getHeight();
        int width = image.getWidth();
        BufferedImage Reduced = reducer.Reduce(image, nbGrayLevel, ForbiddenValue);
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)Reduced, (int)0, (BufferedImage)Reduced);
        }
        int nb = this.ccl.Label(Reduced, 0, EightConnex);
        int[] Labels = this.ccl.Labels1D();
        int[] Correspondances = new int[nb + 1];
        this.FindValues(Labels, width, height, Reduced, Correspondances);
        if (this.distances == null || this.distances.length < nb + 1) {
            this.distances = null;
            this.distances = new float[nb + 1];
        }
        Arrays.fill(this.distances, (float)(width + height));
        this.dmc.Compute(Reduced, se);
        float[] map = this.dmc.getMontanariMap1D();
        if (!centroid) {
            switch (Reduced.getType()) {
                case 10: {
                    byte[] bb = ((DataBufferByte)Reduced.getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < bb.length; ++x) {
                        if (bb[x] == 0 || !(this.distances[Labels[x]] > map[x])) continue;
                        this.distances[Labels[x]] = map[x];
                    }
                    bb = null;
                    break;
                }
                case 11: {
                    short[] sb = ((DataBufferUShort)Reduced.getRaster().getDataBuffer()).getData();
                    for (int x = 0; x < sb.length; ++x) {
                        if (sb[x] == 0 || !(this.distances[Labels[x]] > map[x])) continue;
                        this.distances[Labels[x]] = map[x];
                    }
                    sb = null;
                    break;
                }
                default: {
                    int pos = 0;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            if (Reduced.getRaster().getSample(x, y, 0) != 0 && this.distances[Labels[pos]] > map[pos]) {
                                this.distances[Labels[pos]] = map[pos];
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
            }
        } else {
            float[] X = new float[nb + 1];
            float[] Y = new float[nb + 1];
            float[] N = new float[nb + 1];
            Arrays.fill(X, 0.0f);
            Arrays.fill(Y, 0.0f);
            Arrays.fill(N, 0.0f);
            int pos = 0;
            for (int y = 0; y < height; ++y) {
                int x = 0;
                while (x < width) {
                    if (Reduced.getRaster().getSample(x, y, 0) != 0) {
                        int i3;
                        int n = i3 = Labels[pos];
                        X[n] = X[n] + (float)x;
                        int n2 = i3;
                        Y[n2] = Y[n2] + (float)y;
                        int n3 = i3;
                        N[n3] = N[n3] + 1.0f;
                    }
                    ++x;
                    ++pos;
                }
            }
            for (int i4 = 1; i4 <= nb; ++i4) {
                this.distances[i4] = map[(int)((double)(Y[i4] / N[i4]) + 0.5) * width + (int)((double)(X[i4] / N[i4]) + 0.5)];
            }
            N = null;
            Y = null;
            X = null;
        }
        float max = this.distances[1];
        for (i2 = 2; i2 <= nb; ++i2) {
            if (!(this.distances[i2] > max)) continue;
            max = this.distances[i2];
        }
        if (FixedSize) {
            double a = (double)(nbDistances - 1) / (double)(max - 1.0f);
            double b = 1.0 - a;
            for (double[] row : this.matrix) {
                Arrays.fill(row, 0.0);
            }
            for (int i5 = 1; i5 < Correspondances.length; ++i5) {
                if (Correspondances[i5] < 0) continue;
                double[] dArray = this.matrix[Correspondances[i5]];
                int n = (int)(a * (double)this.distances[i5] + b);
                dArray[n] = dArray[n] + 1.0;
            }
        } else {
            this.Width = (int)max / nbDistances + 1;
            this.matrix = null;
            this.matrix = new double[nbGrayLevel][this.Width];
            for (i2 = 1; i2 < Correspondances.length; ++i2) {
                if (Correspondances[i2] < 0) continue;
                double[] dArray = this.matrix[Correspondances[i2]];
                int n = (int)this.distances[i2] / nbDistances;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        map = null;
        Labels = null;
        Correspondances = null;
    }

    public void FillMatrix(BufferedImage ImageReduced, ConnectedComponentLabeling Ccl) {
        if (!ImageTools.isGrayLevel((BufferedImage)ImageReduced)) {
            throw new IllegalArgumentException("Only gray level images are supported.");
        }
        int height = ImageReduced.getHeight();
        int width = ImageReduced.getWidth();
        int nb = Ccl.ConnectedComponentsNumber();
        if (this.distances == null || this.distances.length < nb + 1) {
            this.distances = null;
            this.distances = new float[nb + 1];
        }
        Arrays.fill(this.distances, (float)(width + height));
        int[] Correspondances = new int[nb + 1];
        int[] Labels = Ccl.Labels1D();
        this.FindValues(Labels, width, height, ImageReduced, Correspondances);
        this.dmc.Compute(ImageReduced, this.se);
        float[] map = this.dmc.getMontanariMap1D();
        switch (ImageReduced.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)ImageReduced.getRaster().getDataBuffer()).getData();
                for (int pos = 0; pos < bb.length; ++pos) {
                    if (bb[pos] == 0 || !(this.distances[Labels[pos]] > map[pos])) continue;
                    this.distances[Labels[pos]] = map[pos];
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)ImageReduced.getRaster().getDataBuffer()).getData();
                for (int pos = 0; pos < sb.length; ++pos) {
                    if (sb[pos] == 0 || !(this.distances[Labels[pos]] > map[pos])) continue;
                    this.distances[Labels[pos]] = map[pos];
                }
                sb = null;
                break;
            }
            default: {
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (ImageReduced.getRaster().getSample(x, y, 0) != 0 && this.distances[Labels[pos]] > map[pos]) {
                            this.distances[Labels[pos]] = map[pos];
                        }
                        ++x;
                        ++pos;
                    }
                }
            }
        }
        float max = this.distances[1];
        for (int i2 = 2; i2 <= nb; ++i2) {
            if (!(this.distances[i2] > max)) continue;
            max = this.distances[i2];
        }
        double a = (double)(this.nbDistances - 1) / (double)(max - 1.0f);
        double b = 1.0 - a;
        for (int i3 = 1; i3 < Correspondances.length; ++i3) {
            if (Correspondances[i3] < 0) continue;
            double[] dArray = this.matrix[Correspondances[i3]];
            int n = (int)(a * (double)this.distances[i3] + b);
            dArray[n] = dArray[n] + 1.0;
        }
        map = null;
        Labels = null;
        Correspondances = null;
    }

    private void FindValues(int[] Labels, int width, int height, BufferedImage Reduced, int[] Correspondances) {
        switch (Reduced.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)Reduced.getRaster().getDataBuffer()).getData();
                for (int pos = 0; pos < bb.length; ++pos) {
                    if (0 >= Labels[pos]) continue;
                    Correspondances[Labels[pos]] = (bb[pos] & 0xFF) - 1;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)Reduced.getRaster().getDataBuffer()).getData();
                for (int pos = 0; pos < sb.length; ++pos) {
                    if (0 >= Labels[pos]) continue;
                    Correspondances[Labels[pos]] = (sb[pos] & 0xFFFF) - 1;
                }
                sb = null;
                break;
            }
            default: {
                WritableRaster wr = Reduced.getRaster();
                int pos = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (0 < Labels[pos]) {
                            Correspondances[Labels[pos]] = wr.getSample(x, y, 0) - 1;
                        }
                        ++x;
                        ++pos;
                    }
                }
                wr = null;
            }
        }
    }

    public void FillMatrix(DV source, int nbGrayLevel, int nbDistances, StructuringElement3D se, boolean centroid, boolean FixedSize, ColorReducer reducer, int ForbiddenValue, boolean TwentySixConnex, int nbCPU) {
        int i2;
        float[] map;
        int[] Correspondances;
        int[] Labels;
        int nb;
        block41: {
            int x;
            DV Reduced;
            block40: {
                if (nbGrayLevel < 2 || !Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
                    throw new IllegalArgumentException("Number of gray level must be dyadic [2...2^N[");
                }
                if (nbDistances < 1) {
                    throw new IllegalArgumentException("Wrong value nbDistances: " + nbDistances + ", wait [2...[.");
                }
                if (se.getType() != -15) {
                    throw new IllegalArgumentException("Montanari structuring element required.");
                }
                this.nbGrayLevel = nbGrayLevel;
                this.nbDistances = nbDistances;
                this.se3 = se;
                this.centroid = centroid;
                this.FixedSize = FixedSize;
                this.reducer = reducer;
                if (FixedSize) {
                    this.Width = nbDistances + 1;
                    this.matrix = new double[nbGrayLevel][this.Width];
                }
                if (!DvTools.isGrayLevel((DV)source)) {
                    throw new IllegalArgumentException("Only gray level volumes are supported.");
                }
                Reduced = reducer.Reduce(source, nbGrayLevel, ForbiddenValue);
                nb = this.ccl.Label(Reduced, 0, this.EightConnex);
                Labels = this.ccl.Labels1D();
                Correspondances = new int[nb + 1];
                this.FindValues(Labels, Reduced, Correspondances);
                if (this.distances == null || this.distances.length < nb + 1) {
                    this.distances = null;
                    this.distances = new float[nb + 1];
                }
                Arrays.fill(this.distances, (float)(source.SizeX + source.SizeY + source.SizeZ));
                this.dmc3.Compute(Reduced, se);
                map = this.dmc3.MontanariMap1D();
                if (centroid) break block40;
                switch (Reduced.Type) {
                    case 8: {
                        byte[] bb = Reduced.getDataBufferByte(0);
                        for (x = 0; x < bb.length; ++x) {
                            if (bb[x] == 0 || !(this.distances[Labels[x]] > map[x])) continue;
                            this.distances[Labels[x]] = map[x];
                        }
                        bb = null;
                        break block41;
                    }
                    case 16: {
                        short[] sb = Reduced.getDataBufferShort(0);
                        for (x = 0; x < sb.length; ++x) {
                            if (sb[x] == 0 || !(this.distances[Labels[x]] > map[x])) continue;
                            this.distances[Labels[x]] = map[x];
                        }
                        sb = null;
                        break block41;
                    }
                    case 32: {
                        int[] ib = Reduced.getDataBufferInt(0);
                        for (x = 0; x < ib.length; ++x) {
                            if (ib[x] == 0 || !(this.distances[Labels[x]] > map[x])) continue;
                            this.distances[Labels[x]] = map[x];
                        }
                        ib = null;
                        break block41;
                    }
                    default: {
                        throw new IllegalArgumentException("DV type not supported.");
                    }
                }
            }
            float[] X = new float[nb + 1];
            float[] Y = new float[nb + 1];
            float[] Z = new float[nb + 1];
            float[] N = new float[nb + 1];
            Arrays.fill(X, 0.0f);
            Arrays.fill(Y, 0.0f);
            Arrays.fill(Z, 0.0f);
            Arrays.fill(N, 0.0f);
            switch (Reduced.Type) {
                case 8: {
                    int y;
                    int z;
                    byte[] bb = Reduced.getDataBufferByte(0);
                    int pos = 0;
                    for (z = 0; z < source.SizeZ; ++z) {
                        for (y = 0; y < source.SizeY; ++y) {
                            x = 0;
                            while (x < source.SizeX) {
                                if (bb[pos] != 0) {
                                    int n = i2 = Labels[pos];
                                    X[n] = X[n] + (float)x;
                                    int n2 = i2;
                                    Y[n2] = Y[n2] + (float)y;
                                    int n3 = i2;
                                    Z[n3] = Z[n3] + (float)z;
                                    int n4 = i2;
                                    N[n4] = N[n4] + 1.0f;
                                }
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    bb = null;
                    break;
                }
                case 16: {
                    int y;
                    int z;
                    short[] sb = Reduced.getDataBufferShort(0);
                    int pos = 0;
                    for (z = 0; z < source.SizeZ; ++z) {
                        for (y = 0; y < source.SizeY; ++y) {
                            x = 0;
                            while (x < source.SizeX) {
                                if (sb[pos] != 0) {
                                    int n = i2 = Labels[pos];
                                    X[n] = X[n] + (float)x;
                                    int n5 = i2;
                                    Y[n5] = Y[n5] + (float)y;
                                    int n6 = i2;
                                    Z[n6] = Z[n6] + (float)z;
                                    int n7 = i2;
                                    N[n7] = N[n7] + 1.0f;
                                }
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    sb = null;
                    break;
                }
                case 32: {
                    int y;
                    int z;
                    int[] ib = Reduced.getDataBufferInt(0);
                    int pos = 0;
                    for (z = 0; z < source.SizeZ; ++z) {
                        for (y = 0; y < source.SizeY; ++y) {
                            x = 0;
                            while (x < source.SizeX) {
                                if (ib[pos] != 0) {
                                    int n = i2 = Labels[pos];
                                    X[n] = X[n] + (float)x;
                                    int n8 = i2;
                                    Y[n8] = Y[n8] + (float)y;
                                    int n9 = i2;
                                    Z[n9] = Z[n9] + (float)z;
                                    int n10 = i2;
                                    N[n10] = N[n10] + 1.0f;
                                }
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    ib = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported.");
                }
            }
            for (i2 = 1; i2 <= nb; ++i2) {
                this.distances[i2] = map[(int)(Z[i2] / N[i2] + 0.5f) * source.LayerSize + (int)(Y[i2] / N[i2] + 0.5f) * source.SizeX + (int)(X[i2] / N[i2] + 0.5f)];
            }
            N = null;
            Z = null;
            Y = null;
            X = null;
        }
        float max = this.distances[1];
        for (i2 = 2; i2 <= nb; ++i2) {
            if (!(this.distances[i2] > max)) continue;
            max = this.distances[i2];
        }
        if (FixedSize) {
            double a = (double)(nbDistances - 1) / (double)(max - 1.0f);
            double b = 1.0 - a;
            for (double[] row : this.matrix) {
                Arrays.fill(row, 0.0);
            }
            for (i2 = 1; i2 < Correspondances.length; ++i2) {
                if (Correspondances[i2] < 0) continue;
                double[] dArray = this.matrix[Correspondances[i2]];
                int n = (int)(a * (double)this.distances[i2] + b);
                dArray[n] = dArray[n] + 1.0;
            }
        } else {
            this.Width = (int)max / nbDistances + 1;
            this.matrix = null;
            this.matrix = new double[nbGrayLevel][this.Width];
            for (i2 = 1; i2 < Correspondances.length; ++i2) {
                try {
                    if (Correspondances[i2] < 0) continue;
                    double[] dArray = this.matrix[Correspondances[i2]];
                    int n = (int)this.distances[i2] / nbDistances;
                    dArray[n] = dArray[n] + 1.0;
                    continue;
                }
                catch (Exception e) {
                    System.out.println(this.distances[i2]);
                    e.printStackTrace();
                    System.exit(0);
                }
            }
        }
        map = null;
        Labels = null;
        Correspondances = null;
    }

    private void FindValues(int[] Labels, DV Reduced, int[] Correspondances) {
        switch (Reduced.Type) {
            case 8: {
                byte[] bb = Reduced.getDataBufferByte(0);
                for (int pos = 0; pos < bb.length; ++pos) {
                    if (0 >= Labels[pos]) continue;
                    Correspondances[Labels[pos]] = (bb[pos] & 0xFF) - 1;
                }
                bb = null;
                break;
            }
            case 16: {
                short[] sb = Reduced.getDataBufferShort(0);
                for (int pos = 0; pos < sb.length; ++pos) {
                    if (0 >= Labels[pos]) continue;
                    Correspondances[Labels[pos]] = (sb[pos] & 0xFFFF) - 1;
                }
                sb = null;
                break;
            }
            case 32: {
                int[] ib = Reduced.getDataBufferInt(0);
                for (int pos = 0; pos < ib.length; ++pos) {
                    if (0 >= Labels[pos]) continue;
                    Correspondances[Labels[pos]] = ib[pos] - 1;
                }
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.nbGrayLevel * this.nbDistances * 3);
        for (int j = 0; j < this.nbGrayLevel; ++j) {
            for (int i2 = 0; i2 <= this.nbDistances; ++i2) {
                sb.append(this.matrix[j][i2]).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 8) {
            throw new IllegalArgumentException("Exactly 8 parameters are required.");
        }
        this.nbGrayLevel = (Integer)parameters[0];
        this.nbDistances = (Integer)parameters[1];
        if (parameters[2] instanceof StructuringElement) {
            this.se = (StructuringElement)parameters[2];
        } else if (parameters[2] instanceof StructuringElement3D) {
            this.se3 = (StructuringElement3D)parameters[2];
        } else {
            throw new IllegalArgumentException("The third parameter is not a structuring element (2D or 3D).");
        }
        this.centroid = (Boolean)parameters[3];
        this.FixedSize = (Boolean)parameters[4];
        this.reducer = (ColorReducer)parameters[5];
        this.ForbiddenValue = (Integer)parameters[6];
        this.EightConnex = (Boolean)parameters[7];
    }
}

