/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.dzm;

import characterization.ComputableFeatures;
import characterization.textures.statisticalmatrices.thibaultmatrices.dzm.GrayLevelDistanceZoneMatrix;
import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import measures.cclh.ConnectedComponentLabeling;
import morphee.StructuringElement;
import morphee.StructuringElement3D;
import processing.reducer.ColorReducer;

public class DZMfeatures
extends GrayLevelDistanceZoneMatrix
implements ComputableFeatures {
    private double[] Features = new double[16];
    private double Sum = 0.0;
    private String[] FeaturesNames = new String[]{"DZM_SDE", "DZM_HDE", "DZM_LGDE", "DZM_HGZE", "DZM_SDLGE", "DZM_SDHGE", "DZM_HDLGE", "DZM_HDHGE", "DZM_GLNU", "DZM_DZNU", "DZM_DPC", "DZM_BARYGL", "DZM_BARYD", "DZM_VARGL", "DZM_VARD", "DZM_ORIE"};

    @Override
    public synchronized void Kill() {
        super.Kill();
        this.FeaturesNames = null;
        this.Features = null;
    }

    public void Compute(BufferedImage image, BufferedImage mask, int nbGrayLevel, int nbDistances, StructuringElement se, boolean centroid, boolean FixedSize, ColorReducer reducer, int ForbiddenValue, boolean EightConnex, int nbCPU) {
        this.FillMatrix(image, mask, nbGrayLevel, nbDistances, se, centroid, FixedSize, reducer, ForbiddenValue, EightConnex, nbCPU);
        this.ComputeFeatures();
    }

    public void Compute(BufferedImage ImageReduced, ConnectedComponentLabeling Ccl) {
        if (!ImageTools.isGrayLevel((BufferedImage)ImageReduced)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.FillMatrix(ImageReduced, Ccl);
        this.ComputeFeatures();
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        this.Compute(image, mask, this.nbGrayLevel, this.nbDistances, this.se, this.centroid, this.FixedSize, this.reducer, ForbiddenValue, this.EightConnex, nbCPU);
        this.ComputeFeatures();
    }

    public void Compute(DV source, int nbGrayLevel, int nbDistances, StructuringElement3D se, boolean centroid, boolean FixedSize, ColorReducer reducer, int ForbiddenValue, boolean EightConnex, int nbCPU) {
        this.FillMatrix(source, nbGrayLevel, nbDistances, se, centroid, FixedSize, reducer, ForbiddenValue, EightConnex, nbCPU);
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV source, int nbCPU) {
        this.Compute(source, this.nbGrayLevel, this.nbDistances, this.se3, this.centroid, this.FixedSize, this.reducer, this.ForbiddenValue, this.EightConnex, nbCPU);
        this.ComputeFeatures();
    }

    private void ComputeFeatures() {
        this.Sum = 0.0;
        for (int y = 0; y < this.nbGrayLevel; ++y) {
            for (int x = 0; x < this.Width; ++x) {
                this.Sum += this.matrix[y][x];
            }
        }
        this.Features[0] = this.SDE();
        this.Features[1] = this.HDE();
        this.Features[2] = this.LGDE();
        this.Features[3] = this.HGDE();
        this.Features[4] = this.SDLGE();
        this.Features[5] = this.SDHGE();
        this.Features[6] = this.HDLGE();
        this.Features[7] = this.HDHGE();
        this.Features[8] = this.GLNU();
        this.Features[9] = this.DZNU();
        this.Features[10] = this.DPC();
        this.Features[11] = this.BARYGL();
        this.Features[12] = this.BARYD();
        this.Features[13] = this.VARGL(this.Features[11]);
        this.Features[14] = this.VARD(this.Features[12]);
        this.Features[15] = this.ORIE(this.Features[11], this.Features[12]);
    }

    public void ComputeFromStack(BufferedImage[] images, BufferedImage[] masks, int nbGrayLevel, int nbDistances, StructuringElement se, boolean centroid, boolean FixedSize, ColorReducer reducer, int ForbiddenValue, boolean EightConnex, int nbCPU) {
        int[] nbNanF1 = new int[this.Features.length];
        double[] F1 = new double[this.Features.length];
        for (int i2 = 0; i2 < images.length; ++i2) {
            this.Compute(images[i2], masks[i2], nbGrayLevel, nbDistances, se, centroid, FixedSize, reducer, ForbiddenValue, EightConnex, nbCPU);
            for (int j = 0; j < F1.length; ++j) {
                if (Double.isNaN(this.Features[j])) {
                    int n = j;
                    nbNanF1[n] = nbNanF1[n] + 1;
                    continue;
                }
                int n = j;
                F1[n] = F1[n] + this.Features[j];
            }
        }
        for (int j = 0; j < F1.length; ++j) {
            this.Features[j] = F1[j] / (double)(images.length - nbNanF1[j]);
        }
        F1 = null;
        nbNanF1 = null;
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    private double SDE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HDE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LGDE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HGDE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double SDLGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] / (Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0));
            }
        }
        return val / this.Sum;
    }

    private double SDHGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(n + 1) / (double)(s + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HDLGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow((double)(s + 1) / (double)(n + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HDHGE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += this.matrix[n][s] * Math.pow(n + 1, 2.0) * Math.pow(s + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            double v = 0.0;
            for (int s = 0; s < this.Width; ++s) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double DZNU() {
        double val = 0.0;
        for (int s = 0; s < this.Width; ++s) {
            double v = 0.0;
            for (int n = 0; n < this.nbGrayLevel; ++n) {
                v += this.matrix[n][s];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double DPC() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return this.Sum / val;
    }

    private double BARYGL() {
        double mean = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                mean += (double)(n + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double BARYD() {
        double mean = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                mean += (double)(s + 1) * this.matrix[n][s];
            }
        }
        return mean / this.Sum;
    }

    private double VARGL(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += Math.pow((double)(n + 1) * this.matrix[n][s] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VARD(double mean) {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                val += Math.pow((double)(s + 1) * this.matrix[n][s] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double ORIE(double bgl, double bs) {
        double m11 = 0.0;
        double m02 = 0.0;
        double m20 = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int s = 0; s < this.Width; ++s) {
                double m = this.matrix[n][s];
                m11 += (double)(n + 1) * (double)(s + 1) * m;
                m02 += (double)((n + 1) * (n + 1)) * m;
                m20 += (double)((s + 1) * (s + 1)) * m;
            }
        }
        double a = m20 / this.Sum - bs * bs;
        double b = 2.0 * (m11 / this.Sum - bgl * bs);
        double c = m02 / this.Sum - bgl * bgl;
        return Math.atan(b / (a - c)) / 2.0;
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        return this.FeaturesNames;
    }
}

