/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.thibaultmatrices.czm;

import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.List;
import mathematics.Maths;
import measures.cclh.ConnectedComponentLabeling;
import measures.cclh.FifoCcl;
import processing.reducer.ColorReducer;

public class GrayLevelCooccurrenceZoneMatrix {
    protected int nbGrayLevel = 32;
    protected double[][] matrix = null;
    private int[][] Neighborhoods = null;
    protected BufferedImage Reduced = null;
    private final ConnectedComponentLabeling ccl = new FifoCcl();

    public GrayLevelCooccurrenceZoneMatrix(int nbGrayLevel) {
        if (nbGrayLevel < 2) {
            throw new IllegalArgumentException("Number of gray level incorrect: " + nbGrayLevel + ", wish [2...2^N[");
        }
        this.nbGrayLevel = nbGrayLevel;
        if (!Maths.isPowerOf((int)nbGrayLevel, (int)2)) {
            throw new IllegalArgumentException("Number of gray level must be a power of 2: " + nbGrayLevel);
        }
    }

    public void FillMatrix(BufferedImage image, ColorReducer reducer, int ForbiddenValue, boolean EightConnex) {
        int x;
        int y;
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        this.Reduced = null;
        this.Reduced = reducer.Reduce(image, this.nbGrayLevel, ForbiddenValue);
        int width = this.Reduced.getWidth();
        int height = this.Reduced.getHeight();
        this.ccl.Label(this.Reduced, 0, EightConnex);
        int[] Labels = this.ccl.Labels1D();
        int[] Sizes = this.ccl.Sizes();
        int[] Correspondances = new int[Sizes.length];
        this.FindValues(Labels, width, height, Correspondances);
        this.Neighborhoods = null;
        this.Neighborhoods = new int[this.ccl.ConnectedComponentsNumber() + 1][this.ccl.ConnectedComponentsNumber() + 1];
        int pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                int p = Labels[pos];
                if (p > 0 && x + 1 < width && Labels[y * width + x + 1] > 0) {
                    this.Neighborhoods[p][Labels[y * width + x + 1]] = 1;
                }
                if (EightConnex && p > 0 && x + 1 < width && y + 1 < height && Labels[(y + 1) * width + x + 1] > 0) {
                    this.Neighborhoods[p][Labels[(y + 1) * width + x + 1]] = 1;
                }
                if (p > 0 && y + 1 < height && Labels[(y + 1) * width + x] > 0) {
                    this.Neighborhoods[Labels[(y + 1) * width + x]][p] = 1;
                    this.Neighborhoods[p][Labels[(y + 1) * width + x]] = 1;
                }
                if (EightConnex && p > 0 && x - 1 >= 0 && y + 1 < height && Labels[(y + 1) * width + x - 1] > 0) {
                    this.Neighborhoods[p][Labels[(y + 1) * width + x - 1]] = 1;
                }
                if (p > 0 && x - 1 >= 0 && Labels[y * width + x - 1] > 0) {
                    this.Neighborhoods[p][Labels[y * width + x - 1]] = 1;
                }
                if (EightConnex && p > 0 && x - 1 >= 0 && y - 1 >= 0 && Labels[(y - 1) * width + x - 1] > 0) {
                    this.Neighborhoods[p][Labels[(y - 1) * width + x - 1]] = 1;
                }
                if (p > 0 && y - 1 >= 0 && Labels[(y - 1) * width + x] > 0) {
                    this.Neighborhoods[p][Labels[(y - 1) * width + x]] = 1;
                }
                if (EightConnex && p > 0 && x + 1 < width && y - 1 >= 0 && Labels[(y - 1) * width + x + 1] > 0) {
                    this.Neighborhoods[p][Labels[(y - 1) * width + x + 1]] = 1;
                }
                ++x;
                ++pos;
            }
        }
        this.matrix = null;
        this.matrix = new double[this.nbGrayLevel][this.nbGrayLevel];
        width = height = this.ccl.ConnectedComponentsNumber() + 1;
        for (x = 0; x < width; ++x) {
            this.Neighborhoods[x][x] = 0;
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (this.Neighborhoods[y][x] != 1) continue;
                double[] dArray = this.matrix[Correspondances[y]];
                int n = Correspondances[x];
                dArray[n] = dArray[n] + 1.0;
            }
        }
    }

    public void FillMatrix(BufferedImage ImageReduced, ConnectedComponentLabeling Ccl, boolean EightConnex) {
        int x;
        int y;
        this.Reduced = null;
        this.Reduced = ImageReduced;
        int width = this.Reduced.getWidth();
        int height = this.Reduced.getHeight();
        int[] Labels = Ccl.Labels1D();
        int[] Correspondances = new int[Ccl.Sizes().length];
        this.FindValues(Labels, width, height, Correspondances);
        this.Neighborhoods = null;
        this.Neighborhoods = new int[Ccl.ConnectedComponentsNumber() + 1][Ccl.ConnectedComponentsNumber() + 1];
        int pos = 0;
        for (y = 0; y < height; ++y) {
            x = 0;
            while (x < width) {
                int p = Labels[pos];
                if (p > 0 && x + 1 < width && Labels[y * width + x + 1] > 0) {
                    this.Neighborhoods[p][Labels[y * width + x + 1]] = 1;
                }
                if (EightConnex && p > 0 && x + 1 < width && y + 1 < height && Labels[(y + 1) * width + x + 1] > 0) {
                    this.Neighborhoods[p][Labels[(y + 1) * width + x + 1]] = 1;
                }
                if (p > 0 && y + 1 < height && Labels[(y + 1) * width + x] > 0) {
                    this.Neighborhoods[Labels[(y + 1) * width + x]][p] = 1;
                    this.Neighborhoods[p][Labels[(y + 1) * width + x]] = 1;
                }
                if (EightConnex && p > 0 && x - 1 >= 0 && y + 1 < height && Labels[(y + 1) * width + x - 1] > 0) {
                    this.Neighborhoods[p][Labels[(y + 1) * width + x - 1]] = 1;
                }
                if (p > 0 && x - 1 >= 0 && Labels[y * width + x - 1] > 0) {
                    this.Neighborhoods[p][Labels[y * width + x - 1]] = 1;
                }
                if (EightConnex && p > 0 && x - 1 >= 0 && y - 1 >= 0 && Labels[(y - 1) * width + x - 1] > 0) {
                    this.Neighborhoods[p][Labels[(y - 1) * width + x - 1]] = 1;
                }
                if (p > 0 && y - 1 >= 0 && Labels[(y - 1) * width + x] > 0) {
                    this.Neighborhoods[p][Labels[(y - 1) * width + x]] = 1;
                }
                if (EightConnex && p > 0 && x + 1 < width && y - 1 >= 0 && Labels[(y - 1) * width + x + 1] > 0) {
                    this.Neighborhoods[p][Labels[(y - 1) * width + x + 1]] = 1;
                }
                ++x;
                ++pos;
            }
        }
        this.matrix = null;
        this.matrix = new double[this.nbGrayLevel][this.nbGrayLevel];
        width = height = this.ccl.ConnectedComponentsNumber() + 1;
        for (x = 0; x < width; ++x) {
            this.Neighborhoods[x][x] = 0;
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (this.Neighborhoods[y][x] != 1) continue;
                double[] dArray = this.matrix[Correspondances[y]];
                int n = Correspondances[x];
                dArray[n] = dArray[n] + 1.0;
            }
        }
    }

    public void FillMatrix(List<BufferedImage> list) {
        throw new Error("Can not fill matrix with a list of zone => Empty method.");
    }

    private void FindValues(int[] Labels, int width, int height, int[] Correspondances) {
        WritableRaster wr = this.Reduced.getRaster();
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (0 < Labels[pos]) {
                    Correspondances[Labels[pos]] = wr.getSample(x, y, 0) - 1;
                }
                ++x;
                ++pos;
            }
        }
        wr = null;
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public int[][] getNeighborhoods() {
        return this.Neighborhoods;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.nbGrayLevel * this.nbGrayLevel * 3);
        for (int j = 0; j <= this.nbGrayLevel; ++j) {
            for (int i2 = 0; i2 <= this.nbGrayLevel; ++i2) {
                sb.append(this.matrix[j][i2]).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

