/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.rlm;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayOperations;
import dv.DV;
import imageTiTi.ImageComparator;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import mathematics.Maths;
import processing.reducer.ColorReducer;
import processing.reducer.FuzzyGLR;

public class RunLengthMatrix {
    protected int nbGrayLevel = -1;
    protected int Width = -1;
    protected double[][] matrix = null;
    private double[][] roughmatrix = null;
    protected int[] dx = new int[]{1, 1, 0, -1};
    protected int[] dy = new int[]{0, 1, 1, 1};
    protected BufferedImage reduced = null;
    protected ColorReducer reducer = null;
    protected int ForbiddenValue = -1;
    protected int[] dx3 = new int[]{-1, 0, 1, 1, -1, 0, 1, 1};
    protected int[] dy3 = new int[]{1, 1, 1, 0, 1, 1, 1, 0};
    protected int[] dz3 = new int[]{0, 0, 0, 0, 1, 1, 1, 1};
    protected DV reduced3d = null;

    public synchronized void Kill() {
        this.roughmatrix = null;
        this.matrix = null;
        this.dy = null;
        this.dx = null;
        this.reducer = null;
        this.reduced = null;
        this.dz3 = null;
        this.dy3 = null;
        this.dx3 = null;
        if (this.reduced3d != null) {
            this.reduced3d.Kill();
        }
        this.reduced3d = null;
    }

    public void setDirection(int DX, int DY) {
        int x = DX;
        int y = DY;
        if (x < 0) {
            x = -x;
        }
        if (y < 0) {
            y = -y;
        }
        if (x > 1 || y > 1) {
            throw new IllegalArgumentException("Unitary displacement wished, so in [-1..1].");
        }
        this.dx = null;
        this.dy = null;
        this.dx = new int[]{DX};
        this.dy = new int[]{DY};
    }

    public void setDirection(int DX, int DY, int DZ) {
        if (this.dx3.length != 1) {
            this.dz3 = null;
            this.dy3 = null;
            this.dx3 = null;
            this.dx3 = new int[1];
            this.dy3 = new int[1];
            this.dz3 = new int[1];
        }
        this.dx3[0] = DX;
        this.dy3[0] = DY;
        this.dz3[0] = DZ;
    }

    public void setDirection(int[] dx, int[] dy) {
        if (dx.length != dy.length) {
            throw new IllegalArgumentException("Different lengths of arrays: " + dx.length + " & " + dy.length);
        }
        this.dx = null;
        this.dy = null;
        this.dx = dx;
        this.dy = dy;
    }

    public void setDirections(int[] dx, int[] dy, int[] dz) {
        if (this.dx3.length != this.dy3.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        if (this.dx3.length != this.dz3.length) {
            throw new IllegalArgumentException("Arrays have different lengths.");
        }
        this.dx3 = null;
        this.dy3 = null;
        this.dz3 = null;
        this.dx3 = Arrays.copyOf(this.dx3, this.dx3.length);
        this.dy3 = Arrays.copyOf(this.dy3, this.dy3.length);
        this.dz3 = Arrays.copyOf(this.dz3, this.dz3.length);
    }

    public void FillMatrix(BufferedImage image, BufferedImage mask, int nbGrayLevel, ColorReducer reducer, int ForbiddenValue, int nbCPU) {
        int x;
        int y;
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level images supported.");
        }
        boolean fuzzy = reducer instanceof FuzzyGLR;
        if (!fuzzy && nbGrayLevel < 1) {
            throw new IllegalArgumentException("Bad gray level: " + nbGrayLevel + ", wished [1..2^n < 65535]");
        }
        if (!fuzzy && Maths.isDyadic((int)nbGrayLevel) == -1) {
            throw new IllegalArgumentException("The gray level number must be dyadic (power of 2): " + nbGrayLevel);
        }
        this.reduced = null;
        this.reduced = fuzzy ? reducer.Reduce(image, ForbiddenValue, nbCPU) : reducer.Reduce(image, nbGrayLevel, ForbiddenValue);
        if (mask != null) {
            ImageComparator.Compare((BufferedImage)mask, (String)"!=", (int)0, (BufferedImage)this.reduced, (int)0, (BufferedImage)this.reduced);
        }
        this.Width = Math.max(image.getWidth(), image.getHeight()) + 1;
        int dim = -1;
        if (!fuzzy) {
            dim = nbGrayLevel;
        } else {
            switch (image.getType()) {
                case 10: {
                    dim = 256;
                    break;
                }
                case 11: {
                    dim = 65536;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported (yet).");
                }
            }
        }
        this.nbGrayLevel = dim;
        if (this.matrix == null || this.roughmatrix.length != dim || this.roughmatrix[0].length != this.Width) {
            this.roughmatrix = null;
            this.roughmatrix = new double[dim][this.Width];
        } else {
            ArrayOperations.Fill((double[][])this.roughmatrix, (double)0.0);
        }
        for (int i2 = 0; i2 < this.dx.length; ++i2) {
            this.FillMatrix(0, 0, image.getWidth() - 1, image.getHeight() - 1, this.dx[i2], this.dy[i2]);
        }
        int max = 0;
        for (y = 0; y < this.roughmatrix.length; ++y) {
            for (x = 0; x < this.Width; ++x) {
                if (!(this.roughmatrix[y][x] > 0.0) || x <= max) continue;
                max = x;
            }
        }
        ArrayArithmetic.Divide((double[][])this.roughmatrix, (double)this.dx.length);
        this.Width = max + 1;
        this.matrix = null;
        this.matrix = new double[this.roughmatrix.length][this.Width];
        for (y = 0; y < this.roughmatrix.length; ++y) {
            for (x = 0; x < this.Width; ++x) {
                this.matrix[y][x] = this.roughmatrix[y][x];
            }
        }
    }

    protected void FillMatrix(int startx, int starty, int endx, int endy, int dx, int dy) {
        int x;
        int y;
        int height = this.reduced.getHeight();
        int width = this.reduced.getWidth();
        int[][] tampon = new int[this.roughmatrix.length][this.roughmatrix[0].length];
        ArrayOperations.Fill((int[][])tampon, (int)0);
        WritableRaster wr = this.reduced.getRaster();
        for (y = starty; y <= endy; ++y) {
            for (x = startx; x <= endx; ++x) {
                if (wr.getSample(x, y, 0) == 0) continue;
                int v0 = wr.getSample(x, y, 0);
                int nb = 1;
                boolean Fin = false;
                int x1 = x;
                int y1 = y;
                do {
                    if ((x1 += dx) < 0 || x1 >= width) {
                        Fin = true;
                    }
                    if ((y1 += dy) < 0 || y1 >= height) {
                        Fin = true;
                    }
                    if (!Fin && wr.getSample(x1, y1, 0) != 0 && wr.getSample(x1, y1, 0) == v0) {
                        ++nb;
                        continue;
                    }
                    Fin = true;
                } while (!Fin);
                int[] nArray = tampon[v0 - 1];
                int n = nb;
                nArray[n] = nArray[n] + 1;
            }
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 1; x < this.Width; ++x) {
                int[] nArray = tampon[y];
                int n = x - 1;
                nArray[n] = nArray[n] - tampon[y][x];
            }
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 1; x < this.Width; ++x) {
                double[] dArray = this.roughmatrix[y];
                int n = x - 1;
                dArray[n] = dArray[n] + (double)tampon[y][x];
            }
        }
        tampon = null;
        wr = null;
    }

    protected void FillMatrix(BufferedImage image, int startx, int starty, int endx, int endy, int nbCPU) {
        int x;
        int y;
        this.reduced = image;
        int max = 0;
        this.Width = image.getWidth() > image.getHeight() ? image.getWidth() + 1 : image.getHeight() + 1;
        this.roughmatrix = null;
        this.roughmatrix = new double[this.nbGrayLevel][this.Width];
        ArrayOperations.Fill((double[][])this.roughmatrix, (double)0.0);
        for (int i2 = 0; i2 < this.dx.length; ++i2) {
            this.FillMatrix(startx, starty, endx, endy, this.dx[i2], this.dy[i2]);
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 0; x < this.Width; ++x) {
                if (!(this.roughmatrix[y][x] > 0.0) || x <= max) continue;
                max = x;
            }
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            x = 0;
            while (x < this.Width) {
                double[] dArray = this.roughmatrix[y];
                int n = x++;
                dArray[n] = dArray[n] / (double)this.dx.length;
            }
        }
        this.Width = max + 1;
        this.matrix = null;
        this.matrix = new double[this.nbGrayLevel][this.Width];
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 0; x < this.Width; ++x) {
                this.matrix[y][x] = this.roughmatrix[y][x];
            }
        }
    }

    public void FillMatrix(DV dv, int nbGrayLevel, ColorReducer reducer, int ForbiddenValue, int nbCPU) {
        int x;
        int y;
        boolean fuzzy = reducer instanceof FuzzyGLR;
        if (!fuzzy && nbGrayLevel < 1) {
            throw new IllegalArgumentException("Bad gray level: " + nbGrayLevel + ", wished [1..2^n < 65535]");
        }
        if (!fuzzy && Maths.isDyadic((int)nbGrayLevel) == -1) {
            throw new IllegalArgumentException("The gray level number must be dyadic (power of 2): " + nbGrayLevel);
        }
        this.reduced3d = null;
        this.reduced3d = fuzzy ? reducer.Reduce(dv, ForbiddenValue, nbCPU) : reducer.Reduce(dv, nbGrayLevel, ForbiddenValue);
        int dim = -1;
        this.Width = Math.max(Math.max(dv.SizeX, dv.SizeY), dv.SizeZ) + 1;
        if (!fuzzy) {
            dim = nbGrayLevel;
        } else {
            switch (dv.Type) {
                case 8: {
                    dim = 256;
                    break;
                }
                case 16: {
                    dim = 65536;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported (yet).");
                }
            }
        }
        this.nbGrayLevel = dim;
        if (this.matrix == null || this.roughmatrix.length != dim || this.roughmatrix[0].length != this.Width) {
            this.roughmatrix = null;
            this.roughmatrix = new double[dim][this.Width];
        } else {
            ArrayOperations.Fill((double[][])this.roughmatrix, (double)0.0);
        }
        for (int i2 = 0; i2 < this.dx3.length; ++i2) {
            this.FillMatrix(0, 0, 0, dv.SizeX - 1, dv.SizeY - 1, dv.SizeZ - 1, this.dx3[i2], this.dy3[i2], this.dz3[i2]);
        }
        int max = 0;
        for (y = 0; y < this.roughmatrix.length; ++y) {
            for (x = 0; x < this.Width; ++x) {
                if (!(this.roughmatrix[y][x] > 0.0) || x <= max) continue;
                max = x;
            }
        }
        ArrayArithmetic.Divide((double[][])this.roughmatrix, (double)this.dx3.length);
        this.Width = max + 1;
        this.matrix = null;
        this.matrix = new double[this.roughmatrix.length][this.Width];
        for (y = 0; y < this.roughmatrix.length; ++y) {
            for (x = 0; x < this.Width; ++x) {
                this.matrix[y][x] = this.roughmatrix[y][x];
            }
        }
    }

    protected void FillMatrix(int startx, int starty, int startz, int endx, int endy, int endz, int dx, int dy, int dz) {
        int x;
        int y;
        int width = this.reduced3d.SizeX;
        int height = this.reduced3d.SizeY;
        int depth = this.reduced3d.SizeZ;
        int offset = dx + dy * width + dz * this.reduced3d.LayerSize;
        int[][] buffer = new int[this.roughmatrix.length][this.roughmatrix[0].length];
        ArrayOperations.Fill((int[][])buffer, (int)0);
        switch (this.reduced3d.Type) {
            case 8: {
                byte[] bb = this.reduced3d.getDataBufferByte(0);
                for (int z = startz; z <= endz; ++z) {
                    for (y = starty; y <= endy; ++y) {
                        x = startx;
                        int pos = x + y * width + z * this.reduced3d.LayerSize;
                        while (x <= endx) {
                            int v0 = bb[pos] & 0xFF;
                            if (v0 != 0) {
                                int nb = 1;
                                boolean Fin = false;
                                int x1 = x;
                                int y1 = y;
                                int z1 = z;
                                int p = pos;
                                do {
                                    if ((x1 += dx) < 0 || x1 >= width) {
                                        Fin = true;
                                    }
                                    if ((y1 += dy) < 0 || y1 >= height) {
                                        Fin = true;
                                    }
                                    if ((z1 += dz) < 0 || z1 >= depth) {
                                        Fin = true;
                                    }
                                    if (!Fin && (bb[p += offset] & 0xFF) != 0 && (bb[p] & 0xFF) == v0) {
                                        ++nb;
                                        continue;
                                    }
                                    Fin = true;
                                } while (!Fin);
                                int[] nArray = buffer[v0 - 1];
                                int n = nb;
                                nArray[n] = nArray[n] + 1;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                bb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 1; x < this.Width; ++x) {
                int[] nArray = buffer[y];
                int n = x - 1;
                nArray[n] = nArray[n] - buffer[y][x];
            }
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 1; x < this.Width; ++x) {
                double[] dArray = this.roughmatrix[y];
                int n = x - 1;
                dArray[n] = dArray[n] + (double)buffer[y][x];
            }
        }
        buffer = null;
    }

    protected void FillMatrix(DV dv, int startx, int starty, int startz, int endx, int endy, int endz, int nbCPU) {
        int x;
        int y;
        this.reduced3d = dv;
        int max = 0;
        this.Width = Math.max(Math.max(dv.SizeX, dv.SizeY), dv.SizeZ) + 1;
        this.roughmatrix = null;
        this.roughmatrix = new double[this.nbGrayLevel][this.Width];
        ArrayOperations.Fill((double[][])this.roughmatrix, (double)0.0);
        for (int i2 = 0; i2 < this.dx3.length; ++i2) {
            this.FillMatrix(startx, starty, startz, endx, endy, endz, this.dx3[i2], this.dy3[i2], this.dz3[i2]);
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 0; x < this.Width; ++x) {
                if (!(this.roughmatrix[y][x] > 0.0) || x <= max) continue;
                max = x;
            }
        }
        for (y = 0; y < this.nbGrayLevel; ++y) {
            x = 0;
            while (x < this.Width) {
                double[] dArray = this.roughmatrix[y];
                int n = x++;
                dArray[n] = dArray[n] / (double)this.dx3.length;
            }
        }
        this.Width = max + 1;
        this.matrix = null;
        this.matrix = new double[this.nbGrayLevel][this.Width];
        for (y = 0; y < this.nbGrayLevel; ++y) {
            for (x = 0; x < this.Width; ++x) {
                this.matrix[y][x] = this.roughmatrix[y][x];
            }
        }
    }

    public void Parameters(Object ... parameters) {
        if (parameters.length != 3) {
            throw new IllegalArgumentException("3 parameters required.");
        }
        this.nbGrayLevel = (Integer)parameters[0];
        this.reducer = (ColorReducer)parameters[1];
        this.ForbiddenValue = (Integer)parameters[2];
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public int[] getDx() {
        return this.dx;
    }

    public int[] getDy() {
        return this.dy;
    }

    public int[] getDx3D() {
        return this.dx3;
    }

    public int[] getDy3D() {
        return this.dy3;
    }

    public int[] getDz3D() {
        return this.dz3;
    }

    public String toString(String Separator2) {
        StringBuilder sb = new StringBuilder(this.nbGrayLevel * this.Width * 3);
        for (int j = 0; j < this.nbGrayLevel; ++j) {
            for (int i2 = 0; i2 < this.Width; ++i2) {
                sb.append(this.matrix[j][i2]).append(Separator2);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void Display(String Separator2) {
        System.out.println(this.toString(Separator2));
    }
}

