/*
 * Decompiled with CFR 0.152.
 */
package characterization.textures.statisticalmatrices.rlm;

import characterization.PreComputable;
import characterization.textures.statisticalmatrices.rlm.RunLengthMatrix;
import dv.DV;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import processing.reducer.ColorReducer;

public class RLMfeatures
extends RunLengthMatrix
implements PreComputable {
    private double[] Features = new double[13];
    private double Sum = 0.0;
    private String[] FeaturesNames = new String[]{"RLM_SRE", "RLM_LRE", "RLM_GLNU", "RLM_RLNU", "RLM_RP", "RLM_LGLRE", "RLM_HGLRE", "RLM_SRLGLE", "RLM_SRHLGE", "RLM_LRLGLE", "RLM_LRHGLE", "RLM_VAR1", "RLM_VAR2"};

    @Override
    public synchronized void Kill() {
        super.Kill();
        this.Features = null;
        this.FeaturesNames = null;
    }

    public void Compute(BufferedImage image, BufferedImage mask, int nbGrayLevel, ColorReducer reducer, int ForbiddenValue, int nbCPU) {
        if (ImageTools.isColored((BufferedImage)image)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        this.FillMatrix(image, mask, nbGrayLevel, reducer, ForbiddenValue, nbCPU);
        this.ComputeFeatures();
    }

    @Override
    public void Compute(BufferedImage image, BufferedImage mask, int ForbiddenValue, int nbCPU) {
        if (this.nbGrayLevel < 0) {
            throw new IllegalArgumentException("Parameters must be set before the call to this method.");
        }
        this.FillMatrix(image, mask, this.nbGrayLevel, this.reducer, ForbiddenValue, nbCPU);
        this.ComputeFeatures();
    }

    public void Compute(DV dv, int nbGrayLevel, ColorReducer reducer, int ForbiddenValue, int nbCPU) {
        this.FillMatrix(dv, nbGrayLevel, reducer, ForbiddenValue, nbCPU);
        this.ComputeFeatures();
    }

    @Override
    public void Compute(DV dv, int nbCPU) {
        if (this.nbGrayLevel < 0) {
            throw new IllegalArgumentException("Parameters must be set before to call this method.");
        }
        this.FillMatrix(dv, this.nbGrayLevel, this.reducer, this.ForbiddenValue, nbCPU);
        this.ComputeFeatures();
    }

    @Override
    public int ForbiddenValue() {
        return this.ForbiddenValue;
    }

    @Override
    public void PreCompute(BufferedImage image, int nbCPU) {
        if (this.nbGrayLevel <= 0) {
            throw new Error("Parameters must be set before the call to this method.");
        }
        this.reduced = this.reducer.Reduce(image, this.nbGrayLevel, this.ForbiddenValue);
    }

    @Override
    public void FastCompute(int startx, int starty, int endx, int endy) {
        this.FillMatrix(this.reduced, startx, starty, endx, endy, 1);
        this.ComputeFeatures();
    }

    public void ComputeFromStack(BufferedImage[] images, BufferedImage[] masks, int nbGrayLevel, ColorReducer reducer, int ForbiddenValue, int nbCPU) {
        int[] nbNanF1 = new int[this.Features.length];
        double[] F1 = new double[this.Features.length];
        for (int i2 = 0; i2 < images.length; ++i2) {
            this.Compute(images[i2], masks[i2], nbGrayLevel, reducer, ForbiddenValue, nbCPU);
            for (int j = 0; j < F1.length; ++j) {
                if (Double.isNaN(this.Features[j])) {
                    int n = j;
                    nbNanF1[n] = nbNanF1[n] + 1;
                    continue;
                }
                int n = j;
                F1[n] = F1[n] + this.Features[j];
            }
        }
        for (int j = 0; j < F1.length; ++j) {
            this.Features[j] = F1[j] / (double)(images.length - nbNanF1[j]);
        }
        F1 = null;
        nbNanF1 = null;
    }

    private void ComputeFeatures() {
        this.Sum = 0.0;
        for (int y = 0; y < this.nbGrayLevel; ++y) {
            for (int x = 0; x < this.Width; ++x) {
                this.Sum += this.matrix[y][x];
            }
        }
        this.Features[0] = this.SRE();
        this.Features[1] = this.LRE();
        this.Features[2] = this.GLNU();
        this.Features[3] = this.RLNU();
        this.Features[4] = this.RP();
        this.Features[5] = this.LGLRE();
        this.Features[6] = this.HGLRE();
        this.Features[7] = this.SRLGLE();
        this.Features[8] = this.SRHGLE();
        this.Features[9] = this.LRLGLE();
        this.Features[10] = this.LRHGLE();
        this.Features[11] = this.VAR1();
        this.Features[12] = this.VAR2();
    }

    private double SRE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] / Math.pow(l + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LRE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] * Math.pow(l + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double GLNU() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            double v = 0.0;
            for (int l = 0; l < this.Width; ++l) {
                v += this.matrix[n][l];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double RLNU() {
        double val = 0.0;
        for (int l = 0; l < this.Width; ++l) {
            double v = 0.0;
            for (int n = 0; n < this.nbGrayLevel; ++n) {
                v += this.matrix[n][l];
            }
            val += v * v;
        }
        return val / this.Sum;
    }

    private double RP() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += (double)(l + 1) * this.matrix[n][l];
            }
        }
        return this.Sum / val;
    }

    private double LGLRE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] / Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double HGLRE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] * Math.pow(n + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double SRLGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] / (Math.pow(n + 1, 2.0) * Math.pow(l + 1, 2.0));
            }
        }
        return val / this.Sum;
    }

    private double SRHGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] * Math.pow((double)(n + 1) / (double)(l + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LRLGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] * Math.pow((double)(l + 1) / (double)(n + 1), 2.0);
            }
        }
        return val / this.Sum;
    }

    private double LRHGLE() {
        double val = 0.0;
        for (int n = 0; n < this.nbGrayLevel; ++n) {
            for (int l = 0; l < this.Width; ++l) {
                val += this.matrix[n][l] * Math.pow(n + 1, 2.0) * Math.pow(l + 1, 2.0);
            }
        }
        return val / this.Sum;
    }

    private double VAR1() {
        int l;
        int n;
        double mean = 0.0;
        double val = 0.0;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.Width; ++l) {
                mean += (double)n * this.matrix[n][l];
            }
        }
        mean /= this.Sum;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.Width; ++l) {
                val += Math.pow((double)n * this.matrix[n][l] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    private double VAR2() {
        int l;
        int n;
        double mean = 0.0;
        double val = 0.0;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.Width; ++l) {
                mean += (double)l * this.matrix[n][l];
            }
        }
        mean /= this.Sum;
        for (n = 0; n < this.nbGrayLevel; ++n) {
            for (l = 0; l < this.Width; ++l) {
                val += Math.pow((double)l * this.matrix[n][l] - mean, 2.0);
            }
        }
        return Math.sqrt(val / this.Sum);
    }

    @Override
    public double[] Features() {
        return this.Features;
    }

    @Override
    public double Feature(int i2) {
        return this.Features[i2];
    }

    @Override
    public String[] FeaturesNames() {
        String glr = this.reducer.getClass().getSimpleName();
        String[] names = new String[this.FeaturesNames.length];
        for (int i2 = 0; i2 < this.FeaturesNames.length; ++i2) {
            names[i2] = this.FeaturesNames[i2] + "_" + glr + "_" + this.reducer.Bins();
        }
        glr = null;
        return names;
    }
}

